<?php
require_once 'CAS-1.3.1/eoleCAS.php';
require_once 'configCAS/cas.inc.php';

if (__CAS_DEBUG) {
    EolephpCAS::setDebug('/var/log/phpcas/phpcas-limesurvey.log');
}

eolephpCAS::client(CAS_VERSION_2_0, __CAS_SERVER, __CAS_PORT, '', false);

class AuthCAS extends AuthPluginBase
{
    protected $storage = 'DbStorage';

    static protected $description = 'CAS authentication';
    static protected $name = 'AuthCAS';

    protected $autoCreate = true;

    public function __construct(PluginManager $manager, $id) {
        parent::__construct($manager, $id);

        $this->subscribe('beforeLogin');
        $this->subscribe('newUserSession');
        $this->subscribe('afterLogout');
    }

    public function beforeLogin()
    {
        if (__CAS_VALIDER_CA) {
            EolephpCAS::setCasServerCACert(__CAS_CA_LOCATION); // v?rification par rapport ? la CA
        } else {
            if (method_exists("EolephpCAS", "setNoCasServerValidation")){
                EolephpCAS::setNoCasServerValidation();
            }
        }
        eolephpCAS::setNoClearTicketsFromUrl();
        //forcer à redemander les infos auprès du serveur CAS (au lieu de les lire en session alors que ce serait les infos d'une autre appli...)
        if(isset($_SESSION["phpCAS"])) unset($_SESSION["phpCAS"]);
        //authentification
        eolephpCAS::forceAuthentication();

        $user = eolephpCAS::getUser();
        $this->setUsername($user);
        //To bypass the login form
        $this->setAuthPlugin();
    }

    public function newUserSession()
    {
        $sUser = $this->getUserName();
        $oUser = $this->api->getUserByName($sUser);
        // Get user details du SSO filter
        $userinfos = eolephpCAS::getDetails();
        // Sonde piwik
        $_SESSION['profil_piwik'] = $userinfos['infos']['ENTPersonProfils'][0];
        if (!is_null($oUser))
        {
            $this->setAuthSuccess($oUser);
            return;
        } else {
            // autocreate user
            if ($this->autoCreate === true) {
                $usermail = $userinfos['utilisateur']['email'][0];
                $userfirstname = $userinfos['utilisateur']['firstname'][0];
                $userlastname = $userinfos['utilisateur']['lastname'][0];
                //Si adresse non renseigné dans le LDAP (ce qui ne devrait pas arriver..) on crée une fausse adresse pour éviter les erreurs
                if($usermail=="")$usermail=$userfirstname.".".$userlastname."@".$_SERVER['HTTP_HOST'];
                // Rempli l'objet user
                $oUser=new User;
                $oUser->users_name=$sUser;
                $oUser->password=hash('sha256', createPassword());
                $oUser->full_name=$userfirstname." ".$userlastname;
                $oUser->parent_id=1;
                $oUser->lang="fr";
                $oUser->email=$usermail;
                // On ajoute en bdd et on définit les permissions
                if ($oUser->save()) {
                    $permission=new Permission;
                    $permission->setPermissions($oUser->uid, 0, 'global', Array('surveys' => array('create'=>true,'read'=>true,'update'=>true,'delete'=>true)), true);
                    // on peut maintenant authentifier l'user nouvellement créé
                    $this->setAuthSuccess($oUser);
                    return;
                } else {
                    echo "Une erreur s'est produite, merci de contacter la personne en charge de Limesurvey";
                    die();
                }
            }
        }
    }

    public function afterLogout()
    {
        session_destroy();
        eolephpCAS::logoutWithUrl($_SERVER['HTTP_REFERER']);
    }
}
?>
