<?php
/**
 * If any error is returned by the server while checking for updates, they will shown through this view.
 * It is injected inside the li#udapteButtonsContainer, in the _checkButton view.
 * @var obj $serverAnswer the update informations provided by the update server
 */
?>
<?php
    // First we check if the server provided a specific HTML message
    if(isset($serverAnswer->html))
        if($serverAnswer->html != "")
            echo $serverAnswer->html;

    $bError = true;

    switch ($serverAnswer->error)
    {
        case 'php_curl_not_loaded':
            $sTile = gT('Error!');
            $sHeader = gT('PHP_CURL library not loaded');
            $sMessage = gT("It seems that your server doesn't support PHP CURL Library. Please install it before proceeding to ComfortUpdate.");
            break;

        case 'no_server_answer':
            $sTile = gT('Error!');
            $sHeader = gT('No server answer');
            $sMessage = gT("It seems that the ComfortUpdate server is not responding. Please try again in few minutes or contact the LimeSurvey team.");
            break;

        case 'no_update_available_for_your_version':
            $bError = false;
            $sTile = gT('Up to date!');
            $sHeader = gT('No update available for your version.');
            $sMessage = gT('Your version is up to date!');
            break;

        case 'not_updatable':
            $sTile = gT('Error!');
            $sHeader = gT('Not updatable!');
            $sMessage = gT('Your version is not updatable via ComfortUpdate. Please update manually.');
            break;

        case 'update_disable':
            $sTile = gT('Error!');
            $sHeader = gT('Not updatable!');
            $sMessage = gT('comfortUpdate is disabled in your LimeSurvey configuration. Please contact your administrator for more informations.');
            break;

        case 'no_build':
            $sTile = gT('Error!');
            $sHeader = gT('No build version found!');
            $sMessage = gT("It seems you're using a version coming from the LimeSurvey GitHub repository. You can't use ComfortUpdate.");
            break;

        case 'not_updatable':
            $sTile = gT('Error!');
            $sHeader = gT('No build version found!');
            $sMessage = gT("You disabled ComfortUpdate in your configuration file.");
            break;

        case 'maintenance':
            $sTile = gT('Maintenance!');
            $sHeader = gT('The ComfortUpdate service is currently undergoing maintenance.');
            $sMessage = gT("Please have patience and retry in 30 minutes. Thank you for your understanding.");
        break;

        default :
            $sTile = gT('Error!');
            $sHeader = gT('Unknown error!');
            $sMessage = gT('An unknown error occured.').' '.gT('Please contact the LimeSurvey team.');
            $sErrorCode = gT('Error code:').' '.$serverAnswer->error;
            break;
    }
?>

<div class="jumbotron message-box <?php if($bError) echo 'message-box-error'; ?>">
        <h2 class="<?php if($bError){echo 'text-danger';}else{echo 'text-success';} ?>"><?php echo $sTile; ?></h2>
        <p class="lead"><?php echo $sHeader; ?></p>
        <p><?php echo $sMessage; ?></p>
        <?php if(isset($sErrorCode)):?>
            <p>
                <?php echo $sErrorCode; ?>
            </p>
        <?php endif;?>
        <p>
            <a class="btn btn-lg btn-default" href="<?php echo $this->createUrl("admin/"); ?>" role="button"><?php eT("Ok"); ?></a>
        </p>
</div>
