
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;


USE `mahara`;

INSERT IGNORE INTO `ma_auth_instance` (`id`, `instancename`, `priority`, `institution`, `authname`) VALUES (2, 'EnvoleCAS', 1, 'mahara', 'cas');
UPDATE  `mahara`.`ma_auth_instance` SET  `instancename` =  'CASEnvole', `authname` =  'cas' WHERE  `ma_auth_instance`.`id` =2;
UPDATE  `mahara`.`ma_usr` SET  `authinstance` =  2;


-- Mise en place de la configuration d'authentification
DELETE FROM ma_auth_instance_config WHERE instance=2;



-- Adresse du Serveur LDAP 2.4
%if %%is_defined("ldap_reader_passfile")
INSERT INTO `ma_auth_instance_config` (`instance`, `field`, `value`) VALUES
(2, 'cas_baseuri', ''),
(2, 'cas_certificatecheck', '0'),
(2, 'cas_certificatepath', ''),
(2, 'cas_hostname', '%%eolesso_adresse'),
(2, 'cas_language', 'french'),
(2, 'cas_logout', '1'),
(2, 'cas_port', '%%eolesso_port'),
(2, 'cas_proxy', '0'),
(2, 'cas_version', '2.0'),

(2, 'bind_dn', '%%ldap_reader'),
(2, 'bind_pw', '%%pwdreader("",%%ldap_reader_passfile)'),
(2, 'contexts', '%%ldap_base_dn'),
(2, 'emailfield', '%%ldap_fill_mail'),
(2, 'firstnamefield', 'givenName'),
(2, 'host_url', '%%adresse_ip_ldap:%%ldap_port'),

(2, 'preferrednamefield', 'displayName'),
(2, 'search_sub', 'yes'),
(2, 'starttls', '0'),
(2, 'studentidfield', ''),
(2, 'surnamefield', 'sn'),
(2, 'syncgroupsautocreate', '1'),
(2, 'syncgroupsbyclass', '0'),
(2, 'syncgroupsbyuserfield', '0'),
(2, 'syncgroupscontexts', ''),
(2, 'syncgroupscron', '0'),
(2, 'syncgroupsexcludelist', ''),
(2, 'syncgroupsgroupattribute', 'cn'),
(2, 'syncgroupsgroupclass', 'groupOfUniqueNames'),
(2, 'syncgroupsgrouptype', 'standard'),
(2, 'syncgroupsincludelist', ''),
(2, 'syncgroupsmemberattribute', 'uniqueMember'),
(2, 'syncgroupsmemberattributeisdn', '0'),
(2, 'syncgroupsnestedgroups', '0'),
(2, 'syncgroupssearchsub', 'yes'),
(2, 'syncgroupsuserattribute', ''),
(2, 'syncgroupsusergroupnames', ''),
(2, 'syncuserscreate', '0'),
(2, 'syncuserscron', '0'),
(2, 'syncusersextrafilterattribute', ''),
(2, 'syncusersgonefromldap', ''),
(2, 'syncusersupdate', '0'),
(2, 'updateuserinfoonlogin', '1'),
(2, 'user_attribute', 'uid'),
(2, 'user_type', 'default'),
(2, 'version', '2'),
(2, 'weautocreateusers', '1');

-- Adresse du Serveur LDAP 2.3
%else
INSERT INTO `ma_auth_instance_config` (`instance`, `field`, `value`) VALUES
(2, 'bind_dn', '%%eolesso_ldap[0].eolesso_ldap_reader'),
(2, 'bind_pw', '%%pwdreader("",%%eolesso_ldap[0].eolesso_ldap_reader_passfile)'),
(2, 'cas_baseuri', ''),
(2, 'cas_certificatecheck', '0'),
(2, 'cas_certificatepath', ''),
(2, 'cas_hostname', '%%eolesso_adresse'),
(2, 'cas_language', 'french'),
(2, 'cas_logout', '1'),
(2, 'cas_port', '%%eolesso_port'),
(2, 'cas_proxy', '0'),
(2, 'cas_version', '2.0'),
(2, 'contexts', '%%eolesso_ldap[0].eolesso_base_ldap'),
(2, 'emailfield', '%%eolesso_ldap[0].eolesso_ldap_fill_mail'),
(2, 'firstnamefield', 'givenName'),
%if(%%eolesso_ldap[0] in ("localhost","127.0.0.1"))
(2, 'host_url', '%%adresse_ip_ldap:%%eolesso_ldap[0].eolesso_port_ldap'),
%else
(2, 'host_url', '%%eolesso_ldap[0]:%%eolesso_ldap[0].eolesso_port_ldap'),
%end if
(2, 'preferrednamefield', 'displayName'),
(2, 'search_sub', 'yes'),
(2, 'starttls', '0'),
(2, 'studentidfield', ''),
(2, 'surnamefield', 'sn'),
(2, 'syncgroupsautocreate', '1'),
(2, 'syncgroupsbyclass', '0'),
(2, 'syncgroupsbyuserfield', '0'),
(2, 'syncgroupscontexts', ''),
(2, 'syncgroupscron', '0'),
(2, 'syncgroupsexcludelist', ''),
(2, 'syncgroupsgroupattribute', 'cn'),
(2, 'syncgroupsgroupclass', 'groupOfUniqueNames'),
(2, 'syncgroupsgrouptype', 'standard'),
(2, 'syncgroupsincludelist', ''),
(2, 'syncgroupsmemberattribute', 'uniqueMember'),
(2, 'syncgroupsmemberattributeisdn', '0'),
(2, 'syncgroupsnestedgroups', '0'),
(2, 'syncgroupssearchsub', 'yes'),
(2, 'syncgroupsuserattribute', ''),
(2, 'syncgroupsusergroupnames', ''),
(2, 'syncuserscreate', '0'),
(2, 'syncuserscron', '0'),
(2, 'syncusersextrafilterattribute', ''),
(2, 'syncusersgonefromldap', ''),
(2, 'syncusersupdate', '0'),
(2, 'updateuserinfoonlogin', '1'),
(2, 'user_attribute', 'uid'),
(2, 'user_type', 'default'),
(2, 'version', '2'),
(2, 'weautocreateusers', '1');
%end if



-- Ajout du second admin
%if %%is_defined('activer_mahara') and %%activer_mahara == 'oui'
%if %%is_defined('activer_addadmin') and %%activer_addadmin == 'oui'

DROP PROCEDURE IF EXISTS AddAdminMahara;
DELIMITER |

CREATE PROCEDURE AddAdminMahara(_adminuser VARCHAR(60))
BEGIN
    DECLARE ad_id INT DEFAULT 0;

    SELECT COUNT(id) INTO ad_id FROM ma_usr WHERE username=_adminuser;

    IF ad_id > 0 THEN
        UPDATE ma_usr SET admin=1, email=CONCAT(_adminuser,'@%%domaine_messagerie_etab') WHERE username=_adminuser;
    ELSE
        INSERT INTO `ma_usr` (`username`, `password`, `salt`, `passwordchange`, `active`, `deleted`, `expiry`, `expirymailsent`, `lastlogin`, `lastlastlogin`, `lastaccess`, `inactivemailsent`, `staff`, `admin`, `firstname`, `lastname`, `studentid`, `preferredname`, `email`, `profileicon`, `suspendedctime`, `suspendedreason`, `suspendedcusr`, `quota`, `quotaused`, `authinstance`, `ctime`, `showhomeinfo`, `logintries`, `unread`, `urlid`) VALUES
(_adminuser, '*', '*', 0, 1, 0, NULL, 0, '2016-02-19 10:04:28', '2014-04-18 16:36:44', '2016-02-19 10:04:28', 0, 0, 1, _adminuser, _adminuser, '', _adminuser, CONCAT(_adminuser,'@%%domaine_messagerie_etab'), NULL, NULL, NULL, NULL, 52428800, 0, 2, NULL, 1, 0, 0, NULL);
    END IF;

END|

DELIMITER ;
CALL AddAdminMahara('%%uid_addadmin');

%end if
%end if

