<?php 
/**
 * @param string $user le login
 * @param string $password le mot de passe
 * @param string $dir le répertoire
 * @param bool $list_dir_only si true, on ne n'affiche que les répertoires (utile pour la sauvegarde)
 * @return array la liste des fichiers et dossiers
 */
function list_dir($host, $user, $password, $dir){
	$url = $host.'/owncloud/remote.php/dav/files/'.$user.'/'.$dir;
	
	$ch = curl_init($url);
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PROPFIND');
	// Retourner le contenu téléchargé dans une chaine (au lieu de l'afficher directement)
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_USERPWD, "$user:$password");
	curl_setopt($ch, CURLOPT_FAILONERROR, true);
	$data = curl_exec($ch);
	
	display_error($ch);

	$xml_document = new DomDocument();
	$xml_document->loadXML($data);
	$elements = $xml_document->getElementsByTagName('response');
	$parent = (!empty($_POST['parent'])) ? $_POST['parent'] : '/';
	if($dir != '/'):
	?>
	<tr>
		<td colspan="2">
			<a class="dir parent" data-href="<?php echo urldecode($parent); ?>" href="#">
			<img class="back" src="img/back.gif" alt="Retour">
			Dossier parent	
			</a>
		</td>
	</tr>

	<?php
	endif;
	foreach($elements as $element){
		$href = $element->getElementsByTagName('href');

		// quota-available-bytes permet de distinguer les dossiers des fichiers
		$quota = $element->getElementsByTagName('quota-available-bytes');
		$getlastmodified = $element->getElementsByTagName('getlastmodified')->item(0)->textContent;

		$class = ($quota->item(0)->nodeValue != 0) ? 'dir' : 'title';	// dossier ou fichier
				
		$e = explode($user.'/', $href->item(0)->textContent);

		$child = ($dir != '/') ? explode($dir, $href->item(0)->textContent) : $e;
		$child = $child[1];

		if($child != ''){
			echo '<tr>
					<td><a data-parent="'.$dir.'" data-href="'.urldecode($child).'" class='.$class.' href="#">'.urldecode($child).'</a></td>
					<td>'.date('d/m/Y', strtotime($getlastmodified)).'</td>
				</tr>';
		}
	}
}

/**
 * retourne le contenu du mindmap
 * @param  string $host     l'url
 * @param  string $user     le login de l'utilisateur
 * @param  string $password le mot de passe de l'utilisateur
 * @param  string $file     le fichier à ouvrir
 * @return object           un objet json
 */
function get_content($host, $user, $password, $parent, $file){
	$ch = curl_init();
	$url = $host.'/owncloud/remote.php/dav/files/'.$user.$parent.$file;

	curl_setopt($ch, CURLOPT_AUTOREFERER, TRUE);
	curl_setopt($ch, CURLOPT_HEADER, 0);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);       
	curl_setopt($ch, CURLOPT_USERPWD, "$user:$password");
	$data = curl_exec($ch);
	curl_close($ch);
	
	// data n'est pas un objet json
	if(!isJson($data)){
		http_response_code(415);
	}
	echo $data;
}

/**
 * sauvegarde le mindmap
 * @param  string $user     le login de l'utilisateur
 * @param  string $password le mot de passe de l'utilisateur
 * @param  string $doc      le document à sauvegarder
 * @param  string $title    le titre du document
 * @param  string $dir      le répertoire de sauvegarde
 * @return bool           sauvegarde le mindmap
 */
function save($host, $user, $password, $doc, $title, $dir){
	$url = $host.'/owncloud/remote.php/dav/files/'.$user.'/'.$dir;
	$ch = curl_init($url.$title);
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT');
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
	curl_setopt($ch, CURLOPT_POSTFIELDS, $doc);
	curl_setopt($ch, CURLOPT_USERPWD, "$user:$password");
	curl_setopt($ch, CURLOPT_FAILONERROR, true);
	curl_setopt($ch, CURLOPT_FILETIME, true);
	curl_exec($ch);

	display_error($ch);
}

/**
 * vérifie si le contenu du fichier est bien un objet json
 * @param  object  $string le contenu json du mindmap
 * @return bool         vrai si le contenu est bien un objet json
 */
function isJson($string) {
	json_decode($string);
	return (json_last_error() == JSON_ERROR_NONE);
}

/**
 * vérifie que owncloud est activé
 * @return bool vrai si owncloud est activé
 */
function owncloudIsActive(){
	$d = exec('CreoleGet activer_owncloud');
	if($d == 'oui'){
		return true;
	}

	http_response_code(404);
	exit();
}

/**
 * renvoi le code d'erreur
 * @param  ressource $ch la session curl
 * @return string     le code de la réponse
 */
function display_error($ch){
	if(curl_errno($ch) != 0){
		echo curl_error($ch);
		http_response_code(curl_getinfo($ch)['http_code']);
	}
}