<?php require_once 'authCAS.php'; ?>
<!doctype html>
<html manifest="cache.appcache">
<head>
<meta charset="utf-8">
<meta name="description" content="mindmaps is an HTML5 based mind mapping app. It lets you create neat looking mind maps in the browser." />
<meta name="keywords" content="mind maps html5 mindmaps offline easy intuitive" />
<meta name="google" content="notranslate"/>
<title>mindmaps</title>
<link rel="icon" type="image/png" href="img/favicon.png" />
<link rel="stylesheet" href="css/common.css">
<link rel="stylesheet" href="css/app.css">
<link rel="stylesheet" href="css/style.css">
<link rel="stylesheet" href="css/Aristo/jquery-ui-1.8.7.custom.css" />
<link rel="stylesheet" href="css/minicolors/jquery.miniColors.css">

<script id="template-float-panel" type="text/x-jquery-tmpl">
<div class="ui-widget ui-dialog ui-corner-all ui-widget-content float-panel no-select">
  <div class="ui-dialog-titlebar ui-widget-header ui-helper-clearfix">
    <span class="ui-dialog-title">${title}</span>
    <a class="ui-dialog-titlebar-close ui-corner-all" href="#" role="button">
      <span class="ui-icon"></span>
    </a>
  </div>
  <div class="ui-dialog-content ui-widget-content">
  </div>
</div>
</script>

<script id="template-notification" type="text/x-jquery-tmpl">
<div class="notification">
  {{if closeButton}}
  <a href="#" class="close-button">x</a>
  {{/if}}
  {{if title}}
  <h1 class="title">{{html title}}</h1>
  {{/if}}
  <div class="content">{{html content}}</div>
</div>
</script>

<script id="template-open-table-item" type="text/x-jquery-tmpl">
<tr>
  <td><a class="title" href="#">${title}</a></td>
  <td>${$item.format(dates.modified)}</td>
  <td><a class="delete" href="#">delete</a></td>
</tr>
</script>

<?
$d = exec('CreoleGet activer_owncloud');
?>
<script id="template-open" type="text/x-jquery-tmpl">
<div id="open-dialog" class="file-dialog" title="Ouvrir un mind map">
  <? if($d=="oui") { ?>
  <h1>Depuis <span class="highlight">Owncloud</span></h1>
  <p>Créez, enregitrez et partagez vos cartes mentales dans votre service de stockage en ligne Owncloud.</p>
  <!-- mot de passe de l'utilisateur  -->
  <!-- utile pour lire et écrire dans owncloud -->
  <label for="password">Indiquez votre mot de passe</label><br>
  <input type="password" name="password" id="password" autocomplete="off">
  <button id="button-open-cloud">Explorer</button><br>
  <span id="loading">Chargement...</span>
  <div class="cloud-error error"></div>
  <div id="owncloud">
    <table class="localstorage-filelist">
      <thead>
        <tr>
          <th class="title">Titre</th>
          <th class="modified">Dernière modification</th>
        </tr>
      </thead>
      <tbody class="document-list"></tbody>
    </table>
  </div>
  <div class="seperator"></div>
  <? } ?>
  <h1>Stockage local</h1>
  <p>Voici la liste des cartes mentales stockées localement. Cliquez sur leur titre pour les ouvrir.</p>
  <div id="localstorage">
    <table class="localstorage-filelist">
      <thead>
        <tr>
          <th class="title">Titre</th>
          <th class="modified">Dernière modification</th>
          <th class="delete"></th>
        </tr>
      </thead>
      <tbody class="document-list"></tbody>
    </table>
  </div>
  <div class="seperator"></div>
  <h1>Depuis un fichier</h1>
  <p>Choisissez une carte mentale sur votre disque dur.</p>
  <div class="file-chooser">
    <input type="file" />
  </div>
</div>
</script>

<script id="template-save" type="text/x-jquery-tmpl">
<div id="save-dialog" class="file-dialog" title="Sauvegarder le mindmap">
  <? if($d=="oui") { ?>
  <h1>Sauvegarder dans Owncloud</h1>
  <p>Vous devez indiquer votre mot de passe LDAP pour sauvegarder le document dans Owncloud.</p>
  
  <!-- on supprime la sauvegarde toutes les 15 minutes car il y' a besoin d'indiquer le mdp -->
  <!-- <div>
    <input type="checkbox" class="autosave" id="checkbox-autosave-localstorage">
    <label for="checkbox-autosave-localstorage">Sauvegarder toutes les minutes.</label>
  </div> -->
  <!-- mot de passe de l'utilisateur  -->
  <!-- utile pour lire et écrire dans owncloud -->
  <label for="password">Indiquez votre mot de passe</label><br>
  <input type="password" name="password" id="password" autocomplete="off">
  <button id="button-explore">Explorer</button>
  <button id="button-save-to-owncloud" data-dir="">Sauvegarder ici</button><br>
  <span id="loading">Chargement...</span>
  <div class="cloud-error error"></div>
  <div id="owncloud">
    <table class="localstorage-filelist">
      <thead>
        <tr>
          <th class="title">Titre</th>
          <th class="modified">Dernière modification</th>
        </tr>
      </thead>
      <tbody class="document-list"></tbody>
    </table>
  </div>
  <div class="seperator"></div>
  <? } ?>
  <h1>Local Storage</h1>
  <p>Vous pouvez sauvegarder votre carte mentale dans le stockage local de votre navigateur. Attention, cette fonctionnalité est expérimantale : l'espace est limité et il n'y a aucune garantie que le navigateur garde ce document indéfiniment. Utile pour des sauvegardes fréquentes avec un stockage en ligne.</p>
  <button id="button-save-localstorage">Sauvegarder</button>
  <input type="checkbox" class="autosave" id="checkbox-autosave-localstorage">
  <label for="checkbox-autosave-localstorage">Sauvegarder toutes les minutes.</label>
  <div class="seperator"></div>
  <h1>Dans le fichier</h1>
  <p>Enregistrez la carte mentale dans un fichier sur votre disque dur.</p>
  <div id="button-save-hdd">Sauvegarder</div>
</div>
</script>

<script id="template-navigator" type="text/x-jquery-tmpl">
<div id="navigator">
  <div class="active">
    <div id="navi-content">
      <div id="navi-canvas-wrapper">
        <canvas id="navi-canvas"></canvas>
        <div id="navi-canvas-overlay"></div>
      </div>
      <div id="navi-controls">
        <span id="navi-zoom-level"></span>
        <div class="button-zoom" id="button-navi-zoom-out"></div>
        <div id="navi-slider"></div>
        <div class="button-zoom" id="button-navi-zoom-in"></div>
      </div>
    </div>
  </div>
  <div class="inactive">
  </div>
</div>
</script>


<script id="template-inspector" type="text/x-jquery-tmpl">
<div id="inspector">
  <div id="inspector-content">
    <table id="inspector-table">
      <tr>
        <td>Taille de police :</td>
        <td><div
            class="buttonset buttons-very-small buttons-less-padding">
            <button id="inspector-button-font-size-decrease">A-</button>
            <button id="inspector-button-font-size-increase">A+</button>
          </div></td>
      </tr>
      <tr>
        <td>Style de police :</td>
        <td><div
            class="font-styles buttonset buttons-very-small buttons-less-padding">
            <input type="checkbox" id="inspector-checkbox-font-bold" />
            <label
            for="inspector-checkbox-font-bold" id="inspector-label-font-bold">B</label>

            <input type="checkbox" id="inspector-checkbox-font-italic" />
            <label
            for="inspector-checkbox-font-italic" id="inspector-label-font-italic">I</label>

            <input
            type="checkbox" id="inspector-checkbox-font-underline" />
            <label
            for="inspector-checkbox-font-underline" id="inspector-label-font-underline">U</label>

            <input
            type="checkbox" id="inspector-checkbox-font-linethrough" />
             <label
            for="inspector-checkbox-font-linethrough" id="inspector-label-font-linethrough">S</label>
          </div>
        </td>
      </tr>
      <tr>
        <td>Couleur de la police:</td>
        <td><input type="hidden" id="inspector-font-color-picker"
          class="colorpicker" /></td>
      </tr>
      <tr>
        <td>Couleur de la branche:</td>
        <td><input type="hidden" id="inspector-branch-color-picker"
          class="colorpicker" />
          <button id="inspector-button-branch-color-children" title="Applique la couleur de la branche à tous les enfants" class="right buttons-small buttons-less-padding">Hériter</button>
        </td>
      </tr>
    </table>
  </div>
</div>
</script>

<script id="template-export-map" type="text/x-jquery-tmpl">
<div id="export-map-dialog" title="Exporter la carte mentale">
    <h2 class='image-description'>Pour télécharger la carte, faites un clic droit et choisissez "Enregistrer l'image sous"</h2>
  <div id="export-preview"></div>
</div>
</script>

</head>
<body>
  <div id="print-area">
    <p class="print-placeholder">Please use the print option from the
      mind map menu</p>
    <p class="print-placeholder">S'il vous plait, utilisez l'option d'impression du menu de mind map</p>
  </div>
  <!-- DEBUG -->
  <!-- <div id="debug-warning">Actuellement en mode debug.</div> -->
  <!-- /DEBUG -->
  <div id="container">
    <div id="topbar">
      <div id="toolbar">
        <div id="logo" class="logo-bg">
          <span>Mindmaps</span>
        </div>

        <div class="buttons">
          <span class="buttons-left"> </span> <span class="buttons-right">
          </span>
          <span class="col-xs">
            <span class="username">Bonjour <?php echo $_SESSION["user_id"]; ?></span>
            <a href="decoCAS.php" class="icon icon-exit" title="Déconnexion"></a>
          </span>
        </div>

      </div>
    </div>
    <div id="canvas-container">
      <div id="drawing-area" class="no-select"></div>
    </div>
    <div id="bottombar">
      <div id="about">
        <a href="http://github.com/drichard/mindmaps" target="_blank">À propos de mindmaps</a>
      </div>
      <div id="statusbar">
        <div
          class="buttons buttons-right buttons-small buttons-less-padding"></div>
      </div>
    </div>
  </div>

  <script src="//ajax.googleapis.com/ajax/libs/jquery/1.6.1/jquery.min.js"></script>
  <script src="//api.filepicker.io/v0/filepicker.js"></script>

  <!-- DEBUG -->
  <!-- set debug flag for all scripts. Will be removed in production -->
  <script type="text/javascript">
    //var mindmaps = mindmaps || {};
    //mindmaps.DEBUG = true;
  </script>
  <!-- /DEBUG -->

  <!-- JS:LIB:BEGIN -->
  <script src="js/libs/jquery-ui-1.8.11.custom.min.js"></script>
  <script src="js/libs/dragscrollable.js"></script>
  <script src="js/libs/jquery.hotkeys.js"></script>
  <script src="js/libs/jquery.mousewheel.js"></script>
  <script src="js/libs/jquery.minicolors.js"></script>
  <script src="js/libs/jquery.tmpl.js"></script>
  <script src="js/libs/events.js"></script>

  <script src="js/MindMaps.js"></script>
  <script src="js/Command.js"></script>
  <script src="js/CommandRegistry.js"></script>
  <script src="js/Action.js"></script>
  <script src="js/Util.js"></script>
  <script src="js/Point.js"></script>
  <script src="js/Document.js"></script>
  <script src="js/MindMap.js"></script>
  <script src="js/Node.js"></script>
  <script src="js/NodeMap.js"></script>
  <script src="js/UndoManager.js"></script>
  <script src="js/UndoController.js"></script>
  <script src="js/ClipboardController.js"></script>
  <script src="js/ZoomController.js"></script>
  <script src="js/ShortcutController.js"></script>
  <script src="js/HelpController.js"></script>
  <script src="js/FloatPanel.js"></script>
  <script src="js/Navigator.js"></script>
  <script src="js/Inspector.js"></script>
  <script src="js/ToolBar.js"></script>
  <script src="js/StatusBar.js"></script>
  <script src="js/CanvasDrawingTools.js"></script>
  <script src="js/CanvasView.js"></script>
  <script src="js/CanvasPresenter.js"></script>
  <script src="js/ApplicationController.js"></script>
  <script src="js/MindMapModel.js"></script>
  <script src="js/NewDocument.js"></script>
  <script src="js/OpenDocument.js"></script>
  <script src="js/SaveDocument.js"></script>
  <script src="js/MainViewController.js"></script>
  <script src="js/Storage.js"></script>
  <script src="js/Event.js"></script>
  <script src="js/Notification.js"></script>
  <script src="js/StaticCanvas.js"></script>
  <script src="js/PrintController.js"></script>
  <script src="js/ExportMap.js"></script>
  <script src="js/AutoSaveController.js"></script>
  <script src="js/FilePicker.js"></script>
  <script src="js/script.js"></script>
  <!-- JS:LIB:END -->
</body>
</html>
