/**
* Creates a new SaveDocumentView. This view renders a dialog where the user can
* save the mind map.
* 
* @constructor
*/
mindmaps.SaveDocumentView = function() {
  var self = this;

  var $dialog = $("#template-save").tmpl().dialog({
    autoOpen : false,
    modal : true,
    zIndex : 5000,
    width : 550,
    close : function() {
      // remove dialog from DOM
      $(this).dialog("destroy");
      $(this).remove();
    }
  });


  var $saveCloudStorageButton = $("#button-save-cloudstorage").button().click(
    function() {
      if (self.cloudStorageButtonClicked) {
        self.cloudStorageButtonClicked();
      }
    });

  var $localSorageButton = $("#button-save-localstorage").button().click(
    function() {
      if (self.localStorageButtonClicked) {
        self.localStorageButtonClicked();
      }
    });

  var $owncloudStorageButton = $("#button-save-to-owncloud").button().click(
    function() {
      if (self.owncloudStorageButtonClicked) {
        self.owncloudStorageButtonClicked();
      }
    });

   var $exploreButton = $("#button-explore").button().click(
    function() {
      list_dir('/', '/');
    });

   var $table = $dialog.find("div#owncloud .localstorage-filelist");
  $table.delegate("a.dir", "click", function() {
      var parent = $(this).attr('data-parent');
      var dir = (typeof parent !== 'undefined') ? parent + $(this).attr('data-href') : $(this).attr('data-href');
        list_dir(dir, parent);
    });

  var $autoSaveCheckbox = $("#checkbox-autosave-localstorage").click(
    function() {
      if (self.autoSaveCheckboxClicked) {
        self.autoSaveCheckboxClicked($(this).prop("checked"));
      }
    });

  var $hddSaveButton = $("#button-save-hdd").button().click(
    function(){
      var parent = document.getElementById('save-dialog'),
        child = document.getElementById('download'),
        filename = (self.fileNameRequested) ? self.fileNameRequested() : '',
        data = (self.fileContentsRequested) ? self.fileContentsRequested() : '',
        a = document.createElement('a'),
        blob = new Blob([data], {type: 'application/json'}),
        url = window.URL.createObjectURL(blob);
      
      document.getElementById('save-dialog').appendChild(a);
      a.id = 'download';
      a.style = 'display: none';
      a.href = url;
      a.download = filename;

      var download = $('a#download').attr('download');
      // si le navigateur ne supporte pas l'attribut download
      if(typeof download === typeof undefined){
        $('a#download').text('click droit et "Enregistrer la cible du lien sous" ou "Enregistrer le lien sous"').show();
        $('#download').wrap('<p class="download-instruction">Votre navigateur ne supporte pas l\'attribut download, suivez les instructions ci-dessous<br></p>');
        return false;
      }
      a.click();
      window.URL.revokeObjectURL(url);
      self.saveToHddComplete();
    });

  this.setAutoSaveCheckboxState = function(checked) {
    $autoSaveCheckbox.prop("checked", checked);
  }

  this.showSaveDialog = function() {
    $dialog.dialog("open");
  };

  this.hideSaveDialog = function() {
    $dialog.dialog("close");
  };

  this.showCloudError = function(msg) {
    $dialog.find('.cloud-error').text(msg);
  }
};

/**
* Creates a new SaveDocumentPresenter. The presenter can store documents in the
* local storage or to a hard disk.
* 
* @constructor
* @param {mindmaps.EventBus} eventBus
* @param {mindmaps.MindMapModel} mindmapModel
* @param {mindmaps.SaveDocumentView} view
* @param {mindmaps.AutoSaveController} autosaveController
* @param {mindmaps.FilePicker} filePicker
*/
mindmaps.SaveDocumentPresenter = function(eventBus, mindmapModel, view, autosaveController, filePicker) {

  /**
  * Save in cloud button was clicked.
  */
  view.cloudStorageButtonClicked = function() {
    mindmaps.Util.trackEvent("Clicks", "cloud-save");

    filePicker.save({
      success: function() {
        view.hideSaveDialog();
      },
      error: function(msg) {
        view.showCloudError(msg);
      }
    });
  };

  /**
  * View callback when local storage button was clicked. Saves the document
  * in the local storage.
  * 
  * @ignore
  */
  view.localStorageButtonClicked = function() {
    mindmaps.Util.trackEvent("Clicks", "localstorage-save");

    var success = mindmapModel.saveToLocalStorage();
    if (success) {
      view.hideSaveDialog();
    } else {
      eventBus.publish(mindmaps.Event.NOTIFICATION_ERROR, "Une erreur s'est produite lors de la sauvegarde");
    }
  };

  /**
  * View callback when owncloud storage button was clicked. Saves the document
  * in the owncloud storage.
  * 
  * @ignore
  */
  view.owncloudStorageButtonClicked = function() {
    mindmaps.Util.trackEvent("Clicks", "localstorage-save");

    var success = mindmapModel.saveToOwncloud();
    if (success) {
      view.hideSaveDialog();
    } else {
      eventBus.publish(mindmaps.Event.NOTIFICATION_ERROR, "Une erreur s'est produite lors de la sauvegarde");
    }
  };


  /**
  * View callback: Enables or disables the autosave function for localstorage.
  *
  * @ignore
  */
  view.autoSaveCheckboxClicked = function(checked) {
    if (checked) {
      autosaveController.enable();
    } else {
      autosaveController.disable();
    }
  }

  /**
  * View callback: Returns the filename for the document for saving on hard
  * drive.
  * 
  * @ignore
  * @returns {String}
  */
  view.fileNameRequested = function() {
    mindmaps.Util.trackEvent("Clicks", "hdd-save");

    return mindmapModel.getMindMap().getRoot().getCaption() + ".json";
  };

  /**
  * View callback: Returns the serialized document.
  * 
  * @ignore
  * @returns {String}
  */
  view.fileContentsRequested = function() {
    var doc = mindmapModel.getDocument();
    return doc.prepareSave().serialize();
  };

  /**
  * View callback: Saving to the hard drive was sucessful.
  * 
  * @ignore
  */
  view.saveToHddComplete = function() {
    var doc = mindmapModel.getDocument();
    eventBus.publish(mindmaps.Event.DOCUMENT_SAVED, doc);
    view.hideSaveDialog();
  };

  this.go = function() {
    view.setAutoSaveCheckboxState(autosaveController.isEnabled());
    view.showSaveDialog();
  };
};
