// explorer les dossiers
function list_dir(dir, parent){
	var password = $('input#password').val();
	var postData = {action:'list_dir', dir: dir, parent: parent, password:password};

	$.post('server.php', postData, function(data, textStatus, xhr) {
		$('div#owncloud').show();
		$('div#owncloud .document-list').empty().append(data);
		$('#button-save-to-owncloud').attr('data-dir', dir);	// permet de savoir dans quel répertoire sauvagarder le doc

		$('#button-save-to-owncloud').show();	// on affiche le bouton de sauvegarde
		display_error(data);
	})
	.fail(function(data){
		display_error(data);
	});
}

/**
 * affiche un message d'erreur en fonction du code erreur
 * @param string error_code le code erreur
 * @return string le message d'erreur
 */
function display_error(error_code){
	$('div.error').empty();
	error_msg = '';
	if (typeof error_code !== 'undefined'){
		error_code = error_code.status;

		switch (error_code){
			case 401:
			error_msg = 'Erreur d\'authentification.';
			break;
			case 403:
			error_msg = 'Accès refusé.';
			break;
			case 415:
			error_msg = 'Le fichier n\'est pas valide.';
			break;
			case 404:
			error_msg = 'Owncloud n\'est pas activé.';
			break;
			case 500:
			error_msg = 'Le serveur a rencontré une erreur.';
			break;
		}
	}
	$('div.error').empty().text(error_msg);
}