<?php
	//--> Authentification à notre application
	
	require_once 'ldap.php';

	// Démarrage session
	session_start();
	// Nom de session
	session_name("mindmaps");
	
	// import phpCAS lib
	require_once 'CAS-1.3.1/eoleCAS.php';
	require_once 'configCAS/cas.inc.php';

	// Cas en mode débug
	if (__CAS_DEBUG) EolephpCAS::setDebug('/var/log/phpcas/phpcas-mindmaps.log'); 
	
	// Chargement du client CAS
	eolephpCAS::client(CAS_VERSION_2_0, __CAS_SERVER, __CAS_PORT, __CAS_FOLDER, false); 

	// Certificats ???
	if (__CAS_VALIDER_CA) 
	{ 
		EolephpCAS::setCasServerCACert(__CAS_CA_LOCATION); // vérification par rapport ? la CA 
	} 
	else 
	{ 
		if (method_exists("EolephpCAS", "setNoCasServerValidation")){ EolephpCAS::setNoCasServerValidation(); } 
	} 
	
	// Traitement déconnexion
	if (__CAS_LOGOUT)
	{
		if (method_exists(eolephpCAS, 'eolelogoutRequests')) eolephpCAS::eolelogoutRequests(false);
	}
	
	// Forcer l'authentification
	eolephpCAS::forceAuthentication();

	// Récupère le login de l'utilisateur
	$_SESSION["user_id"] = EolephpCAS::getUser();