/*
 * Decompiled with CFR 0.152.
 */
package gong.audio;

import gong.Utility;
import gong.audio.AudioData;
import gong.audio.AudioHandlerException;
import gong.audio.OlaBuffer;
import gong.audio.data.ImaADPCMData;
import gong.event.AudioDataListener;
import gong.event.AudioHandlerListener;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.File;
import java.net.ConnectException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;

public class AudioHandler {
    public static final AudioFormat CAPTURE_FORMAT = new AudioFormat(44100.0f, 16, 1, true, true);
    public static final AudioFormat DATA_FORMAT = new AudioFormat(11025.0f, 16, 1, true, true);
    protected AudioFormat dataFormat = null;
    protected AudioData recordData = null;
    public static final AudioFormat PLAYBACK_FORMAT = new AudioFormat(44100.0f, 16, 1, true, true);
    public static final long MAX_DURATION = 300000L;
    public static final int RECORDING = 1;
    public static final int PLAYING = 2;
    public static final int SENDING = 3;
    public static final int PAUSED = 4;
    public static final int PAUSED_RECORD = 5;
    public static final int STOPPING = 6;
    public static final int STOPPED = 7;
    public static final int CLOSING = 8;
    public static final int CLOSED = 9;
    public static final int RECEIVING = 10;
    protected AudioData audioData = null;
    protected String url = null;
    protected long time = 0L;
    protected long duration = 0L;
    protected int status = 9;
    protected boolean silenceData = false;
    protected Vector listeners = new Vector();
    protected Recorder recorder = null;
    protected Player player = null;
    protected float rate = 1.0f;
    protected boolean buffering = false;
    protected float amplitude = 0.0f;
    static /* synthetic */ Class class$javax$sound$sampled$TargetDataLine;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public void addListener(AudioHandlerListener audioHandlerListener) {
        this.listeners.add(audioHandlerListener);
        if (audioHandlerListener != null) {
            audioHandlerListener.statusUpdate(this, this.status);
            audioHandlerListener.timeUpdate(this, this.time);
            audioHandlerListener.durationUpdate(this, this.duration);
            audioHandlerListener.amplitudeUpdate(this, 0.0f);
        }
    }

    public void removeListener(AudioHandlerListener audioHandlerListener) {
        this.listeners.remove(audioHandlerListener);
    }

    public void setListeners(Vector vector) {
        this.listeners = (Vector)vector.clone();
        if (vector.size() > 0) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                AudioHandlerListener audioHandlerListener = (AudioHandlerListener)enumeration.nextElement();
                audioHandlerListener.statusUpdate(this, this.status);
                audioHandlerListener.timeUpdate(this, this.time);
                audioHandlerListener.durationUpdate(this, this.duration);
                audioHandlerListener.amplitudeUpdate(this, 0.0f);
            }
        }
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    public Vector getListeners() {
        return this.listeners;
    }

    public void setDuration(long l) {
        this.duration = l;
        if (this.listeners.size() > 0) {
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                AudioHandlerListener audioHandlerListener = (AudioHandlerListener)enumeration.nextElement();
                audioHandlerListener.durationUpdate(this, l);
            }
        }
    }

    public long getDuration() {
        return this.duration;
    }

    public void setStatus(int n) {
        if (this.status != n) {
            this.status = n;
            if (this.listeners.size() > 0) {
                Enumeration enumeration = this.listeners.elements();
                while (enumeration.hasMoreElements()) {
                    AudioHandlerListener audioHandlerListener = (AudioHandlerListener)enumeration.nextElement();
                    audioHandlerListener.statusUpdate(this, n);
                }
            }
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void setData(AudioData audioData) {
        this.audioData = audioData;
        if (audioData == null) {
            this.setTime(0L);
            this.setDuration(0L);
        } else {
            this.setDuration(audioData.getDuration());
        }
        if (audioData != null || this.url != null) {
            this.setStatus(7);
        } else {
            this.setStatus(9);
        }
    }

    public AudioData getData() {
        return this.audioData;
    }

    public void setURL(String string) {
        this.url = string != null && string.length() == 0 ? null : string;
        if (this.audioData != null || string != null) {
            this.setStatus(7);
        } else {
            this.setStatus(9);
        }
    }

    public String getURL() {
        return this.url;
    }

    public void setRate(float f) {
        this.rate = f;
        if (this.player != null) {
            this.player.setRate(f);
        }
    }

    public float getRate() {
        return this.rate;
    }

    public boolean hasData() {
        return this.audioData != null || this.url != null && this.url.length() > 0;
    }

    public void downloadData(File file, boolean bl, AudioDataListener audioDataListener) throws AudioHandlerException {
        if (this.audioData == null && !this.hasData()) {
            throw new AudioHandlerException("Failed to download empty URL.");
        }
        if (this.audioData != null) {
            while (this.audioData.isTransferInProgress()) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (Throwable throwable) {}
            }
        } else {
            BufferedInputStream bufferedInputStream;
            Object object;
            try {
                object = new URL(Utility.encodeURL(this.getURL()));
                URLConnection uRLConnection = ((URL)object).openConnection();
                uRLConnection.setUseCaches(false);
                bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
            }
            catch (Exception exception) {
                throw new AudioHandlerException("Failed to establish connection to the server.");
            }
            try {
                object = AudioData.createFromStream(bufferedInputStream);
                ((AudioData)object).setCache(file);
                ((AudioData)object).setListener(audioDataListener);
                ((AudioData)object).receiveFromStream(bufferedInputStream, bl);
                this.setURL(null);
                this.setData((AudioData)object);
            }
            catch (ConnectException connectException) {
                throw new AudioHandlerException("Failed to transfer voice data.");
            }
            catch (Exception exception) {
                throw new AudioHandlerException("Failed to open incompatible/unavailable voice data.");
            }
        }
    }

    public void downloadData(File file, boolean bl) throws AudioHandlerException {
        this.downloadData(file, bl, null);
    }

    public void setTime(long l) {
        this.time = l;
        if (this.player != null) {
            this.player.setTime(l);
        } else if (this.listeners.size() > 0) {
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                AudioHandlerListener audioHandlerListener = (AudioHandlerListener)enumeration.nextElement();
                audioHandlerListener.timeUpdate(this, l);
            }
        }
    }

    public long getTime() {
        return this.time;
    }

    public void setVolume(float f) {
        if (this.player != null) {
            this.player.setVolume(f);
        }
    }

    public boolean getBuffering() {
        return this.buffering;
    }

    public float getAmplitude() {
        return this.amplitude;
    }

    public void setDataFormat(AudioFormat audioFormat) {
        this.dataFormat = audioFormat;
    }

    public void setRecordData(AudioData audioData) {
        this.recordData = audioData;
    }

    public synchronized void record(long l) throws AudioHandlerException {
        if (this.recorder == null) {
            try {
                if (this.dataFormat == null) {
                    this.dataFormat = DATA_FORMAT;
                }
                this.recorder = new Recorder(this, CAPTURE_FORMAT, this.dataFormat, l);
                this.recorder.open();
                this.recorder.start();
            }
            catch (Exception exception) {
                this.recorder = null;
                throw new AudioHandlerException("Failed to initialize audio recorder.");
            }
        } else if (this.recorder.isPaused()) {
            this.recorder.resumeRecord();
        }
        this.url = null;
        this.setStatus(1);
    }

    public synchronized void play(long l, long l2) throws AudioHandlerException {
        if (this.player == null) {
            try {
                this.player = new Player(this, this.audioData.getFormat(), PLAYBACK_FORMAT, l2);
                this.player.open();
                this.player.setRate(this.rate);
                this.setTime(l);
                this.player.start();
            }
            catch (Exception exception) {
                this.player = null;
                throw new AudioHandlerException("Failed to initialize audio player.");
            }
        }
        this.setStatus(2);
    }

    public synchronized void play(long l) throws AudioHandlerException {
        this.play(l, 0L);
    }

    public synchronized void pause() {
        AudioHandlerListener audioHandlerListener;
        Enumeration enumeration;
        if (this.player != null) {
            this.player.kill();
            this.player = null;
            this.setStatus(4);
            if (this.listeners.size() > 0) {
                enumeration = this.listeners.elements();
                while (enumeration.hasMoreElements()) {
                    audioHandlerListener = (AudioHandlerListener)enumeration.nextElement();
                    audioHandlerListener.timeUpdate(this, this.time);
                    audioHandlerListener.durationUpdate(this, this.duration);
                    audioHandlerListener.amplitudeUpdate(this, 0.0f);
                }
            }
        }
        if (this.recorder != null) {
            this.recorder.pause();
            this.setStatus(5);
            if (this.listeners.size() > 0) {
                enumeration = this.listeners.elements();
                while (enumeration.hasMoreElements()) {
                    audioHandlerListener = (AudioHandlerListener)enumeration.nextElement();
                    audioHandlerListener.amplitudeUpdate(this, 0.0f);
                }
            }
        }
    }

    public void notifyStop() {
        try {
            this.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void stop() throws AudioHandlerException {
        if (this.status == 7) {
            return;
        }
        this.setStatus(6);
        if (this.recorder != null) {
            this.recorder.kill();
            this.silenceData = this.recorder.isSilence();
            this.recorder = null;
        }
        if (this.player != null) {
            this.player.kill();
            this.player = null;
        }
        this.setTime(0L);
        if (this.audioData != null) {
            this.audioData.reset();
        }
        this.setStatus(7);
        if (this.listeners.size() > 0) {
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                AudioHandlerListener audioHandlerListener = (AudioHandlerListener)enumeration.nextElement();
                audioHandlerListener.timeUpdate(this, this.time);
                audioHandlerListener.durationUpdate(this, this.duration);
                audioHandlerListener.amplitudeUpdate(this, 0.0f);
            }
        }
    }

    public synchronized void close() throws AudioHandlerException {
        if (this.status == 9) {
            return;
        }
        this.setStatus(8);
        if (this.recorder != null) {
            this.recorder.kill();
            this.recorder = null;
        }
        if (this.player != null) {
            this.player.kill();
            this.player = null;
        }
        this.setTime(0L);
        this.setDuration(0L);
        this.setStatus(9);
        if (this.listeners.size() > 0) {
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                AudioHandlerListener audioHandlerListener = (AudioHandlerListener)enumeration.nextElement();
                audioHandlerListener.timeUpdate(this, this.time);
                audioHandlerListener.durationUpdate(this, this.duration);
                audioHandlerListener.amplitudeUpdate(this, 0.0f);
            }
        }
    }

    public boolean isSilence() {
        return this.silenceData;
    }

    public void setSilence(boolean bl) {
        this.silenceData = bl;
    }

    protected class Player
    extends Thread {
        private AudioHandler handler;
        private SourceDataLine line;
        private AudioFormat sourceFormat;
        private AudioFormat targetFormat;
        private boolean stopped = false;
        private long timeToStart;
        private long timeToStop;
        private int delay = 0;
        private float rate = 1.0f;
        private OlaBuffer olaBuffer;
        private byte[] buffer;
        private int position;
        private float maxAmplitude = 0.0f;

        public Player(AudioHandler audioHandler2, AudioFormat audioFormat, AudioFormat audioFormat2, long l) {
            this.handler = audioHandler2;
            this.sourceFormat = audioFormat;
            this.targetFormat = audioFormat2;
            this.timeToStop = l;
            this.olaBuffer = new OlaBuffer(audioFormat, this.rate);
        }

        public void open() throws AudioHandlerException {
            DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = AudioHandler.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, this.targetFormat);
            if (!AudioSystem.isLineSupported(info)) {
                throw new AudioHandlerException("Failed to initialize audio player.");
            }
            try {
                this.line = (SourceDataLine)AudioSystem.getLine(info);
                this.line.open(this.targetFormat, (int)(this.targetFormat.getFrameRate() * (float)this.targetFormat.getFrameSize() / 4.0f));
            }
            catch (LineUnavailableException lineUnavailableException) {
                throw new AudioHandlerException("Audio player is unavailable.");
            }
            this.delay = (int)((float)this.line.getBufferSize() / (this.targetFormat.getFrameRate() * (float)this.targetFormat.getFrameSize()) * 1000.0f) + 15;
            this.setTime(0L);
            AudioHandler.this.audioData.reset();
            this.buffer = new byte[(int)(this.targetFormat.getFrameRate() * (float)this.targetFormat.getFrameSize() / 4.0f)];
            this.position = 0;
        }

        public void kill() {
            this.stopped = true;
        }

        private void write(int n) {
            float f;
            this.buffer[2 * this.position] = (byte)(n >> 8 & 0xFF);
            this.buffer[2 * this.position + 1] = (byte)(n & 0xFF);
            ++this.position;
            if (this.position >= this.buffer.length / 2) {
                this.line.write(this.buffer, 0, 2 * this.position);
                this.position = 0;
            }
            if ((f = (float)n / 32768.0f) < 0.0f) {
                f = -f;
            }
            if (f > this.maxAmplitude) {
                this.maxAmplitude = f;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.line.start();
            int n = (int)this.sourceFormat.getSampleRate() / 5;
            int n2 = 0;
            float f = 0.0f;
            float f2 = this.targetFormat.getSampleRate() / this.sourceFormat.getSampleRate();
            long l = 0L;
            long l2 = AudioHandler.this.audioData.getDuration();
            while (!this.stopped) {
                if (AudioHandler.this.audioData.getTime() == 0L || !AudioHandler.this.audioData.isAvailable()) {
                    AudioHandler.this.buffering = true;
                    while (!AudioHandler.this.audioData.isTransferBuffered(this.rate)) {
                        try {
                            Player.sleep(100L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (!this.stopped) continue;
                    }
                    AudioHandler.this.buffering = false;
                }
                if (this.stopped) break;
                try {
                    Player player = this;
                    synchronized (player) {
                        if (AudioHandler.this.audioData.isAvailable()) {
                            int n3 = AudioHandler.this.audioData.read();
                            while (f < f2) {
                                this.olaBuffer.write(n3);
                                f += 1.0f;
                                while (this.olaBuffer.isAvailable()) {
                                    this.write(this.olaBuffer.read());
                                }
                            }
                            f -= f2;
                            l = AudioHandler.this.audioData.getTime();
                            if (++n2 % n == 0 && (this.timeToStop <= 0L || l <= this.timeToStop)) {
                                if (l - (long)this.delay > this.timeToStart) {
                                    this.listenerUpdate(l - (long)this.delay, this.maxAmplitude);
                                }
                                if (this.timeToStop > 0L) {
                                    if (this.timeToStop - l < (long)this.delay) {
                                        new Timer(this.delay, l, this.maxAmplitude).start();
                                    }
                                } else if (l2 - l < (long)this.delay) {
                                    new Timer(this.delay, l, this.maxAmplitude).start();
                                }
                                this.maxAmplitude = 0.0f;
                            }
                        }
                    }
                    if ((this.timeToStop <= 0L || l <= this.timeToStop) && l != l2) continue;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                    break;
                }
            }
            this.olaBuffer.drain();
            while (this.olaBuffer.isAvailable()) {
                this.write(this.olaBuffer.read());
            }
            if (this.position > 0) {
                this.line.write(this.buffer, 0, 2 * this.position);
            }
            if (this.stopped) {
                this.line.flush();
            } else {
                this.line.drain();
            }
            this.line.stop();
            this.line.close();
            if (!this.stopped) {
                AudioHandler.this.notifyStop();
            }
        }

        public void setVolume(float f) {
            FloatControl floatControl = (FloatControl)this.line.getControl(FloatControl.Type.MASTER_GAIN);
            if (floatControl != null) {
                if (f == 0.0f) {
                    f = 1.0E-4f;
                }
                float f2 = (float)(Math.log(f) / Math.log(10.0) * 20.0);
                floatControl.setValue(f2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTime(long l) {
            try {
                Player player = this;
                synchronized (player) {
                    AudioHandler.this.audioData.setTime(l);
                    AudioHandler.this.time = l;
                    this.timeToStart = l;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setRate(float f) {
            try {
                Player player = this;
                synchronized (player) {
                    this.rate = f;
                    if (this.olaBuffer != null) {
                        this.olaBuffer.setRate(f);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private void listenerUpdate(long l, float f) {
            if (!this.stopped) {
                AudioHandler.this.time = l;
                Enumeration enumeration = AudioHandler.this.listeners.elements();
                while (enumeration.hasMoreElements()) {
                    AudioHandlerListener audioHandlerListener = (AudioHandlerListener)enumeration.nextElement();
                    audioHandlerListener.timeUpdate(this.handler, l);
                    audioHandlerListener.amplitudeUpdate(this.handler, f);
                }
            }
        }

        private class Timer
        extends Thread {
            private int delay;
            private long time;
            private float amplitude;

            public Timer(int n, long l, float f) {
                this.delay = n;
                this.time = l;
                this.amplitude = f;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Timer.sleep(this.delay);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Timer timer = this;
                synchronized (timer) {
                    Player.this.listenerUpdate(this.time, this.amplitude);
                }
            }
        }
    }

    protected class Recorder
    extends Thread {
        private static final float MIN_SILENCE_LEVEL = 0.01f;
        private static final float MIN_SILENCE_PERCENTAGE = 0.9f;
        private AudioHandler handler;
        private TargetDataLine line;
        private AudioFormat sourceFormat;
        private AudioFormat targetFormat;
        private boolean paused = false;
        private boolean stopped = false;
        private float maxAmplitude = 0.0f;
        private int amplSampleCount = 0;
        private float sampleCount = 0.0f;
        private long totalBufferBlock = 0L;
        private long silenceBufferBlock = 0L;
        private long timeToStop = 0L;

        public Recorder(AudioHandler audioHandler2, AudioFormat audioFormat, AudioFormat audioFormat2, long l) {
            this.handler = audioHandler2;
            this.sourceFormat = audioFormat;
            this.targetFormat = audioFormat2;
            this.timeToStop = l;
        }

        public void open() throws AudioHandlerException {
            DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$TargetDataLine == null ? (class$javax$sound$sampled$TargetDataLine = AudioHandler.class$("javax.sound.sampled.TargetDataLine")) : class$javax$sound$sampled$TargetDataLine, this.sourceFormat);
            if (!AudioSystem.isLineSupported(info)) {
                throw new AudioHandlerException("Failed to initialize audio recorder.");
            }
            try {
                this.line = (TargetDataLine)AudioSystem.getLine(info);
                this.line.open(this.sourceFormat, this.line.getBufferSize());
            }
            catch (LineUnavailableException lineUnavailableException) {
                throw new AudioHandlerException("Audio recorder is unavailable.");
            }
            AudioHandler.this.setData(null);
        }

        public void pause() {
            this.paused = true;
        }

        public boolean isPaused() {
            return this.paused;
        }

        public void resumeRecord() {
            this.paused = false;
        }

        public void kill() {
            this.stopped = true;
            while (AudioHandler.this.getDuration() != AudioHandler.this.audioData.getDuration()) {
                try {
                    Recorder.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }

        public void run() {
            int n;
            int n2 = this.line.getBufferSize() / 8;
            int n3 = n2 * this.sourceFormat.getFrameSize();
            byte[] byArray = new byte[n3];
            long l = 0L;
            this.line.start();
            if (AudioHandler.this.recordData == null) {
                AudioHandler.this.audioData = new ImaADPCMData(this.targetFormat);
            } else {
                AudioHandler.this.audioData = AudioHandler.this.recordData;
                AudioHandler.this.recordData = null;
            }
            float f = this.sourceFormat.getSampleRate() / this.targetFormat.getSampleRate();
            while (!this.stopped && (n = this.line.read(byArray, 0, n3)) != -1) {
                if (this.paused) continue;
                int n4 = 0;
                for (int i = 0; i < n; i += 2) {
                    int n5 = byArray[i] << 8 | byArray[i + 1] & 0xFF;
                    float f2 = (float)n5 / 32768.0f;
                    if (f2 < 0.0f) {
                        f2 = -f2;
                    }
                    if (f2 < 0.01f) {
                        ++n4;
                    }
                    if (this.sampleCount < 1.0f) {
                        try {
                            AudioHandler.this.audioData.write(n5);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (f2 > this.maxAmplitude) {
                            this.maxAmplitude = f2;
                        }
                        ++this.amplSampleCount;
                        if (this.amplSampleCount == (int)this.targetFormat.getSampleRate() / 5) {
                            AudioHandler.this.amplitude = this.maxAmplitude;
                            if (AudioHandler.this.listeners.size() > 0) {
                                Enumeration enumeration = AudioHandler.this.listeners.elements();
                                while (enumeration.hasMoreElements()) {
                                    AudioHandlerListener audioHandlerListener = (AudioHandlerListener)enumeration.nextElement();
                                    audioHandlerListener.amplitudeUpdate(this.handler, this.maxAmplitude);
                                }
                            }
                            this.amplSampleCount = 0;
                            this.maxAmplitude = 0.0f;
                        }
                    }
                    this.sampleCount += 1.0f;
                    if (!(this.sampleCount >= f)) continue;
                    this.sampleCount -= f;
                }
                if ((float)n4 / ((float)n / 2.0f) > 0.9f) {
                    ++this.silenceBufferBlock;
                }
                ++this.totalBufferBlock;
                l = AudioHandler.this.audioData.getTime();
                if (AudioHandler.this.listeners.size() > 0) {
                    Enumeration enumeration = AudioHandler.this.listeners.elements();
                    while (enumeration.hasMoreElements()) {
                        AudioHandlerListener audioHandlerListener = (AudioHandlerListener)enumeration.nextElement();
                        audioHandlerListener.timeUpdate(this.handler, l);
                    }
                }
                if (l <= this.timeToStop) continue;
                Toolkit.getDefaultToolkit().beep();
                break;
            }
            this.line.stop();
            this.line.close();
            try {
                AudioHandler.this.audioData.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            l = 0L;
            AudioHandler.this.amplitude = 0.0f;
            if (AudioHandler.this.listeners.size() > 0) {
                Enumeration enumeration = AudioHandler.this.listeners.elements();
                while (enumeration.hasMoreElements()) {
                    AudioHandlerListener audioHandlerListener = (AudioHandlerListener)enumeration.nextElement();
                    audioHandlerListener.timeUpdate(this.handler, l);
                    audioHandlerListener.amplitudeUpdate(this.handler, 0.0f);
                }
            }
            AudioHandler.this.setDuration(AudioHandler.this.audioData.getDuration());
            if (!this.stopped) {
                AudioHandler.this.notifyStop();
            }
        }

        public boolean isSilence() {
            return (float)this.silenceBufferBlock / (float)this.totalBufferBlock > 0.9f;
        }
    }
}

