/*
 * Decompiled with CFR 0.152.
 */
package gong.audio.data;

import gong.audio.AudioData;
import gong.audio.AudioDataException;
import gong.audio.data.BlockAudioData;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import javax.sound.sampled.AudioFormat;

public class ImaADPCMData
extends BlockAudioData {
    public static final String FILE_EXTENSION = ".wav";
    protected static final int DEFAULT_ADPCM_CODE_SIZE = 4;
    protected int codeSize = 4;
    protected static final int[][] indexTable = new int[][]{{-1, 2}, {-1, -1, 2, 4}, {-1, -1, -1, -1, 2, 4, 6, 8}, {-1, -1, -1, -1, -1, -1, -1, -1, 1, 2, 4, 6, 8, 10, 13, 16}};
    protected static final int[] stepsizeTable = new int[]{7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 19, 21, 23, 25, 28, 31, 34, 37, 41, 45, 50, 55, 60, 66, 73, 80, 88, 97, 107, 118, 130, 143, 157, 173, 190, 209, 230, 253, 279, 307, 337, 371, 408, 449, 494, 544, 598, 658, 724, 796, 876, 963, 1060, 1166, 1282, 1411, 1552, 1707, 1878, 2066, 2272, 2499, 2749, 3024, 3327, 3660, 4026, 4428, 4871, 5358, 5894, 6484, 7132, 7845, 8630, 9493, 10442, 11487, 12635, 13899, 15289, 16818, 18500, 20350, 22385, 24623, 27086, 29794, Short.MAX_VALUE};
    protected static final int DEFAULT_BLOCK_ALIGN = 256;
    protected int blockAlign = 256;
    protected long cacheSize = 0L;

    public ImaADPCMData() {
        this.samplesPerBlock = (this.blockAlign - 4) * 2 + 1;
    }

    public ImaADPCMData(AudioFormat audioFormat) {
        super(audioFormat);
        this.samplesPerBlock = (this.blockAlign - 4) * 2 + 1;
    }

    public String getFileExtension() {
        return FILE_EXTENSION;
    }

    protected BlockAudioData.Block createBlock() {
        int n = this.position / this.samplesPerBlock;
        if (n == 0) {
            return new ImaADPCMBlock(this.samplesPerBlock);
        }
        ImaADPCMBlock imaADPCMBlock = (ImaADPCMBlock)this.blockData.lastElement();
        ADPCMState aDPCMState = imaADPCMBlock.getState();
        return new ImaADPCMBlock(aDPCMState.index, this.samplesPerBlock);
    }

    public boolean isSupported(String string) {
        if (string.equals("sent-progress")) {
            return true;
        }
        return string.equals("received-progress");
    }

    public synchronized long getMemoryUsage() {
        return (long)this.blockData.size() * (long)this.blockAlign;
    }

    public synchronized Object clone() {
        ImaADPCMData imaADPCMData = new ImaADPCMData(this.format);
        Enumeration enumeration = this.blockData.elements();
        while (enumeration.hasMoreElements()) {
            imaADPCMData.blockData.add(((ImaADPCMBlock)enumeration.nextElement()).clone());
        }
        imaADPCMData.blockAlign = this.blockAlign;
        imaADPCMData.samplesPerBlock = this.samplesPerBlock;
        imaADPCMData.availableBlocks = this.availableBlocks;
        return imaADPCMData;
    }

    protected void sendHeaderToStream(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.write(new String("RIFF").getBytes());
        int n = 52 + this.blockData.size() * this.blockAlign;
        dataOutputStream.writeInt(ImaADPCMData.swapInt(n));
        dataOutputStream.write(new String("WAVE").getBytes());
        dataOutputStream.write(new String("fmt ").getBytes());
        dataOutputStream.writeInt(ImaADPCMData.swapInt(20));
        dataOutputStream.writeShort(ImaADPCMData.swapShort((short)17));
        dataOutputStream.writeShort(ImaADPCMData.swapShort((short)1));
        dataOutputStream.writeInt(ImaADPCMData.swapInt((int)this.format.getSampleRate()));
        int n2 = (int)(this.format.getSampleRate() / (float)this.samplesPerBlock * (float)this.blockAlign);
        dataOutputStream.writeInt(ImaADPCMData.swapInt(n2));
        dataOutputStream.writeShort(ImaADPCMData.swapShort((short)this.blockAlign));
        dataOutputStream.writeShort(ImaADPCMData.swapShort((short)4));
        dataOutputStream.writeShort(ImaADPCMData.swapShort((short)2));
        dataOutputStream.writeShort(ImaADPCMData.swapShort((short)this.samplesPerBlock));
        dataOutputStream.write(new String("fact").getBytes());
        dataOutputStream.writeInt(ImaADPCMData.swapInt(4));
        dataOutputStream.writeInt(ImaADPCMData.swapInt(this.getLength()));
    }

    protected void sendDataToStream(OutputStream outputStream) throws IOException, AudioDataException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.write(new String("data").getBytes());
        int n = this.blockData.size() * this.blockAlign;
        dataOutputStream.writeInt(ImaADPCMData.swapInt(n));
        int n2 = 0;
        Enumeration enumeration = this.blockData.elements();
        while (enumeration.hasMoreElements()) {
            ImaADPCMBlock imaADPCMBlock = (ImaADPCMBlock)enumeration.nextElement();
            imaADPCMBlock.sendToStream(outputStream);
            ++n2;
            if (this.listener == null) continue;
            this.listener.sent(this, this.getBlockTime(n2));
        }
    }

    public synchronized void sendToStream(OutputStream outputStream) throws IOException, AudioDataException {
        this.sendHeaderToStream(outputStream);
        this.sendDataToStream(outputStream);
    }

    public void receiveHeaderFromStream(InputStream inputStream, OutputStream outputStream) throws IOException, AudioDataException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[4];
        this.receiveByteArrayFromStream(dataInputStream, byArray, 0, 4);
        if (!new String(byArray, 0, 4).equals("RIFF")) {
            throw new AudioDataException("Invalid chunk id ('RIFF').");
        }
        int n = ImaADPCMData.swapInt(dataInputStream.readInt());
        this.receiveByteArrayFromStream(dataInputStream, byArray, 0, 4);
        if (!new String(byArray, 0, 4).equals("WAVE")) {
            throw new AudioDataException("Invalid riff type ('WAVE').");
        }
        this.receiveByteArrayFromStream(dataInputStream, byArray, 0, 4);
        if (!new String(byArray, 0, 4).equals("fmt ")) {
            throw new AudioDataException("Invalid chunk id ('fmt ').");
        }
        int n2 = ImaADPCMData.swapInt(dataInputStream.readInt());
        if (n2 != 20) {
            throw new AudioDataException("Invalid chunk size.");
        }
        short s = ImaADPCMData.swapShort(dataInputStream.readShort());
        if (s != 17) {
            throw new AudioDataException("Invalid compression code.");
        }
        short s2 = ImaADPCMData.swapShort(dataInputStream.readShort());
        if (s2 != 1) {
            throw new AudioDataException("Invalid channel.");
        }
        int n3 = ImaADPCMData.swapInt(dataInputStream.readInt());
        this.format = new AudioFormat(n3, 16, 1, true, true);
        int n4 = ImaADPCMData.swapInt(dataInputStream.readInt());
        short s3 = ImaADPCMData.swapShort(dataInputStream.readShort());
        this.blockAlign = s3;
        short s4 = ImaADPCMData.swapShort(dataInputStream.readShort());
        if (s4 != 4) {
            throw new AudioDataException("Invalid sample size.");
        }
        short s5 = ImaADPCMData.swapShort(dataInputStream.readShort());
        if (s5 != 2) {
            throw new AudioDataException("Invalid extra bytes.");
        }
        short s6 = ImaADPCMData.swapShort(dataInputStream.readShort());
        this.samplesPerBlock = (s3 - 4) * 2 + 1;
        if (this.samplesPerBlock != s6) {
            throw new AudioDataException("Invalid samples per block.");
        }
        if (outputStream != null) {
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeBytes("RIFF");
            dataOutputStream.writeInt(ImaADPCMData.swapInt(n));
            dataOutputStream.writeBytes("WAVE");
            dataOutputStream.writeBytes("fmt ");
            dataOutputStream.writeInt(ImaADPCMData.swapInt(n2));
            dataOutputStream.writeShort(ImaADPCMData.swapShort(s));
            dataOutputStream.writeShort(ImaADPCMData.swapShort(s2));
            dataOutputStream.writeInt(ImaADPCMData.swapInt(n3));
            dataOutputStream.writeInt(ImaADPCMData.swapInt(n4));
            dataOutputStream.writeShort(ImaADPCMData.swapShort(s3));
            dataOutputStream.writeShort(ImaADPCMData.swapShort(s4));
            dataOutputStream.writeShort(ImaADPCMData.swapShort(s5));
            dataOutputStream.writeShort(ImaADPCMData.swapShort(s6));
            this.cacheSize += 40L;
        }
    }

    protected void receiveDataFromStream(InputStream inputStream, OutputStream outputStream, boolean bl) throws IOException, AudioDataException {
        block15: {
            Object object;
            Object object2;
            int n;
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            byte[] byArray = new byte[4];
            while (true) {
                this.receiveByteArrayFromStream(dataInputStream, byArray, 0, 4);
                n = ImaADPCMData.swapInt(dataInputStream.readInt());
                if (new String(byArray, 0, 4).equals("data")) break;
                if (outputStream == null) {
                    dataInputStream.skip(n);
                    continue;
                }
                object2 = new byte[n];
                dataInputStream.read((byte[])object2);
                object = new DataOutputStream(outputStream);
                ((DataOutputStream)object).write(byArray, 0, 4);
                ((DataOutputStream)object).writeInt(ImaADPCMData.swapInt(n));
                ((FilterOutputStream)object).write((byte[])object2);
                this.cacheSize += (long)(8 + n);
            }
            if (n % this.blockAlign != 0) {
                throw new AudioDataException("Invalid block align.");
            }
            if (outputStream != null) {
                object2 = new DataOutputStream(outputStream);
                ((DataOutputStream)object2).writeBytes("data");
                ((DataOutputStream)object2).writeInt(ImaADPCMData.swapInt(n));
                this.cacheSize += 8L;
            }
            for (int i = 0; i < n / this.blockAlign; ++i) {
                object = new ImaADPCMBlock(this.samplesPerBlock);
                this.blockData.add(object);
            }
            if (bl) {
                block6: while (true) {
                    try {
                        while (true) {
                            ImaADPCMBlock imaADPCMBlock = (ImaADPCMBlock)this.blockData.get(this.availableBlocks);
                            imaADPCMBlock.receiveFromStream(inputStream, outputStream);
                            ++this.availableBlocks;
                            if (this.listener != null) {
                                this.listener.received(this, this.getAvailable());
                            }
                            try {
                                if (outputStream == null) continue block6;
                                outputStream.close();
                                continue block6;
                            }
                            catch (IOException iOException) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        if (n != this.blockData.size() * this.blockAlign) {
                            throw new AudioDataException("Invalid block data.");
                        }
                        break block15;
                    }
                }
            }
            if (this.transferThread == null) {
                this.transferThread = this.getTransferThread();
                this.transferThread.start(inputStream, outputStream);
            }
        }
    }

    public synchronized void receiveFromStream(InputStream inputStream, boolean bl) throws IOException, AudioDataException {
        FileOutputStream fileOutputStream = null;
        if (this.cache != null) {
            fileOutputStream = new FileOutputStream(this.cache);
        }
        this.receiveHeaderFromStream(inputStream, fileOutputStream);
        this.receiveDataFromStream(inputStream, fileOutputStream, bl);
    }

    protected AudioData.TransferThread getTransferThread() {
        return new ImaADPCMTransferThread();
    }

    protected class ADPCMState
    implements Cloneable {
        public int previousValue;
        public int index;

        public ADPCMState() {
            this.previousValue = 0;
            this.index = 0;
        }

        public ADPCMState(int n, int n2) {
            this.previousValue = n;
            this.index = n2;
        }

        public Object clone() {
            return new ADPCMState(this.previousValue, this.index);
        }
    }

    protected class ImaADPCMBlock
    extends BlockAudioData.Block {
        protected ADPCMState header;
        protected ADPCMState state;
        protected long cacheOffset;

        public ImaADPCMBlock(int n) {
            this(0, n);
        }

        public ImaADPCMBlock(int n, int n2) {
            super(n2);
            this.header = new ADPCMState();
            this.state = null;
            this.cacheOffset = -1L;
            this.header.index = n;
        }

        public synchronized ADPCMState getState() {
            return this.state;
        }

        protected int decode(byte by) {
            int n = stepsizeTable[this.state.index];
            int n2 = n >> ImaADPCMData.this.codeSize - 1;
            int n3 = 1 << ImaADPCMData.this.codeSize - 2;
            int n4 = 0;
            while (n4 < ImaADPCMData.this.codeSize - 1) {
                if ((by & n3) != 0) {
                    n2 += n >> n4;
                }
                ++n4;
                n3 >>= 1;
            }
            n3 = 1 << ImaADPCMData.this.codeSize - 1;
            if ((by & n3) != 0) {
                n2 = -n2;
            }
            this.state.previousValue += n2;
            if (this.state.previousValue > Short.MAX_VALUE) {
                this.state.previousValue = Short.MAX_VALUE;
            } else if (this.state.previousValue < Short.MIN_VALUE) {
                this.state.previousValue = Short.MIN_VALUE;
            }
            this.state.index += indexTable[ImaADPCMData.this.codeSize - 2][by & ~n3];
            if (this.state.index < 0) {
                this.state.index = 0;
            } else if (this.state.index > 88) {
                this.state.index = 88;
            }
            return this.state.previousValue;
        }

        protected byte encode(int n) {
            int n2 = n - this.state.previousValue;
            int n3 = stepsizeTable[this.state.index];
            byte by = 0;
            if (n2 < 0) {
                by = (byte)(1 << ImaADPCMData.this.codeSize - 1);
                n2 = -n2;
            }
            int n4 = ImaADPCMData.this.codeSize - 2;
            while (n4 >= 0) {
                if (n2 >= n3) {
                    by = (byte)(by | (byte)(1 << n4));
                    n2 -= n3;
                }
                --n4;
                n3 >>= 1;
            }
            this.decode(by);
            return by;
        }

        public synchronized int read() throws IOException, AudioDataException {
            if (this.eob()) {
                throw new AudioDataException("Invalid read request.");
            }
            if (this.position == 0) {
                this.position = 1;
                this.state = (ADPCMState)this.header.clone();
                return this.state.previousValue;
            }
            if (this.data == null && this.cacheOffset < 0L) {
                throw new AudioDataException("Invalid read request.");
            }
            int n = (this.position - 1) / 2;
            int n2 = (this.position - 1) % 2;
            byte by = 0;
            by = this.data == null ? ImaADPCMData.this.cacheInputStream.read(this.cacheOffset + (long)n + 4L) : this.data[n];
            byte by2 = n2 == 0 ? (byte)(by & 0xF) : (byte)(by >> 4 & 0xF);
            ++this.position;
            return this.decode(by2);
        }

        public synchronized void write(int n) throws IOException, AudioDataException {
            if (this.eob()) {
                throw new AudioDataException("Invalid write request.");
            }
            if (this.data == null) {
                this.data = new byte[(this.size - 1) / 2];
                Arrays.fill(this.data, (byte)0);
            }
            if (this.position == 0) {
                this.header.previousValue = n;
                this.state = (ADPCMState)this.header.clone();
                this.position = 1;
            } else {
                byte by = this.encode(n);
                int n2 = (this.position - 1) / 2;
                int n3 = (this.position - 1) % 2;
                if (n3 == 0) {
                    int n4 = n2;
                    this.data[n4] = (byte)(this.data[n4] | (byte)(by & 0xF));
                } else {
                    int n5 = n2;
                    this.data[n5] = (byte)(this.data[n5] | (byte)(by << 4 & 0xF0));
                }
                ++this.position;
            }
        }

        public synchronized int seek(int n) throws IOException, AudioDataException {
            if (n < 0 || n >= this.size) {
                throw new AudioDataException("Invalid seek position.");
            }
            if (n == this.position) {
                return n;
            }
            if (n == 0) {
                this.reset();
                return n;
            }
            if (n < this.position) {
                this.reset();
                for (int i = 0; i < n; ++i) {
                    this.read();
                }
                this.position = n;
                return this.position;
            }
            for (int i = this.position; i < n; ++i) {
                this.read();
            }
            this.position = n;
            return this.position;
        }

        public synchronized void clear() {
            super.clear();
            this.header.index = 0;
            this.header.previousValue = 0;
        }

        public synchronized void reset() {
            super.reset();
            this.state = null;
        }

        public Object clone() {
            ImaADPCMBlock imaADPCMBlock = new ImaADPCMBlock(this.size);
            if (this.data != null) {
                imaADPCMBlock.data = new byte[this.data.length];
                System.arraycopy(this.data, 0, imaADPCMBlock.data, 0, this.data.length);
            }
            imaADPCMBlock.header = (ADPCMState)this.header.clone();
            imaADPCMBlock.size = this.size;
            imaADPCMBlock.position = this.position;
            imaADPCMBlock.cacheOffset = this.cacheOffset;
            return imaADPCMBlock;
        }

        public synchronized void sendToStream(OutputStream outputStream) throws IOException, AudioDataException {
            if (this.data == null && this.cacheOffset < 0L) {
                throw new AudioDataException("Invalid send request.");
            }
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeShort(AudioData.swapShort((short)this.header.previousValue));
            dataOutputStream.writeByte((byte)this.header.index);
            dataOutputStream.writeByte(0);
            if (this.data == null) {
                byte[] byArray = new byte[(this.size - 1) / 2];
                ImaADPCMData.this.cacheInputStream.read(byArray, this.cacheOffset + 4L);
                dataOutputStream.write(byArray);
            } else {
                dataOutputStream.write(this.data);
            }
        }

        public synchronized void receiveFromStream(InputStream inputStream, OutputStream outputStream) throws IOException {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            this.header.previousValue = AudioData.swapShort(dataInputStream.readShort());
            this.header.index = dataInputStream.read();
            if (this.header.index == -1) {
                throw new ConnectException("Connection error.");
            }
            if (dataInputStream.read() == -1) {
                throw new ConnectException("Connection error.");
            }
            this.data = new byte[(this.size - 1) / 2];
            ImaADPCMData.this.receiveByteArrayFromStream(dataInputStream, this.data, 0, this.data.length);
            if (ImaADPCMData.this.cache != null && outputStream != null) {
                this.cacheOffset = ImaADPCMData.this.cacheSize;
                DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
                dataOutputStream.writeShort(AudioData.swapShort((short)this.header.previousValue));
                dataOutputStream.write(this.header.index);
                dataOutputStream.write(0);
                dataOutputStream.write(this.data, 0, this.data.length);
                ImaADPCMData.this.cacheSize += (long)(this.data.length + 4);
                this.data = null;
            }
        }
    }

    protected class ImaADPCMTransferThread
    extends AudioData.TransferThread {
        private long lastUpdatedTime = 0L;

        protected ImaADPCMTransferThread() {
        }

        public void run() {
            super.run();
            try {
                while (this.inProgress) {
                    ImaADPCMBlock imaADPCMBlock = (ImaADPCMBlock)ImaADPCMData.this.blockData.get(ImaADPCMData.this.availableBlocks);
                    imaADPCMBlock.receiveFromStream(this.in, this.out);
                    ++ImaADPCMData.this.availableBlocks;
                    if (ImaADPCMData.this.listener == null) continue;
                    long l = new Date().getTime();
                    if (this.lastUpdatedTime != 0L && this.lastUpdatedTime + 500L >= l) continue;
                    ImaADPCMData.this.listener.received(ImaADPCMData.this, ImaADPCMData.this.getAvailable());
                    this.lastUpdatedTime = l;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ImaADPCMData.this.listener != null) {
                ImaADPCMData.this.listener.finish(ImaADPCMData.this, ImaADPCMData.this.getAvailable());
            }
            try {
                if (this.out != null) {
                    this.out.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ImaADPCMData.this.transferThread = null;
        }
    }
}

