<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodleorg', language 'fr', branch 'MOODLE_25_STABLE'
 *
 * @package   local_moodleorg
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutdemosite'] = 'Notre site de démonstration est un site Moodle complet avec quelques échantillons de cours que vous pouvez tester en tant qu\'enseignant, étudiant ou même en tant qu\'administrateur. N\'hésitez pas à expérimenter comme vous le voulez : le site est totalement remis en état toutes les heures. Aucun problème si vous y provoquez le chaos !';
$string['aboutdemositetitle'] = 'Site de démonstration';
$string['aboutintro'] = 'Moodle est un environnement d\'apprentissage libre et gratuit (Learning Management System ou LMS). Moodle est très populaire dans la communauté des acteurs de l\'éducation du monde entier comme outil de création de site web en ligne pour les élèves et étudiants. Pour faire fonctionner Moodle, il est nécessaire de l\'installer sur un serveur web, soit sur l\'un de vos propres ordinateurs, soit auprès d\'un hébergeur web.';
$string['aboutoverview'] = '<p>L\'ambition du projet Moodle est de donner aux acteurs de l\'éducation les meilleurs outils pour gérer et promouvoir l\'apprentissage. Il y a de nombreuses façons différentes d\'utiliser Moodle :</p>
<ul>
<li>Moodle comporte des fonctionnalités lui permettant de s\'adapter à de très gros déploiements, avec des centaines de milliers d\'étudiants. Mais il peut aussi être utilisé par une école primaire ou par un formateur indépendant ;</li>
<li>de nombreuses institutions l\'utilisent comme leur plateforme pour proposer des cours totalement en ligne, alors que d\'autres l\'utilisent comme complément à l\'enseignement présentiel, dans ce que l\'on appelle de l\'enseignement hybride ;</li>
<li>beaucoup parmi nos utilisateurs aiment utiliser les modules d\'activités (tels que forums, glossaires ou wikis) pour construire de riches communautés d\'apprentissage collaboratif (dans la tradition socio-constructiviste), alors que d\'autres préfèrent utiliser Moodle pour fournir des contenus (tels que des paquets SCORM standards) à leurs étudiants et évaluer l\'apprentissage au moyen de devoir et de tests.</li>
</ul>';
$string['aboutoverviewtitle'] = 'Qu\'est-ce que Moodle ?';
$string['aboutstatistics'] = 'Moodle est téléchargeable gratuitement et son enregistrement est facultatif. Nous ne disposons donc pas d\'informations sur toutes les personnes qui l\'utilisent. Cependant, à l\'aide des données dont nous disposons, nous générons automatiquement quelques graphiques et quelques nombres intéressants sur notre page de statistiques.';
$string['aboutstatisticsheading'] = 'Statistiques Moodle';
$string['aboutstatisticstitle'] = 'Moodle.org : statistiques Moodle';
$string['activeusers24hours'] = 'Utilisateurs enregistrés actifs durant les dernières 24 heures :';
$string['activeuserspastmonth'] = 'Utilisateurs enregistrés actifs durant le mois passé :';
$string['communityintro'] = 'Moodle possède une communauté d\'utilisateurs vaste et variée, comprenant plus de <a href="http://moodle.org/userpics">{$a->usercount} utilisateurs enregistrés</a> rien que sur ce site Moodle, parlant plus de <a href="http://download.moodle.org/lang16/">{$a->langcount} langues</a> et provenant de <a href="http://moodle.org/sites">{$a->countrycount} pays</a> (voyez nos <a href="http://moodle.org/stats">autres statistiques</a>).';
$string['conferencecenter'] = 'Centre de congrès Moodle';
$string['connectedsites'] = 'Certains sites Moodle sont connectés à moodle.org via le réseau Moodle. Vous pouvez ainsi vous connecter directement à ces sites si vous vous êtes authentifié ici.';
$string['connectedsitestitle'] = 'Sites connectés';
$string['contactbugs'] = 'Vous pouvez annoncer des problèmes détectés dans le logiciel Moodle et sur les sites web de moodle.org en créant un nouveau rapport dans le traqueur de bogues de Moodle.';
$string['contactbugstitle'] = 'Annonce de bogue';
$string['contactintro'] = 'Veuillez sélectionner l\'une des options de contact suivantes :';
$string['contactlogin'] = 'Pour toutes les autres demandes, connectez-vous sur ce site et utilisez le formulaire de contact apparaissant sur cette page.';
$string['contactmoodlecom'] = 'Pour toute demande liée aux questions de licence, de marque déposée ou à des questions commerciales, ainsi que pour des développements majeurs de Moodle, veuillez contacter le centre d\'assistance <a href="http://moodle.com/">moodle.com</a>';
$string['contactmoodlecomhelpdesk'] = 'Centre d\'assistance moodle.com';
$string['contactmoodlecomtitle'] = 'Moodle.com';
$string['contactmoodleorgemail'] = 'Pour des problèmes liés à la confirmation de votre compte sur moodle.org, envoyez un courriel à cette adresse :';
$string['contactmoodleorglogin'] = 'Se connecter sur ce site';
$string['contactmoodleorgother'] = 'Pour toute autre demande, veuillez utiliser le formulaire de contact ci-dessous.';
$string['contactmoodleorgtitle'] = 'Moodle.org';
$string['contactsecurity'] = 'Les problèmes de sécurité peuvent également être annoncés de manière sécurisée dans le traqueur de bogues, en indiquant de façon adéquate le niveau de sécurité supposé.';
$string['contactsent'] = 'Votre message a été envoyé par courriel au gestionnaire de la communauté Moodle.';
$string['contactsupport'] = 'Pour de l\'assistance à l\'utilisation du logiciel Moodle, veuillez consulter notre page d\'assistance, qui propose de nombreuses ressources propres à vous aider.';
$string['contactsupporttitle'] = 'Assistance';
$string['developerlist'] = 'Liste complète des développeurs avec accès en écriture';
$string['developermeetings'] = 'Réunion des développeurs';
$string['developers'] = 'Le développement de Moodle est encadré par l\'équipe centrale de développement de Moodle.com. Des centaines d\'autres développeurs du monde entier y participent également. Certains de ces développeurs sont directement responsables de différents modules et plugins.';
$string['developerstitle'] = 'Développeurs';
$string['developmentdocs'] = 'Le gros de notre documentation est dans Moodle Docs, qui comporte notamment les spécifications, réflexions, procédures, standards et manuels d\'utilisation.';
$string['developmentdocstitle'] = 'Documentation développeur';
$string['developmentintro'] = 'Nous visons un processus de développement transparent et ouvert, qui invite toute la communauté des utilisateurs à contribuer. Les programmeurs PHP sont bien sûrs les bienvenus, mais vous pouvez également contribuer par des discussions, des tests, des feedbacks et de la documentation.';
$string['developmenttracker'] = 'Toutes les problématiques de développement (comme les bogues, nouvelles fonctionnalités et améliorations) sont enregistrées et gérées dans le traqueur de bogues de Moodle. Vous pouvez voir qui y travaille et contribuer à toutes les conversations. Veuillez chercher avant tout dans le traqueur si vous recherchez une problématique spécifique. Assurez-vous de <strong>voter</strong> pour les problématiques que vous voudriez voir corrigées ou améliorées : vos votes nous aident à déterminer les priorités du développement.';
$string['donations'] = 'Moodle est offert sans aucune obligation financière. Nombreux sont cependant les membres de la communauté qui ont fait un don à notre projet afin de nous aider à payer les développeurs qui permettent à Moodle d\'exister.';
$string['donationsmoney'] = 'Vous pouvez aussi contribuer directement au moyen d\'un don en argent. Ces montants sont utilisés pour réaliser les fonctionnalités désirées sur notre feuille de route. Pour faire un don par carte de crédit dans la plupart des principales devises, veuillez cliquer sur le bouton Paypal ci-dessous.<br /><br /> Les donateurs de plus de 10 $ peuvent ajouter leur nom à cette page pour une année. N\'oubliez pas de cliquer sur le bouton « continuer » après avoir payé, pour voir le formulaire où vous pouvez modifier la façon dont votre entrée apparaît.';
$string['donationsservices'] = 'Si vous avez un besoin de services Moodle comme de l\'hébergement, du soutien, une installation, une programmation personnalisée, l\'élaboration de cours ou du consulting, veuillez contacter un <a href="http://moodle.com/">Partenaire Moodle de moodle.com</a> autorisé (vous verrez leurs bandeaux publicitaires sur ce site). Les partenaires versent un pourcentage fixe de tous leurs revenus dans le fonds de développement du Moodle Trust, de sorte que tout le monde est gagnant.';
$string['donationstitle'] = 'Dons';
$string['donationstrust'] = 'Moodle a un fonds de développement géré par le Moodle trust, qui fait des contrats avec des programmeurs pour travailler sur Moodle, et prend également en charge des dépenses comme moodle.org.';
$string['downloadcore'] = 'Notre méthode de distribution principale a lieu au moyen de ces paquetages standards. Ils contiennent les modules et plugins maintenus par les développeurs centraux et conviennent à une installation sur pratiquement tous les environnements disposant de PHP et d\'un gestionnaire de base de données.';
$string['downloadcoretitle'] = 'Paquetages Moodle standards';
$string['downloadintro'] = 'Moodle est un logiciel libre sous <a href="http://docs.moodle.org/fr/Licence">Licence GPL</a>. Tout ce que nous produisons est disponible au téléchargement librement et gratuitement.';
$string['downloadlang'] = 'Dans les versions actuelles de Moodle, l\'ajout de nouvelles langues pour l\'interface a été automatisé et est accessible dans le menu d\'administration de votre site. Toutefois, pour certaines versions plus anciennes de Moodle, les nouveaux paquetages de langue doivent être téléchargés manuellement.';
$string['downloadlangtitle'] = 'Paquetages de langue';
$string['downloadlogotitle'] = 'Logos Moodle';
$string['downloadmac'] = 'Si vous ne disposez pas d\'un serveur web déjà installé, ces paquetages tout-en-un vous permettront d\'installer très facilement Moodle sur tout ordinateur Apple avec Mac OS X.';
$string['downloadmactitle'] = 'Moodle pour Mac OS X';
$string['downloadmodules'] = 'Consultez notre base de données très fournie de modules et plugins pouvant être ajoutés à votre site Moodle pour lui donner des fonctionnalités supplémentaires par rapport à la version standard.';
$string['downloadmodulestitle'] = 'Modules et plugins';
$string['downloadthemes'] = 'L\'apparence d\'un site Moodle peut être modifiée complètement en utilisant un nouveau thème. Nous tenons à jour une base de données de thèmes que des utilisateurs de Moodle ont créés et partagés.';
$string['downloadthemestitle'] = 'Thèmes';
$string['downloadwin'] = 'Si vous ne disposez pas d\'un serveur web déjà installé, ces paquetages tout-en-un vous permettront d\'installer très facilement Moodle sur tout ordinateur tournant sous Microsoft Windows.';
$string['downloadwintitle'] = 'Moodle pour Windows';
$string['erroradminonly'] = 'Seuls les administrateurs peuvent accéder à cette interface.';
$string['erroralreadyvoted'] = 'Vous avez déjà voté pour {$a}';
$string['errormaxmessages'] = 'Désolé, mais vous ne pouvez pas envoyer plus de 3 messages.';
$string['errornomainnews'] = 'Impossible de trouver ou de créer un forum principal des nouvelles du site';
$string['errorsendingmail'] = 'Une erreur est survenue lors de l\'envoi du message. S\'il vous plaît essayez à nouveau plus tard ou contactez l\'administrateur du site.';
$string['events'] = 'Nous sommes spécialisés dans l\'apprentissage en ligne. Cependant, c\'est aussi très sympathique de se rencontrer dans un même endroit ! Ces liens vous proposent des informations sur nos congrès ou conférences (appelées « MoodleMoots ») et d\'autres événements.';
$string['eventstitle'] = 'Événements';
$string['frontpagewelcome1'] = 'Moodle est un environnement d\'apprentissage libre (Learning Management System ou LMS). C\'est une application web gratuite que les acteurs de l\'éducation peuvent utiliser pour créer des sites d\'apprentissage efficaces.';
$string['frontpagewelcome2'] = 'Moodle.org est le site de notre communauté, où l\'on discute de la création et de l\'utilisation de Moodle. Utilisez les menus pour explorer et nous rejoindre !';
$string['frontpagewelcometitle'] = 'Bienvenue dans la communauté Moodle !';
$string['generaldeveloperforum'] = 'Forum général des développeurs';
$string['graphpopulation'] = 'Graphique population Moodle';
$string['graphregistrationmap'] = 'Carte enregistrements Moodle';
$string['graphregistrationmapdesc'] = 'Top 10 des sites inscrits dans {$a} pays';
$string['graphusersites'] = 'Comparaison utilisateurs Moodle et sites';
$string['jobs'] = 'Visitez notre base de données d\'emplois pour des informations sur des postes en lien avec Moodle, dans le monde entier.';
$string['jobstitle'] = 'Emplois Moodle';
$string['moodledocs'] = 'Moodle Docs';
$string['moodletrackertitle'] = 'Traqueur de bogues Moodle';
$string['mycoursesintro'] = 'Vous êtes actuellement inscrit aux « cours » suivants sur ce site. Chacun de ces cours contient un ou plusieurs forums.';
$string['nameabout'] = 'À propos';
$string['nameaboutmoodle'] = 'À propos de Moodle';
$string['namecommercial'] = 'Services commerciaux';
$string['namecommunity'] = 'Communauté';
$string['namecontact'] = 'Contact';
$string['namedevelopment'] = 'Développement';
$string['namedocumentation'] = 'Documentation';
$string['namedownloads'] = 'Téléchargements';
$string['nameevents'] = 'Événements';
$string['nameforums'] = 'Forums';
$string['namemycourses'] = 'Mes cours';
$string['namenetwork'] = 'Sites connectés';
$string['namenews'] = 'Brèves';
$string['namesecurity'] = 'Annonces de sécurité';
$string['namesupport'] = 'Assistance';
$string['networkintro'] = 'Les sites Moodle suivants ont été connectés à moodle.org au moyen du réseau Moodle. Vous pouvez donc vous y connecter directement depuis ici.';
$string['newregistrations'] = 'Nouveaux enregistrements';
$string['newsbuzz'] = 'Moodle Buzz';
$string['newsbuzzdetail'] = 'Publications du monde entier en lien avec Moodle';
$string['newscalendar'] = 'Calendrier';
$string['newscalendardetail'] = 'Événements futurs en lien avec Moodle';
$string['newsofficial'] = 'Informations officielles sur  Moodle';
$string['newsplanet'] = 'Planète Moodle';
$string['newsplanetdetail'] = 'Agrégation de blogs de développeurs Moodle';
$string['newsrecent'] = 'Nouvelles récentes';
$string['newssecurity'] = 'Annonces de sécurité';
$string['newssecuritydetail'] = 'Informations importantes sur des problèmes de sécurité';
$string['noenrolledcoursesyet'] = 'Vous n\'êtes encore inscrit à aucun cours sur ce site';
$string['overviewabout'] = 'Un tour d\'horizon de Moodle';
$string['overviewcommunity'] = 'Un tour d\'horizon de la communauté Moodle';
$string['overviewdevelopment'] = 'Un tour d\'horizon du développement de Moodle';
$string['overviewdownloads'] = 'Un tour d\'horizon des téléchargements de Moodle';
$string['overviewmy'] = 'Affichez tous les cours de moodle.org auxquels vous êtes inscrits';
$string['overviewnews'] = 'Un tour d\'horizon des infos actuelles de Moodle';
$string['overviewsupport'] = 'Un tour d\'horizon des possibilités d\'assistance de Moodle';
$string['popularissues'] = 'Problématiques les plus populaires';
$string['recentpart'] = 'Cette page montre quelques personnes ayant utilisé moodle.org aujourd\'hui.';
$string['recentparttitle'] = 'Participants actuels';
$string['registeredsites'] = 'Les institutions ne sont pas tenues d\'informer quiconque qu\'elles utilisent Moodle, car Moodle est un logiciel libre. Cependant, certains sites Moodle ont choisi de s\'enregistrer auprès de nous et nous en conservons une liste.';
$string['registeredsitestitle'] = 'Sites enregistrés';
$string['registereduserslastday'] = 'Nouveaux utilisateurs au cours des 24 dernières heures :';
$string['registereduserstotal'] = 'Total des utilisateurs enregistrés :';
$string['registrationgraphalt'] = 'Tous les enregistrements de Moodle';
$string['registrationgraphdesc'] = 'Nous effectuons un <a href="http://docs.moodle.org/en/Usage">contrôle régulier des sites</a> afin de nous assurer qu\'ils existent encore, c\'est pourquoi le nombre est parfois en diminution';
$string['registrationslast6months'] = 'Enregistrements durant les 6 derniers mois';
$string['registrationstotal'] = 'Tous les enregistrements actuels';
$string['roadmap'] = 'Planification de Moodle';
$string['shop'] = 'Vous cherchez un moyen de montrer que vous faites partie de notre communauté ? Visitez notre magasin en ligne : T-shirts, tasses et beaucoup d\'autres choses pourront vous intéresser.';
$string['shoptitle'] = 'Magasin Moodle';
$string['sourcecodetitle'] = 'Code libre et gratuit';
$string['statscountries'] = 'Pays';
$string['statscourses'] = 'Cours';
$string['statsenrolments'] = 'Inscriptions';
$string['statsposts'] = 'Messages des forums';
$string['statsquestions'] = 'Questions des tests';
$string['statsresources'] = 'Ressources';
$string['statsteachers'] = 'Enseignants';
$string['statsusers'] = 'Utilisateurs';
$string['supportbooks'] = 'Nous tenons à jour une liste des nombreux livres Moodle disponibles.';
$string['supportbookstitle'] = 'Livres et manuels';
$string['supportcommercial'] = 'Les <a href="http://moodle.com/">Partenaires Moodle</a> sont un groupe mondial de sociétés commerciales de services autorisées, qui soutiennent financièrement le projet de logiciel libre Moodle. Ces sociétés fournissent diverses prestations commerciales aux utilisateurs Moodle dans le monde :';
$string['supportcommercialtitle'] = 'Services commerciaux';
$string['supportdocs1'] = 'Moodle Docs est un bon endroit pour commencer, notamment les pages « Foire aux questions » (FAQ).';
$string['supportdocs2'] = 'Une façon simple et facile d\'accéder à la documentation est l\'utilisation des liens « Documentation Moodle pour cette page » au bas de chaque page de votre propre site Moodle.';
$string['supportdocsfaq'] = 'Questions fréquemment posées (FAQ)';
$string['supportdocslang'] = 'Moodle Docs dans d\'autres langues';
$string['supportdocstitle'] = 'Documentation';
$string['supportforums'] = 'Notre communauté d\'utilisateurs communique principalement au moyen de forums situés dans des « cours » sur ce site Moodle. Vous devez vous « inscrire » à un cours pour participer aux discussions des forums qu\'il contient (l\'inscription est totalement gratuite).';
$string['supportforumsenglish'] = 'L\'assistance principale et les discussions entre développeurs et utilisateurs ont lieu ici, en anglais :';
$string['supportforumsenglishname'] = 'Using Moodle';
$string['supportforumslang'] = 'L\'espace « Moodle en français », où se tiennent toutes les discussions autour de Moodle en français est accessible ici :';
$string['supportforumslangname'] = 'Moodle en Français';
$string['supportforumslangurl'] = 'http://moodle.org/course/view.php?id=20';
$string['supportforumslist'] = 'Nous avons également beaucoup d\'autres forums, dans différentes langues :';
$string['supportforumslistname'] = 'Liste de tous les forums';
$string['supportforumstitle'] = 'Forums';
$string['supportintro'] = 'Vous n\'êtes pas tout seul ! Il y a une multitude de façons d\'obtenir de l\'aide sur Moodle si vous en avez besoin.';
$string['top10sitesbycourses'] = 'Top 10 des sites, par cours';
$string['top10sitesbyusers'] = 'Top 10 des sites, par utilisateurs';
