<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_essential', language 'fr', branch 'MOODLE_25_STABLE'
 *
 * @package   theme_essential
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['alert1'] = 'Première alerte';
$string['alert2'] = 'Deuxième alerte';
$string['alert3'] = 'Troisième alerte';
$string['alert_general'] = 'Annonce';
$string['alert_info'] = 'Information';
$string['alertsdesc'] = 'Ceci va afficher une alerte (ou plusieurs) dans trois différents styles à vos utilisateurs sur la page d\'accueil de Moodle. Pensez s\'il vous plaît à les désactiver lorsqu\'elles ne seront plus nécessaires.';
$string['alertsheading'] = 'Alertes utilisateur';
$string['alertsheadingsub'] = 'Affiche des messages importants à vos utilisateurs sur la page d\'accueil';
$string['alerttext'] = 'Texte de l\'alerte';
$string['alerttextdesc'] = 'Le texte que vous souhaitez afficher dans votre alerte';
$string['alerttitle'] = 'Titre';
$string['alerttitledesc'] = 'Titre/en-tête principal pour votre alerte';
$string['alerttype'] = 'Niveau';
$string['alerttypedesc'] = 'Définissez le juste niveau d\'alerte pour informer au mieux vos utilisateurs';
$string['alert_warning'] = 'Attention';
$string['allclasses'] = 'Toutes les classes';
$string['allcourses'] = 'Tous les cours';
$string['allmodules'] = 'Tous les modules';
$string['allunits'] = 'Toutes les unités';
$string['alwaysdisplay'] = 'Toujours afficher';
$string['analyticsclean'] = 'Envoyer des URL réécrites';
$string['analyticscleandesc'] = 'Cette fonctionnalité fantastique a été créé par <a href="https://moodle.org/user/profile.php?id=281671" target="_blank">Gavin Henrick</a> et <a href="https://moodle.org/user/view.php?id=907814" target="_blank">Bas Brands</a> et est mis en œuvre dans ce thème. Plutôt que des URLs standard de Moodle le thème enverra des URLs réécrites, ce qui rend plus facile l\'identification de la page et un reporting avancé. Plus d\'informations sur cette fonction et ses utilisations peuvent être <a href="http://www.somerandomthoughts.com/blog/2012/04/18/ireland-uk-moodlemoot-analytics-to-the-front/" target="_blank"><b>trouvées ici</b></a> .';
$string['analyticsdesc'] = 'Ici vous pouvez activer Google Analytics pour votre site Moodle. Vous aurez besoin de créer un compte gratuit sur le site Google Analytics ( <a href="http://analytics.google.com" target="_blank">http://analytics.google.com</a> )';
$string['analyticsheading'] = 'Google Analytics';
$string['analyticsheadingsub'] = 'Des outils analytiques puissants de Google';
$string['analyticsid'] = 'Votre numéro de suivi';
$string['analyticsiddesc'] = 'Saisissez l\'ID de suivi fourni. Typiquement formaté comme ceci  UA-XXXXXXXX-X';
$string['android'] = 'Android (Google Play)';
$string['androiddesc'] = 'Indiquez l\'URL vers votre application pour mobiles sur le Google Play Store. Si vous ne disposez pas de la vôtre, vous pouvez envisager de pointer vers l\'application officielle gratuite Moodle pour mobiles.';
$string['autohide'] = 'Inclure la fonctionnalité de masquage automatique';
$string['autohidedesc'] = 'La fonctionnalité de masquage automatique est conçue pour rendre Moodle moins intimidant. Lorsque le mode édition est actif, les icônes d\'édition apparaissent uniquement lorsqu\'un élément est survolé par le pointeur de la souris.';
$string['backtotop'] = 'Retour en haut de page';
$string['bootstrapcdn'] = 'Police Awesome de CDN';
$string['bootstrapcdndesc'] = 'Si activé, cela va charger la police Awesome à partir de la source CDN Bootstrap en ligne. Activez cette option si vous rencontrez des problèmes d\'affichage avec les icônes de la police Awesome sur votre site.';
$string['choosereadme'] = '<div class="clearfix"><div class="well"><h2> Clean </h2><p><img class=img-polaroid src="clean/pix/screenshot.jpg" /></p></div><div class="well"><h3> À propos de Essential </h3><p> Essential est un thème modifié Bootstrap de Moodle  qui hérite des styles et des moteurs de rendus de son thème parent. </p><h3> Parents </h3><p> Ce thème est basé sur le thème  Bootstrap, qui a été créé pour Moodle 2.5, avec l\'aide de: <br> Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans. </p><h3> Crédits du thème </h3><p> Auteurs: Julian Ridden <br> Contact: julian@moodleman.net <br> Site Web: <a href="http://www.moodleman.net">www.moodleman.net</a> </p></div></div>';
$string['colordesc'] = 'Ici vous pouvez trouver différents réglages pour changer de nombreuses couleurs présentes dans ce thème.';
$string['colorheading'] = 'Paramètres des couleurs';
$string['colorheadingsub'] = 'Définissez les couleurs utilisées dans votre thème';
$string['configtitle'] = 'Essential';
$string['contactinfo'] = 'Coordonnées';
$string['contactinfodesc'] = 'Entrez vos coordonnées';
$string['copyright'] = 'Droits d\'auteur';
$string['copyrightdesc'] = 'Le nom de votre organisation';
$string['customcss'] = 'CSS personnalisées';
$string['customcssdesc'] = 'Toutes les règles CSS que vous ajoutez à cette zone de texte seront reflétées dans chaque page, ce qui rend plus facile la personnalisation de ce thème.';
$string['custommenudesc'] = 'Les réglages ici vous permette d\'ajouter une nouvelle fonctionnalité dynamique au menu personnalisé (également connu sous le terme menu déroulant)';
$string['custommenuheading'] = 'Menu personnalisé';
$string['custommenuheadingsub'] = 'Ajoute des fonctionnalités à votre menu personnalisé.';
$string['displayafterlogin'] = 'Afficher après connexion';
$string['displaybeforelogin'] = 'N\'afficher qu\'avant la connexion';
$string['displaymycourses'] = 'Afficher les cours des utilisateurs';
$string['displaymycoursesdesc'] = 'Affiche les cours des utilisateurs dans le menu personnalisé';
$string['displaymydashboard'] = 'Afficher le tableau de bord';
$string['displaymydashboarddesc'] = 'Affiche un tableau des liens de l\'utilisateur dans le menu personnalisé';
$string['dontdisplay'] = 'Ne pas afficher';
$string['editicons'] = 'Modifier des icônes V2';
$string['editiconsdesc'] = 'Ceci utilise la police Awesome pour afficher des icônes colorées et plus nettes dans les pages de cours et les blocs. Veuillez noter qu\'actuellement ceci n\'est pas compatible avec la fonctionnalité de masquage automatique.';
$string['enablealert'] = 'Activer l\'alerte';
$string['enablealertdesc'] = 'Active ou désactive les alertes';
$string['facebook'] = 'URL Facebook';
$string['facebookdesc'] = 'Entrez l\'URL de votre page Facebook. (ex. http://www.facebook.com/mycollege)';
$string['flickr'] = 'URL Flickr';
$string['flickrdesc'] = 'Entrez l\'URL de votre page Flickr. (ex. http://www.flickr.com/mycollege)';
$string['fontselect'] = 'Sélecteur de police';
$string['fontselectdesc'] = 'Choisissez dans la liste des polices disponibles. Vous pouvez choisir ici de désactiver les polices Google si nécessaire.';
$string['footercolor'] = 'Couleur de fond du pied de page';
$string['footercolordesc'] = 'Régler la couleur de fond de la boîte du pied de page.';
$string['footerheadingcolor'] = 'Couleur des titres dans le pied de page';
$string['footerheadingcolordesc'] = 'Définissez la couleur des titres pour les blocs dans le pied de page.';
$string['footerhovercolor'] = 'Couleur au survol dans le pied de page';
$string['footerhovercolordesc'] = 'Définissez la couleur des hyperliens au survol de la souris.';
$string['footersepcolor'] = 'Couleur du séparateur dans le pied de page';
$string['footersepcolordesc'] = 'Les séparateurs sont des lignes utilisées pour séparer le contenu. Réglez leur couleur ici.';
$string['footertextcolor'] = 'Couleur du texte du pied de page';
$string['footertextcolordesc'] = 'Définissez la couleur de votre texte dans le pied de page';
$string['footerurlcolor'] = 'Couleur des liens dans le pied de page';
$string['footerurlcolordesc'] = 'Définissez la couleur de vos hyperliens dans le pied de page.';
$string['footnote'] = 'Note de bas de page';
$string['footnotedesc'] = 'Le texte ajouté dans cette zone de texte sera affiché dans le pied de page sur tout votre site Moodle.';
$string['frontcontentarea'] = 'Contenu de la page d\'accueil';
$string['frontcontentareadesc'] = 'Tout ce qui est écrit ici dans cette zone de texte sera affiché sur toute la largeur de la page entre le diaporama et les annonces marketing';
$string['frontcontentdesc'] = 'Ceci ajoute un contenu personnalisé entre le diaporama et les annonces marketing';
$string['frontcontentheading'] = 'Contenu de la page d\'accueil';
$string['frontcontentheadingsub'] = 'Ajoute de l\'information pour les utilisateurs sur la page d\'accueil';
$string['geneicsettings'] = 'Paramètres généraux';
$string['googleplus'] = 'URL Google+';
$string['googleplusdesc'] = 'Entrez l\'URL de votre profil Google+. (ex. http://plus.google.com/107817105228930159735)';
$string['headerprofilepic'] = 'Afficher l\'image de profil de l\'utilisateur';
$string['headerprofilepicdesc'] = 'Si cochée, affiche l\'image de profil de l\'utilisateur dans l\'en-tête de la page.';
$string['hideonphone'] = 'Diaporama sur les mobiles';
$string['hideonphonedesc'] = 'Choisissez si vous souhaitez avoir le diaporama qui s\'afficher sur les mobiles ou non';
$string['ie7message'] = '<p id="ie7message">Désolé, ce site requiert <strong>Internet Explorer 8</strong> ou plus récent pour s\'afficher et fonctionner correctement. SVP, mettez à jour votre navigateur via Windows Update, ou <a href="http://windows.microsoft.com/fr-fr/internet-explorer/download-ie" target="_blank">téléchargez la dernière version ici</a>. Sinon, vous pouvez essayer d\'installer <a href="http://www.google.com/chromeframe" target="_blank">le plugin ChromeFrame</a> qui peut résoudre certains des problèmes rencontrés avec les navigateurs anciens. Si vous utilisez IE8 ou plus récent peut-être le mode de compatibilité est-il activé, désactivez ce mode pour afficher le site correctement. Si vous continuez à avoir des problèmes pour l\'accès à ce site ou pour les mises à jour mentionnées ci-dessus, s\'il vous plait contactez votre Helpdesk pour plus d\'assistance.</p>';
$string['instagram'] = 'URL Instagram';
$string['instagramdesc'] = 'Entrez l\'URL de votre page Instagram. (ex. http://instagram.com/mycollege)';
$string['invert'] = 'Inverser la barre de navigation';
$string['invertdesc'] = 'Échange le texte et le fond de la barre de navigation en haut de la page entre le noir et le blanc.';
$string['ios'] = 'iPhone/iPad (App Store)';
$string['iosdesc'] = 'Indiquez l\'URL vers votre application pour mobiles sur le App Store. Si vous ne disposez pas de la vôtre, vous pouvez envisager de pointer vers l\'application officielle gratuite Moodle pour mobiles.';
$string['iosicon'] = 'Icônes d\'écran d\'accueil iOS';
$string['iosicondesc'] = 'Le thème fournit une icône par défaut pour les écrans d\'accueil d\'iOS et Android. Vous pouvez déposer vos icônes personnalisées si vous le souhaitez.';
$string['ipadicon'] = 'Icône iPad (Non Retina)';
$string['ipadicondesc'] = 'L\'icône devrait être un fichier PNG d\'une définition de 72px par 72px';
$string['ipadretinaicon'] = 'Icône iPad (Retina)';
$string['ipadretinaicondesc'] = 'L\'icône devrait être un fichier PNG d\'une définition de 144px par 144px';
$string['iphoneicon'] = 'Icône iPhone/iPod Touch (Non Retina)';
$string['iphoneicondesc'] = 'L\'icône devrait être un fichier PNG d\'une dimension de 57px par 57px';
$string['iphoneretinaicon'] = 'Icône iPhone/iPod Touch (Retina)';
$string['iphoneretinaicondesc'] = 'L\'icône devrait être un fichier PNG d\'une dimension de 114px par 114px';
$string['layout'] = 'Utilisez une disposition de cours standard';
$string['layoutdesc'] = 'Ce thème est conçu pour mettre les deux colonnes de blocs sur le côté. Si vous préférez la disposition standard des cours Moodle, vous pouvez cocher cette case et retourner à l\'ancienne et ennuyeuse disposition en trois colonnes.';
$string['linkedin'] = 'URL LinkdIn';
$string['linkedindesc'] = 'Entrez l\'URL de votre profil LinkedIn. (C. http://www.linkedin.com/company/mycollege)';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Déposez votre logo personnalisé ici si vous voulez l\'ajouter à l\'en-tête. <br> Si vous déposez un logo, il remplacera l\'icône standard et le nom qui a été affiché par défaut.';
$string['marketing1'] = 'Annonce marketing  Une - Titre';
$string['marketing2'] = 'Annonce marketing Deux - Titre';
$string['marketing3'] = 'Annonce marketing Trois - Titre';
$string['marketingbuttontext'] = 'Texte du lien';
$string['marketingbuttontextdesc'] = 'Texte à afficher sur le bouton';
$string['marketingbuttonurl'] = 'Lien URL';
$string['marketingbuttonurldesc'] = 'URL vers laquelle le bouton va pointer';
$string['marketingcontent'] = 'Contenu';
$string['marketingcontentdesc'] = 'Contenu à afficher dans l\'annonce marketing. Gardez le court et concis.';
$string['marketingdesc'] = 'Ce thème offre la possibilité d\'activer trois annonces "marketing" ou "spots publicitaires" juste sous le diaporama. Elles vous permettent d\'afficher facilement les informations essentielles à vos utilisateurs et fournissent des liens directs.';
$string['marketingheading'] = 'Annonces marketing';
$string['marketingheadingsub'] = 'Trois emplacements sur la première page pour ajouter des informations et des liens';
$string['marketingheight'] = 'Hauteur des images marketing';
$string['marketingheightdesc'] = 'Si vous souhaitez afficher des images dans les annonces marketing, vous pouvez spécifier leur hauteur ici.';
$string['marketingicon'] = 'Icône';
$string['marketingicondesc'] = 'Nom de l\'icône que vous souhaitez utiliser. La liste est <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">ici</a> . Il suffit d\'entrer ce qui est après le "icon-".';
$string['marketingimage'] = 'Image';
$string['marketingimagedesc'] = 'Ceci donne la possibilité d\'afficher une image au-dessus du texte dans l\'annonce marketing';
$string['marketinginfodesc'] = 'Entrez les réglages de votre annonce marketing.';
$string['marketingtitle'] = 'Titre';
$string['marketingtitledesc'] = 'Titre à afficher dans cette annonce marketing';
$string['mobileappsdesc'] = 'Avez-vous une web app sur l\'App Store ou Google Play Store? Fournissez un lien ici afin que vos utilisateurs puissent se procurer l\'application en ligne';
$string['mobileappsheading'] = 'Apps pour mobiles';
$string['mobileappsheadingsub'] = 'Lien vers votre application pour vos étudiants qui utilisent des mobiles';
$string['myclasses'] = 'Mes classes';
$string['mycourses'] = 'Mes cours';
$string['mycoursesinfo'] = 'Liste dynamique des cours des utilisateurs';
$string['mycoursesinfodesc'] = 'Affiche une liste dynamique des cours des utilisateurs.';
$string['mycoursetitle'] = 'Terminologie';
$string['mycoursetitledesc'] = 'Change la terminologie pour le lien "Mes cours" dans le menu déroulant';
$string['mydashboard'] = 'Mon tableau de bord';
$string['mydashboardinfo'] = 'Tableau de bord utilisateur personnalisé';
$string['mydashboardinfodesc'] = 'Affiche une liste de fonctionnalités communes utilisées par les utilisateurs.';
$string['mymodules'] = 'Mes modules';
$string['myunits'] = 'Mes unités';
$string['navbarsep'] = 'Séparateur de barre de navigation';
$string['navbarsepdesc'] = 'Ici vous pouvez changer le type de séparateur affiché dans la barre de navigation / fil d\'Ariane';
$string['nav_doublebracket'] = 'Double-chevron fin';
$string['nav_pipe'] = 'Ligne verticale';
$string['nav_slash'] = 'Barre oblique avant';
$string['nav_thickbracket'] = 'Chevron épais';
$string['nav_thinbracket'] = 'Chevron fin';
$string['noenrolments'] = 'Vous n\'avez pas de cours actuellement';
$string['pagebackground'] = 'Image de fond de la page';
$string['pagebackgrounddesc'] = 'Déposez votre propre image de fond. Elle sera appliquée en arrière-plan sur toutes les pages. Si rien n\'est déposé, une image par défaut est utilisée.';
$string['perfinfo'] = 'Mode d\'indications de performance';
$string['perfinfodesc'] = 'De nombreux sites n\'ont pas besoin d\'indications de performance entièrement détaillées. Surtout vu du côté utilisateurs. Lorsqu\'il est activé, il montre un formulaire simplifié avec des informations de base de chargement de la page.';
$string['perf_max'] = 'Détaillé';
$string['perf_min'] = 'Minimal';
$string['pinterest'] = 'URL Pinterest';
$string['pinterestdesc'] = 'Entrez l\'URL de votre page Pinterest. (C. http://pinterest.com/mycollege)';
$string['pluginname'] = 'Essential';
$string['profilebarcustomtitle'] = 'Titre du bloc personnalisé de la barre de profil';
$string['profilebarcustomtitledesc'] = 'Titre du bloc personnalisé de la barre de profil';
$string['readmore'] = 'Lire la suite';
$string['region-footer-left'] = 'Pied de page (gauche)';
$string['region-footer-middle'] = 'Pied de page (centre)';
$string['region-footer-right'] = 'Pied de page (droite)';
$string['region-hidden-dock'] = 'Caché aux utilisateurs';
$string['region-side-post'] = 'Droite';
$string['region-side-pre'] = 'Gauche';
$string['siteicon'] = 'Icône du site';
$string['siteicondesc'] = 'Vous n\'avez pas de logo? Entrez le nom de l\'icône que vous souhaitez utiliser. La liste est ici <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">ici</a> . Il suffit d\'entrer ce qui est après le "icon-".';
$string['skype'] = 'Compte Skype';
$string['skypedesc'] = 'Entrez le nom d\'utilisateur Skype du compte de votre organisation';
$string['slide1'] = 'Diapositive Une : Titre';
$string['slide2'] = 'Diapositive Deux : Titre';
$string['slide3'] = 'Diapositive Trois : Titre';
$string['slide4'] = 'Diapositive Quatre : Image';
$string['slidecaption'] = 'Légende de la diapositive';
$string['slidecaptiondesc'] = 'Entrez le texte de la légende à utiliser pour la première diapositive';
$string['slideimage'] = 'Image de la diapositive';
$string['slideimagedesc'] = 'L\'image s\'affiche mieux si elle est transparente. (Les dimensions de l\'image devraient être de 256px par 256px)';
$string['slideinfodesc'] = 'Entrez les réglages pour votre diaporama';
$string['slideshowdesc'] = 'Ceci crée un diaporama dynamique avec jusqu\'à 4 diapositives pour vous permettre de promouvoir des éléments importants de votre site.';
$string['slideshowheading'] = 'Diaporama de la page d\'accueil';
$string['slideshowheadingsub'] = 'Diaporama dynamique pour la page d\'accueil';
$string['slideshowTitle'] = 'Diaporama';
$string['slidetitle'] = 'Titre de la diapositive';
$string['slidetitledesc'] = 'Entrez un titre descriptif pour votre diapositive';
$string['slideurl'] = 'Lien de la diapositive';
$string['slideurldesc'] = 'Entrez la cible du lien de l\'image de la première diapositive';
$string['socialdesc'] = 'Fournir des liens directs vers les réseaux sociaux essentiels qui font de la publicité pour votre site. Ceux-ci apparaissent dans l\'en-tête de chaque page.';
$string['socialheading'] = 'Réseautage social';
$string['socialheadingsub'] = 'Motivez vos utilisateurs avec les réseaux sociaux';
$string['socialnetworks'] = 'Réseaux sociaux';
$string['themecolor'] = 'Couleur du thème';
$string['themecolordesc'] = 'La couleur que votre thème devrait avoir. Ceci va changer de multiples composants pour produire la couleur que vous souhaitez sur le site Moodle';
$string['themehovercolor'] = 'Couleur de survol du thème';
$string['themehovercolordesc'] = 'La couleur que prennent les éléments survolés sur votre site. Ceci concerne les liens, les menus, etc.';
$string['togglemarketing'] = 'Bascule de l\'affichage des annonces marketing';
$string['togglemarketingdesc'] = 'Choisissez si vous souhaitez afficher ou masquer les trois annonces marketing.';
$string['toggleslideshow'] = 'Bascule de l\'affichage du diaporama';
$string['toggleslideshowdesc'] = 'Choisissez si vous souhaitez afficher ou masquer le diaporama.';
$string['twitter'] = 'URL de Twitter';
$string['twitterdesc'] = 'Entrez l\'URL de votre flux Twitter. (ex. http://www.twitter.com/mycollege)';
$string['useanalytics'] = 'Activer Google Analytics';
$string['useanalyticsdesc'] = 'Active ou désactive la fonctionnalité Google Analytics.';
$string['usefrontcontent'] = 'Activer le contenu de la page d\'accueil';
$string['usefrontcontentdesc'] = 'Si activé, ceci va afficher le contenu de la zone de texte ci-dessous entre le diaporama et les annonces marketing.';
$string['visibleadminonly'] = 'Les blocs déplacés dans la zone ci-dessous ne seront visibles que par les administrateurs';
$string['vk'] = 'URL VKontakte';
$string['vkdesc'] = 'Entrez l\'URL de la page Vkontakte. (ex. http://www.vk.com/mycollege)';
$string['website'] = 'URL du site Web';
$string['websitedesc'] = 'Entrez l\'URL de votre propre site. (ex. http://www.pukunui.com)';
$string['yourprofile'] = 'Vous';
$string['youtube'] = 'URL Youtube';
$string['youtubedesc'] = 'Entrez l\'URL de votre chaîne YouTube. (C. http://www.youtube.com/mycollege)';
