<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * English strings for nanogong
 *
 * @author     Ning
 * @author     Gibson
 * @package    mod
 * @subpackage nanogong
 * @copyright  2012 The Gong Project
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @version    4.2.2
 */

defined('MOODLE_INTERNAL') || die();

$string['modulename'] = 'NanoGong voice activity';
$string['modulenameplural'] = 'NanoGong voices';
$string['modulename_help'] = 'The NanoGong voice module lets participants record, playback and submit their voice. When the recording is played back the user can speed up or slow down the sound without changing it.';
$string['nanogongfieldset'] = 'Show content with NanoGong voice';
$string['nanogongname'] = 'Name of this NanoGong voice activity';
$string['nanogong'] = 'NanoGong voice';
$string['pluginadministration'] = 'NanoGong voice administration';
$string['pluginname'] = 'NanoGong voice';
$string['invalidid'] = 'Invalid nanogong ID';

$string['availabledate'] = 'Available from';
$string['description'] = 'Description';
$string['duedate'] = 'Due date';
$string['maxgrade'] = 'Maximum grade';
$string['maxduration'] = 'Duration (secs)';
$string['maxduration_help'] = 'Maximum duration of each recording in seconds (1 - 1200)';
$string['maxdurationdetail'] = 'Maximum duration of each recording (secs)';
$string['maxnumber'] = 'Allowed recordings';
$string['maxnumber_help'] = 'Maximum number of recordings allowed for each student (0 means there is no limitation)';
$string['maxnumberdetail'] = 'Maximum number of recordings';
$string['preventlate'] = 'Prevent late submissions';
$string['permission'] = 'Can students access the recordings of others?';

$string['submission'] = 'Submission';
$string['grade'] = 'Grade';
$string['comment'] = 'Message from teacher to student';
$string['edit'] = 'Click here to edit';
$string['show'] = 'Show';
$string['submit'] = 'Submit';
$string['insert'] = 'Deleted, click here to reinsert';
$string['add'] = 'Add a new recording';
$string['delete'] = 'Delete selected recording';
$string['leavemessage'] = 'Add / Edit message to teacher';
$string['cancel'] = 'Cancel';
$string['yes'] = 'Yes';
$string['no'] = 'No';
$string['view'] = 'View';
$string['hide'] = 'Hide';
$string['backtolist'] = 'Back to the list of students';
$string['supplement'] = 'Message';
$string['reverse'] = 'in reverse chronological order';
$string['chronological'] = 'in chronological order';
$string['reversebutton'] = 'Change to reverse chronological order';
$string['chronologicalbutton'] = 'Change to chronological order';
$string['recording'] = 'Recording';

$string['nanogong:view'] = 'View NanoGong voice';
$string['nanogong:submit'] = 'Submit NanoGong voice';
$string['nanogong:grade'] = 'Grade NanoGong voice';

$string['nanogongaudios'] = 'NanoGong voice recordings';
$string['nanogongmessages'] = 'NanoGong voice messages';

$string['tablename'] = 'Name';
$string['tableyourmessage'] = 'List of recordings';
$string['tablemessage'] = 'Your recordings';
$string['tablevoice'] = 'Voice feedback from teacher';
$string['tablemodified'] = 'Last modified';

$string['modulenamefull'] = 'NanoGong voice recording';
$string['nolimitation'] = 'No limitation';
$string['voicetitle'] = 'What is the subject of your recording?';
$string['titlemax'] = '(30 letters maximum)';
$string['voicerecording'] = 'Your voice recording';
$string['submitted'] = 'Submitted';
$string['gradedon'] = 'Modified on';
$string['instructions'] = 'Click on a recording below';
$string['checkdeletemessage'] = 'Are you absolutely sure you want to delete this recording?';
$string['checkdeletemessages'] = 'Are you absolutely sure you want to delete the selected recording(s)?';
$string['inonepage'] = 'student(s) in one page';
$string['recordinginonepage'] = 'recording(s) in one page';
$string['all'] = 'All';
$string['submiitedrecordings'] = 'Students who have submitted recordings';
$string['gradedstudents'] = 'Who have submitted recordings that have been graded';
$string['ungradedstudents'] = 'Who have submitted recordings that have not been graded';
$string['studentsnosubmissions'] = 'Students with no submissions';
$string['allstudents'] = 'All students';
$string['recordingtempname'] = 'Recording ';
$string['otherrecording'] = 'Recordings of all students';
$string['previouspage'] = 'Previous page';
$string['nextpage'] = 'Next page';
$string['listof'] = 'List of recordings for ';
$string['feedbackfor'] = 'Your feedback for ';
$string['submissionintotal'] = ' student in total';
$string['submissionsintotal'] = ' students in total';
$string['thereis'] = 'There is ';
$string['thereare'] = 'There are ';
$string['submissionsfrom'] = 'submissions from ';
$string['thereareno'] = 'There are no ';
$string['voicerecorded'] = 'Your recording history';
$string['timecreated'] = 'Time created';
$string['title'] = 'Title';
$string['inuse'] = 'In use';
$string['messagefor'] = 'Message for your teacher (cannot be seen by others)';
$string['messagefrom'] = 'Message from student to teacher';
$string['page'] = 'Page ';
$string['deletealertmessage'] = 'Please select a recording first';
$string['student'] = 'Student ';
$string['emptymessage'] = 'Nothing has been recorded yet.';
$string['with'] = 'with';
$string['allcategory'] = 'students in total';
$string['submittedcategory'] = 'students who have submitted recordings';
$string['gradedcategory'] = 'students who have submitted recordings that have been graded';
$string['ungradedcategory'] = 'students who have submitted recordings that have not been graded';
$string['unsubmittedcategory'] = 'students with no submissions';
$string['allcategoryone'] = 'student in total';
$string['submittedcategoryone'] = 'student who has submitted recordings';
$string['gradedcategoryone'] = 'student who has submitted recordings that have been graded';
$string['ungradedcategoryone'] = 'student who has submitted recordings that have not been graded';
$string['unsubmittedcategoryone'] = 'student with no submissions';
$string['notavailable'] = 'It is not available now';
$string['changetorecordings'] = 'Show recordings of all students in chronological order';
$string['changetostudents'] = 'Show recordings of each student for entering feedback';
$string['requiredfield'] = 'There are required fields in this form marked';
$string['nofeeadback'] = 'Currently there is no feedback from your teacher';
$string['notes'] = 'Notes';
$string['submittedtime'] = 'Submitted time';
$string['feedbacktitle'] = 'Feedback from the teacher';
$string['nosubmission'] = 'No submission';
$string['loadcurrent'] = 'Load current voice feedback into this applet';
$string['yourmessage'] = 'Your message to student';
$string['outof'] = ' out of ';
$string['studentlist'] = 'Recordings of each student';
$string['wronggrade'] = 'Please input a number between 0 and ';
$string['voicefeedback'] = 'Voice feedback';
$string['commentmessage'] = 'Message from your teacher';
$string['forentering'] = 'for entering feedback';
$string['messagearea'] = 'Your message for the teacher';
$string['imgtitle'] = 'Show/hide the NanoGong player by clicking this icon';
$string['servererror'] = 'There is problem sending the recording to the server. Please try again later!';
$string['showdeleteboxes'] = 'Click here to select the recording you want to delete';
$string['isdelete'] = 'Delete?';
$string['deleterecordings'] = 'Delete the selected recordings';
$string['lockstudent'] = 'Lock this student from further modification';
$string['submissionlocked'] = 'This submission has been locked from further modifications';

?>
