<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle. If not, see <http://www.gnu.org/licenses/>.

/**
 * Traditional Chinese strings for nanogong
 *
 * @author     Ning
 * @author     Gibson
 * @package    mod
 * @subpackage nanogong
 * @copyright  2012 The Gong Project
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @version    4.2.2
 */

defined('MOODLE_INTERNAL') || die();

$string['modulename'] = 'NanoGong語音活動';
$string['modulenameplural'] = 'NanoGong語音';
$string['modulename_help'] = 'NanoGong語音活動允許參與者錄音播放以及提交他們的聲音. 當錄音被回放, 用戶可以加快或放慢速度.';
$string['nanogongfieldset'] = '顯示帶有NanoGong語音的內容';
$string['nanogongname'] = 'NanoGong語音活動名稱';
$string['nanogong'] = 'NanoGong語音';
$string['pluginadministration'] = 'NanoGong語音管理';
$string['pluginname'] = 'NanoGong語音';

$string['availabledate'] = '開始時間';
$string['description'] = '描述';
$string['duedate'] = '結束時間';
$string['maxgrade'] = '滿分';
$string['maxduration'] = '持續時間 (秒)';
$string['maxduration_help'] = '最大可設的持續時間：1 - 1200 秒';
$string['maxdurationdetail'] = '每段錄音允許的最大持續時間(秒)';
$string['maxnumber'] = '允許的錄音數量';
$string['maxnumber_help'] = '每個學生最多課錄製的語音數量(0代表沒有限制)';
$string['maxnumberdetail'] = '最多錄製的語音數量';
$string['preventlate'] = '是否阻止晚提交?';
$string['permission'] = '學生是否可以播放其他學生提交的語音?';

$string['submission'] = '提交的語音';
$string['grade'] = '分數';
$string['comment'] = '老師給學生的評語';
$string['edit'] = '點擊進行編輯';
$string['show'] = '顯示';
$string['submit'] = '提交';
$string['insert'] = '已刪除，點擊重新插入到提交列表中';
$string['add'] = '添加新的語音';
$string['delete'] = '刪除所選的語音';
$string['leavemessage'] = '添加/編輯給老師的留言';
$string['cancel'] = '取消';
$string['yes'] = '是';
$string['no'] = '否';
$string['view'] = '查看';
$string['hide'] = '隱藏';
$string['backtolist'] = '回到學生列表';
$string['supplement'] = '消息';
$string['reverse'] = '按反向時間順序';
$string['chronological'] = '按時間順序';
$string['reversebutton'] = '更改為反向時間順序';
$string['chronologicalbutton'] = '更改為時間順序';
$string['recording'] = '語音';

$string['nanogong:view'] = '查看NanoGong語音';
$string['nanogong:submit'] = '提交NanoGong語音';
$string['nanogong:grade'] = '評分NanoGong語音';

$string['nanogongaudios'] = 'NanoGong語音';
$string['nanogongmessages'] = 'NanoGong語音消息';

$string['tablename'] = '名字';
$string['tableyourmessage'] = '語音列表';
$string['tablemessage'] = '你的語音';
$string['tablevoice'] = '來自老師的語音反饋';
$string['tablemodified'] = '最後修改';

$string['modulenamefull'] = 'NanoGong語音';
$string['nolimitation'] = '沒有限制';
$string['voicetitle'] = '你的語音的主題是什麼?';
$string['titlemax'] = '(最多30個字符)';
$string['voicerecording'] = '你的語音';
$string['submitted'] = '提交於';
$string['gradedon'] = '修改於';
$string['instructions'] = '點擊下列語音';
$string['checkdeletemessage'] = '你確定你要刪除這份語音嗎?';
$string['checkdeletemessages'] = '你確定你要刪除所選的語音嗎?';
$string['inonepage'] = '個學生在一頁';
$string['recordinginonepage'] = '個語音在一頁';
$string['all'] = '所有';
$string['submiitedrecordings'] = '學生已經提交語音';
$string['gradedstudents'] = '學生已經提交語音並且被評分';
$string['ungradedstudents'] = '學生已經提交語音並且未被評分';
$string['studentsnosubmissions'] = '學生沒有提交語音';
$string['allstudents'] = '所有學生';
$string['recordingtempname'] = '語音';
$string['otherrecording'] = '所有學生的語音';
$string['previouspage'] = '上一頁';
$string['nextpage'] = '下一頁';
$string['listof'] = '語音列表: ';
$string['feedbackfor'] = '你的反饋關於';
$string['submissionintotal'] = '學生總共';
$string['submissionsintotal'] = '學生總共';
$string['thereis'] = '有';
$string['thereare'] = '有';
$string['submissionsfrom'] = '提交的語音來自於';
$string['thereareno'] = '沒有';
$string['voicerecorded'] = '你的語音記錄';
$string['timecreated'] = '創建時間';
$string['title'] = '標題';
$string['inuse'] = '使用中';
$string['messagefor'] = '給你老師的留言(不會被別人看見)';
$string['messagefrom'] = '學生給老師的留言';
$string['page'] = '頁';
$string['deletealertmessage'] = '請先選擇語音';
$string['student'] = '學生';
$string['emptymessage'] = '還沒有錄製任何語音.';
$string['with'] = '並且';
$string['allcategory'] = '個學生總共';
$string['submittedcategory'] = '個學生已經提交語音';
$string['gradedcategory'] = '個學生已經提交語音並且被評分';
$string['ungradedcategory'] = '個學生已經提交語音並且未被評分';
$string['unsubmittedcategory'] = '個學生沒有提交語音';
$string['allcategoryone'] = '個學生總共';
$string['submittedcategoryone'] = '個學生已經提交語音';
$string['gradedcategoryone'] = '個學生已經提交語音並且被評分';
$string['ungradedcategoryone'] = '個學生已經提交語音並且未被評分';
$string['unsubmittedcategoryone'] = '個學生沒有提交語音';
$string['notavailable'] = '目前無法提供語音活動.';
$string['changetorecordings'] = '顯示所有學生的語音按時間順序';
$string['changetostudents'] = '顯示每個學生的語音以輸入反饋';
$string['requiredfield'] = '有必須填寫的字段標記';
$string['nofeeadback'] = '當前沒有來自於你老師的反饋';
$string['notes'] = '標註';
$string['submittedtime'] = '提交時間';
$string['feedbacktitle'] = '老師的反饋';
$string['nosubmission'] = '沒有提交';
$string['loadcurrent'] = '加載當前的語音反饋到這個小程序中';
$string['yourmessage'] = '你給學生的評語';
$string['outof'] = ' / ';
$string['studentlist'] = '每個學生的語音';
$string['wronggrade'] = '請輸入數字在0到';
$string['voicefeedback'] = '語音反饋';
$string['commentmessage'] = '來自你的老師的評語';
$string['forentering'] = '以輸入反饋';
$string['messagearea'] = '你給老師的留言';
$string['imgtitle'] = '點擊此圖示可顯示或隱藏NanoGong語音訊息';
$string['servererror'] = '未能傳送語音訊息，請稍後再試！';
$string['showdeleteboxes'] = '點擊這裏選擇你要刪除的語音';
$string['isdelete'] = '刪除?';
$string['deleterecordings'] = '刪除所選的語音';
$string['lockstudent'] = '鎖上這名學生以防止進一步的修改';
$string['submissionlocked'] = '此提交已被鎖上';

?>
