<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'competency', language 'fr', branch 'MOODLE_34_STABLE'
 *
 * @package   competency
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allchildrenarecomplete'] = 'Toutes les compétences filles sont atteintes';
$string['competencies'] = 'Compétences';
$string['competenciesarenotenabled'] = 'Les compétences ne sont pas activées.';
$string['competenciessettings'] = 'Réglages des compétences';
$string['completeplanstask'] = 'Achèvement des plans de formation à rendre';
$string['coursecompetencyoutcome_complete'] = 'Marquer la compétence comme atteinte';
$string['coursecompetencyoutcome_evidence'] = 'Joindre une preuve';
$string['coursecompetencyoutcome_none'] = 'Ne rien faire';
$string['coursecompetencyoutcome_recommend'] = 'Envoyer pour validation';
$string['coursemodulecompetencyoutcome_complete'] = 'Marquer la compétence comme atteinte';
$string['coursemodulecompetencyoutcome_evidence'] = 'Joindre une preuve';
$string['coursemodulecompetencyoutcome_none'] = 'Ne rien faire';
$string['coursemodulecompetencyoutcome_recommend'] = 'Envoyer pour validation';
$string['deletecompetencyratings'] = 'Supprimer les évaluations de compétence';
$string['duplicateditemname'] = '{$a} (copie)';
$string['enablecompetencies'] = 'Activer les compétences';
$string['enablecompetencies_desc'] = 'Les compétences permettent l\'évaluation des utilisateurs relativement à des plans de formation.';
$string['errorcannotchangeapastduedate'] = 'Le délai est échu ; il ne peut pas être modifié.';
$string['errorcannotsetduedateinthepast'] = 'Le délai ne peut pas être défini dans le passé.';
$string['errorcannotsetduedatetoosoon'] = 'Le délai est trop proche.';
$string['errorcompetencyrule'] = 'Règle de compétence « {$a} » inconnue';
$string['errorcoursecompetencyrule'] = 'Règle de compétence de cours « {$a} » inconnue';
$string['errorinvalidcourse'] = 'Cours non valide.';
$string['errornocompetency'] = 'La compétence {$a} est introuvable';
$string['errorplanstatus'] = 'Statut des plans de formation « {$a} » inconnu';
$string['errorscalealreadyused'] = 'Le barème ne peut pas être modifié, car il est déjà utilisé.';
$string['errorscaleconfiguration'] = 'Le barème doit être configuré en choisissant la valeur par défaut et le seuil de compétence.';
$string['errorusercomptencystatus'] = 'Statut de la compétence utilisateur « {$a} » inconnu';
$string['eventcompetencycreated'] = 'Compétence créée';
$string['eventcompetencydeleted'] = 'Compétence supprimée';
$string['eventcompetencyframeworkcreated'] = 'Référentiel de compétences créé';
$string['eventcompetencyframeworkdeleted'] = 'Référentiel de compétences supprimé';
$string['eventcompetencyframeworkupdated'] = 'Référentiel de compétences modifié';
$string['eventcompetencyframeworkviewed'] = 'Référentiel de compétences consulté';
$string['eventcompetencyupdated'] = 'Compétence modifiée';
$string['eventcompetencyviewed'] = 'Compétence consultée';
$string['eventevidencecreated'] = 'Preuve de compétence créée';
$string['eventplanapproved'] = 'Plan de formation approuvé';
$string['eventplancompleted'] = 'Plan de formation terminé';
$string['eventplancreated'] = 'Plan de formation créé';
$string['eventplandeleted'] = 'Plan de formation supprimé';
$string['eventplanreopened'] = 'Plan de formation rouvert';
$string['eventplanreviewrequestcancelled'] = 'Demande de validation de plan de formation annulée.';
$string['eventplanreviewrequested'] = 'Validation de plan de formation demandée.';
$string['eventplanreviewstarted'] = 'Validation de plan de formation commencée.';
$string['eventplanreviewstopped'] = 'Validation de plan de formation arrêtée.';
$string['eventplanunapproved'] = 'Plan de formation désapprouvé';
$string['eventplanunlinked'] = 'Plan de formation délié';
$string['eventplanupdated'] = 'Plan de formation modifié';
$string['eventplanviewed'] = 'Plan de formation consulté';
$string['eventtemplatecreated'] = 'Modèle de plan de formation créé';
$string['eventtemplatedeleted'] = 'Modèle de plan de formation supprimé';
$string['eventtemplateupdated'] = 'Modèle de plan de formation modifié';
$string['eventtemplateviewed'] = 'Modèle de plan de formation consulté';
$string['eventusercompetencyplanviewed'] = 'Plan de compétences utilisateur consulté';
$string['eventusercompetencyrated'] = 'Compétence utilisateur évaluée';
$string['eventusercompetencyratedincourse'] = 'Compétence utilisateur évaluée dans un cours';
$string['eventusercompetencyratedinplan'] = 'Compétence utilisateur évaluée dans un plan de formation';
$string['eventusercompetencyreviewrequestcancelled'] = 'Demande de validation de compétence utilisateur annulée.';
$string['eventusercompetencyreviewrequested'] = 'Validation de compétence utilisateur demandée.';
$string['eventusercompetencyreviewstarted'] = 'Validation de compétence utilisateur commencée.';
$string['eventusercompetencyreviewstopped'] = 'Validation de compétence utilisateur arrêtée.';
$string['eventusercompetencyviewed'] = 'Compétence utilisateur consultée';
$string['eventusercompetencyviewedincourse'] = 'Compétence utilisateur consultée dans un cours';
$string['eventusercompetencyviewedinplan'] = 'Compétence utilisateur consultée dans un plan de formation';
$string['eventuserevidencecreated'] = 'Preuve d\'acquis créée';
$string['eventuserevidencedeleted'] = 'Preuve d\'acquis supprimée';
$string['eventuserevidenceupdated'] = 'Preuve d\'acquis modifiée';
$string['evidence_competencyrule'] = 'La règle pour la compétence a été atteinte.';
$string['evidence_coursecompleted'] = 'Le cours « {$a} » a été achevé.';
$string['evidence_coursemodulecompleted'] = 'L\'activité « {$a} » a été achevée.';
$string['evidence_courserestored'] = 'L\'évaluation a été restaurée avec le cours « {$a} ».';
$string['evidence_evidenceofpriorlearninglinked'] = 'La preuve d\'acquis « {$a} » a été liée.';
$string['evidence_evidenceofpriorlearningunlinked'] = 'La preuve d\'acquis « {$a} » a été déliée.';
$string['evidence_manualoverride'] = 'L\'évaluation de la compétence a été donnée manuellement.';
$string['evidence_manualoverrideincourse'] = 'L\'évaluation de la compétence a été donnée manuellement dans le cours « {$a} ».';
$string['evidence_manualoverrideinplan'] = 'L\'évaluation de la compétence a été donnée manuellement dans le plan « {$a} ».';
$string['invalidevidencedesc'] = 'Description de preuve non valide';
$string['invalidgrade'] = 'Évaluation non valide';
$string['invalidpersistent'] = 'Donnée persistante non valide';
$string['invalidpersistenterror'] = 'Erreur : {$a}';
$string['invalidplan'] = 'Plan de formation non valide';
$string['invalidtaxonomy'] = 'Taxonomie non valide : {$a}';
$string['invalidurl'] = 'L\'URL n\'est pas valide. Veuillez vous assurer qu\'elle commence par « http:// » ou « https:// ».';
$string['planstatusactive'] = 'Actif';
$string['planstatuscomplete'] = 'Achevé';
$string['planstatusdraft'] = 'Brouillon';
$string['planstatusinreview'] = 'En cours de validation';
$string['planstatuswaitingforreview'] = 'En attente de validation';
$string['pointsrequiredaremet'] = 'Le nombre de points requis est atteint';
$string['pushcourseratingstouserplans'] = 'Envoyer les évaluations du cours vers les plans de formation individuels';
$string['pushcourseratingstouserplans_desc'] = 'Valeur par défaut dans les réglages des cours pour la modification des plans de formation individuels lorsque les compétences du cours sont évaluées.';
$string['syncplanscohorts'] = 'Synchronisation des plans de formation depuis les modèles de plan de cohorte';
$string['taxonomy_behaviour'] = 'Comportement';
$string['taxonomy_competency'] = 'Compétence';
$string['taxonomy_concept'] = 'Concept';
$string['taxonomy_domain'] = 'Domaine';
$string['taxonomy_indicator'] = 'Indicateur';
$string['taxonomy_level'] = 'Niveau';
$string['taxonomy_outcome'] = 'Objectif';
$string['taxonomy_practice'] = 'Entraînement';
$string['taxonomy_proficiency'] = 'Aptitude';
$string['taxonomy_skill'] = 'Habileté';
$string['taxonomy_value'] = 'Valeur';
$string['usercommentedonacompetency'] = '{$a->fullname} a commenté la compétence « {$a->competency} »:

{$a->comment}

Voir {$a->url}';
$string['usercommentedonacompetencyhtml'] = '<p>{$a->fullname} a commenté la compétence « {$a->competency} »:</p>
<div>{$a->comment}</div>
<p>Voir <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonacompetencysmall'] = '{$a->fullname} a commenté la compétence « {$a->competency} ».';
$string['usercommentedonacompetencysubject'] = '{$a} a commenté une compétence.';
$string['usercommentedonaplan'] = '{$a->fullname} a commenté le plan de formation « {$a->plan} »:

{$a->comment}

Voir {$a->url}';
$string['usercommentedonaplanhtml'] = '<p>{$a->fullname} a commenté le plan de formation « {$a->plan} »:</p>
<div>{$a->comment}</div>
<p>Voir <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonaplansmall'] = '{$a->fullname} a commenté le plan de formation « {$a->plan} ».';
$string['usercommentedonaplansubject'] = '{$a} a commenté un plan de formation.';
$string['usercompetencystatus_idle'] = 'En suspens';
$string['usercompetencystatus_inreview'] = 'En cours de validation';
$string['usercompetencystatus_waitingforreview'] = 'En attente de validation';
$string['userplans'] = 'Plans de formation';
