<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'hvp', language 'fr', branch 'MOODLE_34_STABLE'
 *
 * @package   hvp
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Action';
$string['addedandupdatedpp'] = 'Ajouter {$a->%new} nouvelles bibliothèques H5P et mettre à jour les {$a->%old} anciennes.';
$string['addedandupdatedps'] = 'Ajouter {$a->%new} nouvelles bibliothèques H5P et mettre à jour lancienne {$a->%old}.';
$string['addedandupdatedsp'] = 'Ajouter la {$a->%new} nouvelle bibliothèque H5P et mettre à jour les {$a->%old} anciennes.';
$string['addedandupdatedss'] = 'Ajouter la {$a->%new} nouvelle bibliothèque H5P et mettre à jour l\'ancienne {$a->%old}.';
$string['addednewlibraries'] = 'Ajouter {$a->%new} de nouvelles bibliothèques H5P.';
$string['addlibraries'] = 'Ajouter des bibliothèques.';
$string['ajaxfailed'] = 'Échec du téléchargement des données.';
$string['attribution'] = 'Attribution 4.0';
$string['author'] = 'Auteur';
$string['by'] = 'par';
$string['cancellabel'] = 'Annuler';
$string['close'] = 'Fermer';
$string['confirmdialogbody'] = 'Merci de confirmer que vous voulez continuer. Cette action est irréversible.';
$string['confirmdialogheader'] = 'Confirmer l\'action';
$string['confirmlabel'] = 'Confirmer';
$string['contentchanged'] = 'Ce contenu a changé depuis votre dernière utilisation.';
$string['contentstatefrequency'] = 'Fréquence de la sauvegarde du contenu';
$string['contentstatefrequency_help'] = 'En secondes, à quelle fréquence souhaitez-vous que les utilisateurs enregistrent leurs progrès. Augmentez ce nombre si vous rencontrez des problèmes avec les requêtes ajax.';
$string['contenttypecacheheader'] = 'Cache du type de contenu';
$string['copyright'] = 'Droits d\'utilisation';
$string['copyrightinfo'] = 'Informations sur le copyright';
$string['copyrightstring'] = 'Copyright';
$string['copyrighttitle'] = 'Voir les informations du copyright pour ce contenu.';
$string['couldnotcopy'] = 'Le fichier n\'a pas pu être copié.';
$string['couldnotsave'] = 'Le fichier n\'a pas pu être sauvegardé.';
$string['create'] = 'Créer';
$string['ctcachebuttonlabel'] = 'Mettre à jour le cache';
$string['ctcacheconnectionfailed'] = 'Impossible de communiquer avec le hub H5P. Merci de ré-essayer plus tard.';
$string['ctcachedescription'] = 'Assurez-vous que le cache du type de contenu est à jour pour vous permettre  de visualiser, télécharger et utiliser les dernières bibliothèques. Ceci est différent de la mise à jour des bibliothèques elles-mêmes.';
$string['ctcachelastupdatelabel'] = 'Dernière mise à jour';
$string['ctcacheneverupdated'] = 'Jamais';
$string['ctcachenolibraries'] = 'Pas de types  de contenu reçus du hub H5P. Merci de ré-essayer plus tard.';
$string['ctcachesuccess'] = 'Le cache des librairies H5P a été correctement mis à jour!';
$string['ctcachetaskname'] = 'Mettre à jour le cache des types de contenu';
$string['currentpage'] = 'Page $current de $total';
$string['dataviewreportlabel'] = 'Voir les réponses';
$string['disablefileextensioncheck'] = 'Désactiver la vérification de l\'extension du fichier';
$string['disablefileextensioncheckwarning'] = 'Attention ! Désactiver la vérification de l\'extension du fichier peut entrainer des problèmes de sécurité car cela autorise le dépôt de fichiers php. Par conséquent, des personnes mal intentionnées pourraient exécuter du code sur votre site. Veuillez vous assurer que vous connaissez le contenu de tout ce que vous déposez.';
$string['disablefullscreen'] = 'Désactiver le plein écran';
$string['disablehubconfirmationmsg'] = 'Voulez-vous toujours activer le hub?';
$string['disablehubdescription'] = 'Il est fortement recommandé de maintenir cette option activée. Le Hub H5P fournit une interface facile pour obtenir de nouveaux types de contenu et maintenir les types de contenu existants à jour. À l\'avenir, il facilitera également la diffusion et la réutilisation du contenu. Si cette option est désactivée, vous devrez installer et mettre à jour des types de contenu via des formulaires de téléchargement de fichiers.';
$string['displayoptionalwaysshow'] = 'Toujours montrer';
$string['displayoptionauthoroff'] = 'Contrôlé par l\'auteur,  désactivé par défaut';
$string['displayoptionauthoron'] = 'Contrôlé par l\'auteur, activé par défaut';
$string['displayoptionnevershow'] = 'Ne jamais montrer';
$string['displayoptionpermissions'] = 'Ne montrer que si droits d\'exports H5P';
$string['displayoptions'] = 'Afficher les options';
$string['download'] = 'Télécharger';
$string['downloadfailed'] = 'Le téléchargement de la librairie a échoué';
$string['downloadtitle'] = 'Télécharger ce contenu comme un fichier H5P.';
$string['editor'] = 'Éditeur';
$string['embed'] = 'Embarqué';
$string['embedloginfailed'] = 'Vous n\'avez pas accès à ce contenu. Essayez de vous connecter.';
$string['embedtitle'] = 'Voir le code embraqué pour ce contenu';
$string['empty'] = 'Pas de résultats disponibles';
$string['enableabout'] = 'À propos du bouton H5P';
$string['enablecopyright'] = 'Bouton copyright';
$string['enabledlrscontenttypes'] = 'Activer les types de contenu dépendants d\'un LRS';
$string['enabledlrscontenttypes_help'] = 'Permet d\'utiliser des types de contenu qui s\'appuient sur un Learning Record Store pour fonctionner correctement, comme le type de contenu "Questionnaire"';
$string['enabledownload'] = 'Bouton de téléchargement';
$string['enableembed'] = 'Bouton d\'intégration';
$string['enableframe'] = 'Afficher la barre d\'action et le cadre';
$string['enablehublabel'] = 'Utiliser Hub H5P';
$string['enablejavascript'] = 'Veuillez activer le JavaScript.';
$string['enablesavecontentstate'] = 'Sauvegarder le contenu actuel';
$string['enablesavecontentstate_help'] = 'Enregistrer automatiquement l\'état actuel du contenu interactif pour chaque utilisateur. Cela veut dire que l\'utilisateur pourra reprendre où il s\'est arrêté.';
$string['failedtodownloadh5p'] = 'Impossible de télécharger le fichier H5P demandé.';
$string['filenotfoundonserver'] = 'Le fichier n\'existe pas. Merci de revoir les options de téléchargement.';
$string['filenotimage'] = 'Le fichier n\'est pas une image.';
$string['filetypenotallowed'] = 'Ce type de fichier n\'est pas autorisé.';
$string['finished'] = 'Terminé';
$string['fullscreen'] = 'Plein écran';
$string['gpl'] = 'General Public License v3';
$string['h5pfile'] = 'Fichier H5P';
$string['h5ptitle'] = 'Visitez H5P.org pour consulter plus de contenus sympas.';
$string['hide'] = 'Cacher';
$string['hideadvanced'] = 'Cacher (mode avancé)';
$string['hubcommunicationdisabled'] = 'La communication avec le hub H5P a été désactivée car une ou plusieurs dépendances H5P ont échoué.';
$string['hubisdisabled'] = 'Le hub H5P est désactivé. Vous pouvez le réactiver via la page de configuration du plugin H5P.';
$string['hubisdisableduploadlibraries'] = 'Le hub H5P a été désactivé. Vous pouvez toujours télécharger des bibliothèques via la page "Bibliothèques H5P".';
$string['hubsettingsheader'] = 'Type de contenus';
$string['hvp:addinstance'] = 'Ajouter une nouvelle activité H5P';
$string['hvp:getcachedassets'] = 'Obtenir le contenu H5P mis en cache';
$string['hvp:getexport'] = 'Obtenez un fichier d\'exportation de H5P';
$string['hvp:installrecommendedh5plibraries'] = 'Installation des librairies H5P recommandées';
$string['hvp:manage'] = 'Modifier les activités H5P existantes';
$string['hvp:restrictlibraries'] = 'Restreindre une bibliothèque H5P.';
$string['hvp:savecontentuserdata'] = 'Enregistrer les données d\'utilisateurs du contenu H5P';
$string['hvp:saveresults'] = 'Sauvegarder les résultats du contenu H5P';
$string['hvp:updatelibraries'] = 'Mettre à jour la version d\'une bibliothèque H5P.';
$string['hvp:userestrictedlibraries'] = 'Utiliser des bibliothèques H5P restreintes';
$string['hvp:viewallresults'] = 'Voir tous les résultats des activités H5P terminées';
$string['hvp:viewresults'] = 'Voir le résultat du contenu H5P';
$string['installdenied'] = 'Vous n\'avez pas l\'autorisation d\'installer des types de contenu. Merci de contacter l\'administrateur du site.';
$string['installedlibraries'] = 'Installer des bibliothèques';
$string['intro'] = 'Introduction';
$string['invalidaudioformat'] = 'Format du fichier audio non valide. Utilisez mp3 ou wav.';
$string['invalidcontentfolder'] = 'Contenu du dossier non valide.';
$string['invalidcontenttype'] = 'Le type de contenu choisi n\'est pas valide.';
$string['invalidfieldtype'] = 'Type de champ non valide.';
$string['invalidfile'] = 'Fichier « {$a->%filename} » non autorisé. Seuls les fichiers avec les extensions suivantes sont autorisés : {$a->%files-allowed}.';
$string['invalidh5ppost'] = 'Impossible de publier';
$string['invalidimageformat'] = 'Format de l\'image non valide. Utilisez jpg, png ou gif.';
$string['invalidlanguagefile'] = 'Fichier de langue non valide {$a->%file} dans la bibliothèque {$a->%library}';
$string['invalidlanguagefile2'] = 'Un fichier de langue non valide {$a->%languageFile} a été ajouté dans la bibliothèque {$a->%name}';
$string['invalidlibrary'] = 'Bibliothèque H5P  {$a->%library} non valide';
$string['invalidlibrarydata'] = 'Données fournies invalides pour {$a->%property}  de {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Données fournies invalides pour {$a->%property} de {$a->%library}. Booléen attendu.';
$string['invalidlibraryname'] = 'Nom de bibliothèque non valide : {$a->%name}';
$string['invalidlibrarynamed'] = 'La bibliothèque H5P {$a->%library} utilisée dans le contenu n\'est pas valide';
$string['invalidlibraryoption'] = 'Option {$a->%option} non autorisée de {$a->%library}';
$string['invalidlibraryproperty'] = 'Impossible de lire les propriétés {$a->%property} de {$a->%library}';
$string['invalidmultiselectoption'] = 'Option sélectionnée non valide pour multi-select';
$string['invalidparameters'] = 'Paramètres non valides';
$string['invalidselectoption'] = 'Option sélectionnée non valide';
$string['invalidtoken'] = 'Jeton de sécurité non valide.';
$string['invalidvideoformat'] = 'Format de la vidéo non valide. Utilisez mp4 ou webm.';
$string['javascriptloading'] = 'En attente du Javascript...';
$string['libraries'] = 'Bibliothèques H5P';
$string['librarylistactions'] = 'Actions';
$string['librarylistinstancedependencies'] = 'Dépendances entre les instances';
$string['librarylistinstances'] = 'Instances';
$string['librarylistlibrarydependencies'] = 'Dépendances entre les bibliothèques';
$string['librarylistrestricted'] = 'Restreint';
$string['librarylisttitle'] = 'Titre';
$string['librarynotselected'] = 'Vous devez sélectionner un type de contenu.';
$string['license'] = 'Licence';
$string['licenseV1'] = 'Version 1';
$string['licenseV2'] = 'Version 2';
$string['licenseV3'] = 'Version 3';
$string['licenseversion'] = 'Version de la licence';
$string['loadingdata'] = 'Chargement des données.';
$string['lookforupdates'] = 'Rechercher des mises à jour';
$string['maximumgrade'] = 'Note maximale';
$string['maxscore'] = 'Score maximum';
$string['missingcontentfolder'] = 'Il manque un dossier de contenu valide';
$string['missinglibrary'] = 'Bibliothèque requise manquante {$a->@library}';
$string['missinglibraryfile'] = 'Le fichier « {$a->%file} » est manquant dans la bibliothèque : « {$a->%name} »';
$string['missingparameters'] = 'Paramètres manquants';
$string['missinguploadpermissions'] = 'Veuillez noter que les bibliothèques peuvent exister dans le fichier que vous avez téléchargé, mais vous n\'êtes pas autorisé à télécharger de nouvelles bibliothèques. Contactez l\'administrateur du site.';
$string['modulename'] = 'Contenu interactif';
$string['modulename_help'] = 'Le module d\'activités H5P vous permet de créer du contenu interactif tel que des vidéos interactives, des banques de questions, des questions « glisser-déposer », des questions à choix multiples, des présentations et bien plus encore.

En plus d\'être un outil de création pour du contenu riche, H5P vous permet d\'importer et d\'exporter des fichiers H5P afin de les réutiliser et de les partager.

Les interactions et les scores des utilisateurs sont suivis en utilisant xAPI et sont accessibles dans le carnet de note de Moodle.

Vous ajoutez un contenu interactif H5P en créant votre propre contenu grâce aux outils de création intégrés ou en important des fichiers H5P que vous aurez trouvés sur d\'autres sites H5P.';
$string['modulenameplural'] = 'Contenu interactif';
$string['nextpage'] = 'Page suivante';
$string['nocontenttype'] = 'Aucun type de contenu n\'a été spécifié.';
$string['nocopyright'] = 'Aucune information sur le copyright de ce contenu n\'est disponible.';
$string['nodata'] = 'Il n\'y a pas de données disponibles correspondant à vos critères.';
$string['noh5ps'] = 'Il n\'y a pas de contenu interactif disponible pour ce cours.';
$string['nojson'] = 'Le fichier h5p.json principal n\'est pas valide';
$string['noparameters'] = 'Pas de paramètres';
$string['nopermissiontorestrict'] = 'Vous n\'avez pas les droits pour restreindre des bibliothèques.';
$string['nopermissiontosavecontentuserdata'] = '';
$string['nopermissiontosaveresult'] = 'Vous n\'avez pas les droits pour enregistrer les résultats de ce contenu.';
$string['nopermissiontoupgrade'] = 'Vous n\'avez pas les droits pour mettre à jour les bibliothèques.';
$string['nopermissiontouploadcontent'] = 'Vous n\'avez pas les droits pour déposer du contenu ici.';
$string['nopermissiontouploadfiles'] = 'Vous n\'avez pas les droits pour déposer des fichiers ici.';
$string['nopermissiontoviewcontenttypes'] = 'Vous n\'avez pas les droits pour voir les types de contenu.';
$string['nopermissiontoviewresult'] = 'Vous n\'avez pas les droits pour voir les résultats de ce contenu.';
$string['nosuchlibrary'] = 'Cette bibliothèque n\'existe pas';
$string['notapplicable'] = 'N/A';
$string['nounzip'] = 'Le fichier que vous avez déposé n\'est pas un paquet HTML valide (il n\'est pas possible de le décompresser)';
$string['noversionattribution'] = 'Attribution';
$string['noziparchive'] = 'Votre version de PHP ne supporte pas ZipArchive.';
$string['onlyupdate'] = 'Mettre à jour les bibliothèques existantes uniquement.';
$string['options'] = 'Options';
$string['pluginadministration'] = 'H5P';
$string['pluginname'] = 'H5P';
$string['previouspage'] = 'Page précédente';
$string['removeoldlogentries'] = 'Effacer les anciens logs H5P';
$string['removetmpfiles'] = 'Effacer les anciens fichiers temporaires d\'H5P';
$string['reportingscaledscorelabel'] = 'Score du carnet de note :';
$string['reportingscoredelimiter'] = 'sur';
$string['reportingscorelabel'] = 'Score :';
$string['reportnotsupported'] = 'Non supporté';
$string['reveal'] = 'Révéler';
$string['score'] = 'Score';
$string['search'] = 'Rechercher';
$string['sendusagestatistics'] = 'Contribuer aux statistiques d\'utilisation';
$string['sendusagestatistics_help'] = 'Les statistiques d\'utilisation seront automatiquement reportées pour aider les développeurs à mieux comprendre comment H5P est utilisé et pour déterminer les potentiels domaines d\'amélioration. En savoir plus sur <a {$a}>les données collectées sur h5p.org</a>.';
$string['settings'] = 'Paramètres H5P';
$string['showadvanced'] = 'Afficher les paramètres avancés';
$string['showless'] = 'Afficher moins';
$string['showmore'] = 'Afficher plus';
$string['sitekey'] = 'Clef du site';
$string['size'] = 'Taille';
$string['source'] = 'Source';
$string['startingover'] = 'Vous allez recommencer depuis le début.';
$string['title'] = 'Titre';
$string['updatedlibraries'] = 'Bibliothèques H5P {$a->%old} mises à jour.';
$string['updatedlibrary'] = 'Bibliothèque H5P {$a->%old} mise à jour.';
$string['updatelibraries'] = 'Mettre à jour toutes les bibliothèques';
$string['upgrade'] = 'Actualiser H5P';
$string['upgradebuttonlabel'] = 'Actualiser';
$string['upgradeheading'] = 'Actualiser le contenu {$a}';
$string['upgradelibrarycontent'] = 'Actualiser le contenu de la bibliothèque';
$string['upgradelibrarymissing'] = 'Erreur : Votre bibliothèque est manquante !';
$string['upgradenoavailableupgrades'] = 'Il n\'y a pas d\'actualisations disponibles pour cette bibliothèque.';
$string['upgradereturn'] = 'Retour';
$string['upload'] = 'Déposer';
$string['uploadlibraries'] = 'Déposer des bibliothèques';
$string['user'] = 'Utilisateur';
$string['viewreportlabel'] = 'Reporter';
$string['welcomecommunity'] = 'Nous espérons que vous aimerez H5P et que vous vous engagerez dans notre communauté grandissante à travers nos <a {$a->forums}>forums</a>.';
$string['welcomecontactus'] = 'Si vous avez des retours, n\'hésitez pas à nous <a {$a}>contacter</a>. Nous prenons les retours très sérieusement et nous investissons pour rendre H5P meilleur de jour en jour !';
$string['welcomegettingstarted'] = 'Pour commencer avec H5P et Moodle, lisez notre <a {$a->moodle_tutorial}>tutoriel</a> et regardez nos <a {$a->example_content}>exemples de contenus</a> sur h5p.org pour vous inspirer.';
$string['welcomeheader'] = 'Bienvenue dans le monde d\'H5P !';
$string['year'] = 'Année';
$string['years'] = 'Année(s)';
