<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'fr', branch 'MOODLE_26_STABLE'
 *
 * @package   local_moodlemobileapp
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['appstoredescription'] = 'Remarque : cette app mobile officielle Moodle ne fonctionne qu\'avec les plateformes Moodle qui ont été configurées adéquatement dans ce but. Veuillez contacter l\'administrateur de votre plateforme Moodle si vous avez des difficultés à vous connecter.

Si votre plateforme Moodle a été configurée adéquatement, vous pouvez utiliser cette app pour :

– consulter le contenu de vos cours, même hors connexion ;
– recevoir des notifications instantanées des messages et autres événements ;
– trouver rapidement et contacter d\'autres personnes de vos cours ;
– déposer des images, sons, vidéos et autres fichiers à partir de votre appareil mobile ;
– consulter vos notes ;
– et bien plus encore !

Veuillez consulter http://docs.moodle.org/en/Mobile_app (en anglais) pour les informations les plus récentes.

Nous apprécions vraiment les bonnes critiques sur les fonctionnalités existantes ainsi que toute suggestion sur ce que vous aimeriez pouvoir faire avec cette app.';
$string['mma.calendar.calendarevents'] = 'Événements du calendrier';
$string['mma.calendar.defaultnotificationtime'] = 'Heure de notification par défaut';
$string['mma.calendar.errorloadevent'] = 'Erreur de chargement de l\'événement';
$string['mma.calendar.errorloadevents'] = 'Erreur de chargement des événements';
$string['mma.calendar.noevents'] = 'Il n\'y a pas d\'événement';
$string['mma.calendar.notifications'] = 'Notifications';
$string['mma.competency.errornocompetenciesfound'] = 'Aucune compétence trouvée';
$string['mma.competency.mylearningplans'] = 'Mes plans de formation';
$string['mma.competency.nocompetencies'] = 'Aucune compétence';
$string['mma.coursecompletion.complete'] = 'Terminer';
$string['mma.coursecompletion.completecourse'] = 'Terminer le cours';
$string['mma.coursecompletion.completed'] = 'Terminé';
$string['mma.coursecompletion.completiondate'] = 'Date d\'achèvement';
$string['mma.coursecompletion.couldnotloadreport'] = 'Impossible de charger le rapport d\'achèvement de cours. Veuillez essayer plus tard.';
$string['mma.coursecompletion.coursecompletion'] = 'Achèvement du cours';
$string['mma.coursecompletion.criteria'] = 'Critères';
$string['mma.coursecompletion.criteriagroup'] = 'Groupe de critères';
$string['mma.coursecompletion.criteriarequiredall'] = 'Tous les critères ci-dessous sont requis.';
$string['mma.coursecompletion.criteriarequiredany'] = 'Un des critères ci-dessous est requis.';
$string['mma.coursecompletion.inprogress'] = 'En cours';
$string['mma.coursecompletion.manualselfcompletion'] = 'Auto-achèvement manuel';
$string['mma.coursecompletion.notyetstarted'] = 'Pas encore commencé';
$string['mma.coursecompletion.pending'] = 'En attente';
$string['mma.coursecompletion.required'] = 'Requis';
$string['mma.coursecompletion.requiredcriteria'] = 'Critères requis';
$string['mma.coursecompletion.requirement'] = 'Condition';
$string['mma.coursecompletion.status'] = 'Statut';
$string['mma.coursecompletion.viewcoursereport'] = 'Afficher le rapport du cours';
$string['mma.files.admindisableddownload'] = 'L\'administrateur de votre Moodle a désactivé le téléchargement des fichiers. Vous pouvez les consulter, mais pas les télécharger.';
$string['mma.files.audio'] = 'Audio';
$string['mma.files.camera'] = 'Caméra';
$string['mma.files.chooseaccountuploadfile'] = 'Sélectionner un compte vers lequel déposer le fichier.';
$string['mma.files.clicktoupload'] = 'Cliquer sur le bouton ci-dessous pour déposer les fichiers dans vos fichiers personnels.';
$string['mma.files.confirmuploadfile'] = 'Vous allez déposer {{size}}. Voulez-vous vraiment continuer ?';
$string['mma.files.couldnotloadfiles'] = 'La liste des fichiers n\'a pas pu être chargée.';
$string['mma.files.downloading'] = 'Téléchargement';
$string['mma.files.emptyfilelist'] = 'Aucun fichier à afficher.';
$string['mma.files.errorcapturingaudio'] = 'Erreur d\'enregistrement audio.';
$string['mma.files.errorcapturingimage'] = 'Erreur lors de la capture de l\'image.';
$string['mma.files.errorcapturingvideo'] = 'Erreur lors de la capture vidéo.';
$string['mma.files.errorgettingimagealbum'] = 'Erreur lors de la récupération de l\'image dans l\'album.';
$string['mma.files.errormustbeonlinetoupload'] = 'Vous devez être en ligne pour déposer des fichiers.';
$string['mma.files.errornoapp'] = 'Vous n\'avez pas d\'app installée pour effectuer cette action.';
$string['mma.files.errorreadingfile'] = 'Erreur lecture du fichier.';
$string['mma.files.errorreceivefilenosites'] = 'Aucun site enregistré. Veuillez ajouter un site avant de déposer un fichier.';
$string['mma.files.erroruploadnotworking'] = 'Il n\'est actuellement pas possible de déposer des fichiers sur votre site.';
$string['mma.files.errorwhiledownloading'] = 'Une erreur est survenue lors du téléchargement du fichier.';
$string['mma.files.errorwhilerecordingaudio'] = 'Une erreur est survenue lors de l\'enregistrement du son.';
$string['mma.files.errorwhileuploading'] = 'Une erreur est survenue durant le dépôt du fichier.';
$string['mma.files.fileuploaded'] = 'Le fichier a été déposé.';
$string['mma.files.myfiles'] = 'Mes fichiers';
$string['mma.files.myprivatefiles'] = 'Mes fichiers personnels';
$string['mma.files.myprivatefilesdesc'] = 'Fichiers auxquels vous seul avez accès.';
$string['mma.files.photoalbums'] = 'Albums photos';
$string['mma.files.readingfile'] = 'Lecture du fichier';
$string['mma.files.sitefilesdesc'] = 'Autres fichiers auxquels vous avez accès sur cette plateforme.';
$string['mma.files.success'] = 'Succès !';
$string['mma.files.uploadfiles'] = 'Déposer des fichiers';
$string['mma.files.uploading'] = 'Dépôt en cours';
$string['mma.files.video'] = 'Vidéo';
$string['mma.frontpage.frontpage'] = 'Page d\'accueil';
$string['mma.grades.itemname'] = 'Élément d\'évaluation';
$string['mma.messageoutput_airnotifier.processorsettingsdesc'] = 'Configurer les appareils';
$string['mma.messages.blockcontactconfirm'] = 'Vous ne recevrez plus de messages de ce contact.';
$string['mma.messages.contactlistempty'] = 'La liste des contacts est vide';
$string['mma.messages.contactname'] = 'Nom du contact';
$string['mma.messages.errordeletemessage'] = 'Erreur lors de la suppression du message.';
$string['mma.messages.errorwhileretrievingcontacts'] = 'Erreur lors de la récupération de contacts depuis le serveur.';
$string['mma.messages.errorwhileretrievingdiscussions'] = 'Erreur lors de la récupération de discussions depuis le serveur.';
$string['mma.messages.errorwhileretrievingmessages'] = 'Erreur lors de la récupération de messages depuis le serveur.';
$string['mma.messages.loadpreviousmessages'] = 'Charger les messages antérieurs';
$string['mma.messages.messagenotsent'] = 'Ce message n\'a pas été envoyé. Veuillez essayer plus tard.';
$string['mma.messages.mustbeonlinetosendmessages'] = 'Vous devez être en ligne pour envoyer des messages.';
$string['mma.messages.newmessages'] = 'Nouveaux messages';
$string['mma.messages.nousersfound'] = 'Aucun utilisateur trouvé';
$string['mma.messages.removecontactconfirm'] = 'Le contact sera retiré de votre liste.';
$string['mma.messages.type_blocked'] = 'Bloqué';
$string['mma.messages.type_offline'] = 'Hors connexion';
$string['mma.messages.type_online'] = 'En ligne';
$string['mma.messages.type_search'] = 'Résultats de recherche';
$string['mma.messages.type_strangers'] = 'Autres';
$string['mma.messages.warningmessagenotsent'] = 'Impossible d\'envoyer de message à l\'utilisateur {{user}}. {{error}}';
$string['mma.mod_assign.acceptsubmissionstatement'] = 'Veuillez accepter les conditions d\'envoi.';
$string['mma.mod_assign.cannoteditduetostatementsubmission'] = 'Vous ne pouvez ni ajouter ni modifier de données dans l\'app, car la déclaration de remise n\'a pas pu être récupérée depuis le site.';
$string['mma.mod_assign.cannotgradefromapp'] = 'Certaines méthodes d\'évaluations ne sont pas encore supportées par l\'app et ne peuvent pas être modifiées.';
$string['mma.mod_assign.cannotsubmitduetostatementsubmission'] = 'Vous ne pouvez pas déposer de travail à évaluer dans l\'app, car il n\'est actuellement pas possible de récupérer la déclaration de remise.';
$string['mma.mod_assign.erroreditpluginsnotsupported'] = 'Vous ne pouvez ni ajouter ni modifier de données dans l\'app, car certains plugins ne permettent pas la modification.';
$string['mma.mod_assign.errorshowinginformation'] = 'Il n\'est pas possible d\'afficher les informations de remise.';
$string['mma.mod_assign.feedbacknotsupported'] = 'Le feedback n\'est pas supporté par l\'app et pourrait ne pas contenir la totalité des informations.';
$string['mma.mod_assign.gradenotsynced'] = 'Note non synchronisée';
$string['mma.mod_assign.notallparticipantsareshown'] = 'Les participants qui n\'ont pas encore remis de travail ne sont pas affichés.';
$string['mma.mod_assign.submissionnotsupported'] = 'Le remise de documents n\'est pas supportée par l\'app et pourrait ne pas contenir la totalité des informations.';
$string['mma.mod_assign.userwithid'] = 'Utilisateur d\'ID {{id}}';
$string['mma.mod_assign.warningsubmissiongrademodified'] = 'La note a été modifiée sur le site.';
$string['mma.mod_assign.warningsubmissionmodified'] = 'Le travail remis par l\'utilisateur a été modifié sur le site.';
$string['mma.mod_chat.errorwhileconnecting'] = 'Erreur lors de la connexion au chat.';
$string['mma.mod_chat.errorwhilegettingchatdata'] = 'Erreur lors de l\'obtention des données de chat.';
$string['mma.mod_chat.errorwhilegettingchatusers'] = 'Erreur lors de l\'obtention des usagers du chat.';
$string['mma.mod_chat.errorwhileretrievingmessages'] = 'Erreur lors de la récupération de messages sur le serveur.';
$string['mma.mod_chat.errorwhilesendingmessage'] = 'Erreur lors de l\'envoi du message.';
$string['mma.mod_chat.mustbeonlinetosendmessages'] = 'Vous devez être en ligne pour envoyer des messages.';
$string['mma.mod_choice.errorgetchoice'] = 'Erreur lors de l\'obtention des données du choix.';
$string['mma.mod_choice.responsesresultgraphdescription'] = '{{number}} % des participants ont choisi l\'option : {{text}}.';
$string['mma.mod_choice.resultsnotsynced'] = 'Votre dernière réponse doit être synchronisée pour être inclue dans les résultats.';
$string['mma.mod_data.errorapproving'] = 'Erreur lors de l\'approbation ou de la désapprobation de la fiche.';
$string['mma.mod_data.errordeleting'] = 'Erreur lors de suppression de la fiche.';
$string['mma.mod_feedback.captchaofflinewarning'] = 'Le feedback avec CAPTCHA ne peut pas être terminé hors connexion, ou s\'il n\'est pas configuré, ou si le serveur est arrêté.';
$string['mma.mod_feedback.feedback_submitted_offline'] = 'Ce feedback a été enregistré pour être remis plus tard.';
$string['mma.mod_folder.emptyfilelist'] = 'Aucun fichier à afficher.';
$string['mma.mod_folder.errorwhilegettingfolder'] = 'Erreur lors de l\'obtention des données du dossier.';
$string['mma.mod_forum.errorgetforum'] = 'Erreur de récupération des données de forum.';
$string['mma.mod_forum.errorgetgroups'] = 'Erreur lors de l\'obtention des réglages de groupe.';
$string['mma.mod_forum.forumnodiscussionsyet'] = 'Il n\'y a pas encore de discussion dans ce forum.';
$string['mma.mod_forum.group'] = 'Groupe';
$string['mma.mod_forum.numdiscussions'] = '{{numdiscussions}} discussions';
$string['mma.mod_forum.numreplies'] = '{{numreplies}} réponses';
$string['mma.mod_forum.refreshdiscussions'] = 'Rafraîchir les discussions';
$string['mma.mod_forum.refreshposts'] = 'Actualiser les messages';
$string['mma.mod_forum.sortnewestfirst'] = 'Afficher la plus récente en premier';
$string['mma.mod_forum.sortoldestfirst'] = 'Afficher la plus ancienne en premier';
$string['mma.mod_glossary.browsemode'] = 'Parcourir les articles';
$string['mma.mod_glossary.byalphabet'] = 'Alphabétiquement';
$string['mma.mod_glossary.byauthor'] = 'Grouper par auteur';
$string['mma.mod_glossary.bycategory'] = 'Grouper par catégorie';
$string['mma.mod_glossary.bynewestfirst'] = 'Les plus récents en premier';
$string['mma.mod_glossary.byrecentlyupdated'] = 'Modifiés récemment';
$string['mma.mod_glossary.bysearch'] = 'Rechercher';
$string['mma.mod_glossary.cannoteditentry'] = 'Impossible de modifier l\'article';
$string['mma.mod_glossary.entriestobesynced'] = 'Articles à synchroniser';
$string['mma.mod_glossary.entrypendingapproval'] = 'Cet article est en attente d\'approbation';
$string['mma.mod_glossary.errorloadingentries'] = 'Une erreur est survenue lors du chargement des articles.';
$string['mma.mod_glossary.errorloadingentry'] = 'Une erreur est survenue lors du chargement de l\'article.';
$string['mma.mod_glossary.errorloadingglossary'] = 'Une erreur est survenue lors du chargement du glossaire.';
$string['mma.mod_glossary.noentriesfound'] = 'Aucun article trouvé.';
$string['mma.mod_glossary.searchquery'] = 'Texte recherché';
$string['mma.mod_imscp.showmoduledescription'] = 'Afficher la description';
$string['mma.mod_label.label'] = 'Étiquette';
$string['mma.mod_label.taptoview'] = 'Tapoter pour voir l\'étiquette.';
$string['mma.mod_lesson.errorprefetchrandombranch'] = 'Cette leçon comporte un saut vers une page aléatoire. Elle ne peut être effectuée dans l\'app avant d\'avoir été commencée dans un navigateur.';
$string['mma.mod_lesson.errorreviewretakenotlast'] = 'Cette tentative ne peut plus être relue, car une autre tentative a été terminée.';
$string['mma.mod_lesson.finishretakeoffline'] = 'Cette tentative a été terminée localement.';
$string['mma.mod_lesson.retakefinishedinsync'] = 'Une tentative locale a été synchronisée. Voulez-vous la relire ?';
$string['mma.mod_lesson.retakelabelfull'] = '{{retake}} : {{grade}} {{timestart}} ({{duration}})';
$string['mma.mod_lesson.retakelabelshort'] = '{{retake}} : {{grade}} {{timestart}}';
$string['mma.mod_lesson.warningretakefinished'] = 'Cette tentative a été terminée dans un navigateur.';
$string['mma.mod_lti.errorgetlti'] = 'Erreur lors de l\'obtention des données du module.';
$string['mma.mod_lti.errorinvalidlaunchurl'] = 'L\'URL de lancement n\'est pas valide.';
$string['mma.mod_lti.launchactivity'] = 'Lancer l\'activité';
$string['mma.mod_page.errorwhileloadingthepage'] = 'Erreur lors du chargement du contenu de la page.';
$string['mma.mod_quiz.cannotsubmitquizdueto'] = 'Cette tentative de test ne peut pas être envoyée pour les raisons suivantes :';
$string['mma.mod_quiz.confirmcontinueoffline'] = 'La tentative n\'a pas été synchronisée depuis {{$a}}. Si entretemps vous avez continué cette tentative avec un autre appareil, vous risquez de perdre des données.';
$string['mma.mod_quiz.confirmleavequizonerror'] = 'Une erreur est survenu lors de l\'enregistrement des réponses. Voulez-vous vraiment quitter le test ?';
$string['mma.mod_quiz.errorbehaviournotsupported'] = 'Ce test ne peut être effectué dans l\'app, car le comportement de question n\'est pas supporté par l\'app :';
$string['mma.mod_quiz.errordownloading'] = 'Erreur lors du téléchargement des données requises.';
$string['mma.mod_quiz.errorgetattempt'] = 'Erreur lors de l\'obtention des données de tentative.';
$string['mma.mod_quiz.errorgetquestions'] = 'Erreur lors de l\'obtention des questions.';
$string['mma.mod_quiz.errorgetquiz'] = 'Erreur lors de l\'obtention des données du test.';
$string['mma.mod_quiz.errorparsequestions'] = 'Une erreur est survenue lors de la lecture des questions. Veuillez faire ce test dans un navigateur web.';
$string['mma.mod_quiz.errorquestionsnotsupported'] = 'Ce test ne peut être effectué dans l\'app, car il contient des questions qui ne sont pas supportées :';
$string['mma.mod_quiz.errorrulesnotsupported'] = 'Ce test ne peut être effectué dans l\'app, car il contient des règles d\'accès qui ne sont pas supportées :';
$string['mma.mod_quiz.errorsaveattempt'] = 'Une erreur est survenue lors de l\'enregistrement des données de tentative.';
$string['mma.mod_quiz.errorsyncquiz'] = 'Une erreur est survenue lors de la synchronisation. Veuillez essayer à nouveau.';
$string['mma.mod_quiz.errorsyncquizblocked'] = 'Ce test ne peut pas être synchronisé maintenant en raison d\'une tâche en cours. Veuillez essayer plus tard. Si le problème persiste, veuillez relancer l\'app.';
$string['mma.mod_quiz.finishnotsynced'] = 'Terminé, mais pas synchronisé';
$string['mma.mod_quiz.hasdatatosync'] = 'Ce test a des données locales à synchroniser.';
$string['mma.mod_quiz.opentoc'] = 'Ouvrir la navigation';
$string['mma.mod_quiz.warningattemptfinished'] = 'Tentative locale écartée, car elle a été terminée sur le site web ou n\'a pas été trouvée.';
$string['mma.mod_quiz.warningdatadiscarded'] = 'Certaines réponses faites hors connexion ont été écartées, car les questions ont été modifiées.';
$string['mma.mod_quiz.warningdatadiscardedfromfinished'] = 'Tentative non terminée, car certaines réponses faites hors connexion ont été écartées. Veuillez revoir vos réponses et envoyer à nouveau votre tentative.';
$string['mma.mod_resource.errorwhileloadingthecontent'] = 'Erreur lors du chargement du contenu';
$string['mma.mod_resource.openthefile'] = 'Ouvrir le fichier';
$string['mma.mod_scorm.cannotcalculategrade'] = 'La note n\'a pas pu être calculée.';
$string['mma.mod_scorm.dataattemptshown'] = 'Ces données appartiennent à la tentative numéro {{number}}';
$string['mma.mod_scorm.errorcreateofflineattempt'] = 'Une erreur est survenue lors de la création d\'une tentative hors connexion. Veuillez réessayer.';
$string['mma.mod_scorm.errordownloadscorm'] = 'Erreur de téléchargement SCORM : « {{name}} »';
$string['mma.mod_scorm.errorgetscorm'] = 'Erreur de récupération des données SCORM.';
$string['mma.mod_scorm.errorinvalidversion'] = 'Désolé, l\'application ne supporte que SCORM 1.2.';
$string['mma.mod_scorm.errornotdownloadable'] = 'Le téléchargement des paquetages SCORM est désactivé. Veuillez contacter l\'administrateur de la plateforme.';
$string['mma.mod_scorm.errornovalidsco'] = 'Ce paquetage SCORM n\'a pas de SCO visible à charger.';
$string['mma.mod_scorm.errorpackagefile'] = 'L\'application ne supporte que les paquetages ZIP.';
$string['mma.mod_scorm.errorsyncscorm'] = 'Une erreur est survenue lors de la synchronisation. Veuillez réessayer.';
$string['mma.mod_scorm.lastsync'] = 'Dernière synchronisation';
$string['mma.mod_scorm.offlineattemptnote'] = 'Cette tentative comporte des données non synchronisées.';
$string['mma.mod_scorm.offlineattemptovermax'] = 'Cette tentative ne peut pas être envoyée, car vous avez dépassé le nombre maximum de tentatives.';
$string['mma.mod_scorm.scormstatusnotdownloaded'] = 'Ce paquetage SCORM n\'est pas téléchargé. Il sera téléchargé automatiquement dès que vous l\'ouvrirez.';
$string['mma.mod_scorm.scormstatusoutdated'] = 'Ce paquetage SCORM a été modifié depuis son dernier téléchargement. Il sera téléchargé automatiquement dès que vous l\'ouvrirez.';
$string['mma.mod_scorm.warningofflinedatadeleted'] = 'Des données locales de la tentative {{number}} ont été supprimées, car elles n\'ont pas pu être intégrées dans une nouvelle tentative.';
$string['mma.mod_scorm.warningsynconlineincomplete'] = 'Certaines tentatives n\'ont pas pu être synchronisées avec la plateforme, car la dernière tentative en ligne n\'est pas terminée. Veuillez d\'abord finir votre tentative en ligne.';
$string['mma.mod_survey.cannotsubmitsurvey'] = 'Un problème est survenu lors de l\'envoi de votre consultation. Veuillez essayer à nouveau.';
$string['mma.mod_survey.errorgetsurvey'] = 'Erreur lors de l\'obtention des données de la consultation.';
$string['mma.mod_survey.results'] = 'Résultats';
$string['mma.mod_url.accessurl'] = 'Accéder à l\'URL';
$string['mma.mod_url.pointingtourl'] = 'URL vers laquelle cette ressource dirige.';
$string['mma.mod_wiki.errorloadingpage'] = 'Une erreur est survenue lors du chargement de la page.';
$string['mma.mod_wiki.errornowikiavailable'] = 'Ce wiki n\'a pas encore de contenu.';
$string['mma.mod_wiki.gowikihome'] = 'Vers la première page du wiki';
$string['mma.mod_wiki.page'] = 'Page';
$string['mma.mod_wiki.subwiki'] = 'Sous-wiki';
$string['mma.mod_wiki.titleshouldnotbeempty'] = 'Le titre ne doit pas être vide';
$string['mma.mod_wiki.viewpage'] = 'Consulter la page';
$string['mma.mod_wiki.wikipage'] = 'Page wiki';
$string['mma.mod_workshop.assessmentstrategynotsupported'] = 'Stratégie d\'évaluation {{$a}} non supportée';
$string['mma.mod_workshop.selectphase'] = 'Sélectionner la phase';
$string['mma.mod_workshop.warningassessmentmodified'] = 'Le travail remis a été modifié sur la plateforme.';
$string['mma.mod_workshop.warningsubmissionmodified'] = 'L\'évaluation a été modifiée sur la plateforme.';
$string['mma.notes.addnewnote'] = 'Ajouter une annotation';
$string['mma.notes.coursenotes'] = 'Annotations de cours';
$string['mma.notes.eventnotecreated'] = 'Annotation créée';
$string['mma.notes.nonotes'] = 'Il n\'y a pas encore d\'annotation de ce type.';
$string['mma.notes.note'] = 'Annotation';
$string['mma.notes.notes'] = 'Annotations';
$string['mma.notes.personalnotes'] = 'Annotations personnelles';
$string['mma.notes.publishstate'] = 'Contexte';
$string['mma.notes.sitenotes'] = 'Annotations du site';
$string['mma.notes.userwithid'] = 'Utilisateur d\'ID {{id}}';
$string['mma.notes.warningnotenotsent'] = 'Impossible d\'ajouter d\'annotation au cours {{course}}. {{error}}';
$string['mma.notifications.errorgetnotifications'] = 'Erreur lors de la récupération des notifications.';
$string['mma.notifications.notificationpreferences'] = 'Préférences de notification';
$string['mma.notifications.notifications'] = 'Notifications';
$string['mma.notifications.playsound'] = 'Jouer le son';
$string['mma.notifications.therearentnotificationsyet'] = 'Aucune notification.';
$string['mma.participants.noparticipants'] = 'Aucun participant trouvé dans ce cours.';
$string['mma.participants.participants'] = 'Participants';
$string['mm.contentlinks.chooseaccount'] = 'Sélectionner un compte';
$string['mm.contentlinks.chooseaccounttoopenlink'] = 'Sélectionner un compte avec lequel ouvrir le lien.';
$string['mm.contentlinks.confirmurlothersite'] = 'Ce lien provient d\'un autre site. Voulez-vous l\'ouvrir ?';
$string['mm.contentlinks.errornoactions'] = 'Impossible de trouver une action à effectuer avec ce lien.';
$string['mm.contentlinks.errornosites'] = 'Impossible de trouver un site pour traiter ce lien.';
$string['mm.core.accounts'] = 'Comptes';
$string['mm.core.android'] = 'Android';
$string['mm.core.cannotconnect'] = 'Connexion impossible : vérifiez que l\'URL a été saisie correctement et que votre site utilise Moodle 2.4 ou ultérieur.';
$string['mm.core.cannotdownloadfiles'] = 'Le téléchargement de fichiers est désactivé. Veuillez contacter l\'administrateur de la plateforme.';
$string['mm.core.captureaudio'] = 'Enregistrer un son';
$string['mm.core.capturedimage'] = 'Photo prise';
$string['mm.core.captureimage'] = 'Prendre une photo';
$string['mm.core.capturevideo'] = 'Enregistrer une vidéo';
$string['mm.core.clearsearch'] = 'Effacer la recherche';
$string['mm.core.clicktoseefull'] = 'Cliquer pour voir tout le contenu.';
$string['mm.core.commentsnotworking'] = 'Les commentaires ne peuvent pas être récupérés';
$string['mm.core.confirmcanceledit'] = 'Voulez-vous vraiment quitter cette page ? Toutes vos modifications seront perdues.';
$string['mm.core.confirmloss'] = 'Vraiment ? Toutes les modifications seront perdues.';
$string['mm.core.confirmopeninbrowser'] = 'Voulez-vous l\'ouvrir dans un navigateur ?';
$string['mm.core.contenteditingsynced'] = 'Le contenu que vous modifiez a été synchronisé.';
$string['mm.core.copiedtoclipboard'] = 'Texte copié dans le presse-papier';
$string['mm.core.currentdevice'] = 'Appareil actuel';
$string['mm.core.datastoredoffline'] = 'Données stockées sur l\'appareil, car elles n\'ont pas pu être envoyées. Elles seront automatiquement envoyées ultérieurement.';
$string['mm.core.deletedoffline'] = 'Supprimé en local';
$string['mm.core.deleting'] = 'Suppression';
$string['mm.core.dfdaymonthyear'] = 'DD-MM-YYYY';
$string['mm.core.dfdayweekmonth'] = 'ddd, D MMM';
$string['mm.core.dffulldate'] = 'dddd, D MMMM YYYY h[:]mm A';
$string['mm.core.dflastweekdate'] = 'ddd';
$string['mm.core.dfmediumdate'] = 'LLL';
$string['mm.core.dftimedate'] = 'hh[:]mm';
$string['mm.core.discard'] = 'Ignorer';
$string['mm.core.dismiss'] = 'Rejeter';
$string['mm.core.downloading'] = 'Téléchargement en cours';
$string['mm.core.elementseparator'] = ',';
$string['mm.core.emptysplit'] = 'Cette page paraîtra vide si le panneau de gauche est vide ou en cours de chargement.';
$string['mm.core.errorchangecompletion'] = 'Une erreur est survenue lors du changement de l\'état d\'achèvement. Veuillez essayer à nouveau.';
$string['mm.core.errordeletefile'] = 'Erreur lors de la suppression du fichier. Veuillez essayer à nouveau.';
$string['mm.core.errordownloading'] = 'Erreur lors du téléchargement du fichier.';
$string['mm.core.errordownloadingsomefiles'] = 'Erreur lors du téléchargement de fichiers. Certains fichiers peuvent être manquants.';
$string['mm.core.errorfileexistssamename'] = 'Un fichier de même nom est déjà présent.';
$string['mm.core.errorinvalidform'] = 'Le formulaire comporte des données non valides. Veuillez vous assurer que tous les champs requis sont renseignés et que les données sont valides.';
$string['mm.core.errorinvalidresponse'] = 'Réponse reçue non valide. Veuillez contacter l\'administrateur de votre plateforme si l\'erreur persiste.';
$string['mm.core.errorloadingcontent'] = 'Erreur lors du chargement du contenu.';
$string['mm.core.erroropenfilenoapp'] = 'Erreur lors de l\'ouverture du fichier : aucune app trouvée pour ouvrir ce type de fichier.';
$string['mm.core.erroropenfilenoextension'] = 'Erreur lors de l\'ouverture du fichier : le nom du fichier n\'a pas d\'extension.';
$string['mm.core.erroropenpopup'] = 'Cette activité essaie d\'ouvrir dans une fenêtre surgissante. Ceci n\'est pas supporté dans l\'app.';
$string['mm.core.errorrenamefile'] = 'Erreur lors du renommage du fichier. Veuillez essayer à nouveau.';
$string['mm.core.errorsync'] = 'Une erreur est survenue lors de la synchronisation. Veuillez essayer plus tard.';
$string['mm.core.errorsyncblocked'] = 'Ce {{$a}} ne peut pas être synchronisé maintenant en raison d\'une tâche en cours. Veuillez essayer plus tard. Si le problème persiste, veuillez relancer l\'app.';
$string['mm.core.fieldvalueseparator'] = ':';
$string['mm.core.filenameexist'] = 'Le nom de fichier existe déjà : {{$a}}';
$string['mm.core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['mm.core.hasdatatosync'] = 'Ce {{$a}} a des données locales à synchroniser.';
$string['mm.core.humanreadablesize'] = '{{size}} {{unit}}';
$string['mm.core.image'] = 'Image';
$string['mm.core.imageviewer'] = 'Lecteur d\'images';
$string['mm.core.info'] = 'Info';
$string['mm.core.ios'] = 'iOS';
$string['mm.core.lastdownloaded'] = 'Dernier téléchargement';
$string['mm.core.lastsync'] = 'Dernière synchronisation';
$string['mm.core.loadmore'] = 'Charger plus';
$string['mm.core.lostconnection'] = 'Votre jeton n\'est pas valide ou est échu. Veuillez vous reconnecter à la plateforme.';
$string['mm.core.mygroups'] = 'Mes groupes';
$string['mm.core.networkerrormsg'] = 'Un problème est survenu lors de la connexion au site. Veuillez vérifier votre connexion et essayer à nouveau.';
$string['mm.core.nopasswordchangeforced'] = 'Vous ne pouvez pas continuer sans changer votre mot de passe.';
$string['mm.core.notapplicable'] = 'n/a';
$string['mm.core.notsent'] = 'Pas envoyé';
$string['mm.core.openfullimage'] = 'Cliquer ici pour afficher l\'image en pleine grandeur';
$string['mm.core.openinbrowser'] = 'Ouvrir dans le navigateur';
$string['mm.core.othergroups'] = 'Autres groupes';
$string['mm.core.percentagenumber'] = '{{$a}} %';
$string['mm.core.pulltorefresh'] = 'Tirer pour actualiser';
$string['mm.core.redirectingtosite'] = 'Vous allez être redirigé vers le site.';
$string['mm.core.requireduserdatamissing'] = 'Il manque certaines données au profil de cet utilisateur. Veuillez compléter ces données dans votre plateforme et essayer à nouveau.<br />{{$a}}';
$string['mm.core.retry'] = 'Essayer à nouveau';
$string['mm.core.searching'] = 'Recherche';
$string['mm.core.sending'] = 'Envoi';
$string['mm.core.sitemaintenance'] = 'Le site est en cours de maintenance et n\'est pas disponible.';
$string['mm.core.sizetb'] = 'To';
$string['mm.core.sorry'] = 'Désolé...';
$string['mm.core.tablet'] = 'Tablette';
$string['mm.core.thereisdatatosync'] = 'Il y a des {{$a}} locales à synchroniser.';
$string['mm.core.tryagain'] = 'Essayer encore';
$string['mm.core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['mm.core.uhoh'] = 'Aïe !';
$string['mm.core.unexpectederror'] = 'Erreur inattendue. Veuillez fermer et rouvrir l\'app et réessayer.';
$string['mm.core.unicodenotsupported'] = 'Certains emojis ne sont pas supportés sur ce site. Ils seront supprimés avant l\'envoi.';
$string['mm.core.unicodenotsupportedcleanerror'] = 'Un texte vide a été rencontré lors du nettoyage des caractères Unicode.';
$string['mm.core.unknown'] = 'Inconnu';
$string['mm.core.unzipping'] = 'Décompression';
$string['mm.core.warningofflinedatadeleted'] = 'Des données locales de {{component}} « {{name}} » ont été supprimées. {{error}}';
$string['mm.core.whoops'] = 'Oups !';
$string['mm.core.whyisthishappening'] = 'Que se passe-t-il ?';
$string['mm.core.windowsphone'] = 'Windows phone';
$string['mm.core.wsfunctionnotavailable'] = 'Le service web n\'est pas disponible.';
$string['mm.course.activitydisabled'] = 'Votre institution a désactivé cette activité dans l\'App mobile.';
$string['mm.course.activitynotyetviewable'] = 'Cette activité n\'est pas encore accessible via l\'app.';
$string['mm.course.activitynotyetviewablegothere'] = 'Cette activité ou ressource n\'est pas encore accessible via l\'app ; cliquez sur le bouton ci-dessous pour y accéder sur la plateforme.';
$string['mm.course.activitynotyetviewableinapp'] = 'L\'activité {{$a}} sera bientôt supportée.';
$string['mm.course.activitynotyetviewableremoteaddon'] = 'Votre institution a installé un plugin qui n\'est pas encore supporté.';
$string['mm.course.activitynotyetviewablesiteupgradeneeded'] = 'L\'installation Moodle de votre institution doit être mise à jour.';
$string['mm.course.allsections'] = 'Toutes les sections';
$string['mm.course.askadmintosupport'] = 'Veuillez contacter l\'administrateur de la plateforme et l\'informer que vous désirez utiliser cette activité avec l\'app mobile Moodle.';
$string['mm.course.confirmdeletemodulefiles'] = 'Voulez-vous vraiment supprimer ces fichiers de module ?';
$string['mm.course.confirmdownload'] = 'Vous allez télécharger {{size}}. Voulez-vous vraiment continuer ?';
$string['mm.course.confirmdownloadsection'] = 'Vous allez télécharger {{size}}. Voulez-vous vraiment continuer ?';
$string['mm.course.confirmdownloadunknownsize'] = 'Il n\'a pas été possible de calculer la taille du téléchargement. Voulez-vous vraiment effectuer le téléchargement ?';
$string['mm.course.confirmpartialdownloadsize'] = 'Vous allez télécharger <strong>au moins</strong> {{size}}. Voulez-vous vraiment continuer ?';
$string['mm.course.contents'] = 'Contenus';
$string['mm.course.couldnotloadsectioncontent'] = 'Impossible de charger le contenu de la section. Veuillez essayer plus tard.';
$string['mm.course.couldnotloadsections'] = 'Impossible de charger les sections. Veuillez essayer plus tard.';
$string['mm.course.downloadcourse'] = 'Télécharger le cours';
$string['mm.course.errordownloadingcourse'] = 'Erreur lors du téléchargement du cours.';
$string['mm.course.errordownloadingsection'] = 'Erreur lors du téléchargement de la section.';
$string['mm.course.errorgetmodule'] = 'Erreur lors de l\'obtention des données du module.';
$string['mm.course.gotothesite'] = 'Aller sur la plateforme';
$string['mm.course.nocontentavailable'] = 'Aucun contenu disponible actuellement.';
$string['mm.courses.cannotretrievemorecategories'] = 'Les catégories de niveau plus grand que {{$a}} ne peuvent pas être chargées.';
$string['mm.courses.confirmselfenrol'] = 'Voulez-vous vraiment vous inscrire dans ce cours ?';
$string['mm.courses.downloadcourses'] = 'Télécharger les cours';
$string['mm.courses.enrolme'] = 'M\'inscrire';
$string['mm.courses.errorloadcategories'] = 'Une erreur est survenue lors du chargement des catégories.';
$string['mm.courses.errorloadcourses'] = 'Une erreur est survenue lors du chargement des cours.';
$string['mm.courses.errorsearching'] = 'Une erreur est survenue durant la recherche.';
$string['mm.courses.errorselfenrol'] = 'Une erreur est survenue durant l\'auto-inscription.';
$string['mm.courses.filtermycourses'] = 'Filtrer mes cours';
$string['mm.courses.frontpage'] = 'Page d\'accueil';
$string['mm.course.showall'] = 'Tout afficher';
$string['mm.courses.nocourses'] = 'Aucune information de cours à afficher';
$string['mm.courses.notenrollable'] = 'Vous ne pouvez pas vous inscrire vous-même à ce cours.';
$string['mm.courses.password'] = 'Clef d\'inscription';
$string['mm.courses.searchcoursesadvice'] = 'Veuillez utiliser le bouton de recherche de cours pour accéder anonymement à des cours ou vous inscrire vous-même à des cours qui le permettent.';
$string['mm.courses.selfenrolment'] = 'Auto-inscription';
$string['mm.courses.totalcoursesearchresults'] = 'Nombre de cours : {{$a}}';
$string['mm.course.useactivityonbrowser'] = 'Vous pouvez continuer à l\'utiliser avec le navigateur de votre appareil.';
$string['mm.course.whoops'] = 'Oups !';
$string['mm.fileuploader.addfiletext'] = 'Ajouter le fichier';
$string['mm.fileuploader.audio'] = 'Audio';
$string['mm.fileuploader.camera'] = 'Caméra';
$string['mm.fileuploader.confirmuploadfile'] = 'Vous allez déposer {{size}}. Voulez-vous vraiment continuer ?';
$string['mm.fileuploader.confirmuploadunknownsize'] = 'Impossible de calculer la taille du fichier à dépasser. Voulez-vous malgré tout continuer ?';
$string['mm.fileuploader.errorcapturingaudio'] = 'Erreur lors de l\'enregistrement audio.';
$string['mm.fileuploader.errorcapturingimage'] = 'Erreur lors de la capture de l\'image.';
$string['mm.fileuploader.errorcapturingvideo'] = 'Erreur lors de la capture vidéo.';
$string['mm.fileuploader.errorgettingimagealbum'] = 'Erreur lors de la récupération de l\'image de l\'album.';
$string['mm.fileuploader.errormustbeonlinetoupload'] = 'Vous devez être en ligne pour déposer des fichiers.';
$string['mm.fileuploader.errornoapp'] = 'Vous n\'avez pas d\'app installée pour effectuer cette action.';
$string['mm.fileuploader.errorreadingfile'] = 'Erreur de lecture du fichier.';
$string['mm.fileuploader.errorwhileuploading'] = 'Une erreur est survenue lors du dépôt du fichier.';
$string['mm.fileuploader.file'] = 'Fichier';
$string['mm.fileuploader.filesofthesetypes'] = 'Types de fichier acceptés :';
$string['mm.fileuploader.fileuploaded'] = 'Le fichier a été déposé.';
$string['mm.fileuploader.maxbytesfile'] = 'Le fichier {{$a.file}} est trop gros. La taille maximale permise est de {{$a.size}}.';
$string['mm.fileuploader.photoalbums'] = 'Albums photos';
$string['mm.fileuploader.readingfile'] = 'Lecture du fichier';
$string['mm.fileuploader.selectafile'] = 'Choisir un fichier';
$string['mm.fileuploader.uploadafile'] = 'Déposer un fichier';
$string['mm.fileuploader.uploading'] = 'Envoi';
$string['mm.fileuploader.uploadingperc'] = 'Dépôt en cours : {{$a}} %';
$string['mm.fileuploader.video'] = 'Vidéo';
$string['mm.login.auth_email'] = 'Auto-enregistrement par courriel';
$string['mm.login.authenticating'] = 'Authentification';
$string['mm.login.cannotdownloadfiles'] = 'Le téléchargement des fichiers est désactivé sur votre Moodle et l\'app ne peut pas fonctionner si ce réglage est désactivé. Veuillez contacter l\'administrateur de la plateforme.';
$string['mm.login.checksiteversion'] = 'Veuillez vérifier que votre site utilise Moodle 2.4 ou une version ultérieure.';
$string['mm.login.confirmdeletesite'] = 'Voulez-vous vraiment supprimer la plateforme {{sitename}} ?';
$string['mm.login.connect'] = 'Connecter !';
$string['mm.login.connecttomoodle'] = 'Connexion à Moodle';
$string['mm.login.contactyouradministrator'] = 'Veuillez contacter l\'administrateur de la plateforme pour plus d\'aide.';
$string['mm.login.contactyouradministratorissue'] = 'Veuillez demander à l\'administrateur de la plateforme de vérifier l\'élément suivant : {{$a}}';
$string['mm.login.credentials'] = 'Données de connexion';
$string['mm.login.credentialsdescription'] = 'Veuillez fournir votre nom d\'utilisateur et votre mot de passe pour vous connecter.';
$string['mm.login.emailconfirmsent'] = '<p>Un message vous a été envoyé par courriel à l\'adresse <b>{{$a}}</b></p><p>Il contient des instructions vous permettant de terminer votre enregistrement.</p><p>En cas de difficulté, veuillez contacter l\'administrateur de la plateforme.</p>';
$string['mm.login.emailnotmatch'] = 'Les adresses de courriel ne correspondent pas';
$string['mm.login.erroraccesscontrolalloworigin'] = 'La tentative d\'appel « Cross-Origin » que vous avez effectuée a été rejetée. Veuillez consulter https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['mm.login.errordeletesite'] = 'Une erreur est survenue lors de la suppression de la plateforme. Veuillez essayer plus tard.';
$string['mm.login.errorupdatesite'] = 'Une erreur est survenue lors de la mise à jour du jeton du site.';
$string['mm.login.helpmelogin'] = '<p>Il existe plusieurs milliers de sites Moodle dans le monde. Cette app vous permet de vous connecter aux sites Moodle qui ont explicitement activé l\'accès via l\'app mobile.</p><p>Si vous ne pouvez pas vous connecter à votre site Moodle, veuillez contacter son administrateur local et lui demander de lire <a href="http://docs.moodle.org/en/Mobile_app" target="_blank">http://docs.moodle.org/en/Mobile_app</a></p><p>Pour tester l\'app dans une plateforme Moodle de démonstration, tapez <i>teacher</i> ou <i>student</i> dans le champ <i>Adresse du site</i> et tapoter le <b>bouton de connexion</b>.</p>';
$string['mm.login.invalidaccount'] = 'Veuillez vérifier vos données de connexion ou demander à l\'administrateur de votre site de vérifier sa configuration.';
$string['mm.login.invaliddate'] = 'Date non valide';
$string['mm.login.invalidmoodleversion'] = 'Version de Moodle non valide. La version minimale requise est 2.4.';
$string['mm.login.invalidsite'] = 'Cette URL n\'est pas valide.';
$string['mm.login.invalidtime'] = 'Temps non valide';
$string['mm.login.invalidvaluemax'] = 'La valeur maximale est {{$a}}';
$string['mm.login.invalidvaluemin'] = 'La valeur minimale est {{$a}}';
$string['mm.login.localmobileunexpectedresponse'] = 'La vérification des fonctionnalités additionnelles de Moodle Mobile a envoyé une réponse inattendue. Vous allez être connecté au moyen du service mobile standard.';
$string['mm.login.loggedoutssodescription'] = 'Veuillez vous ré-authentifier en vous connectant au site au moyen d\'un navigateur web.';
$string['mm.login.loginbutton'] = 'Se connecter';
$string['mm.login.logininsiterequired'] = 'Vous devez vous connecter au moyen d\'un navigateur.';
$string['mm.login.mobileservicesnotenabled'] = 'Les Services Moodle ne sont pas activés sur votre site. Veuillez contacter l\'administrateur de votre site si vous pensez qu\'ils devraient être activés.';
$string['mm.login.newsitedescription'] = 'Veuillez saisir l\'URL de votre plateforme Moodle. Notez qu\'elle peut ne pas être configurée pour fonctionner avec cette app.';
$string['mm.login.notloggedin'] = 'Vous devez être connecté.';
$string['mm.login.passwordrequired'] = 'Mot de passe requis';
$string['mm.login.problemconnectingerror'] = 'Impossible de se connecter à';
$string['mm.login.problemconnectingerrorcontinue'] = 'Veuillez vérifier l\'adresse indiquée et essayer à nouveau.';
$string['mm.login.profileinvaliddata'] = 'Valeur non valide';
$string['mm.login.recaptchachallengeimage'] = 'Image reCAPTCHA';
$string['mm.login.reconnect'] = 'Reconnecter';
$string['mm.login.reconnectdescription'] = 'Votre jeton d\'authentification est non valide ou échu. Veuillez vous reconnecter à la plateforme.';
$string['mm.login.reconnectssodescription'] = 'Votre jeton d\'authentification est non valide ou échu. Veuillez vous reconnecter à la plateforme, en vous connectant dans un navigateur.';
$string['mm.login.searchby'] = 'Rechercher par :';
$string['mm.login.selectsite'] = 'Veuillez sélectionner votre site :';
$string['mm.login.signupplugindisabled'] = '{{$a}} n\'est pas activée.';
$string['mm.login.siteaddress'] = 'Adresse de la plateforme';
$string['mm.login.siteinmaintenance'] = 'Votre site est en mode de maintenance';
$string['mm.login.sitepolicynotagreederror'] = 'Règlement du site pas accepté.';
$string['mm.login.siteurl'] = 'URL du site';
$string['mm.login.siteurlrequired'] = 'URL du site requis, p. ex. <i>http://www.votre_moodle.fr</i> ou <i>https://www.votre_moodle.fr</i>';
$string['mm.login.stillcantconnect'] = 'Toujours impossible de se connecter ?';
$string['mm.login.usernamerequired'] = 'Nom d\'utilisateur requis';
$string['mm.login.visitchangepassword'] = 'Voulez-vous vraiment visiter le site pour modifier votre mot de passe ?';
$string['mm.login.webservicesnotenabled'] = 'Les Services web ne sont pas activés sur votre site. Veuillez contacter l\'administrateur de votre site si vous pensez qu\'ils devraient être activés.';
$string['mm.question.errorattachmentsnotsupported'] = 'L\'application ne permet pas encore d\'annexer des fichiers aux réponses.';
$string['mm.question.errorinlinefilesnotsupported'] = 'L\'app ne permet pas encore la modification de fichiers en ligne.';
$string['mm.question.errorquestionnotsupported'] = 'Ce type de question n\'est pas supporté par l\'app : {{$a}}.';
$string['mm.question.howtodraganddrop'] = 'Tapoter pour sélectionner, puis tapoter pour déposer.';
$string['mm.question.questionmessage'] = 'Question {{$a}} : {{$b}}';
$string['mm.question.unknown'] = 'Impossible de déterminer l\'état';
$string['mm.settings.about'] = 'À propos';
$string['mm.settings.appname'] = 'Moodle Mobile {{version}}';
$string['mm.settings.appready'] = 'Prêt pour l\'app';
$string['mm.settings.cacheexpirationtime'] = 'Durée d\'échéance du cache (ms)';
$string['mm.settings.cannotsyncoffline'] = 'Impossible de synchroniser hors connexion.';
$string['mm.settings.cannotsyncwithoutwifi'] = 'Impossible de synchroniser car les réglages ne permettent la synchronisation que lorsque une connexion Wi-Fi est établie. Veuillez vous connecter à un réseau Wi-Fi.';
$string['mm.settings.configuringnotifications'] = 'Vous configurez les notifications « {{$a}} ».';
$string['mm.settings.cordovadevicemodel'] = 'Modèle Cordova Device';
$string['mm.settings.cordovadeviceosversion'] = 'Version OS Cordova Device';
$string['mm.settings.cordovadeviceplatform'] = 'Plateforme Cordova Device';
$string['mm.settings.cordovadeviceuuid'] = 'UUID Cordova Device';
$string['mm.settings.cordovaversion'] = 'Version Cordova';
$string['mm.settings.credits'] = 'Remerciements';
$string['mm.settings.deletesitefiles'] = 'Voulez-vous vraiment supprimer les fichiers téléchargés depuis le site « {{sitename}} » ?';
$string['mm.settings.deletesitefilestitle'] = 'Supprimer les fichiers du site';
$string['mm.settings.development'] = 'Développement';
$string['mm.settings.deviceinfo'] = 'Info sur l\'appareil';
$string['mm.settings.deviceos'] = 'Système d\'exploitation de l\'appareil';
$string['mm.settings.devicewebworkers'] = 'Web workers supportés';
$string['mm.settings.displayformat'] = 'Format d\'affichage';
$string['mm.settings.enabledebugging'] = 'Activer le débogage';
$string['mm.settings.enabledownloadsection'] = 'Activer le téléchargement des sections';
$string['mm.settings.enabledownloadsectiondescription'] = 'La désactivation de cette option accélère le chargement des sections de cours.';
$string['mm.settings.enablerichtexteditor'] = 'Activer l\'éditeur WYSIWYG';
$string['mm.settings.enablerichtexteditordescription'] = 'Si ce réglage est activé, un éditeur WYSIWYG sera affiché aux emplacements permis.';
$string['mm.settings.enablesyncwifi'] = 'Ne permettre la synchronisation que sur Wi-Fi';
$string['mm.settings.errordeletesitefiles'] = 'Erreur lors de la suppression des fichiers du site.';
$string['mm.settings.errorsyncsite'] = 'Erreur de synchronisation des données. Veuillez vérifier votre connexion internet et essayer plus tard.';
$string['mm.settings.estimatedfreespace'] = 'Espace libre estimé';
$string['mm.settings.filesystemroot'] = 'Racine du système de fichiers';
$string['mm.settings.localnotifavailable'] = 'Notifications locales disponibles';
$string['mm.settings.locationhref'] = 'URL webview';
$string['mm.settings.navigatorlanguage'] = 'Langue du navigateur';
$string['mm.settings.navigatoruseragent'] = 'UserAgent du navigateur';
$string['mm.settings.networkstatus'] = 'Statut de la connexion internet';
$string['mm.settings.privacypolicy'] = 'Politique de confidentialité';
$string['mm.settings.reportinbackground'] = 'Annoncer les erreurs automatiquement';
$string['mm.settings.spaceusage'] = 'Espace utilisé';
$string['mm.settings.storagetype'] = 'Type de stockage';
$string['mm.settings.success'] = 'Succès !';
$string['mm.settings.synchronization'] = 'Synchronisation';
$string['mm.settings.synchronizenow'] = 'Synchroniser maintenant';
$string['mm.settings.synchronizing'] = 'Synchronisation en cours';
$string['mm.settings.syncsettings'] = 'Réglages de synchronisation';
$string['mm.settings.syncsitesuccess'] = 'Données du site synchronisées et tous les caches vidés.';
$string['mm.settings.versioncode'] = 'Code de version';
$string['mm.settings.versionname'] = 'Nom de version';
$string['mm.settings.wificonnection'] = 'Connexion WiFi';
$string['mm.sharedfiles.chooseaccountstorefile'] = 'Veuillez choisir un compte dans lequel enregistrer le fichier.';
$string['mm.sharedfiles.chooseactionrepeatedfile'] = 'Un fichier de ce nom existe déjà. Voulez-vous remplacer le fichier existant ou le renommer en « {{$a}} » ?';
$string['mm.sharedfiles.errorreceivefilenosites'] = 'Aucun site n\'est enregistré. Veuillez ajouter un site avant de partager un fichier avec l\'app.';
$string['mm.sharedfiles.nosharedfiles'] = 'Il n\'y a pas de fichier partagé sur ce site.';
$string['mm.sharedfiles.nosharedfilestoupload'] = 'Il n\'y a pas de fichier à déposer ici. Si vous voulez déposer un fichier à partir d\'une autre app, localiser le fichier et tapoter « Ouvrir dans ».';
$string['mm.sharedfiles.rename'] = 'Renommer';
$string['mm.sharedfiles.replace'] = 'Remplacer';
$string['mm.sharedfiles.sharedfiles'] = 'Fichiers partagés';
$string['mm.sharedfiles.successstorefile'] = 'Fichier enregistré. Vous pouvez maintenant le sélectionner pour le déposer dans vos fichiers privés ou le joindre à des activités.';
$string['mm.sidemenu.appsettings'] = 'Réglages de l\'app';
$string['mm.sidemenu.changesite'] = 'Changer de plateforme';
$string['mm.sidemenu.help'] = 'Aide';
$string['mm.sidemenu.logout'] = 'Déconnexion';
$string['mm.sidemenu.mycourses'] = 'Mes cours';
$string['mm.sidemenu.togglemenu'] = 'Menu';
$string['mm.sidemenu.website'] = 'Site web';
$string['mm.user.contact'] = 'Contact';
$string['mm.user.details'] = 'Détails';
$string['mm.user.detailsnotavailable'] = 'Vous n\'avez pas accès aux informations de cet utilisateur.';
$string['mm.user.editingteacher'] = 'Enseignant';
$string['mm.user.invaliduser'] = 'Utilisateur non valide.';
$string['mm.user.manager'] = 'Gestionnaire';
$string['mm.user.sendemail'] = 'Courriel';
$string['mm.user.student'] = 'Étudiant';
$string['mm.user.teacher'] = 'Enseignant non-éditeur';
$string['pluginname'] = 'Chaînes de caractères de Moodle Mobile';
