<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'reservation', language 'fr', branch 'MOODLE_34_STABLE'
 *
 * @package   reservation
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addparticipant'] = 'Ajouter une demande';
$string['after10min'] = '10 minutes à partir du début de l\'événement';
$string['after12h'] = '12 heures à partir du début de l\'évènement';
$string['after1d'] = '1 jour à partir du début de l\'évènement';
$string['after1h'] = '1 heure à partir du début de l\'évènement';
$string['after1w'] = '1 semaine à partir du début de l\'évènement';
$string['after2d'] = '2 jours à partir du début de l\'évènement';
$string['after2h'] = '2 heures à partir du début de l\'évènement';
$string['after2w'] = '2 semaines à partir du début de l\'évènement';
$string['after30min'] = '30 minutes à partir du début de l\'évènement';
$string['after3w'] = '3 semaines à partir du début de l\'évènement';
$string['after4h'] = '4 heures à partir du début de l\'évènement';
$string['after4w'] = '4 semaines à partir du début de l\'évènement';
$string['after5min'] = '5 minutes à partir du début de l\'évènement';
$string['after6h'] = '6 heures à partir du début de l\'évènement';
$string['alreadybooked'] = 'Vous êtes déjà inscrit';
$string['atstart'] = 'Au démarrage de l\'événement';
$string['autohide'] = 'Masquer automatiquement la liste de réservation';
$string['availablerequests'] = 'Places disponibles';
$string['badcourse'] = 'Le cours n\'existe pas';
$string['badsection'] = 'La section n\'existe pas dans le cours "{$a}"';
$string['badteachers'] = 'Le courriel spécifié de l\'enseignant ({$a}) n\'a pas été trouvé';
$string['badteachersmail'] = 'Le courriel spécifié de l\'enseignant ({$a}) est erroné';
$string['badtimeclose'] = 'L\'heure de fermeture est erronée';
$string['badtimeend'] = 'L\'heure de fin est erronée';
$string['badtimeopen'] = 'L\'heure d\'ouverture est erronée';
$string['badtimestart'] = 'L\'heure de début est erronée';
$string['by'] = 'par';
$string['bydate'] = 'Date de l\'évènement';
$string['byname'] = 'Nom';
$string['bysection'] = 'Thème/Semaine';
$string['cancelledon'] = 'Annulé le';
$string['checkclashes'] = 'Vérifier les lieux et horaires conflictuels';
$string['clashesfound'] = 'Des lieux et horaires conflictuels trouvés';
$string['clashesreport'] = 'Rapport de conflits';
$string['cleanview'] = 'Voir seulement les réservations en cours';
$string['close'] = 'Fermer';
$string['closed'] = 'Fermé';
$string['completionreserved'] = 'Les étudiants doivent réserver pour achever cette activité';
$string['config'] = 'Paramètres globaux du module réservation';
$string['configautohide'] = 'Ceci définit si les réservations doivent ne pas apparaitre dans la liste des réservations (mod/reservation/index.php). Ceci peut être utile avec des listes publiques, dans l\'idée d\'afficher une liste correcte.';
$string['configcheckclashes'] = 'Activer le bouton "Vérifier les lieux et horaires conflictuels" sur la page de modification de la réservation';
$string['configconnectto'] = 'Définit où connecter le module de recherche de réservations';
$string['configdownload'] = 'Ceci définit le format de fichier de téléchargement par défaut pour toutes les listes de demandes et de réservations.';
$string['configevents'] = 'Ce paramètre définit les événements qui seront créés pour chaque réservation';
$string['configfields'] = 'Ce paramètre définit quels champs seront indiqués dans le tableau des réservations';
$string['configlocations'] = 'Sur cette page vous pouvez gérer des lieux standard pour les réservations';
$string['configmanualusers'] = 'Ceci définit quelle liste d\'utilisateurs est affichée dans le menu déroulant';
$string['configmaxoverbook'] = 'Ceci définit le pourcentage maximum de surréservation.';
$string['configmaxrequests'] = 'Définit la limite du menu déroulant sur la page de modification de la réservation';
$string['configminduration'] = 'Ceci indique la durée minimum d\'un évènement. Ceci est utilisé avec les évènements sans durée pour vérifier les disponibilités en termes d\'horaires et de places';
$string['confignotifies'] = 'Ce paramètre définit qui notifie';
$string['configoverbookstep'] = 'Ceci définit le pourcentage de granularité de surréservation. Écart plus petit, granularité plus grande';
$string['configpubliclists'] = 'Ceci définit si la liste de réservation est publique (sans authentification) ou non.';
$string['configsortby'] = 'Ceci définit comment les listes de réservations sont triées.';
$string['configsublimits'] = 'Définit le nombre de règles de limites inférieures sur la page de modification d\'une réservation';
$string['confirmdelete'] = 'Êtes-vous certains de vous supprimer les demandes de réservations sélectionnées?';
$string['connectedto'] = 'Réservation connectée à';
$string['connectto'] = 'Réservation connectable de';
$string['description'] = 'Description';
$string['downloadas'] = 'Format de téléchargement par défaut';
$string['duration10h'] = '10 heures';
$string['duration10min'] = '10 minutes';
$string['duration11h'] = '11 heures';
$string['duration12h'] = '12 heures';
$string['duration15min'] = '15 minutes';
$string['duration20min'] = '20 minutes';
$string['duration2h'] = '2 heures';
$string['duration30min'] = '30 minutes';
$string['duration3h'] = '3 heures';
$string['duration45min'] = '45 minutes';
$string['duration4h'] = '4 heures';
$string['duration5h'] = '5 heures';
$string['duration5min'] = '5 minutes';
$string['duration60min'] = '60 minutes';
$string['duration6h'] = '6 heures';
$string['duration7h'] = '7 heures';
$string['duration8h'] = '8 heures';
$string['duration90min'] = '90 minutes';
$string['duration9h'] = '9 heures';
$string['enablenote'] = 'Autoriser les notes des utilisateurs';
$string['equal'] = 'égal à';
$string['err_sublimitsgreater'] = 'La somme des sous-limites est supérieure au maximum des demandes autorisées';
$string['err_timeendlower'] = 'La date de fin de l\'évènement est définie avant la date de début';
$string['err_timeopengreater'] = 'La date de début de la réservation est définie après la date de fin';
$string['eventevent'] = 'Créer un évènement avec une date de début et de fin (l\'évènement)';
$string['eventrequestadded'] = 'Demande de réservation ajoutée';
$string['eventrequestcancelled'] = 'Réservation annulée';
$string['eventrequestdeleted'] = 'Demande de réservation supprimée';
$string['events'] = 'Événements du calendrier';
$string['eventsettings'] = 'Paramètres de l\'évènement';
$string['explainconfig'] = 'Les administrateurs peuvent définir des paramètres généraux pour le module réservation';
$string['fields'] = 'Champs affichés';
$string['fullview'] = 'Voir aussi les réservations supprimées';
$string['gradedmail'] = '{$a->teacher} a fait un commentaire sur votre réservation \'{$a->reservation}\'

Vous pouvez le voir ici :

{$a->url}';
$string['gradedmailhtml'] = '{$a->teacher} a fait un commentaire sur votre réservation \'<i>{$a->reservation}</i>\'<br /><br />
Vous pouvez le voir  <a href="{$a->url}">ici</a>.';
$string['importreservations'] = 'Importer des réservations';
$string['justbooked'] = 'Vous êtes inscrits comme {$a}';
$string['linenumber'] = '#';
$string['location'] = 'Lieu';
$string['locations'] = 'Gérer les lieux';
$string['locationslist'] = 'Liste de lieux';
$string['mail'] = 'La réservation  \'{$a->reservation}\' a été fermée.

Vous pouvez télécharger la liste des réservations à partir d\'ici :

{$a->url}';
$string['mailhtml'] = 'La réservation <em>{$a->reservation}</em> a été fermée. <br /><br /> Vous pouvez télécharger la liste des réservations d\' <a href="{$a->url}">ici</a> .';
$string['mailrequest'] = 'La réservation \'{$a->reservation}\' a été fermée.
Vous pouvez obtenir votre numéro de réservation ici :

{$a->url}';
$string['mailrequesthtml'] = 'La réservation <em>{$a->reservation}</em> a été fermée.<br /><br />
Vous pouvez obtenir votre numéro de réservation  <a href="{$a->url}">ici</a>.';
$string['manage'] = 'Gérer';
$string['manualusers'] = 'Utilisateurs réservés manuellement';
$string['maxoverbook'] = 'Pourcentage maximum de surréservation';
$string['maxrequest'] = 'Réservations maximum';
$string['message'] = 'Message aux participants';
$string['minduration'] = 'Durée minimum de l\'évènement';
$string['modulename'] = 'Réservation';
$string['modulename_help'] = '<p> L\'objectif principal de cette activité est la gestion d\'un calendrier de sessions et d\'examens de laboratoire mais vous pouvez planifier tout ce que vous voulez. </p><p> L\'enseignant peut définir le nombre de places disponibles pour l\'événement, la date de l\'événement, la réservation, date d\'ouverture et de clôture. <br /> Une réservation peut avoir une note ou un barème. <br /> Les étudiants peuvent placer ou annuler une réservation  et ajouter une note sur cette réservation. </p><p> Après le début de l\'événement l\'enseignant peut attribuer une note. Les étudiants seront informés par courriel. </p><p> La liste des réservations peut être téléchargé dans divers formats. </p>';
$string['modulenameplural'] = 'Réservations';
$string['newlocation'] = 'Nouveaux lieux';
$string['noclashes'] = 'Pas de conflits d\'horaires et de lieux trouvés';
$string['nocourseswithnsections'] = 'Pas de cours trouvé avec {$a} sections';
$string['nolimit'] = 'Pas de limite de réservation';
$string['nomorerequest'] = 'Plus de places disponibles';
$string['nooverbook'] = 'Pas de surréservation';
$string['noparent'] = 'Aucun';
$string['noreservations'] = 'Pas de réservation à afficher';
$string['note'] = 'Note';
$string['noteachers'] = 'Pas d\'enseignants disponibles';
$string['notequal'] = 'différent de';
$string['notifies'] = 'Notifications envoyées';
$string['notifygrades'] = 'Informer les étudiants d\'une réservation évaluée';
$string['notifystudents'] = 'Informer les étudiants de la fin de la période de réservation';
$string['notifyteachers'] = 'Informer les enseignants de la fin de la période de réservation';
$string['notopened'] = 'Pas ouvert';
$string['novalues'] = 'Pas disponible pour ce champ';
$string['number'] = 'Numéro de réservation';
$string['otherlocation'] = 'Autre lieu spécifié';
$string['overbook'] = 'Surréservation';
$string['overbookonly'] = 'Seuls les places surréservées sont disponibles';
$string['overbookstep'] = 'Écart de surréservation';
$string['overview'] = 'Vue d\'ensemble';
$string['parent'] = 'Connecter cette réservation avec';
$string['pluginadministration'] = 'Administration de la réservation';
$string['pluginname'] = 'Réservation';
$string['publiclists'] = 'Liste publique de réservations';
$string['requestoverview'] = 'Vue d\'ensemble des demandes';
$string['requests'] = 'Demandes';
$string['reservation:addinstance'] = 'Ajouter une nouvelle réservation';
$string['reservationcancelled'] = 'Réservation annulée';
$string['reservationclosed'] = 'Réservations fermées';
$string['reservationdenied'] = 'Réservations non autorisées';
$string['reservation:downloadrequests'] = 'Peut télécharger la liste des demandes';
$string['reservationevent'] = 'Créer un évènement avec une date de début et de fin (heure de réservation)';
$string['reservation:grade'] = 'Peut attribuer une note';
$string['reservation_listing'] = 'Paramètres de la page d\'index';
$string['reservation:manualdelete'] = 'Peut supprimer les demandes des autres utilisateurs';
$string['reservation:manualreserve'] = 'Peut soumettre des demandes pour d\'autres utilisateurs';
$string['reservationnotopened'] = 'Réservations pas encore ouvertes';
$string['reservation_other'] = 'Autres paramètres';
$string['reservation:reserve'] = 'Peut soumettre ses propres demandes';
$string['reservations'] = 'Réservations';
$string['reservationsettings'] = 'Paramètres des réservations';
$string['reservation_settings'] = 'Modifier les paramètres';
$string['reservation_view'] = 'Voir les paramètres de la page';
$string['reservation:viewnote'] = 'Peut voir les notes des demandes';
$string['reservation:viewrequest'] = 'Peut voir la liste des demandes';
$string['reserve'] = 'Réserver';
$string['reservecancel'] = 'Annuler une réservation';
$string['reserved'] = 'Réservé';
$string['reservedon'] = 'Réservé le';
$string['reservedonconnected'] = 'Vous êtes déjà inscrit sur une réservation connectée : {$a}';
$string['resetreservation'] = 'Supprimer toutes les réservations';
$string['save'] = 'Enregistrer la note';
$string['selectvalue'] = 'Sélectionner une des valeurs disponibles';
$string['showrequest'] = 'Les utilisateurs peuvent voir la liste des demandes';
$string['sortby'] = 'Liste des réservations triée par';
$string['sublimit'] = 'Sous-limite {$a}';
$string['sublimitrules'] = 'Règles de sous-limites';
$string['sublimits'] = 'Sous-limites de réservation';
$string['timeclose'] = 'Fin de la réservation le';
$string['timeend'] = 'Date de fin';
$string['timeopen'] = 'La réservation débute le';
$string['timestart'] = 'Date de début';
$string['upload'] = 'Import de réservations';
$string['upload_help'] = '<p> Les réservations peuvent être téléchargés via un fichier texte. Le format du fichier doit être comme suit: </p><ul><li> Chaque ligne du fichier contient un enregistrement </li><li> Chaque enregistrement est une série de données séparées par des virgules (ou d\'autres délimiteurs) </li><li> Le premier enregistrement contient une liste de noms de champs définissant le format du reste du fichier </li><li>  Les champs requis sont article, nom et timestart </li><li> Les champs facultatifs sont course, intro, enseignants, timeend, maxgrade, timeopen, timeclose, maxrequest </li><li> Si le cours n\'est pas spécifié, il doit être choisi après l\'aperçu </li></ul>';
$string['uploadreservations'] = 'Importer des réservations';
$string['uploadreservationspreview'] = 'Aperçu de l\'import des réservations';
$string['uploadreservationsresult'] = 'Résultat de l\'import des réservations';
$string['with'] = 'avec';
$string['withselected'] = 'avec sélectionné...';
$string['yourgrade'] = 'Votre note pour cette réservation est : {$a->grade}/${a->maxgrade}';
$string['yourscale'] = 'Votre note pour cette réservation est : {$a}';
