<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'search_elastic', language 'fr', branch 'MOODLE_34_STABLE'
 *
 * @package   search_elastic
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addfail'] = 'Échec d\'ajout du document à l\'index.';
$string['fileindexing'] = 'Activer l\'indexation de fichiers';
$string['fileindexing_help'] = 'Active l\'indexation de fichiers pour cette extension. En activant cette option, vous devrez fournir des précisions sur le service Tika dans le champ «Paramètres d\'indexation de fichiers» ci-dessous.<br /> Pour que les nouveaux fichiers soient ajoutés à l\'index, il faudra réindexer tout le contenu du site.';
$string['fileindexsettings'] = 'Paramètres d\'indexation de fichiers';
$string['fileindexsettings_desc'] = 'Ajouter les précisions pour le service Tika. Ces renseignements sont requis si l\'indexation de fichiers (ci-dessus) est activée.';
$string['hostname'] = 'Nom du serveur';
$string['hostname_desc'] = 'Nom de domaine du moteur de recherche Elastic';
$string['imageindex'] = 'Activer l\'indexation d\'image';
$string['imageindex_desc'] = 'Lorsque ce paramètre est activé, Moodle utilise AWS Rekognition pour indexer les images. L\'indexation de fichiers doit également être activé pour que l\'indexation d\'images soit opérante.';
$string['index'] = 'Index';
$string['index_desc'] = 'Espace de nom (namespace) pour sauvegarder les données de recherche.';
$string['indexfail'] = 'Échec à la création de l\'index';
$string['maxlabels'] = 'Nombre maximal de résultats de recherche';
$string['maxlabels_desc'] = 'Le nombre maximal de résultats de recherche rendus par Rekognition';
$string['minconfidence'] = 'Confiance minimale';
$string['minconfidence_desc'] = 'Reckognition proposera des résultats qui sont au-dessus du minimum fixé.';
$string['noconfig'] = 'La configuration de Elasticsearch est manquante.';
$string['noserver'] = 'Le serveur Elasticsearch est inaccessible';
$string['pluginname'] = 'Elastic';
$string['pluginname_desc'] = 'Nom du serveur Elasticsearch';
$string['port'] = 'Port';
$string['port_desc'] = 'Port utilisé pour accéder au serveur Elasticsearch';
$string['region'] = 'Région';
$string['region_desc'] = 'La région AWS dans laquelle se situe cette instance d\'ElasticSearch.';
$string['rekognitionsettings'] = 'Réglages d\'AWS Rekognition';
$string['rekognitionsettings_desc'] = 'Réglages pour configurer la reconnaissance et l\'indexation d\'images en utilisation le service AWS Rekognition.';
$string['rekregion'] = 'Région';
$string['rekregion_desc'] = 'La région AWS dans laquelle se situe ce service Rekognition';
$string['reksigningkeyid'] = 'Clé ID';
$string['reksigningkeyid_desc'] = 'L\'ID de la clé utilisée pour accéder à Rekcognition.';
$string['reksigningsecretkey'] = 'Clé secrète';
$string['reksigningsecretkey_desc'] = 'La clé secrète utilisée pour accéder à Rekcognition';
$string['searchinfo'] = 'Requête de recherche';
$string['searchinfo_help'] = 'Le champ à être recherché peut être précisé en ajoutant au début de la requête «title:», «content:», «name:» ou «intro:». Par exemple, la recherche de «title:nouvelles» présentera des résultats d\'éléments ayant nouvelles dans leur titre.
Les opérateurs booléens (AND et OR) peuvent être utilisés pour combiner certains mots clés de recherche.

Il est également possible d\'utiliser des jokers (* ou ?) dans les recherches.';
$string['sendsize'] = 'Taille de la requête';
$string['sendsize_desc'] = 'Certains fournisseurs ElasticSearch comme AWS impose une limite sur la taille de la requête HTTP. Ca paramètre permet d\'ajuster la taille maximale en octets de la requête.';
$string['signing'] = 'Active la signature de requête';
$string['signing_desc'] = 'Lorsque ce paramètre est activé, Moodle signera chaque requête ElasticSearch avec les informations d\'authentification ci-dessous.';
$string['signingkeyid'] = 'Clé ID';
$string['signingkeyid_desc'] = 'La clé ID utilisée pour signer les requêtes';
$string['signingsecretkey'] = 'Clé secrète';
$string['signingsecretkey_desc'] = 'Clé secrète utilisée pour les requêtes';
$string['signingsettings'] = 'Paramètres de signature des requêtes';
$string['signingsettings_desc'] = 'Si votre configuration ElasticSearch requiert des requêtes signées, voous pourrez l\'ajuster ci-dessous.

Cette situation s\'applique généralement si vous utilisez les services AWS pour votre besoin ElasticSearch.';
$string['tikahostname'] = 'Nom du serveuur Tika';
$string['tikahostname_desc'] = 'Nom de domaine du serveur Apache Tika';
$string['tikaport'] = 'Port Tika';
$string['tikaport_desc'] = 'Port du serveur Apache Tika';
$string['tikasendsize'] = 'Taille maximale du fichier';
$string['tikasendsize_desc'] = 'L\'envoi de fichiers volumineux vers Tika peut occasionner des problèmes de ressources mémoire. Les fichiers sont ainsi limités en taille.';
