<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'studentquiz', language 'fr', branch 'MOODLE_34_STABLE'
 *
 * @package   studentquiz
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['approve'] = 'Des-/Attester';
$string['approved'] = '✓';
$string['approved_column_name'] = 'Attesté';
$string['approveselectedscheck'] = 'Voulez-vous vraiment desattester les questions suivantes?<br /><br />{$a}';
$string['comment_column_name'] = 'Commentaires';
$string['createnewquestion'] = 'Créer une nouvelle question';
$string['createnewquestionfirst'] = 'Créer une première question';
$string['creator_anonym_firstname'] = 'anonyme';
$string['creator_anonym_lastname'] = 'anonyme';
$string['difficulty_level_column_name'] = 'Difficulté';
$string['emailapprovedbody'] = 'Dear {$a->studentname},

Cet e-mail vous informe que votre question \'{$a->questionname}\'
dans le cours \'{$a->coursename}\' a été attesté par un enseignant.

Vous pouvez examiner cette question à: {$a->questionurl}.';
$string['emailapprovedsmall'] = 'Votre question \'{$a->questionname}\' a été attesté par un enseignant.';
$string['emailapprovedsubject'] = 'Question attesté: {$a->questionname}';
$string['emailunapprovedbody'] = 'Dear {$a->studentname},

Cet e-mail vous informe que votre question \'{$a->questionname}\'
dans le cours \'{$a->coursename}\' a été deattesté par un enseignant.

Vous pouvez examiner cette question à: {$a->questionurl}.';
$string['emailunapprovedsmall'] = 'Votre question \'{$a->questionname}\' a été deattesté par un enseignant.';
$string['emailunapprovedsubject'] = 'Question deattesté: {$a->questionname}';
$string['filter'] = 'Filtre';
$string['filter_ishigher'] = 'est plus élevé';
$string['filter_islower'] = 'Est plus bas';
$string['filter_label_approved'] = 'Questions attesté';
$string['filter_label_comment'] = 'Commentaires';
$string['filter_label_createdate'] = 'Création';
$string['filter_label_difficulty_level'] = 'Difficulté';
$string['filter_label_firstname'] = 'Prénom';
$string['filter_label_practice'] = 'Tentatives';
$string['filter_label_question'] = 'Titre de question';
$string['filter_label_questiontext'] = 'Contenu de la question';
$string['filter_label_show_mine'] = 'Mes questions';
$string['filter_label_surname'] = 'Nom de famille';
$string['filter_label_tags'] = 'Étiquette';
$string['messageprovider:approved'] = 'Notification de attesté de question';
$string['messageprovider:unapproved'] = 'Notification de deattesté de question';
$string['modulename'] = 'StudentQuiz';
$string['modulename_help'] = 'L\'activité StudentQuiz permet aux élèves d\'ajouter des questions à la foule. Dans l\'aperçu du StudentQuiz, les élèves peuvent filtrer les questions. Ils peuvent également utiliser les questions filtrées dans la foule pour pratiquer. L\'enseignant a une option pour anonymiser les créateurs des questions. <br> <br> L\'activité StudentQuiz récompense les élèves avec des points pour les motiver à ajouter et à pratiquer. Les Points sont listés dans un classement. <br> <br> Pour plus d\'informations, lisez le <a href = "https://github.com/frankkoch/moodle-mod_studentquiz/blob/master/manuals/User-Manual.pdf "> Manuel d\'utilisateur </a>.';
$string['modulenameplural'] = 'StudentQuizzes';
$string['nav_export'] = 'Export';
$string['nav_import'] = 'Import';
$string['no_comment'] = 'pas de commentaires';
$string['no_difficulty_level'] = 'pas de difficulté';
$string['no_practice'] = 'pas de tentative';
$string['no_tags'] = 'pas de tags';
$string['not_approved'] = '✗';
$string['pluginadministration'] = 'Administration StudentQuiz';
$string['pluginname'] = 'StudentQuiz';
$string['practice_column_name'] = 'Tenues';
$string['questionsinuse'] = '(* Les questions marquées d\'un astérisque sont déjà utilisées dans certains quiz.)';
$string['rankingsettingsheader'] = 'Réglage des Rangs';
$string['reportquiz_admin_title'] = 'Statistique d\'utilisateur';
$string['reportquiz_stats_title'] = 'Statistiques';
$string['reportquiz_total_attempt'] = 'Nombre de tentatives';
$string['reportquiz_total_obtained_marks'] = 'Note reçu';
$string['reportquiz_total_questions_answered'] = 'Questions Répondu';
$string['reportquiz_total_questions_right'] = 'Réponses correctes';
$string['reportquiz_total_questions_wrong'] = 'Réponses fausses';
$string['reportquiz_total_users'] = 'Nombre de participants';
$string['reportrank_table_column_fullname'] = 'Nom';
$string['reportrank_table_column_points'] = 'Points';
$string['reportrank_table_column_rank'] = 'Rang';
$string['reportrank_table_title'] = '- Classement';
$string['reportrank_title'] = 'Classement des étudiants';
$string['start_quiz_button'] = 'Démarrer le quiz';
$string['studentquiz'] = 'studentquiz';
$string['studentquiz:addinstance'] = 'Ajouter une nouvelle instance';
$string['studentquiz:emailnotifyapproved'] = 'Notification de attesté de question';
$string['studentquizname'] = 'Nom StudentQuiz';
$string['studentquizname_help'] = 'Nom StudentQuiz';
$string['studentquiz:submit'] = 'Envoyer sur StudentQuiz';
$string['studentquiz:view'] = 'Voir StudentQuiz';
