<?php

include "mysql.php";

function writeligne($ligne) {
    echo $ligne."\n";
}

function writeredligne($ligne) {
    echo "\e[31m".$ligne."\e[0m\n";
}

function finduser($username) {
    global $bddnin;
    
    $q="SELECT * FROM user WHERE username=?";
    $query=$bddnin->prepare($q);
    $query->execute([$username]);
    if($row=$query->fetch()) return $row["id"];
    else false;
}

function findgroup($groupname) {
    global $bddnin;
    
    switch($groupname) {
        case "eleves" : $groupname = "PROFIL - Elèves"; break;
        case "administratifs" : $groupname = "PROFIL - Administratifs"; break;
        case "professeurs" : $groupname = "PROFIL - Enseignants"; break;
        default: $groupname = "% - ".$groupname;
    }
    $q="SELECT * FROM groupe WHERE label LIKE ?";
    $query=$bddnin->prepare($q);
    $query->execute([$groupname]);
    if($row=$query->fetch()) {
        writeligne($row["id"]." - ".$row["name"]);
        return $row["id"];
    }
    else false;
}

function findether($ether,$id,$userid) {
    global $bddnin;
    
    switch($ether) {
        case "etherpad"  : $q="SELECT * FROM etherpad  WHERE name=?"; break;
        case "ethercalc" : $q="SELECT * FROM ethercalc WHERE name=?"; break;
    }
    $query=$bddnin->prepare($q);
    $query->execute([$id]);
    if($row=$query->fetch()) {
        $id=$row["id"];

        if($userid) {
            switch($ether) {
                case "etherpad"  : $q="UPDATE etherpad  SET user_id=? WHERE id=?"; break;
                case "ethercalc" : $q="UPDATE ethercalc SET user_id=? WHERE id=?"; break;
            }
            $query=$bddnin->prepare($q);
            $query->execute([$userid,$id]);
        }

        return $id;
    }
    else false;
}

function shareether($ether,$share,$etherid,$shareid) {
    global $bddnin;

    switch($ether) {
        case "etherpad" : 
            switch($share) {
                case "user"  : $q="SELECT * FROM etherpaduser   WHERE etherpad=? and user=?"; break;
                case "group" : $q="SELECT * FROM etherpadgroupe WHERE etherpad=? and groupe=?"; break;
            }
        break;

        case "ethercalc" : 
            switch($share) {
                case "user"  : $q="SELECT * FROM ethercalcuser   WHERE ethercalc=? and user=?"; break;
                case "group" : $q="SELECT * FROM ethercalcgroupe WHERE ethercalc=? and groupe=?"; break;
            }
        break;
    }
    $query=$bddnin->prepare($q);
    $query->execute([$etherid,$shareid]);
    if(!$query->fetch()) {
        switch($ether) {
            case "etherpad" : 
                switch($share) {
                    case "user"  : $q="INSERT IGNORE INTO etherpaduser   (etherpad, user)   VALUES (?,?)"; break;
                    case "group" : $q="INSERT IGNORE INTO etherpadgroupe (etherpad, groupe) VALUES (?,?)"; break;
                }
            break;
    
            case "ethercalc" : 
                switch($share) {
                    case "user"  : $q="INSERT IGNORE INTO ethercalcuser   (ethercalc, user)   VALUES (?,?)"; break;
                    case "group" : $q="INSERT IGNORE INTO ethercalcgroupe (ethercalc, groupe) VALUES (?,?)"; break;
                }
            break;
        }

        $query=$bddnin->prepare($q);
        $query->execute([$etherid,$shareid]);        
    }
}

// Test de la connexion à la base etherhome
try{
    global $bddeth;
    $pdo_options[PDO::ATTR_ERRMODE] = PDO::ERRMODE_EXCEPTION;
    $pdo_options[PDO::MYSQL_ATTR_INIT_COMMAND] = "SET NAMES utf8";
    $bddeth = new PDO("mysql:host=".$dbhost.";dbname=etherhome",$dblogin,$dbpassword,$pdo_options);
}
catch (Exception $e){
    writeredligne("Erreur connexion bdd etherhome");
    die();
}

// Test de la connexion à la base nineboard
try{
    global $bddnin;
    $pdo_options[PDO::ATTR_ERRMODE] = PDO::ERRMODE_EXCEPTION;
    $pdo_options[PDO::MYSQL_ATTR_INIT_COMMAND] = "SET NAMES utf8";
    $bddnin = new PDO("mysql:host=".$dbhost.";dbname=nineboard",$dblogin,$dbpassword,$pdo_options);
}
catch (Exception $e){
    writeredligne("Erreur connexion bdd nineboard");
    die();
}

// Rattachement propriétaire
writeligne("");
writeligne("== RATTACHEMENT PROPRIETAIRE");
$q="SELECT * FROM elements where appli!=?";
$queryeth=$bddeth->prepare($q);
$queryeth->execute(["scrumblr"]);
while($row=$queryeth->fetch()) {
    $userid=finduser($row["uid"]);
    if(!$userid) {
        writeredligne("Utilisateur ".$row["uid"]." inconnu : impossible de rattacher sur l'ether ".$row["nom"]);
        continue;
    }

    $etherid=findether($row["appli"],$row["nom"],$userid);
    if(!$etherid) {
        // Pas d'erreur si le pas/calc n'est pas nineboard c'est qu'il n'existe pas vraiment dans les ether
        continue;
    }
}

// Rattachement partage
writeligne("");
writeligne("== RATTACHEMENT PARTAGE");
$q="SELECT * FROM shares where appli!=?";
$queryeth=$bddeth->prepare($q);
$queryeth->execute(["scrumblr"]);
while($row=$queryeth->fetch()) {
    $tmp=explode("/",$row["url"]);
    $ethername=end($tmp);
    $etherid=findether($row["appli"],$ethername,null);

    if($etherid) {
        // si partage de type utilisateur
        if($row["shareType"]==0) {
            $userid=finduser($row["shareWith"]);
            if(!$userid) {
                writeredligne("Utilisateur ".$row["shareWith"]." inconnu : impossible de rattacher son partage ".$ethername);
                continue;
            }            

            shareether($row["appli"],"user",$etherid,$userid);
        }
        
        // si partage de type groupe
        else {
            $groupid=findgroup($row["shareWith"]);
            if(!$groupid) {
                writeredligne("Groupe ".$row["shareWith"]." inconnu : impossible de rattacher son partage ".$ethername);
                continue;
            }            

            shareether($row["appli"],"group",$etherid,$groupid);
        }
    }
}

?>