#!/bin/bash

# Récuper les composer associés à la version de php installé
version72=`php -r 'echo version_compare(phpversion(), "7.2.0", ">=");'`
if [[ "$version72" == "1" ]]
then
    cp -rf /var/www/html/nineboard/scripts/php72/composer.json /var/www/html/nineboard/composer.json
    cp -rf /var/www/html/nineboard/scripts/php72/composer.lock /var/www/html/nineboard/composer.lock
else
    version70=`php -r 'echo version_compare(phpversion(), "7.0.0", ">=");'`
    if [[ "$version70" == "1" ]]
    then
        cp -rf /var/www/html/nineboard/scripts/php70/composer.json /var/www/html/nineboard/composer.json
        cp -rf /var/www/html/nineboard/scripts/php70/composer.lock /var/www/html/nineboard/composer.lock
    fi
fi

# Suppression des logs trop ancien
find var/logs -mindepth 1 -mtime +7 -delete

# Installation des dépendances composer
echo COMPOSER = Install
composer install --quiet

# Permissions
./perm.sh www-data

# Nettoyage du cache
echo 
echo CACHE = Refresh
rm /var/www/html/nineboard/var/cache/* -rf > /dev/null
php bin/console cache:clear --env=prod --no-debug --quiet

# Migration si nécessaire du schéma de la base
php bin/console doctrine:schema:update --force --env=prod --no-debug --quiet

# Insertion data de base
php bin/console Core:InitData --env=prod
php bin/console Cron:InitData --env=prod

# Passage des scripts
php bin/console Core:Script --env=prod

# Generation des assets
echo ASSET = Dump
bin/console assetic:dump --env=prod  --quiet


# Copie des polices du projet dans le rep web
cp -rf src/Cadoles/CoreBundle/Resources/public/fonts web/

# Permissions
./perm.sh www-data

# Server Websocket
echo
/var/www/html/nineboard/scripts/nineboard-websocket.sh

echo