#!/bin/bash

websocket_url=$(CreoleGet adresse_ip_eth0 non) 
websocket_portinterne=$(CreoleGet nineboard_websocket_portinterne non) 

# Server Websocket
if [[ "$1" != "restartifdown" ]]; then
    echo WEBSOCKET = STOP
    pid="$(pgrep -a -f gos:websocket | grep $websocket_portinterne)"
    if [ -n "${pid}" ]; then
        IFS=' ' read -r -a array <<< "$pid"
        kill -9 ${array[0]};
    fi
fi

# Port LISTEN ?
pid="$(pgrep -a -f gos:websocket | grep $websocket_portinterne)"
restart="yes"
if [ "$1" == "restartifdown" ] && [ -n "${pid}" ] ; then
    restart="no"
fi

if [[ "$restart" == "yes" ]]; then
    echo WEBSOCKET = START
    cd /var/www/html/nineboard
    bin/console gos:websocket:server --port $websocket_portinterne -a $websocket_url --no-debug -n -q --env=prod  & disown
fi