<?php

namespace Cadoles\CASBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Security\Core\Authentication\Token\UsernamePasswordToken;
use Symfony\Component\Security\Http\Event\InteractiveLoginEvent;
use Symfony\Component\EventDispatcher\EventDispatcher;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

use Cadoles\CoreBundle\Entity\User;

class SecurityController extends Controller
{
    public function metadataAction()
    {
        return parent::metadataAction();
    }

   public function loginAction(Request $request)
    {
        // Init Client CAS
        \phpCAS::setDebug(false);
        \phpCAS::client(CAS_VERSION_2_0, $this->getParameter('cas_host'), $this->getParameter('cas_port'), is_null($this->getParameter('cas_path')) ? '' : $this->getParameter('cas_path'), false);
        \phpCAS::setNoCasServerValidation();
        

        // Authentification
        \phpCAS::forceAuthentication();

        // Récupération UID
        $username = \phpCAS::getUser();

        // Récupération Attribut
        $attributes = \phpCAS::getAttributes();

        // Init
        $email = "";
        $lastname = "";
        $firstname = "";

        // Rechercher l'utilisateur
        $em = $this->getDoctrine()->getManager();
        if(isset($attributes[$this->getParameter('user_attr_cas_username')]))
            $username = $attributes[$this->getParameter('user_attr_cas_username')];
        
        if(isset($attributes[$this->getParameter('user_attr_cas_mail')]))
            $email = $attributes[$this->getParameter('user_attr_cas_mail')];
        
        if(isset($attributes[$this->getParameter('user_attr_cas_lastname')]))
            $lastname = $attributes[$this->getParameter('user_attr_cas_lastname')];
        
        if(isset($attributes[$this->getParameter('user_attr_cas_firstname')]))
            $firstname = $attributes[$this->getParameter('user_attr_cas_firstname')];

        $user = $em->getRepository('CadolesCoreBundle:User')->findOneBy(array("username"=>$username));
        $exists = $user ? true : false;
        
        if (!$exists) {
            if(empty($email)) $email = $username."@nomail.com";
        
            $user = new User();

            $user->setUsername($username);
            $user->setEmail($email);
            $user->setLastname($lastname);
            if(isset($firstname)) $user->setFirstname($firstname);
            $user->setPassword("CASPWD-".$username);
            $user->setSalt("CASPWD-".$username);
            $user->setAvatar("noavatar.png");
            $user->setRole("ROLE_USER");

            $em->persist($user);
            $em->flush();             
        }
        else {
            $user->setLastname($lastname);
            $user->setFirstname((isset($firstname)?$firstname:null));
            $user->setEmail($email);
            
            $em->persist($user);
            $em->flush();
        }

        // Sauvegarde des attributes en session
        $this->get('session')->set('attributes', $attributes);

        // Autoconnexion
        // Récupérer le token de l'utilisateur
        $token = new UsernamePasswordToken($user, null, "main", $user->getRoles());
        $this->get("security.token_storage")->setToken($token);

        // Simuler l'evenement de connexion
        $event = new InteractiveLoginEvent($request, $token);
        $dispatcher = new EventDispatcher();
        $dispatcher->dispatch("security.interactive_login", $event);


        return $this->redirect($this->generateUrl('cadoles_core_home'));
    }

    public function logoutAction() {
        // Init Client CAS
        \phpCAS::setDebug(false);
        \phpCAS::client(CAS_VERSION_2_0, $this->getParameter('cas_host'), $this->getParameter('cas_port'), is_null($this->getParameter('cas_path')) ? '' : $this->getParameter('cas_path'), true);
        \phpCAS::setNoCasServerValidation();


        // Logout
        $url=$this->generateUrl('cadoles_core_home', array(), UrlGeneratorInterface::ABSOLUTE_URL);
        \phpCAS::logout(array("service"=>$url));
    }
}
