<?php
namespace Cadoles\CoreBundle\Command;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Finder\Finder;
use Symfony\Component\HttpKernel\KernelInterface;
use Doctrine\DBAL\Connection as DBALConnection;
use Doctrine\ORM\EntityManager;
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\Exception\UnsatisfiedDependencyException;

use Cadoles\CoreBundle\Entity\Group;
use Cadoles\CoreBundle\Entity\UserGroup;

class InitDataCommand extends ContainerAwareCommand
{
    protected function configure()
    {
        $this
            // the name of the command (the part after "bin/console")
            ->setName('Core:InitData')

            // the short description shown while running "php bin/console list"
            ->setDescription('Init Data for Core')

            // the full command description shown when running the command with
            // the "--help" option
            ->setHelp('This command Init Data for Core')
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $output->writeln('');
        $output->writeln('CORE = Default Data');

        $em = $this->getContainer()->get('doctrine')->getManager();

		$finder = new Finder();
    	$finder->in('src/Cadoles/CoreBundle/Command/data');

        // Init 01 = ce qui templetisé
        $finder->name('core-init-01.sql');
    	foreach( $finder as $file ){
        	$content = $file->getContents();

            $stmt = $em->getConnection()->prepare($content);
        	$stmt->execute();
    	}
        $stmt->closeCursor();
    }

    protected static function determineKernelRootDir(Event $event) {
        $extra = $event->getComposer()->getPackage()->getExtra();
        $rootdir = rtrim(getcwd(), '/');
        return $rootdir . '/' . trim($extra['symfony-app-dir'], '/');
    }
}
