<?php
namespace Cadoles\CoreBundle\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Finder\Finder;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\HttpFoundation\File\File;
use Symfony\Component\HttpKernel\KernelInterface;
use Doctrine\DBAL\Connection as DBALConnection;
use Doctrine\ORM\EntityManager;
use Symfony\Component\Validator\Constraints\DateTime;

use Cadoles\CoreBundle\Entity\Registration;

class PurgeFileCommand extends Command
{
    private $container;
    private $em;
    private $output;
    private $filesystem;
    private $rootlog;

    protected function configure()
    {
        $this
            ->setName('Core:PurgeFile')
            ->setDescription('Purge Files')
            ->setHelp('This command Purge the obsolete Files')
            ->addArgument('cronid', InputArgument::OPTIONAL, 'ID Cron Job') 
            ->addArgument('lastchance', InputArgument::OPTIONAL, 'Lastchance to run the cron')              
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->container    = $this->getApplication()->getKernel()->getContainer();
        $this->em           = $this->container->get('doctrine')->getEntityManager();
        $this->output       = $output;
        $this->filesystem   = new Filesystem();
        $this->rootlog      = $this->container->get('kernel')->getRootDir()."/../var/logs/";
        $alias              = $this->container->getParameter('alias');

        $this->writelnred('');
        $this->writelnred('== Core:PurgeFile');        
        $this->writelnred('==========================================================================================================');

        $now=new \DateTime('now');

        // /uploads/file
        $this->writelnred('');
        $this->writelnred('== Directory = File');        

        $directory=$this->container->get('kernel')->getRootDir()."/../uploads/file";
        $files=[];
        $fs = new Filesystem();

        if($fs->exists($directory)) {
            $finder = new Finder();
            $finder->in($directory)->directories()->exclude("thumb");

            foreach (iterator_to_array($finder) as $file) {
                $name   = $file->getRelativePathname();
                $type   = explode("-",$name)[0];
                $id     = explode("-",$name)[1];

                switch($type) {
                    case "widget":
                        $entity=$this->em->getRepository("CadolesPortalBundle:Pagewidget")->find($id);
                        if(!$entity) {
                            $this->writeln($name);
                            $url=$directory."/".$name;
                            if($fs->exists($url)) {
                                $fs->remove($url);
                            }                            
                        }
                    break;
                }
                

            }
        }

        // /web/uploads/avatar
        $this->writelnred('');
        $this->writelnred('== Directory = Avatar');

        $directory=$this->container->get('kernel')->getRootDir()."/../web/uploads/avatar";
        $files=[];
        $fs = new Filesystem();

        if($fs->exists($directory)) {
            $finder = new Finder();
            $finder->in($directory)->files();

            foreach (iterator_to_array($finder) as $file) {
                $name   = $file->getRelativePathname();
                if($name!="admin.jpg"&&$name!="noavatar.png"&&$name!="system.jpg") {
                    $entity=$this->em->getRepository("CadolesCoreBundle:User")->findBy(["avatar"=>$name]);
                    if(!$entity) { 
                        $this->writeln($name);
                        $url=$directory."/".$name;
                        if($fs->exists($url)) {
                            $fs->remove($url);
                        }                          
                    }
                }
            }
        }

        // /web/uploads/header
        $this->writelnred('');
        $this->writelnred('== Directory = Header');

        $directory=$this->container->get('kernel')->getRootDir()."/../web/uploads/header";
        $files=[];
        $fs = new Filesystem();

        if($fs->exists($directory)) {
            $finder = new Finder();
            $finder->in($directory)->files();

            foreach (iterator_to_array($finder) as $file) {
                $name   = $file->getRelativePathname();
                if($name!="header.png") {
                    $entity=$this->em->getRepository("CadolesCoreBundle:Config")->findBy(["id"=>"header","value"=>"uploads/header/".$name]);
                    if(!$entity) {
                        $this->writeln($name);
                        $url=$directory."/".$name;
                        if($fs->exists($url)) {
                            $fs->remove($url);
                        }                          
                    }
                }
            }
        }

        // /web/uploads/logo
        $this->writelnred('');
        $this->writelnred('== Directory = Logo');

        $directory=$this->container->get('kernel')->getRootDir()."/../web/uploads/logo";
        $files=[];
        $fs = new Filesystem();

        if($fs->exists($directory)) {
            $finder = new Finder();
            $finder->in($directory)->files();

            foreach (iterator_to_array($finder) as $file) {
                $name   = $file->getRelativePathname();
                if($name!="logo.png") {
                    $entity=$this->em->getRepository("CadolesCoreBundle:Config")->findBy(["id"=>"logo","value"=>"uploads/logo/".$name]);
                    if(!$entity) {
                        $this->writeln($name);
                        $url=$directory."/".$name;
                        if($fs->exists($url)) {
                            $fs->remove($url);
                        }                          
                    }
                }
            }
        }

        // /web/uploads/ckeditor
        $this->writelnred('');
        $this->writelnred('== Directory = Ckeditor');
        $directory=$this->container->get('kernel')->getRootDir()."/../web/uploads/ckeditor";
        $files=[];
        $fs = new Filesystem();

        if($fs->exists($directory)) {
            $finder = new Finder();
            $finder->in($directory)->files();

            foreach (iterator_to_array($finder) as $file) {
                $name   = $file->getRelativePathname();
                $tofind = "/".$alias."/uploads/ckeditor/".$name;
                $find=false;
                
                // On recherche l'image dans les Scrumwidget
                $result = $this->em
                        ->getRepository("CadolesCoreBundle:Scrumwidget")->createQueryBuilder('scrumwidget')
                        ->where('scrumwidget.description LIKE :tofind')
                        ->setParameter('tofind', '%'.$tofind.'%')
                        ->getQuery()->getResult();                
                if($result) $find=true;

                // Si pas trouvé on supprime
                if(!$find) {
                    $this->writeln($name);
                    $url=$directory."/".$name;
                    if($fs->exists($url)) {
                        $fs->remove($url);
                    }                       
                }
            }
        }

        $this->writeln('');
        return 1;
    }

    private function writelnred($string) { 
        $this->output->writeln('<fg=red>'.$string.'</>');
        $this->filesystem->appendToFile($this->rootlog.'cron.log', $string."\n");
    }
    private function writeln($string) { 
        $this->output->writeln($string);
        $this->filesystem->appendToFile($this->rootlog.'cron.log', $string."\n");
    }     
}
