<?php
namespace Cadoles\CoreBundle\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Finder\Finder;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\HttpKernel\KernelInterface;
use Doctrine\DBAL\Connection as DBALConnection;
use Doctrine\ORM\EntityManager;

use Doctrine\ORM\Mapping\ClassMetadata;
use Doctrine\ORM\Id\AssignedGenerator;

use Cadoles\CoreBundle\Entity\Script;

global $bdd01;
global $config;

class ScriptCommand extends Command
{
    private $container;
    private $em;
    private $output;
    private $filesystem;
    private $rootlog;

    protected function configure()
    {
        $this
            ->setName('Core:Script')
            ->setDescription('Lauch Script')
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->container    = $this->getApplication()->getKernel()->getContainer();
        $this->em           = $this->container->get('doctrine')->getEntityManager();
        $this->output       = $output;
        $this->filesystem   = new Filesystem();
        $this->rootlog      = $this->container->get('kernel')->getRootDir()."/../var/logs/";


        $script=$this->em->getRepository("CadolesCoreBundle:Script")->findOneBy(["name"=>"renamegroup"]);
        if(!$script) {
            $this->writelnred("== SCRIPT = renamegroup");
            $this->renamegroup();
            
            $script=new Script();
            $script->setName("renamegroup");
            $this->em->persist($script);
            $this->em->flush();                  
            $this->writeln("");
        }

        $script=$this->em->getRepository("CadolesCoreBundle:Script")->findOneBy(["name"=>"moveimages"]);
        if(!$script) {
            $this->writelnred("== SCRIPT = moveimages");
            $this->moveimages();
            
            $script=new Script();
            $script->setName("moveimages");
            $this->em->persist($script);
            $this->em->flush();                  
            $this->writeln("");
        }

        return 1;
    }

    private function renamegroup(){
        
        $groups = $this->em->getRepository('CadolesCoreBundle:Group')->findAll();
        foreach($groups as $group) {
            // Si présence d'un = dans le label
            if(stripos($group->getLabel(),"=")!==false) {
                $newname=str_replace("=","-",$group->getLabel());

                $this->writeln("Renommer groupe = ".$group->getLabel());

                $group->setLabel($newname);
                $this->em->persist($group);
                $this->em->flush();                  
            }
        }
    }


    private function moveimages() {
        $fs = new Filesystem();
              
        // Rangement des fichiers uploadés dans ckeditor
        $directory=$this->container->get('kernel')->getProjectDir()."/web/uploads/ckeditor";
        if($fs->exists($directory)) {
            $finder = new Finder();
            $finder->in($directory)->files();

            foreach (iterator_to_array($finder) as $file) {
                $name = $file->getRelativePathname();
                $this->writeln($name);

                // Scrumwidget
                $results = $this->em
                    ->getRepository("CadolesCoreBundle:Scrumwidget")
                    ->createQueryBuilder('table')
                    ->where('table.description LIKE :tofind')
                    ->setParameter('tofind', '%'.$name.'%')
                    ->getQuery()->getResult();                
                foreach($results as $result) {
                    // On récupère l'id parent
                    $id=$result->getScrumcolumn()->getScrum()->getId();

                    // On génère les répertoires de destination
                    $fs->mkdir($this->container->get('kernel')->getProjectDir()."/web/uploads");
                    $fs->mkdir($this->container->get('kernel')->getProjectDir()."/web/uploads/scrum");
                    $fs->mkdir($this->container->get('kernel')->getProjectDir()."/web/uploads/scrum/$id");
                    
                    // On déplace le fichier
                    $filesource=$this->container->get('kernel')->getProjectDir()."/web/uploads/ckeditor/$name";
                    $filedestination=$this->container->get('kernel')->getProjectDir()."/web/uploads/scrum/$id/$name";
                    $fs->rename($filesource,$filedestination, true);

                    // On remplace le chemin
                    $description=$result->getDescription();
                    $result->setDescription(str_replace("/uploads/ckeditor/$name","/uploads/scrum/$id/$name",$description));
                    $this->em->persist($result);
                    $this->em->flush();   
                }
            }
        }
    }   











    private function writelnred($string) { 
        $this->output->writeln('<fg=red>'.$string.'</>');
        $this->filesystem->appendToFile($this->rootlog.'cron.log', $string."\n");
    }
    private function writeln($string) { 
        $this->output->writeln($string);
        $this->filesystem->appendToFile($this->rootlog.'cron.log', $string."\n");
    }   

}
