<?php
namespace Cadoles\CoreBundle\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Finder\Finder;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\HttpKernel\KernelInterface;
use Doctrine\DBAL\Connection as DBALConnection;
use Doctrine\ORM\EntityManager;

use Cadoles\CoreBundle\Entity\User;
use Cadoles\CoreBundle\Entity\Group;


use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\Exception\UnsatisfiedDependencyException;

global $bdd01;
global $config;

class SynchroCommand extends Command
{
    private $container;
    private $em;
    private $em2;
    private $output;
    private $filesystem;
    private $rootlog;
    private $ldap;
    private $ldap_basedn;

    protected function configure()
    {
        $this
            ->setName('Core:Synchro')
            ->setDescription('Synchronisation Annuaire')
            ->setHelp('This command Synchro for Core')
            ->addArgument('simulate', InputArgument::OPTIONAL, 'true to simulate / false to run')            
            ->addArgument('cronid', InputArgument::OPTIONAL, 'ID Cron Job') 
            ->addArgument('lastchance', InputArgument::OPTIONAL, 'Lastchance to run the cron')              
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->container    = $this->getApplication()->getKernel()->getContainer();
        $this->em           = $this->container->get('doctrine')->getEntityManager();
        $this->output       = $output;
        $this->filesystem   = new Filesystem();
        $this->rootlog      = $this->container->get('kernel')->getRootDir()."/../var/logs/";

        $this->writelnred('');
        $this->writelnred('== Core:Synchro');        
        $this->writelnred('==========================================================================================================');
        
        setlocale( LC_CTYPE, 'fr_FR' );
        $masteridentity = $this->container->getParameter('masteridentity');

        $simulate = $input->getArgument('simulate');
        if($simulate=="") $simulate="true";
        
        if($simulate!="true"&&$simulate!="false") {
            $this->writeln('Paramétre incorrect');
            return;
        }
        $simulate=($simulate=="true");
        
        $this->writeln('');
        if($simulate) $this->writeln('** SIMULATION');
        else $this->writeln('** REEL');



        $this->ldap = $this->container->get('cadoles.core.service.ldap');

        if(!$this->ldap->isEnabled()) {
            if($masteridentity =="Ninegate") {
                $this->synchroNinegate($simulate);
            }

            if($masteridentity =="LDAP") {
                $this->writeln('');
                $this->writeln('=====================================================');
                $this->writeln('== SYNCHONISATION ANNUAIRE ==========================');
                $this->writeln('=====================================================');

                $this->writeln('');
                $this->writeln('=====================================================');
                $this->writeln('== SYNCHONISATION LDAP TO BUNDLE ====================');
                $this->writeln('=====================================================');

                // Suppression des groupe annuaire
                $groups=$this->em->getRepository("CadolesCoreBundle:Group")->findAll();
                foreach($groups as $group) {
                    if($group->getIdexternal()) {
                        $this->writeln("    - Suppression dans Bundle  >> ".$group->getLabel());
                        if(!$simulate) {
                            $this->em->remove($group);
                            $this->em->flush();
                                                        
                        }
                    }
                }

                // Parametre LDAP
                $this->ldap_basedn  = $this->container->getParameter('ldap_basedn');
                $ldap_template      = $this->container->getParameter('ldap_template');
                $ldap_username      = $this->container->getParameter('ldap_username');
                $ldap_firstname     = $this->container->getParameter('ldap_firstname');
                $ldap_lastname      = $this->container->getParameter('ldap_lastname');
                $ldap_email         = $this->container->getParameter('ldap_email');
                $ldap_usersadmin    = $this->container->getParameter('ldap_usersadmin');
                $fieldstoread       = array($ldap_username,$ldap_firstname,$ldap_lastname,$ldap_email);
                $ldapusers          = array();
                $ldapmails          = array();

                if($ldap_template=="scribe") {
                    $this->writeln('');
                    $this->writeln('== PROFILS ==========================================');

                    // Eleves
                    $ldapfilter="(&(uid=*)(ENTPersonProfils=eleve))";
                    $label="PROFIL - Elèves";
                    $this->writeln("    - $label");
                    if(!$simulate) $this->addmodGroup($label,$ldapfilter,false);

                    // Enseignants
                    $ldapfilter="(|(&(uid=*)(ENTPersonProfils=enseignant))(&(uid=*)(typeadmin=0))(&(uid=*)(typeadmin=2)))";
                    $label="PROFIL - Enseignants";
                    $this->writeln("    - $label");
                    if(!$simulate) $this->addmodGroup($label,$ldapfilter,true);

                    // Responsables
                    $ldapfilter="(&(uid=*)(ENTPersonProfils=responsable))";
                    $label="PROFIL - Responsables";
                    $this->writeln("    - $label");
                    if(!$simulate) $this->addmodGroup($label,$ldapfilter,false);

                    // Administratifs
                    $ldapfilter="(&(uid=*)(ENTPersonProfils=administratif))";
                    $label="PROFIL - Administratifs";
                    $this->writeln("    - $label");
                    if(!$simulate) $this->addmodGroup($label,$ldapfilter,true);

                    // Classes
                    $this->writeln('');
                    $this->writeln('== CLASSES ==========================================');
                    $results = $this->ldap->search("type=Classe", ['cn','description','gidNumber'], $this->ldap_basedn);
                    foreach($results as $result) {
                        $cn=$result["cn"];
                        $ldapfilter="(|(&(type=Classe)(cn=$cn))(&(type=Equipe)(cn=profs-$cn))(&(ENTPersonProfils=Administratif)(divcod=$cn)))";

                        $label="CLASSE - ".$result["cn"];
                        $this->writeln("    - $label");
                        if(!$simulate) $this->addmodGroup($label,$ldapfilter,true);                        
                    }

                    // Elèves des Classes
                    $this->writeln('');
                    $this->writeln('== ELEVES DES CLASSES ==========================================');
                    $results = $this->ldap->search("type=Classe", ['cn','description','gidNumber'], $this->ldap_basedn);
                    foreach($results as $result) {
                        $cn=$result["cn"];
                        $ldapfilter="(&(type=Classe)(cn=$cn))";

                        $label="ELEVES - ".$result["cn"];
                        $this->writeln("    - $label");
                        if(!$simulate) $this->addmodGroup($label,$ldapfilter,false);                        
                    }

                    // Professeurs des Classes
                    $this->writeln('');
                    $this->writeln('== PROFESSEURS DES CLASSES ==========================================');
                    $results = $this->ldap->search("type=Classe", ['cn','description','gidNumber'], $this->ldap_basedn);
                    foreach($results as $result) {
                        $cn=$result["cn"];
                        $ldapfilter="(|(&(type=Equipe)(cn=profs-$cn))(&(ENTPersonProfils=Administratif)(divcod=$cn)))";

                        $label="PROFESSEURS - ".$result["cn"];
                        $this->writeln("    - $label");
                        if(!$simulate) $this->addmodGroup($label,$ldapfilter,false);                        
                    }
                    
                    // Options
                    $this->writeln('');
                    $this->writeln('== OPTIONS ==========================================');
                    $results = $this->ldap->search("type=Option", ['cn','description','gidNumber'], $this->ldap_basedn);
                    foreach($results as $result) {
                        $cn=$result["cn"];
                        $ldapfilter="(|(&(type=Option)(cn=$cn))(&(type=Equipe)(cn=profs-$cn))(&(ENTPersonProfils=Administratif)(divcod=$cn)))";

                        $label="OPTION - ".$result["cn"];
                        $this->writeln("    - $label");
                        if(!$simulate) $this->addmodGroup($label,$ldapfilter,true);                        
                    }

                    // Groupes
                    $this->writeln('');
                    $this->writeln('== GROUPES ==========================================');
                    $results = $this->ldap->search("type=Groupe", ['cn','description','gidNumber'], $this->ldap_basedn);
                    foreach($results as $result) {
                        $cn=$result["cn"];
                        $ldapfilter="(&(type=Groupe)(cn=$cn))";

                        $label="GROUPE - ".$result["cn"];
                        $this->writeln("    - $label");
                        if(!$simulate) $this->addmodGroup($label,$ldapfilter,true);                        
                    }
                }

                $this->writeln('');
                $this->writeln('== USERS ============================================');
                
                // On stocke tout les email déjà existant
                $this->writeln('== Stocker les emails utilisateurs existants');
                $users=$this->em->createQueryBuilder()->select('table.email')->from('CadolesCoreBundle:User','table')->getQuery()->getArrayResult();
                foreach($users as $user) {
                    array_push($ldapmails,$user["email"]);
                }                

                // On parcours les niveaux 01 pour connaitre les filtres ldap associé
                $tbfilters=["(&(uid=*)(objectclass=inetOrgPerson)(!(description=Computer)))"];
                $nbusers=0;
                $tberrors=[];
                foreach($tbfilters as $filter) {
                    // On execute le filtre d'appartenance à ce niveau
                    $this->writeln("== Récupération des utilisateurs de l'annuaire");
                    $results = $this->ldap->search($filter, $fieldstoread, $this->ldap_basedn);
                    $nbuserstotal=count($results);

                    // Pour chaque utilisateur ldap
                    $this->writeln('== Traitement des utilisateurs = '.$filter);
                    foreach($results as $result) {
                        // Compteur de users
                        $nbusers++;

                        // Formatage du résultat
                        if(is_array($result[$ldap_username])) {
                            $result[$ldap_username]=$result[$ldap_username][0];
                        }

                        $result[$ldap_username]=utf8_encode($result[$ldap_username]);
                        if(!isset($result[$ldap_lastname])) $result[$ldap_lastname] = "";
                        if(!isset($result[$ldap_firstname])) $result[$ldap_firstname] = "";

                        if(!array_key_exists($ldap_email,$result)||empty($result[$ldap_email])) {
                            $result[$ldap_email]=$result[$ldap_username]."@nomail.fr";
                        }                        
                        $result[$ldap_email]=strtolower($result[$ldap_email]);
                        $result[$ldap_email]=utf8_encode($result[$ldap_email]);

                        // On sauvegarde ce user
                        if(in_array($result[$ldap_username],$ldapusers)) {
                            $this->writelnred("    - Création dans Bundle impossible     >> ".$result[$ldap_username]." deux users avec le meme uid");
                            continue;
                        }
                        array_push($ldapusers,$result[$ldap_username]);
                        
                        // Création ou Modification du user
                        $user=$this->em->getRepository('CadolesCoreBundle:User')->findOneBy(array('username' => $result[$ldap_username]));
                        if(!$user) {
                            if(empty($result[$ldap_email]))
                                array_push($tberrors,"    - Création dans Bundle impossible         >> ".$result[$ldap_username]." sans email");
                            else {
                                if(in_array($result[$ldap_email],$ldapmails))
                                    array_push($tberrors,"    - Création dans Bundle impossible         >> ".$result[$ldap_username]." un autre utilisateur a déjà ce mail = ".$result[$ldap_email]);
                                else {
                                    array_push($ldapmails,$result[$ldap_email]);
                                    $this->writeln("    - Création dans Bundle     >> ".$result[$ldap_username]);
                                    if(!$simulate) $this->addUser($result[$ldap_username],$result[$ldap_firstname],$result[$ldap_lastname],$result[$ldap_email],$ldap_usersadmin);
                                }
                            }
                        }
                        else {
                            $toadmin=false;
                            if(in_array($result[$ldap_username],$ldap_usersadmin)&&!in_array("ROLE_ADMIN",$user->getRoles()))
                                $toadmin=true;

                            $changerole=$this->changerole($result[$ldap_username],$user->getRole());

                            if($user->getLastname()!=$result[$ldap_lastname]||$user->getFirstname()!=$result[$ldap_firstname]||$user->getEmail()!=$result[$ldap_email]||$toadmin||$changerole) {
                                $usermail=$this->em->getRepository('CadolesCoreBundle:User')->findOneBy(array('email' => $result[$ldap_email]));
                                if($usermail&&$usermail!=$user) {
                                      array_push($tberrors,"    - Modification dans Bundle impossible     >> ".$result[$ldap_username]." un autre utilisateur a déjà ce mail = ".$result[$ldap_email]);
                                }
                                else {
                                    $this->writeln("    - Modification dans Bundle >> ".$result[$ldap_username]);
                                    if(!$simulate) $this->modUser($user,$result[$ldap_username],$result[$ldap_firstname],$result[$ldap_lastname],$result[$ldap_email],$ldap_usersadmin);
                                }
                            }
                        }

                        if(!$simulate) {
                            $this->em->clear();
                        }

                        if($nbusers%1000==0) $this->writeln("    == Nombre d'utilisateurs traités = $nbusers sur $nbuserstotal ==");
                    }
                }
                if(!$simulate) {
                    $this->writeln("    == Nombre d'utilisateurs traités = $nbusers sur $nbuserstotal ==");
                    $this->em->flush();
                    $this->em->clear();
                }

                foreach($tberrors as $error) {
                    $this->writelnred("    == ERROR == $error");
                }

                $this->writeln('');
                $this->writeln('== USERS GROUP ======================================');                

                $groups=$this->em->getRepository('CadolesCoreBundle:Group')->findAll();
                foreach($groups as $group) {
                    $ldapusersgroup=array();

                    $ldapfilter=$group->getLdapfilter();

                    $this->writeln('');
                    $this->writeln('== '.$group->getLabel());                
    
                    if(!is_null($ldapfilter)) {
                        $results = $this->ldap->search($ldapfilter,[$ldap_username,"memberuid"] , $this->ldap_basedn);

                        foreach($results as $result) {
                            if(isset($result["memberuid"])) {
                                // Si memberid est un tableau il y a plusieur user dedans
                                if(is_array($result["memberuid"])) {
                                    foreach($result["memberuid"] as $key => $value) {
                                        if(is_int($key)) {
                                            $user=$this->em->getRepository('CadolesCoreBundle:User')->findOneBy(array('username' => $value));
                                            if($user) {
                                                array_push($ldapusersgroup,$value);
                                                $this->writeln("    - Rattacher   >> ".$value);
                                                if(!$simulate) $this->addtoGroup($user,$group);
                                            }
                                        }
                                    }
                                }
                                // sinon m'a qu'un seul uid
                                else {
                                    $user=$this->em->getRepository('CadolesCoreBundle:User')->findOneBy(array('username' => $result["memberuid"]));
                                    if($user) {
                                        array_push($ldapusersgroup,$result["memberuid"]);
                                        $this->writeln("    - Rattacher   >> ".$result["memberuid"]);
                                        if(!$simulate) $this->addtoGroup($user,$group);
                                    }
                                }
                            }

                            if(isset($result[$ldap_username])) {
                                $user=$this->em->getRepository('CadolesCoreBundle:User')->findOneBy(array('username' => $result[$ldap_username]));
                                if($user) {
                                    array_push($ldapusersgroup,$result[$ldap_username]);
                                    $this->writeln("    - Rattacher   >> ".$result[$ldap_username]);
                                    if(!$simulate) $this->addtoGroup($user,$group);
                                }
                            }
                        }

                        $members=$group->getUsers();
                        foreach($members as $member) {
                            if(!in_array($member->getUsername(),$ldapusersgroup)) {
                                $this->writeln("    - Détattacher >> ".$member->getUsername());
                                if(!$simulate) {
                                    $member->removeGroup($group);
                                    $this->em->persist($member);
                                    $this->em->flush();                            
                                }                                
                            }
                        }
                    }
                }
                

                $this->writeln('');
                $this->writeln('=====================================================');
                $this->writeln('== SYNCHONISATION BUNDLE TO LDAP ====================');
                $this->writeln('=====================================================');

                $this->writeln('');
                $this->writeln('== USERS ============================================');

                // Pour chaque utilisateur de la base
                //$users=$this->em->getRepository('CadolesCoreBundle:User')->findAll();
                $datas=$this->em->createQueryBuilder()->select('table.id,table.username')->from('CadolesCoreBundle:User','table')->getQuery()->getArrayResult();
                $nbusers=0;

                // tentative d'optimisation
                $flipped = array_flip($ldapusers);

                foreach($datas as $data) {
                    $nbusers++;

                    // Si l'utilisateur n'est pas dans la liste des users ldap : on le supprime
                    if(!isset($flipped[$data["username"]])) {
                        $user=$this->em->getRepository('CadolesCoreBundle:User')->find($data["id"]);
                        if($user->getUsername()=="admin")
                            $this->writeln("    - Ne jamais supprimer  >> ".$user->getUsername());
                        else {
                            $this->writeln("    - Suppression dans Bundle  >> ".$user->getUsername());
                            if(!$simulate) {
                                $this->em->remove($user);
                                $this->em->flush();
                                                         
                            }
                        }
                    }
                    else { 
                        //on peut unset les recherches suivantes seront plus rapide
                        unset($flipped[$data["username"]]);
                    }
                    
                    $this->em->clear();   
                    if($nbusers%1000==0) $this->writelnred("    == Nombre d'utilisateurs traités = $nbusers==");
                }
            }
        }

        $this->writeln('');
        return 1;
    }

    protected function synchroNinegate($simulate) {
        $this->writeln('');
        $this->writeln('=====================================================');
        $this->writeln('== SYNCHONISATION NINEGATE ==========================');
        $this->writeln('=====================================================');

        $this->writeln('');
        $this->writeln('=====================================================');
        $this->writeln('== SYNCHONISATION NINEGATE TO BUNDLE ================');
        $this->writeln('=====================================================');

        $appmasterurl = $this->container->getParameter("masterurl");
        $appmasterkey = $this->container->getParameter("masterapikey");

        // Suppression des groupe annuaire
        $groups=$this->em->getRepository("CadolesCoreBundle:Group")->findAll();
        foreach($groups as $group) {
            if($group->getLdapfilter()) {
                $this->writeln("    - Suppression dans Bundle  >> ".$group->getLabel());
                if(!$simulate) {
                    $this->em->remove($group);
                    $this->em->flush();
                                                
                }
            }
        }

        // Généraltion de l'urol de communication
        if(stripos($appmasterurl,"/")===0) {
            $url="https://".$this->container->getParameter("weburl").$appmasterurl;
        }
        else
            $url=$appmasterurl;

        // Entete
        $headers = ['Accept' => 'application/json'];
        $query = [];
    
        // Paramétrage unirest
        \Unirest\Request::verifyPeer(false);
        \Unirest\Request::verifyHost(false);
        \Unirest\Request::timeout(5);

        // Login sans proxy
        try{
            $response = \Unirest\Request::post($url.'/rest/login',$headers,["key"=>$appmasterkey,"only"=>"user,groups"]);
        }
        catch (\Exception $e) {
            // On tente avec le proxy s'il y en a un
            $proxyUse = $this->container->getParameter("proxyUse");
            if($proxyUse) {
                $proxyHost = $this->container->getParameter("proxyHost");
                $proxyPort = $this->container->getParameter("proxyPort");
                \Unirest\Request::proxy($proxyHost, $proxyPort, CURLPROXY_HTTP, true);

                try{
                    $response = \Unirest\Request::post($url.'/rest/login/'.$appmasterkey,$headers,$query);
                }
                catch (\Exception $e) {
                    die("Erreur de communication API = ".$e->getMessage()."\n");
                }
            }
            else {
                die("Erreur de communication API = ".$e->getMessage()."\n");
            }            
        }
        
        if($response->code!="200") 
            die("Erreur sur clé API\n");


        $this->writeln('');
        $this->writeln('== GROUPS ============================================');

        // Récupération des informations groups issus du masteridentity
        try{
            $response = \Unirest\Request::post($url.'/rest/groups',$headers,["key"=>$appmasterkey]);
        }
        catch (\Exception $e) {
            die("Erreur de communication API = ".$e->getMessage()."\n");
        }

        $lstgroups=[];
        if($response->code=="200" && is_object($response->body)) {
            $apigroups=$response->body;
            foreach($apigroups as $apigroup) {
                array_push($lstgroups,$apigroup->id);

                $group=$this->em->getRepository("CadolesCoreBundle:Group")->findOneBy(["idexternal"=>$apigroup->id]);
                $this->writeln("    - ".$apigroup->name);
                if(!$simulate) {
                    if(!$group) {
                        $group = new Group();
                        $group->setIdexternal($apigroup->id);
                    }

                    $group->setLabel($apigroup->name);
                    $group->setFgtemplate(true);
     
                    $this->em->persist($group);
                    $this->em->flush();
                }
            }
        }
        else die("Erreur de communication = ".print_r($response,true));

        $this->writeln('');
        $this->writeln('== USERS ============================================');

        // Récupération des informations utilisateurs issus du masteridentity
        try{
            $response = \Unirest\Request::post($url.'/rest/users',$headers,["key"=>$appmasterkey]);
        }
        catch (\Exception $e) {
            die("Erreur de communication API = ".$e->getMessage()."\n");
        }

        $lstusers=[];
        if($response->code=="200"&&is_object($response->body)) {
            $apiusers=$response->body;
            foreach($apiusers as $apiuser) {
                array_push($lstusers,$apiuser->username);

                $user=$this->em->getRepository("CadolesCoreBundle:User")->findOneBy(["username"=>$apiuser->username]);
                $this->writeln("    - ".$apiuser->username);
                if(!$simulate) {
                    if(!$user) {
                        $user = new User();

                        $user->setUsername($apiuser->username);
                        $user->setPassword("NOPASSWORD");
                    }
                    $oldrole=$user->getRole();

                    $user->setLastname($apiuser->lastname);
                    $user->setFirstname($apiuser->firstname);
                    $user->setEmail($apiuser->email);        
                    $user->setAvatar($apiuser->avatar);
                    
                    if(in_array($apiuser->username,$this->container->getParameter("ldap_usersadmin")))
                        $role="ROLE_ADMIN";
                    else                    
                        $role=($apiuser->role=="ROLE_ANIM"?"ROLE_MASTER":$apiuser->role);
                    
                    if(!is_null($oldrole)) {
                        if($oldrole=="ROLE_ADMIN"&&($role=="ROLE_USER"||$role=="ROLE_MASTER"||$role=="ROLE_MODO")) $role="ROLE_ADMIN";
                        elseif($oldrole=="ROLE_MODO"&&($role=="ROLE_USER"||$role=="ROLE_MASTER")) $role="ROLE_MODO";
                        elseif($oldrole=="ROLE_MASTER"&&$role=="ROLE_USER") $role="ROLE_MASTER";
                    }


                    $user->setRole($role);
     
                    $this->em->persist($user);
                    $this->em->flush();
                }
            }
        }
        else die("Erreur de communication");

        $this->writeln('');
        $this->writeln('== USERS GROUP ======================================');                

        $groups=$this->em->getRepository('CadolesCoreBundle:Group')->findAll();
        $tabgroups = json_decode(json_encode($apigroups), true);
        
        foreach($groups as $group) {
            if(!$group->getIdexternal()) continue;
            
            $this->writeln($group->getLabel());

            $usergroups=[];
            if($tabgroups[$group->getIdexternal()])
                $usergroups = $tabgroups[$group->getIdexternal()]["users"];
            $tbusers=[];
            foreach($usergroups as $user) {
                array_push($tbusers,$user["username"]);

                // On recherche le user en question
                $user=$this->em->getRepository("CadolesCoreBundle:User")->findOneBy(["username"=>$user["username"]]);
                if($user) {
                    $this->writeln("    - Rattachement ".$user->getUsername());

                    if(!$simulate) {
                        if(!$group->getUsers()||!$group->getUsers()->contains($user)) {
                            $group->addUser($user);
                        }
                    }
                }
            }

            foreach($group->getUsers() as $user) {
                if(!in_array($user->getUsername(),$tbusers)) {
                    $this->writeln("    - Détachement ".$user->getUsername());
                    if(!$simulate) {
                        $group->removeUser($user);
                    }
                }
            }

            $this->em->persist($group);
            $this->em->flush();

        }

        $this->writeln('');
        $this->writeln('=====================================================');
        $this->writeln('== SYNCHONISATION BUNDLE TO NINEGATE ================');
        $this->writeln('=====================================================');


        $this->writeln('');
        $this->writeln('== USERS ============================================');

        // Pour chaque utilisateur de la base
        $users=$this->em->getRepository("CadolesCoreBundle:User")->findAll();
        foreach($users as $user) {
            if(!in_array($user->getUsername(),$lstusers)) {
                if($user->getUsername()=="admin")
                    $this->writeln("    - Ne jamais supprimer  >> ".$user->getUsername());
                else {
                    $this->writeln("    - Suppression dans Bundle  >> ".$user->getUsername());
                    if(!$simulate) {
                        $this->em->remove($user);
                        $this->em->flush();
                                                    
                    }
                }
            }
        }
        
        $this->writeln('');
        $this->writeln('== GROUPS ============================================');
        $groups=$this->em->getRepository("CadolesCoreBundle:Group")->findAll();
        foreach($groups as $group) {
            if(!$group->getIdexternal()) continue;

            if(!in_array($group->getIdexternal(),$lstgroups)) {
                $this->writeln("    - Suppression dans Bundle  >> ".$group->getLabel());
                if(!$simulate) {
                    $this->em->remove($group);
                    $this->em->flush();
                                                
                }
            }
        }

        $this->writeln('');

    }


    private function writelnred($string) { 
        $this->output->writeln('<fg=red>'.$string.'</>');
        $this->filesystem->appendToFile($this->rootlog.'cron.log', $string."\n");
    }
    private function writeln($string) { 
        $this->output->writeln($string);
        $this->filesystem->appendToFile($this->rootlog.'cron.log', $string."\n");
    }   

    protected function addmodGroup($label,$ldapfilter,$fgcanshare) {
        $group=$this->em->getRepository('CadolesCoreBundle:Group')->findOneBy(['label' => $label]);
        if(!$group)
            $group=new Group();

        $group->setLabel($label);
        $group->setLdapfilter($ldapfilter);
        $group->setFgtemplate(true);
        
        $this->em->persist($group);
        $this->em->flush();      
    }

    protected function addtoGroup($user,$group) {
        if ( !$user->getGroups()->contains($group) ) {
            $user->addGroup($group);
            $this->em->persist($user);
            $this->em->flush();    
    
        }  
    }

    protected function addUser($username,$firstname,$lastname,$email,$usersadmin) {
        $user = new User();

        $user->setUsername($username);
        $user->setLastname($lastname);
        $user->setFirstname($firstname);
        $user->setEmail($email);        
        $user->setPassword("PASSWORDFROMEXTERNE");

        if(in_array($username,$usersadmin))
            $user->setRole("ROLE_ADMIN");
        else {
            $user->setRole("ROLE_USER");

            // Si modèle scribe 
            $ldap_template = $this->container->getParameter('ldap_template');
            if($ldap_template=="scribe") {
                $ldapfilter="(&(uid=".$user->getUsername().")(ENTPersonProfils=administratif))";
                $results = $this->ldap->search($ldapfilter, ['uid'], $this->ldap_basedn);
                if($results) $user->setRole("ROLE_MASTER");
            }  
        }            

        $this->em->persist($user);
        $this->em->flush();
    }

    protected function modUser($user,$username,$firstname,$lastname,$email,$usersadmin) {
        $user->setLastname($lastname);
        $user->setFirstname($firstname);
        $user->setEmail($email);

        $oldrole=$user->getRole();
        
        if(in_array($username,$usersadmin)) $role="ROLE_ADMIN";
        elseif(!is_null($oldrole)) {
            $role="ROLE_USER";

            // Si modèle scribe 
            $ldap_template = $this->container->getParameter('ldap_template');
            if($ldap_template=="scribe") {
                $ldapfilter="(&(uid=".$user->getUsername().")(ENTPersonProfils=administratif))";
                $results = $this->ldap->search($ldapfilter, ['uid'], $this->ldap_basedn);
                if($results) $role="ROLE_MASTER";
            } 
            
            if($oldrole=="ROLE_ADMIN"&&($role=="ROLE_USER"||$role=="ROLE_MASTER"||$role=="ROLE_MODO")) $role="ROLE_ADMIN";
            elseif($oldrole=="ROLE_MODO"&&($role=="ROLE_USER"||$role=="ROLE_MASTER")) $role="ROLE_MODO";
            elseif($oldrole=="ROLE_MASTER"&&$role=="ROLE_USER") $role="ROLE_MASTER";
        }

        $user->setRole($role);

        $this->em->persist($user);
        $this->em->flush();
    }

    protected function changerole($username,$oldrole) {
        if(!is_null($oldrole)) {
            $role="ROLE_USER";

            // Si modèle scribe 
            $ldap_template = $this->container->getParameter('ldap_template');
            if($ldap_template=="scribe") {
                $ldapfilter="(&(uid=".$username.")(ENTPersonProfils=administratif))";
                $results = $this->ldap->search($ldapfilter, ['uid'], $this->ldap_basedn);
                if($results) $role="ROLE_MASTER";
            } 
            
            if($oldrole=="ROLE_ADMIN"&&($role=="ROLE_USER"||$role=="ROLE_MASTER"||$role=="ROLE_MODO")) $role="ROLE_ADMIN";
            elseif($oldrole=="ROLE_MODO"&&($role=="ROLE_USER"||$role=="ROLE_MASTER")) $role="ROLE_MODO";
            elseif($oldrole=="ROLE_MASTER"&&$role=="ROLE_USER") $role="ROLE_MASTER";
        }

        return ($oldrole!=$role);
    }

}
