<?php

namespace Cadoles\CoreBundle\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Filesystem\Filesystem;

use Cadoles\CoreBundle\Entity\Etherpad as Etherpad;
use Cadoles\CoreBundle\Entity\Ethercalc as Ethercalc;

class SynchroEtherCommand extends Command
{

    private $container;
    private $em;
    private $output;
    private $filesystem;
    private $rootlog;


    protected function configure()
    {
        $this
            ->setName('Core:synchroEther')
            ->setDescription('Synchronisation Nineboar <> Ether')
            ->setHelp('Synchronisation Nineboar <> Ether')
            ->addArgument('simulate', InputArgument::OPTIONAL, 'true to simulate / false to run')            
            ->addArgument('cronid', InputArgument::OPTIONAL, 'ID Cron Job') 
            ->addArgument('lastchance', InputArgument::OPTIONAL, 'Lastchance to run the cron')               
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->container        = $this->getApplication()->getKernel()->getContainer();
        $this->output           = $output;
        $this->filesystem       = new Filesystem();
        $this->rootlog          = $this->container->get('kernel')->getRootDir()."/../var/logs/";
        $this->em               = $this->container->get('doctrine')->getEntityManager();

        $this->writelnred('');
        $this->writelnred('== app:synchroEther');        
        $this->writelnred('==========================================================================================================');

        $simulate = $input->getArgument('simulate');
        if($simulate=="") $simulate="true";
        if($simulate!="true"&&$simulate!="false") {
            $this->writeln('Paramétre incorrect');
            return;
        }
        $simulate=($simulate=="true");
        $this->writeln('');
        if($simulate) $this->writeln('** SIMULATION');
        else $this->writeln('** REEL');

        // Récupération du service ethperad ethercalc
        $this->etherpad = $this->container->get('app.etherpad.service');
        $this->ethercalc = $this->container->get('app.ethercalc.service');
        
        if($this->container->getParameter("etherpad_activate")) {
            // Liste des pads ether
            $this->writeln('');
            $this->writelnred('ETHERPAD > NINEBOARD');
            $pads=$this->etherpad->listAllPads();
            if($pads) {
                foreach($pads as $pad) {
                    // On recherche si ce pad existe dans nineboard
                    $ninepad=$this->em->getRepository('CadolesCoreBundle:Etherpad')->findOneBy(array('title' => $pad));
                    if($ninepad) $this->writeln($pad." >> existe déjà dans nineboard");
                    else {
                        $this->writelnred($pad." >> à créer dans nineboard");
                        if(!$simulate) {
                            $ninepad=new Etherpad();
                            $ninepad->setTitle($pad);
                            $this->em->persist($ninepad);
                            $this->em->flush();                        
                        }
                    }
                }
            }

            // Liste des pads nineboard
            $this->writeln('');
            $this->writelnred('NINEBOARD > ETHERPAD');
            $ninepads=$this->em->getRepository('CadolesCoreBundle:Etherpad')->findAll();
            foreach($ninepads as $ninepad) {
                $title=$ninepad->getTitle();
                if(in_array($title,$pads)) $this->writeln($title." >> existe déjà dans etherpad");
                else {
                    $this->writelnred($title." >> à créer dans etherpad");
                    if(!$simulate) $this->etherpad->createPad($title);
                }
            }
        }




        if($this->container->getParameter("ethercalc_activate")) {
            // Liste des calcs ether
            $this->writeln('');
            $this->writelnred('ETHERCALC > NINEBOARD');
            $calcs=$this->ethercalc->listAllCalcs();
            if($calcs) {
                foreach($calcs as $calc) {
                    // On recherche si ce calc existe dans nineboard
                    $ninecalc=$this->em->getRepository('CadolesCoreBundle:Ethercalc')->findOneBy(array('title' => $calc));
                    if($ninecalc) $this->writeln($calc." >> existe déjà dans nineboard");
                    else {
                        $this->writelnred($calc." >> à créer dans nineboard");
                        if(!$simulate) {
                            $ninecalc=new Ethercalc();
                            $ninecalc->setTitle($calc);
                            $this->em->persist($ninecalc);
                            $this->em->flush();                        
                        }
                    }
                }
            }

            // Liste des calcs nineboard
            $this->writeln('');
            $this->writelnred('NINEBOARD > ETHERCALC');
            $ninecalcs=$this->em->getRepository('CadolesCoreBundle:Ethercalc')->findAll();
            foreach($ninecalcs as $ninecalc) {
                $title=$ninecalc->getTitle();
                if(in_array($title,$calcs)) $this->writeln($title." >> existe déjà dans ethercalc");
                else {
                    $this->writelnred($title." >> à créer dans ethercalc");
                    if(!$simulate) $this->ethercalc->createCalc($title);
                }
            }            
        }

        return 1;
    }
    
    function api($method,$url,$query) {
        // Entete
        $headers = ['Accept' => 'application/json'];
    
        // Paramétrage unirest
        \Unirest\Request::verifyPeer(false);
        \Unirest\Request::verifyHost(false);
        \Unirest\Request::timeout(5);
        
        $response = false;
        switch($method) {
            case "POST":
                // Tentative sans proxy
                try{
                    $response = \Unirest\Request::post($url,$headers,$query);
                }
                catch (\Exception $e) {
                    // On tente avec le proxy s'il y en a un
                    $proxyUse = $this->container->getParameter("proxyUse");
                    if($proxyUse) {
                        $proxyHost = $this->container->getParameter("proxyHost");
                        $proxyPort = $this->container->getParameter("proxyPort");
                        \Unirest\Request::proxy($proxyHost, $proxyPort, CURLPROXY_HTTP, true);

                        try{
                            $response = \Unirest\Request::post($url,$headers,$query);
                        }
                        catch (\Exception $e) {
                            return false;
                        }
                    }
                    else {
                        return false;
                    }            
                }
            break;

            case "GET":
                // Tentative sans proxy
                try{
                    $response = \Unirest\Request::get($url,$headers,$query);
                }
                catch (\Exception $e) {
                    // On tente avec le proxy s'il y en a un
                    $proxyUse = $this->container->getParameter("proxyUse");
                    if($proxyUse) {
                        $proxyHost = $this->container->getParameter("proxyHost");
                        $proxyPort = $this->container->getParameter("proxyPort");
                        \Unirest\Request::proxy($proxyHost, $proxyPort, CURLPROXY_HTTP, true);

                        try{
                            $response = \Unirest\Request::get($url,$headers,$query);
                        }
                        catch (\Exception $e) {
                            return false;
                        }
                    }
                    else {
                        return false;
                    }            
                }            
            break;
        }

        return $response;
    }

    private function writelnred($string) { 
        $this->output->writeln('<fg=red>'.$string.'</>');
    }
    private function writeln($string) { 
        $this->output->writeln($string);
    }     
}
