<?php

namespace Cadoles\CoreBundle\Command;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Filesystem\Filesystem;

class TestEtherCommand extends Command
{

    private $container;
    private $em;
    private $output;
    private $filesystem;
    private $rootlog;

    protected function configure()
    {
        $this
            ->setName('Core:testEther')
            ->setDescription('Test API Ether')
            ->setHelp('Test API Ether')
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->container        = $this->getApplication()->getKernel()->getContainer();
        $this->output           = $output;
        $this->filesystem       = new Filesystem();
        $this->rootlog          = $this->container->get('kernel')->getRootDir()."/../var/logs/";
        $this->em               = $this->container->get('doctrine')->getEntityManager();
        
        $this->etherpad = $this->container->get('app.etherpad.service');
        $this->ethercalc = $this->container->get('app.ethercalc.service');
        

        $this->writelnred("ETHERPAD");
        // Création pads
        /*
        $pad=$this->etherpad->createPad("testapinineboard");
        dump($pad);
        */

        // Liste des pads
        $pads=$this->etherpad->listAllPads();
        if($pads) {
            foreach($pads as $pad) {
                $this->writeln($pad);
            }
        }

        // Suppression pad
        /*
        $pad=$this->etherpad->deletePad("testapinineboard");
        dump($pad);
        */


        $this->writelnred("ETHERCALC");

        // Création calc
        /*
        $calc=$this->ethercalc->createCalc("testapinineboard");
        dump($calc);
        */
        
        // Liste de calc
        $calcs=$this->ethercalc->listAllCalcs();
        if($calcs) {
            foreach($calcs as $calc) {
                $this->writeln($calc);
            }
        }        

        // Suppression calc
        /*
        $calc=$this->ethercalc->deleteCalc("testapinineboard");
        dump($calc);
        */
        

        return 1;
    }
    
    function api($method,$url,$query) {
        // Entete
        $headers = ['Accept' => 'application/json'];
    
        // Paramétrage unirest
        \Unirest\Request::verifyPeer(false);
        \Unirest\Request::verifyHost(false);
        \Unirest\Request::timeout(5);
        
        $response = false;
        switch($method) {
            case "POST":
                // Tentative sans proxy
                try{
                    $response = \Unirest\Request::post($url,$headers,$query);
                }
                catch (\Exception $e) {
                    // On tente avec le proxy s'il y en a un
                    $proxyUse = $this->container->getParameter("proxyUse");
                    if($proxyUse) {
                        $proxyHost = $this->container->getParameter("proxyHost");
                        $proxyPort = $this->container->getParameter("proxyPort");
                        \Unirest\Request::proxy($proxyHost, $proxyPort, CURLPROXY_HTTP, true);

                        try{
                            $response = \Unirest\Request::post($url,$headers,$query);
                        }
                        catch (\Exception $e) {
                            return false;
                        }
                    }
                    else {
                        return false;
                    }            
                }
            break;

            case "GET":
                // Tentative sans proxy
                try{
                    $response = \Unirest\Request::get($url,$headers,$query);
                }
                catch (\Exception $e) {
                    // On tente avec le proxy s'il y en a un
                    $proxyUse = $this->container->getParameter("proxyUse");
                    if($proxyUse) {
                        $proxyHost = $this->container->getParameter("proxyHost");
                        $proxyPort = $this->container->getParameter("proxyPort");
                        \Unirest\Request::proxy($proxyHost, $proxyPort, CURLPROXY_HTTP, true);

                        try{
                            $response = \Unirest\Request::get($url,$headers,$query);
                        }
                        catch (\Exception $e) {
                            return false;
                        }
                    }
                    else {
                        return false;
                    }            
                }            
            break;
        }

        return $response;
    }

    private function writelnred($string) { 
        $this->output->writeln('<fg=red>'.$string.'</>');
    }
    private function writeln($string) { 
        $this->output->writeln($string);
    }     
}
