<?php

namespace Cadoles\CoreBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Form\FormError;

use Cadoles\CoreBundle\Entity\Config;
use Cadoles\CoreBundle\Form\ConfigType;
use Cadoles\CoreBundle\Form\DatauserType;

class ConfigController extends Controller
{
    public function homeAction(Request $request)
    {
      	return $this->render('CadolesCoreBundle:Core:config.html.twig',[
            'useheader'     => true,
            'usemenu'       => false,
            'usesidebar'    => true,
        ]);
    }

    public function listAction()
    {
        if($this->getUser()->getRole()!="ROLE_ADMIN") throw $this->createNotFoundException('Permission denied');

        $em = $this->getDoctrine()->getManager();

        $configs = $em->createQueryBuilder()
                      ->select('b')
                      ->from('CadolesCoreBundle:Config',  'b')
                      ->where('b.visible = :visible')
                      ->setParameter('visible', 1)
                      ->addOrderBy('b.order')
                      ->getQuery()
                      ->getResult();

        return $this->render('CadolesCoreBundle:Config:list.html.twig', [
            'useheader'     => true,
            'usemenu'       => false,
            'usesidebar'    => true,
            'configs'       => $configs
        ]);
    }

    public function updateAction($id,Request $request)
    {
        if($this->getUser()->getRole()!="ROLE_ADMIN") throw $this->createNotFoundException('Permission denied');

        // Récupération de l'enregistrement courant
        $config=$this->getConfig($id);

        // Vérifier que cet enregistrement est modifiable
        $type=$config->getType();
        $required=$config->getRequired();
        $visible=$config->getVisible();
        $changeable=$config->getChangeable();
        if(!$visible||!$changeable) {
            return $this->redirectToRoute('cadoles_core_config_commun');
        }

        // Création du formulaire
        $form = $this->createForm(ConfigType::class,$config,array("key" => $id, "type" => $type, "required" => $required));

        // Récupération des data du formulaire
        $form->handleRequest($request);

        // Sur erreur
        $this->getErrorForm($form,$request,$config);

        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $config = $form->getData();
            $em->persist($config);
            $em->flush();

            // Sur type boolean
            if($type=="boolean") {
                $qb = $em->createQueryBuilder();
                $q = $qb->update('CadolesCoreBundle:Config', 'c')
                    ->set('c.visible', ':visible')
                    ->where('c.grouped = :key')
                    ->setParameter('visible', $config->getValue())
                    ->setParameter('key', $id)
                    ->getQuery();
                $q->execute();                
            }
            return $this->redirectToRoute('cadoles_core_config_commun');
        }

        // Affichage du formulaire
        return $this->render('CadolesCoreBundle:Config:update.html.twig', [
            'useheader'     => true,
            'usemenu'       => false,
            'usesidebar'    => true,
            'config'        => $config,
            'type'          => $type,
            'form'          => $form->createView()
        ]);
    }

    public function deleteAction($id,Request $request)
    {
        if($this->getUser()->getRole()!="ROLE_ADMIN") throw $this->createNotFoundException('Permission denied');

        // Récupération de l'enregistrement courant
        $config=$this->getConfig($id);
        if(!$config->getRequired()) {
            $config->setValue("");
            $em = $this->getDoctrine()->getManager();
            $em->persist($config);
            $em->flush();            
        }
        return $this->redirectToRoute('cadoles_core_config_commun',['usesidebar'=>true]);
    }

    public function logoAction()
    {
        if($this->getUser()->getRole()!="ROLE_ADMIN") throw $this->createNotFoundException('Permission denied');

        return $this->render('CadolesCoreBundle:Config:logo.html.twig',[
            'useheader'     => false,
            'usemenu'       => false,
            'usesidebar'    => false,
        ]);
    }

    public function headerAction()
    {
        if($this->getUser()->getRole()!="ROLE_ADMIN") throw $this->createNotFoundException('Permission denied');
        
        return $this->render('CadolesCoreBundle:Config:header.html.twig',[
            'useheader'     => false,
            'usemenu'       => false,
            'usesidebar'    => false,
        ]);
    }

    protected function getConfig($id)
    {
        $em = $this->getDoctrine()->getManager();
        $config = $em->getRepository('CadolesCoreBundle:Config')->find($id);

        if (!$config) {
            throw $this->createNotFoundException('Unable to find config.');
        }

        return $config;
    }

   protected function getErrorForm($form,$request,$data) {
        if ($form->get('submit')->isClicked() && !$form->isValid()) {
            $this->get('session')->getFlashBag()->clear();
            $validator = $this->get('validator');
            $errors = $validator->validate($data);
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }

            $errors = $form->getErrors();
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }
        }
    }
}
