<?php

namespace Cadoles\CoreBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Response;

use Cadoles\CoreBundle\Entity\Group;

class CoreController extends Controller
{
    public function homeAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $user=$this->getUser();
        $masteridentity=$this->getParameter("masteridentity");
        $masterurl=$this->getParameter("masterurl");
        $masterapikey=$this->getParameter("masterapikey");
        
        // Mes scrums / pads
        $myscrums=[];
        $myscrumgroups=[];
        $myscrumgroupwriters=[];
        $myscrumgroupreaders=[];          
        
        $mywhiteboards=[];
        $mywhiteboardgroups=[];
        $mywhiteboardgroupwriters=[];
        $mywhiteboardgroupreaders=[];

        $mypads=[];
        $mypadgroups=[];
        
        $mycalcs=[];
        $mycalcgroups=[];

        if($user) {
            if($masteridentity=="Ninegate") {
                if(stripos($masterurl,"/")===0)
                    $url="https://".$this->getParameter("weburl").$masterurl;
                else
                    $url=$masterurl;
                
                $indomaine = (stripos($url,$this->getParameter("weburl"))!==false);

                // Recherche des élèments de masterIdentify
                $headers = ['Accept' => 'application/json'];
                $query = [];

                /* si hor domaine on utilise le proxy si proxy il y a */
                if(!$indomaine) {
                    $PROXYactivate = $em->getRepository("CadolesCoreBundle:Config")->find("PROXYactivate")->getValue();
                    if($PROXYactivate) {
                        $PROXYserver    = $em->getRepository("CadolesCoreBundle:Config")->find("PROXYserver")->getValue();
                        $PROXYport      = $em->getRepository("CadolesCoreBundle:Config")->find("PROXYport")->getValue();                    
                        \Unirest\Request::proxy($PROXYserver, $PROXYport, CURLPROXY_HTTP, true);
                    }
                }

                // Récupération des informations utilisateurs issus du masteridentity
                $response = \Unirest\Request::post($url.'/rest/user/'.$user->getUsername(),$headers,["key"=>$masterapikey,"only"=>"user,groups"]);
                
                // Récupération de l'avatar
                $user->setAvatar($response->body->user->avatar);

                // Definition du role
                $role=$response->body->user->role;
                if($role=="ROLE_ANIM") $role="ROLE_MASTER";
                $oldrole=$user->getRole();
                if(!is_null($oldrole)) {
                    if($oldrole=="ROLE_ADMIN"&&($role=="ROLE_USER"||$role=="ROLE_MASTER"||$role=="ROLE_MODO")) $role="ROLE_ADMIN";
                    elseif($oldrole=="ROLE_MODO"&&($role=="ROLE_USER"||$role=="ROLE_MASTER")) $role="ROLE_MODO";
                    elseif($oldrole=="ROLE_MASTER"&&$role=="ROLE_USER") $role="ROLE_MASTER";
                }

                $user->setRole($role);
                
                // Mise à jour du user
                $em->persist($user);
                $em->flush();

                // Mise à jour des groupes
                $groups=$response->body->groups;

                foreach($groups as $groupexternal) {
                    // Si un groupe avec le meme nom exise mais avec un id externe différent, il prend l'id externe
                    $group=$em->getRepository("CadolesCoreBundle:Group")->findOneBy(["label"=>$groupexternal->title]);
                    if($group&&$group->getIdexternal()!=$groupexternal->id) {
                        $group->setIdexternal($groupexternal->id);
                        $em->persist($group);
                        $em->flush();                
                    }

                    // Le groupe existe-t-il
                    $group=$em->getRepository("CadolesCoreBundle:Group")->findOneBy(["idexternal"=>$groupexternal->id]);
                    if(!$group)
                        $group = new Group();
                    $group->setIdexternal($groupexternal->id);
                    $group->setLabel($groupexternal->title);
                    $group->setFgtemplate(true);
                    
                    // Si l'utilisateur ne fait partie du groupe on l'ajoute
                    $users=$group->getUsers();
                    if(!$users||!$users->contains($user)) {
                        $group->addUser($user);
                    }

                    $em->persist($group);
                    $em->flush();       
                }
            }

            // Mes scrums / whiteboards / timelines / pads / calcs
            $myscrums=$em->getRepository("CadolesCoreBundle:Scrum")->findBy(["user"=>$user]);
            $mywhiteboards=$em->getRepository("CadolesCoreBundle:Whiteboard")->findBy(["user"=>$user]);
            $mypads=$em->getRepository("CadolesCoreBundle:Etherpad")->findBy(["user"=>$user]);
            $mycalcs=$em->getRepository("CadolesCoreBundle:Ethercalc")->findBy(["user"=>$user]);   

            // Cacul des scrum / pad / calc partagées aux groupes
            $myscrumgroups=$em->getRepository("CadolesCoreBundle:Scrum")->getScrumgroups($user);
            $myscrumgroupwriters=$em->getRepository("CadolesCoreBundle:Scrum")->getScrumgroupwriters($user,$myscrumgroups);
            $myscrumgroupreaders=$em->getRepository("CadolesCoreBundle:Scrum")->getScrumgroupreaders($user,$myscrumgroups,$myscrumgroupwriters);

            $mywhiteboardgroups=$em->getRepository("CadolesCoreBundle:Whiteboard")->getWhiteboardgroups($user);
            $mywhiteboardgroupwriters=$em->getRepository("CadolesCoreBundle:Whiteboard")->getWhiteboardgroupwriters($user,$mywhiteboardgroups);
            $mywhiteboardgroupreaders=$em->getRepository("CadolesCoreBundle:Whiteboard")->getWhiteboardgroupreaders($user,$mywhiteboardgroups,$mywhiteboardgroupwriters);
            
            $mypadgroups=$em->getRepository("CadolesCoreBundle:Etherpad")->getPadgroups($user);

            $mycalcgroups=$em->getRepository("CadolesCoreBundle:Ethercalc")->getCalcgroups($user);         
        }

        return $this->render('CadolesCoreBundle:Core:home.html.twig',[
            'useheader'                 => true,
            'usemenu'                   => false,
            'usesidebar'                => false,              
            'myscrums'                  => $myscrums,
            'myscrumgroups'             => $myscrumgroups,
            'myscrumgroupwriters'       => $myscrumgroupwriters,
            'myscrumgroupreaders'       => $myscrumgroupreaders,
            'mywhiteboards'             => $mywhiteboards,
            'mywhiteboardgroups'        => $mywhiteboardgroups,
            'mywhiteboardgroupwriters'  => $mywhiteboardgroupwriters,
            'mywhiteboardgroupreaders'  => $mywhiteboardgroupreaders,             
            'mypads'                    => $mypads,
            'mypadgroups'               => $mypadgroups,
            'mycalcs'                   => $mycalcs,
            'mycalcgroups'              => $mycalcgroups,
        ]);
    }
}
