<?php

namespace Cadoles\CoreBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\HttpFoundation\File\File;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Symfony\Component\HttpFoundation\ResponseHeaderBag;

use Cadoles\CoreBundle\Entity\Document as Entity;
use Cadoles\CoreBundle\Form\DocumentType as Form;

class DocumentController extends Controller
{
    private $data   = "document";
    private $route  = "app_document";
    private $render = "CadolesCoreBundle:Document:";
    private $entity = "CadolesCoreBundle:Document";

    public function uploadAction($entity,$id,Request $request)
    {
        // Controles d'accès en fonction de l'entité d'arrivé
        if(!$this->ctrlAccessentity($entity,$id,"update")) return $this->redirectToRoute("app_home");

        $modal = $request->get('modal');
        // Rendu
        return $this->render($this->render.'upload.html.twig',[
            'useheader'     => false,
            'usesidebar'    => false,
            'usemenu'       => false,
            'entity'        => $entity,
            'id'            => $id,
            'modal'         => $modal,
        ]);
    }  

    public function recordAction($entity,$id)
    {
        // Controles d'accès en fonction de l'entité d'arrivé
        if(!$this->ctrlAccessentity($entity,$id,"update")) return $this->redirectToRoute("app_home");

        // Rendu
        return $this->render($this->render.'record.html.twig',[
            'useheader'     => false,
            'usesidebar'    => false,
            'usemenu'       => false,
            'entity'        => $entity,
            'id'            => $id,
        ]);
    }  

    public function recorduploadAction($entity,$id,Request $request)
    {
        // Controles d'accès en fonction de l'entité d'arrivé
        if(!$this->ctrlAccessentity($entity,$id,"update")) return $this->redirectToRoute("app_home");

        // Récupérper l'enregistrement
        $content = $request->getContent();
        $name = $request->get('name');

        // Destination
        $directory = $this->getParameter('kernel.project_dir')."/uploads/document/".$entity."/".$id;
        $filename = uniqid().".ogg";

        // Ecrire sur le filesystem
        $fs = new Filesystem();
        $fs->mkdir($directory);
        $fp = fopen($directory."/".$filename, 'wb');
        fwrite($fp, $content);
        fclose($fp);
        
        // Création du document
        $em = $this->getDoctrine()->getManager();
        $document=new Entity();
        $document->setName($name);
        $document->setFilename($filename);
        $document->setRoworder(99999);
        $document->setExtention("ogg");
        $document->setMinetype("video/webm");
        $document->setHavethumb(false);
        $document->setEntity($entity);


        // Rattacher le document à l'entity
        switch($entity) {
            case "scrumwidget":
                $scrumwidget=$em->getRepository("CadolesCoreBundle:Scrumwidget")->find($id);
                $document->setScrumwidget($scrumwidget);
            break;

            case "whiteboardwidget":
                $whiteboardwidget=$em->getRepository("CadolesCoreBundle:Whiteboardwidget")->find($id);
                $document->setWhiteboardwidget($whiteboardwidget);
            break;            
        }

        // Sauvegarde
        $em->persist($document);
        $em->flush();        

        // Retour
        return new Response(json_encode([])); 
    } 

    public function listAction($entity,$id,$master) {
        // Controles d'accès en fonction de l'entité d'arrivé
        if(!$this->ctrlAccessentity($entity,$id,"view")&&$master!="user") return $this->redirectToRoute("app_home");

        // Récupérer les documents
        $em = $this->getDoctrine()->getManager();
        $documents=null;
        switch($entity) {
            case "scrumwidget":
                $scrumwidget=$em->getRepository("CadolesCoreBundle:Scrumwidget")->find($id);
                if($scrumwidget) {
                    $documents=$em->getRepository("CadolesCoreBundle:Document")->findBy(["scrumwidget"=>$scrumwidget]);
                }

                // On détermine les permissions dans le controleur
                if($master=="user") {
                    $master=$this->ctrlAccessentity("scrumwidget",$id,"update");
                }
            break;

            case "whiteboardwidget":
                $whiteboardwidget=$em->getRepository("CadolesCoreBundle:Whiteboardwidget")->find($id);
                if($whiteboardwidget) {
                    $documents=$em->getRepository("CadolesCoreBundle:Document")->findBy(["whiteboardwidget"=>$whiteboardwidget]);
                }

                // On détermine les permissions dans le controleur
                if($master=="user") {
                    $master=$this->ctrlAccessentity("whiteboardwidget",$id,"update");
                }
            break;            
        }

        // Construire le tableau d'id 
        $output=[];

        foreach($documents as $document) {
            $tmp=[
                "id"=>$document->getId(),
                "html"=>$this->thumb($document->getId(),$master),
            ];
            
            array_push($output,$tmp);

        }

        // Retour 
        return new Response(json_encode($output)); 
    }

    public function thumb($id,$master) 
    {
        $em = $this->getDoctrine()->getManager();
        $data=$em->getRepository($this->entity)->find($id);

        $title=$data->getName();
        $filename=$data->getFilename();
        $description=$data->getDescription();
        $extention=$data->getExtention();
        $minetype=$data->getMinetype();
        $minefamily=explode("/",$minetype)[0];

        switch($data->getEntity()) {
            case "scrumwidget" : $identity=$data->getScrumwidget()->getId(); break;
            case "whiteboardwidget" : $identity=$data->getWhiteboardwidget()->getId(); break;
        }
        if($data->getHavethumb()) {
            $directory    = $this->getParameter('kernel.project_dir') . '/uploads/document/'.$data->getEntity()."/".$identity; 
            $dataimg = file_get_contents($directory."/thumb/".$filename);
            $url="data:image/" . $extention . ";base64," . base64_encode($dataimg);
        }
        else {
            $url="/".$this->getParameter("alias")."/bundles/cadolescore/images/files/".$extention.".png";
        }


        return $this->renderView($this->render.'render.html.twig',[
            'entity'            => $data->getEntity(),
            'id'                => $id,
            'identity'          => $identity,
            'title'             => $title,
            'description'       => $description,
            'url'               => $url,
            'extention'         => $extention,
            'minefamily'        => $minefamily,
            'master'            => $master,
        ]);        
    }

    public function viewAction($entity,$id) {
        // Controles d'accès sur le document
        if(!$this->ctrlAccessdocument($entity,$id,"view")) return $this->redirectToRoute("app_home");

        $em = $this->getDoctrine()->getManager();
        $data=$em->getRepository($this->entity)->find($id);

        switch($data->getEntity()) {
            case "scrumwidget" : $identity=$data->getScrumwidget()->getId(); break;
            case "whiteboardwidget" : $identity=$data->getWhiteboardwidget()->getId(); break;
        }

        $directory= $this->getParameter('kernel.project_dir') . '/uploads/document/'.$entity."/".$identity;
        $url=$directory."/".$data->getFilename();
        $file = new file($url);

        $minetype=$file->getMimeType();
        $minefamily=explode("/",$minetype)[0];

        if($minefamily=="text" || $minefamily=="image") {
            $image="";
            if($minefamily=="image") {
                $image = "data:image/" . $file->getExtension() . ";base64," . base64_encode(file_get_contents($url));
            }

            return $this->render($this->render.'view.html.twig',[
                'useheader'     => false,
                'usesidebar'    => false,
                'usemenu'       => false,
                'entity'        => $entity,
                'id'            => $id,
                'minefamily'    => $minefamily,
                'image'         => $image
            ]);
        }
        else {
            $response = new BinaryFileResponse($file);
            $response->setContentDisposition(ResponseHeaderBag::DISPOSITION_INLINE);
            
            return $response;
        }
    }    

    public function showAction($entity,$id) {
        // Controles d'accès sur le document
        if(!$this->ctrlAccessdocument($entity,$id,"view")) return $this->redirectToRoute("app_home");

        $em = $this->getDoctrine()->getManager();
        $data=$em->getRepository($this->entity)->find($id);

        switch($data->getEntity()) {
            case "scrumwidget" : $identity=$data->getScrumwidget()->getId(); break;
            case "whiteboardwidget" : $identity=$data->getWhiteboardwidget()->getId(); break;
        }

        $directory= $this->getParameter('kernel.project_dir') . '/uploads/document/'.$entity."/".$identity;
        $url=$directory."/".$data->getFilename();
        $file = new file($url);

        $response = new BinaryFileResponse($file);
        $name= ($data->getName()==$data->getFilename()?$data->getFilename():$data->getName().'.'.$data->getExtention());
        $response->setContentDisposition(
            ResponseHeaderBag::DISPOSITION_ATTACHMENT,
            $name
        );

        return $response;
    }

    public function updateAction($entity,$id,Request $request)
    {
        // Controles d'accès sur le document
        if(!$this->ctrlAccessdocument($entity,$id,"update")) return $this->redirectToRoute("app_home");

        // Initialisation de l'enregistrement
        $em = $this->getDoctrine()->getManager();
        $data=$em->getRepository($this->entity)->find($id);

        // On récupère l'id parent
        $idparent=null;
        $typeparent=null;
        if($data->getScrumwidget()) {
            $typeparent="scrum";
            $idparent=$data->getScrumwidget()->getScrumcolumn()->getScrum()->getId();            
        }
        elseif($data->getWhiteboardwidget()) {
            $typeparent="whiteboard";
            $idparent=$data->getWhiteboardwidget()->getWhiteboard()->getId();
        }

        // Création du formulaire
        $form = $this->createForm(Form::class,$data,array("mode"=>"update","type"=>$typeparent,"id"=>$idparent));

        // Récupération des data du formulaire
        $form->handleRequest($request);

        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {  
            $data = $form->getData();  
            $em->persist($data);
            $em->flush();
            
            return $this->render($this->render.'close.html.twig', [
                'useheader'         => false,
                'usesidebar'        => false,      
                'usemenu'           => false,   
            ]);
        }
        
        // Affichage du formulaire
        return $this->render($this->render.'edit.html.twig', [
            'useheader'         => false,
            'usesidebar'        => false,      
            'usemenu'           => false,           
            $this->data         => $data,
            'mode'              => 'update',
            'form'              => $form->createView(),
        ]);
    }  

    public function deleteAction($entity,$id,Request $request)
    {
        // Controles d'accès sur le document
        if(!$this->ctrlAccessdocument($entity,$id,"update")) return $this->redirectToRoute("app_home");

        // Initialisation de l'enregistrement
        $em = $this->getDoctrine()->getManager();
        $data=$em->getRepository($this->entity)->find($id);

        // Création du formulaire
        $form = $this->createForm(Form::class,$data,array("mode"=>"update"));

        // Récupération des data du formulaire
        $form->handleRequest($request);
       
        if($data) {
            $em->remove($data);
            $em->flush();

            
            return $this->render($this->render.'close.html.twig', [
                'useheader'         => false,
                'usesidebar'        => false,      
                'usemenu'           => false,   
            ]);
        }

        // Affichage du formulaire
        return $this->render($this->render.'edit.html.twig', [
            'useheader'         => false,
            'usesidebar'        => false, 
            'usemenu'           => false,                
            $this->data         => $data,
            'mode'              => 'update',
            'form'              => $form->createView(),
        ]);
    }
    
    private function ctrlAccessentity($entity,$id,$mode) {
        // Initialisation de l'enregistrement
        $em = $this->getDoctrine()->getManager();
        
        switch($entity) {
            case "scrumwidget" :
                $data=$em->getRepository("CadolesCoreBundle:Scrumwidget")->find($id);
                if(!$data) return false;
                
                $user=$this->getUser();
                $isadmin=($user->Hasrole("ROLE_ADMIN")||$user->Hasrole("ROLE_MODO"));
                $ismaster=($user==$data->getScrumcolumn()->getScrum()->getUser());
                $isowner=($user==$data->getUser());
                if($isadmin || $ismaster) return true;

                // Accès en lecture / écriture
                $groups=$data->getScrumcolumn()->getScrum()->getGroups();
                foreach($groups as $group) {
                    $ismember=($group->getUsers()->contains($this->getUser()));
                    if($ismember) return true;
                }

                $groups=$data->getScrumcolumn()->getScrum()->getGroupwriters();
                foreach($groups as $group) {
                    $ismember=($group->getUsers()->contains($this->getUser()));
                    if($ismember&&$isowner) return true;
                }

                $users=$data->getScrumcolumn()->getScrum()->getUsers();
                $ismember=($users->contains($this->getUser()));
                if($ismember) return true;

                $users=$data->getScrumcolumn()->getScrum()->getUserwriters();
                $ismember=($users->contains($this->getUser()));
                if($ismember&&$isowner) return true;

                // Accès en lecture
                if($mode=="update") return false;

                $groups=$data->getScrumcolumn()->getScrum()->getGroupreaders();
                foreach($groups as $group) {
                    $ismember=($group->getUsers()->contains($this->getUser()));
                    if($ismember) return true;
                }

                $users=$data->getScrumcolumn()->getScrum()->getUserreaders();
                $ismember=($users->contains($this->getUser()));
                if($ismember) return true;               

                return false;
            break;

            case "whiteboardwidget" :
                $data=$em->getRepository("CadolesCoreBundle:Whiteboardwidget")->find($id);
                if(!$data) return false;
                
                $user=$this->getUser();
                $isadmin=($user->Hasrole("ROLE_ADMIN")||$user->Hasrole("ROLE_MODO"));
                $ismaster=($user==$data->getWhiteboard()->getUser());
                $isowner=($user==$data->getUser());
                if($isadmin || $ismaster) return true;

                // Accès en lecture / écriture
                $groups=$data->getWhiteboard()->getGroups();
                foreach($groups as $group) {
                    $ismember=($group->getUsers()->contains($this->getUser()));
                    if($ismember) return true;
                }

                $groups=$data->getWhiteboard()->getGroupwriters();
                foreach($groups as $group) {
                    $ismember=($group->getUsers()->contains($this->getUser()));
                    if($ismember&&$isowner) return true;
                }

                $users=$data->getWhiteboard()->getUsers();
                $ismember=($users->contains($this->getUser()));
                if($ismember) return true;

                $users=$data->getWhiteboard()->getUserwriters();
                $ismember=($users->contains($this->getUser()));
                if($ismember&&$isowner) return true;

                // Accès en lecture
                if($mode=="update") return false;

                $groups=$data->getWhiteboard()->getGroupreaders();
                foreach($groups as $group) {
                    $ismember=($group->getUsers()->contains($this->getUser()));
                    if($ismember) return true;
                }

                $users=$data->getWhiteboard()->getUserreaders();
                $ismember=($users->contains($this->getUser()));
                if($ismember) return true;               

                return false;
            break;            
        }

        return true;
    }

    private function ctrlAccessdocument($entity,$id,$mode) {
        // Initialisation de l'enregistrement
        $em = $this->getDoctrine()->getManager();
        
        $document=$em->getRepository($this->entity)->find($id);
        if(!$document) return false;
        
        switch($entity) {
            case "scrumwidget" :
                $data=$document->getScrumwidget();        
                return $this->ctrlAccessentity($entity,$data->getId(),$mode);
            break;

            case "whiteboardwidget" :
                $data=$document->getWhiteboardwidget();        
                return $this->ctrlAccessentity($entity,$data->getId(),$mode);
            break;            
        }

        return true;
    }

}
