<?php

namespace Cadoles\CoreBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Filesystem\Filesystem;

use Cadoles\CoreBundle\Entity\Etherpad;
use Cadoles\CoreBundle\Form\EtherpadType;

class EtherpadController extends Controller
{
    private $labelentity="CadolesCoreBundle:Etherpad";

    public function listAction(Request $request) {
        $em = $this->getDoctrine()->getManager();
        $entitys = $em->getRepository($this->labelentity)->findAll();

        return $this->render($this->labelentity.':list.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,   
            'maxwidth'          => false,           
            'entitys'           => $entitys
        ]);
    }

    public function submitAction(Request $request,$access="user") {
        $entity = new Etherpad();

        $form = $this->createForm(EtherpadType::class, $entity, ["mode" => "submit", "access" => $access]);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            if($access=="user") $entity->setUser($this->getUser());

            $em->persist($entity);
            $em->flush();

            // Création du pad dans etherpad
            $serviceetherpad = $this->container->get('app.etherpad.service');
            $serviceetherpad->createPad($entity->getTitle());

            if($access=="user")
                return $this->redirect($this->generateUrl('cadoles_core_home'));          
            else 
                return $this->redirect($this->generateUrl('cadoles_core_config_etherpad'));          
        }

        return $this->render($this->labelentity.':edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),   
            'maxwidth'          => ($access=="user"),           
            'entity'            => $entity,
            'mode'              => "submit",
            'form'              => $form->createView(),
            'access'            => $access
        ]);
    }

    public function updateAction($id, Request $request,$access="user") {
        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository($this->labelentity)->find($id);
        if (!$entity) throw $this->createNotFoundException('Unable to find entity.');

        if($entity->getUser()!=$this->getUser()&&$this->getUser()->getRole()!="ROLE_ADMIN"&&$this->getUser()->getRole()!="ROLE_MODO")
        throw $this->createNotFoundException('Permission denied');

        $form = $this->createForm(EtherpadType::class, $entity, ["mode" => "update", "access" => $access]);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em->persist($entity);
            $em->flush();

            // Création du pad dans etherpad
            $serviceetherpad = $this->container->get('app.etherpad.service');
            $serviceetherpad->createPad($entity->getTitle());

            if($access=="user")
                return $this->redirect($this->generateUrl('cadoles_core_home'));          
            else
                return $this->redirect($this->generateUrl('cadoles_core_config_etherpad'));                          
        }

        return $this->render($this->labelentity.':edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),   
            'maxwidth'          => ($access=="user"),           
            'entity'            => $entity,
            'mode'              => "update",
            'form'              => $form->createView(),
            'access'            => $access
        ]);
    }

    public function deleteAction($id, Request $request,$access="user") {
        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository($this->labelentity)->find($id);
        if (!$entity) throw $this->createNotFoundException('Unable to find entity.');

        if($entity->getUser()!=$this->getUser()&&$this->getUser()->getRole()!="ROLE_ADMIN"&&$this->getUser()->getRole()!="ROLE_MODO")
        throw $this->createNotFoundException('Permission denied');

        $em->remove($entity);
        $em->flush();

        // Suppression du pad dans etherpad
        $serviceetherpad = $this->container->get('app.etherpad.service');
        $serviceetherpad->deletePad($entity->getTitle());

        if($access=="user")
            return $this->redirect($this->generateUrl('cadoles_core_home'));          
        else
            return $this->redirect($this->generateUrl('cadoles_core_config_etherpad'));          
    }    
}
