<?php

namespace Cadoles\CoreBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Form\FormError;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Symfony\Component\HttpFoundation\ResponseHeaderBag;
use Symfony\Component\Finder\Finder;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\HttpFoundation\File\File;

class FileController extends Controller
{
    public function uploadAction($id,$type,$access="config")
    {
        return $this->render('CadolesCoreBundle:File:upload.html.twig',[
            'useheader'     => false,
            'usemenu'       => false,
            'usesidebar'    => false,
            'access'        => $access,
            'id'            => $id,
            'type'          => $type,
        ]);
    }  

    public function deleteAction(Request $request,$access="config")
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }

        $output=array();
        $directory=$request->request->get('directory');
        $filename=$request->request->get('filename');

        $this->getPermission($access,$directory);
        $fs = new Filesystem();
        $url=$this->get('kernel')->getRootDir()."/../uploads/file/".$directory."/".$filename;
        if($fs->exists($url)) {
            $fs->remove($url);
        }

        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');        
        return $response;                
    }

    public function viewAction($directory,$filename,Request $request,$access="config")
    {
        $this->getPermission($access,$directory);

        $navigation = $request->query->get('navigation');
        $tbprev=[];
        $tbnext=[];

        $url=$this->get('kernel')->getRootDir()."/../uploads/file/".$directory."/".$filename;
        $file = new file($url);

        
        $minetype=$file->getMimeType();
        $minefamily=explode("/",$minetype)[0];

        if($minefamily=="text" || $minefamily=="image" || $minetype == "application/pdf") {
            $image="";
            if($minefamily=="image") {
                $image = "data:image/" . $file->getExtension() . ";base64," . base64_encode(file_get_contents($url));

                if($navigation) {
                    $dir=$this->get('kernel')->getRootDir()."/../uploads/file/".$directory;
                    $files=[];
                    $fs = new Filesystem();
            
                    if($fs->exists($dir)) {
                        $finder = new Finder();
                        $finder->sortByName()->in($dir)->exclude('thumb');
                        
                        $i=-1;


                        foreach ($finder as $key => $file) {
                            $i++;

                            if($file->getRelativePathname()==$filename) {
                                $keyprev=$i-1;
                                $keynext=$i+1;
                            }

                            $tmp=[];
                            $tmp["name"]=$file->getRelativePathname();
                            $tmp["extension"]=$file->getExtension();
                            $fileinfo = new file($file->getPathname());
                            $tmp["minetype"]=$fileinfo->getMimeType();
                            $tmp["minefamily"]=explode("/",$tmp["minetype"])[0];
            
                            $tmp["thumb"]="";
                            if($fs->exists($dir."/thumb/".$tmp["name"])) {
                                $data = file_get_contents($dir."/thumb/".$tmp["name"]);
                                $tmp["thumb"]="data:image/" . $tmp["extension"] . ";base64," . base64_encode($data);
                            }
                            
                            array_push($files,$tmp);
                        }
                        
                        if(array_key_exists($keyprev,$files))
                            $tbprev=$files[$keyprev];
                        if(array_key_exists($keynext,$files))
                            $tbnext=$files[$keynext];
                    }
                }                
            }

            return $this->render('CadolesCoreBundle:File:view.html.twig',[
                'useheader'     => false,
                'usemenu'       => false,
                'usesidebar'    => false,
                'access'        => $access,
                'directory'     => $directory,
                'minefamily'    => $minefamily,
                'minetype'      => $minetype,
                'filename'      => $filename,
                'image'         => $image,
                'prev'          => $tbprev,
                'next'          => $tbnext
            ]);
        }
        else {
            // normalement le widget ne fait jamais passer par là
            $response = new BinaryFileResponse($file);
            $response->setContentDisposition(ResponseHeaderBag::DISPOSITION_INLINE);
            
            return $response;
        }
    }

    public function showAction($directory,$filename,$access="config")
    {
        $this->getPermission($access,$directory);

        $file=$this->get('kernel')->getRootDir()."/../uploads/file/".$directory."/".$filename;

        $response = new BinaryFileResponse($file);
        $response->setContentDisposition(ResponseHeaderBag::DISPOSITION_INLINE);
        
        return $response;
    }

    public function downloadAction($directory,$filename,$access="config")
    {
        $this->getPermission($access,$directory);

        $file=$this->get('kernel')->getRootDir()."/../uploads/file/".$directory."/".$filename;

        $response = new BinaryFileResponse($file);
        $response->setContentDisposition(ResponseHeaderBag::DISPOSITION_ATTACHMENT);
        
        return $response;
    }    

    public function getPermission($access, $directory) {
        if($access=="user") {
            $em = $this->getDoctrine()->getManager();

            $type=explode("-",$directory)[0];
            $id=explode("-",$directory)[1];

            switch($type) {
                case "widget":
                    // Récupération du widget
                    $widget=$em->getRepository("CadolesPortalBundle:Pagewidget")->find($id);
                    if (!$widget) throw $this->createNotFoundException('Unable to find entity.');

                    // On s'assure que l'utilisateur à la permission de voir
                    $page=$widget->getPage();
                    $em->getRepository("CadolesPortalBundle:Page")->getPermission($this->getUser(),$page,$cansee,$canupdate);
                    if(!$cansee) throw $this->createNotFoundException('Permission denied');                
                break;
            }
        }
    }
}
