<?php

namespace Cadoles\CoreBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Filesystem\Filesystem;

use Cadoles\CoreBundle\Entity\Scrum;
use Cadoles\CoreBundle\Form\ScrumType;

class GroupController extends Controller
{
    private $labelentity="CadolesCoreBundle:Group";

    public function ajaxlistAction(Request $request, $access="user")
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }

        $output=array();
        $em = $this->getDoctrine()->getManager();
        $page_limit=$request->query->get('page_limit');
        $q=$request->query->get('q');
        
        if($this->getUser()) {
            if($access=="user")
                $groups=$this->getUser()->getGroups();
            else {
                $qb = $em->createQueryBuilder();
                $qb->select('table')->from("CadolesCoreBundle:Group",'table')
                ->where('table.label LIKE :value')
                ->setParameter("value", "%".$q."%")
                ->orderBy('table.label');
                $groups=$qb->setFirstResult(0)->setMaxResults($page_limit)->getQuery()->getResult();
            }

            foreach($groups as $group) {
                array_push($output,array("id"=>$group->getId(),"text"=>$group->getLabel()));
            }
        }

        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');      
        return $response;
    }


}
