<?php

namespace Cadoles\CoreBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Symfony\Component\HttpFoundation\ResponseHeaderBag;
use Doctrine\ORM\Mapping\ClassMetadata;
use Doctrine\ORM\Id\AssignedGenerator;
use Symfony\Component\Finder\Finder;

use Cadoles\CoreBundle\Entity\Scrum;
use Cadoles\CoreBundle\Entity\Scrumcolumn;
use Cadoles\CoreBundle\Entity\Scrumwidget;
use Cadoles\CoreBundle\Entity\Document;
use Cadoles\CoreBundle\Entity\Message;

use Cadoles\CoreBundle\Form\ScrumType;


class ScrumController extends Controller
{
    private $labelentity="CadolesCoreBundle:Scrum";

    public function listAction(Request $request) {
        $em = $this->getDoctrine()->getManager();
        $entitys = $em->getRepository($this->labelentity)->findAll();

        return $this->render($this->labelentity.':list.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,   
            'maxwidth'          => false,           
            'entitys'           => $entitys
        ]);
    }

    public function viewAction($id, Request $request, $access="user")
    {
        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository($this->labelentity)->find($id);
        if (!$entity) throw $this->createNotFoundException('Unable to find entity.');

        $perm = $this->perm($entity);

        $form = $this->createForm(ScrumType::class,$entity, ["mode" => "view", "access" => $access, "id" => $id]);
        return $this->render($this->labelentity.':view.html.twig',[
            'useheader'     => true,
            'usemenu'       => false,
            'usesidebar'    => ($access=="config"),   
            'maxwidth'      => false,           
            'entity'        => $entity,
            'form'          => $form->createView(),
            'access'        => $access,
            'perm'          => $perm
        ]);
    }

    public function imageAction($id)
    {
        return $this->render($this->labelentity.':image.html.twig',[
            "id"=>$id,
            'useheader'     => false,
            'usemenu'       => false,
            'usesidebar'    => false,   
        ]);
    }

    public function messageAction(Request $request, $access="user")
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }

        $id=$request->request->get('id');
        $em = $this->getDoctrine()->getManager();
        $data=$em->getRepository("CadolesCoreBundle:Scrumwidget")->find($id);
        if (!$data) return new JsonResponse(array('message' => 'Interdit'), 400);
        $perm = $this->perm($data->getScrumColumn()->getScrum());

        $messages=$em->getRepository("CadolesCoreBundle:Message")->findBy(["scrumwidget"=>$data],["submitdate"=>"DESC"]);
        $output=[];
        foreach($messages as $message) {
            $msg=$message->getMessage();
            $username=$message->getUser()->getUsername();

            $fgcandel=false;
            if($message->getUser()==$this->getUser()) $fgcandel=true;
            if($data->getUser()==$this->getUser()) $fgcandel=true;
            if($data->getScrumcolumn()->getScrum()->getUser()==$this->getUser()) $fgcandel=true;

            array_push($output, [
                "idwid" => $data->getId(),
                "idmsg" => $message->getId(),
                "message" => $msg,
                "date" => $message->getSubmitdate()->format("d/m/Y H:i"),
                "username" => $username,
                "fgcandel" => $fgcandel,
            ]);
        }

        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');      
        return $response;        
        
    }

    public function submitAction(Request $request, $access="user") {
        $entity = new Scrum();

        $form = $this->createForm(ScrumType::class, $entity, ["mode" => "submit", "access" => $access]);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            if($access=="user") $entity->setUser($this->getUser());

            $em->persist($entity);
            $em->flush();

            return $this->redirect($this->generateUrl('cadoles_core_'.$access.'_scrum_view',["id"=>$entity->getId()]));          
        }

        return $this->render($this->labelentity.':edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),   
            'maxwidth'          => ($access=="user"),           
            'entity'            => $entity,
            'mode'              => "submit",
            'form'              => $form->createView(),
            'access'            => $access,
        ]);
    }

    public function updateAction($id, Request $request, $access="user") {
        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository($this->labelentity)->find($id);
        if (!$entity) throw $this->createNotFoundException('Unable to find entity.');

        if($entity->getUser()!=$this->getUser()&&$this->getUser()->getRole()!="ROLE_ADMIN"&&$this->getUser()->getRole()!="ROLE_MODO")
        throw $this->createNotFoundException('Permission denied');

        $form = $this->createForm(ScrumType::class, $entity, ["mode" => "update", "access" => $access]);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em->persist($entity);
            $em->flush();

            return $this->redirect($this->generateUrl('cadoles_core_'.$access.'_scrum_view',["id"=>$entity->getId()]));          
        }

        return $this->render($this->labelentity.':edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),   
            'maxwidth'          => ($access=="user"),           
            'entity'            => $entity,
            'mode'              => "update",
            'form'              => $form->createView(),
            'access'            => $access,
        ]);
    }

    public function deleteAction($id, Request $request, $access="user") {
        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository($this->labelentity)->find($id);
        if (!$entity) throw $this->createNotFoundException('Unable to find entity.');

        if($entity->getUser()!=$this->getUser()&&$this->getUser()->getRole()!="ROLE_ADMIN"&&$this->getUser()->getRole()!="ROLE_MODO")
        throw $this->createNotFoundException('Permission denied');

        $em->remove($entity);
        $em->flush();

        if($access=="user")
            return $this->redirect($this->generateUrl('cadoles_core_home'));          
        else
            return $this->redirect($this->generateUrl('cadoles_core_config_scrum'));          
    }    

    public function uploadAction($id,Request $request, $access="user") {
        // Fichier temporaire uploadé
        $tmpfile    = $request->files->get('upload');
        $extention  = $tmpfile->getClientOriginalExtension();

        // Répertoire de Destination
        $fs         = new Filesystem();
        $rootdir    = $this->get('kernel')->getRootDir()."/../web";
        $fs->mkdir($rootdir."/uploads/scrum");
        $fs->mkdir($rootdir."/uploads/scrum/$id");
        
        // Fichier cible
        $targetName = uniqid().".".$extention;
        $targetFile = $rootdir."/uploads/scrum/$id/".$targetName;
        $targetUrl  = "/".$this->getParameter('alias')."/uploads/scrum/$id/".$targetName;
        $message    = "";

        move_uploaded_file($tmpfile,$targetFile);
        
        $output["uploaded"]=1;
        $output["fileName"]=$targetName;
        $output["url"]=$targetUrl;

        return new Response(json_encode($output));
    }


    public function exportAction($id, Request $request, $access="user") {
        $em = $this->getDoctrine()->getManager();
        $scrum=$em->getRepository($this->labelentity)->find($id);
        if (!$scrum) throw $this->createNotFoundException('Unable to find entity.');

        if($scrum->getUser()!=$this->getUser()&&!$this->getUser()->hasRole("ROLE_ADMIN")&&!$this->getUser()->hasRole("ROLE_MODO")) 
        throw $this->createNotFoundException('Permission denied');

        $fs = new Filesystem();
        $rootdir = $this->get('kernel')->getRootDir()."/..";
        $destdir = $rootdir."/uploads/export/scrum/$id";
        $destdir=str_replace("app/../","",$destdir);

        // Regénération du répertoire d'export
        $fs->remove($destdir);
        $fs->mkdir($rootdir."/uploads");
        $fs->mkdir($rootdir."/uploads/export");
        $fs->mkdir($rootdir."/uploads/export/scrum");
        $fs->mkdir($rootdir."/uploads/export/scrum/$id");
        $fs->mkdir($rootdir."/uploads/export/scrum/$id/public");
        $fs->mkdir($rootdir."/uploads/export/scrum/$id/public/scrum");
        $fs->mkdir($rootdir."/uploads/export/scrum/$id/public/document");
        $fs->mkdir($rootdir."/uploads/export/scrum/$id/private");
        $fs->mkdir($rootdir."/uploads/export/scrum/$id/private/scrum");
        $fs->mkdir($rootdir."/uploads/export/scrum/$id/private/document");

        // Création du json d'export
        $export = new \stdClass();
        $export->type = "scrum";
        $export->id = $scrum->getId();
        $export->title = $scrum->getTitle();
        $export->fgcomment = $scrum->getFgcomment();
        $export->user = $scrum->getUser()->getId();

        $export->groups = [];
        $groups=$scrum->getGroups();
        foreach($groups as $group) {
            $idgrp=$group->getId();
            $export->groups[$idgrp] = new \stdClass();
            $export->groups[$idgrp]->id=$idgrp;
        }
        
        $export->groupwriters = [];
        $groups=$scrum->getGroupwriters();
        foreach($groups as $group) {
            $idgrp=$group->getId();
            $export->groupwriters[$idgrp] = new \stdClass();
            $export->groupwriters[$idgrp]->id=$idgrp;
        }            
        
        $export->groupreaders = [];
        $groups=$scrum->getGroupreaders();
        foreach($groups as $group) {
            $idgrp=$group->getId();
            $export->groupreaders[$idgrp] = new \stdClass();
            $export->groupreaders[$idgrp]->id=$idgrp;
        } 

        $export->users = [];
        $users=$scrum->getUsers();
        foreach($users as $user) {
            $idusr=$user->getId();
            $export->users[$idusr] = new \stdClass();
            $export->users[$idusr]->id=$idusr;
        }
        
        $export->userwriters = [];
        $users=$scrum->getUserwriters();
        foreach($users as $user) {
            $idusr=$user->getId();
            $export->userwriters[$idusr] = new \stdClass();
            $export->userwriters[$idusr]->id=$idusr;
        }            
        
        $export->userreaders = [];
        $users=$scrum->getUserreaders();
        foreach($users as $user) {
            $idusr=$user->getId();
            $export->userreaders[$idusr] = new \stdClass();
            $export->userreaders[$idusr]->id=$idusr;
        } 

        $export->columns = [];
        $scrumcolumns = $scrum->getScrumcolumns();
        foreach($scrumcolumns as $scrumcolumn) {
            $idcol=$scrumcolumn->getId();
            $export->columns[$idcol] = new \stdClass();
            $export->columns[$idcol]->id=$idcol;
            $export->columns[$idcol]->title=$scrumcolumn->getTitle();
            $export->columns[$idcol]->roworder=$scrumcolumn->getRoworder();
            $export->columns[$idcol]->size=$scrumcolumn->getSize();

            $export->columns[$idcol]->widgets = [];
            $scrumwidgets = $scrumcolumn->getScrumwidgets();
            foreach($scrumwidgets as $scrumwidget) {
                $idwid=$scrumwidget->getId();
                $export->columns[$idcol]->widgets[$idwid] = new \stdClass();
                $export->columns[$idcol]->widgets[$idwid]->id=$idwid;
                $export->columns[$idcol]->widgets[$idwid]->title=$scrumwidget->getTitle();
                $export->columns[$idcol]->widgets[$idwid]->description=$scrumwidget->getDescription();
                $export->columns[$idcol]->widgets[$idwid]->filetype=$scrumwidget->getFiletype();
                $export->columns[$idcol]->widgets[$idwid]->file=$scrumwidget->getFile();
                $export->columns[$idcol]->widgets[$idwid]->roworder=$scrumwidget->getRoworder();
                $export->columns[$idcol]->widgets[$idwid]->user=($scrumwidget->getUser()?$scrumwidget->getUser()->getId():$scrum->getUser()->getId());
                
                $export->columns[$idcol]->widgets[$idwid]->documents = [];
                $documents=$scrumwidget->getScrumwidgetdocuments();
                foreach($documents as $document) {
                    $iddoc=$document->getId();
                    $export->columns[$idcol]->widgets[$idwid]->documents[$iddoc] = new \stdClass();
                    $export->columns[$idcol]->widgets[$idwid]->documents[$iddoc]->id=$iddoc;
                    $export->columns[$idcol]->widgets[$idwid]->documents[$iddoc]->name=$document->getName();
                    $export->columns[$idcol]->widgets[$idwid]->documents[$iddoc]->filename=$document->getFilename();
                    $export->columns[$idcol]->widgets[$idwid]->documents[$iddoc]->description=$document->getDescription();
                    $export->columns[$idcol]->widgets[$idwid]->documents[$iddoc]->entity=$document->getEntity();
                    $export->columns[$idcol]->widgets[$idwid]->documents[$iddoc]->roworder=$document->getRoworder();
                    $export->columns[$idcol]->widgets[$idwid]->documents[$iddoc]->extention=$document->getExtention();
                    $export->columns[$idcol]->widgets[$idwid]->documents[$iddoc]->minetype=$document->getMinetype();
                    $export->columns[$idcol]->widgets[$idwid]->documents[$iddoc]->havethumb=$document->getHavethumb();
                }

                $export->columns[$idcol]->widgets[$idwid]->messages = [];
                $messages=$scrumwidget->getMessages();
                foreach($messages as $message) {
                    $idmsg=$message->getId();
                    $export->columns[$idcol]->widgets[$idwid]->messages[$idmsg] = new \stdClass();
                    $export->columns[$idcol]->widgets[$idwid]->messages[$idmsg]->id=$idmsg;
                    $export->columns[$idcol]->widgets[$idwid]->messages[$idmsg]->message=$message->getMessage();
                    $export->columns[$idcol]->widgets[$idwid]->messages[$idmsg]->submitdate=$message->getSubmitdate()->format("Y-m-d H:i");
                    $export->columns[$idcol]->widgets[$idwid]->messages[$idmsg]->user=$message->getUser()->getId();
                }

                // Copier les documents
                if($fs->exists($rootdir."/uploads/document/scrumwidget/$idwid")) $fs->mirror($rootdir."/uploads/document/scrumwidget/$idwid", $destdir."/private/document/$idwid");
            }
        }

        // Copier les fichiers  public/privé
        if($fs->exists($rootdir."/web/uploads/scrum/$id")) $fs->mirror($rootdir."/web/uploads/scrum/$id", $destdir."/public/scrum/$id");
        if($fs->exists($rootdir."/uploads/scrum/$id")) $fs->mirror($rootdir."/uploads/scrum/$id", $destdir."/private/scrum/$id");

        
        file_put_contents($destdir."/info.json",json_encode($export));
        $zipName=$rootdir."/uploads/export/scrum-$id.zip";
        $tool = $this->container->get('app.tool.service');
        $tool->zip($destdir,$zipName);

        $response = new BinaryFileResponse($zipName);
        $response->setContentDisposition(ResponseHeaderBag::DISPOSITION_INLINE);
        return $response;
    }


    public function importAction(Request $request, $access="user") {
        return $this->render($this->labelentity.':import.html.twig',[
            'useheader'     => true,
            'usemenu'       => false,
            'usesidebar'    => ($access=="admin"),
            'access'        => $access
        ]);
    }

    public function importzipAction($access="user")
    {
        return $this->render($this->labelentity.':importzip.html.twig',[
            'useheader'     => false,
            'usemenu'       => false,
            'usesidebar'    => false,
            'access'        => $access
        ]);
    }
    
    public function importexecAction(Request $request,$access="user")
    {
        if (!$request->isXmlHttpRequest()) return new JsonResponse(array('message' => 'Interdit'), 400);

        $em = $this->getDoctrine()->getManager();
        $metadata =  $em->getClassMetaData($this->labelentity);
        $metadata->setIdGeneratorType(ClassMetadata::GENERATOR_TYPE_NONE);
        $metadata->setIdGenerator(new AssignedGenerator());

        $metadata =  $em->getClassMetaData("CadolesCoreBundle:Scrumcolumn");
        $metadata->setIdGeneratorType(ClassMetadata::GENERATOR_TYPE_NONE);
        $metadata->setIdGenerator(new AssignedGenerator());
        
        $metadata =  $em->getClassMetaData("CadolesCoreBundle:Scrumwidget");
        $metadata->setIdGeneratorType(ClassMetadata::GENERATOR_TYPE_NONE);
        $metadata->setIdGenerator(new AssignedGenerator());
        
        $metadata =  $em->getClassMetaData("CadolesCoreBundle:Document");
        $metadata->setIdGeneratorType(ClassMetadata::GENERATOR_TYPE_NONE);
        $metadata->setIdGenerator(new AssignedGenerator());

        $output=array();

        // Décompresser le fichier zip et controler son format
        $rootdir = $this->get('kernel')->getRootDir()."/../";
        $rootdir = str_replace("app/../","",$rootdir);

        $zip = $rootdir.$request->request->get('file');
        $tmp=explode("/",$zip);
        $tmp=explode(".",end($tmp));
        $id=$tmp[0];
        $destdir = $rootdir."uploads/import/$id";

        $tool = $this->container->get('app.tool.service');
        $unzipped = $tool->unzip($zip,$destdir);
        $error="";
        if(!$unzipped) 
            return $this->importreturnerror("<p>Votre fichier ZIP n'a pas pu être décompressé<p>");
        else {
            // Chargement du fichier json associé
            $json=file_get_contents($destdir."/info.json");
            if(!$json) return $this->importreturnerror("<p>Contenu du fichier ZIP invalide<p>");;
            $json= json_decode($json);
            if(!$json) return $this->importreturnerror("<p>Contenu du fichier ZIP invalide<p>");;
        }

        // Structure attendu
        $frmboards=["type","id","title","fgcomment","user","groups","groupwriters","groupreaders","users","userwriters","userreaders","columns"];
        $frmcolumns=["id","title","roworder","size","widgets"];
        $frmwidgets=["id","title","description","filetype","file","roworder","user","documents","messages"];
        $frmdocuments=["id","name","filename","description","entity","roworder","extention","minetype","havethumb"];
        $frmmessages=["id","message","submitdate","user"];

        // On vérifie la structure du json
        foreach($frmboards as $frm) {
            if (!property_exists($json,$frm)) $error.="<p>Contenu du fichier ZIP invalide = propriété $frm manquante<p>";
        }
        if($error) return $this->importreturnerror($error);
        if($json->type!="scrum") return $this->importreturnerror("<p>Contenu du fichier ZIP invalide = type invalide<p>");

        // On s'assure que les columns sont correctement formée
        foreach($json->columns as $column) {
            foreach($frmcolumns as $frm) {
                if (!property_exists($column,$frm)) $error.="<p>Contenu du fichier ZIP invalide = propriété colonne $frm manquante<p>";
            }
            if($error) return $this->importreturnerror($error);

            foreach($column->widgets as $widget) {
                foreach($frmwidgets as $frm) {
                    if (!property_exists($widget,$frm)) $error.="<p>Contenu du fichier ZIP invalide = propriété billet $frm manquante<p>";
                }

                foreach($widget->documents as $document) {
                    foreach($frmdocuments as $frm) {
                        if (!property_exists($document,$frm)) $error.="<p>Contenu du fichier ZIP invalide = propriété document $frm manquante<p>";
                    }
                }

                foreach($widget->messages as $message) {
                    foreach($frmmessages as $frm) {
                        if (!property_exists($message,$frm)) $error.="<p>Contenu du fichier ZIP invalide = propriété message $frm manquante<p>";
                    }
                }            
            }
        }
        if($error) return $this->importreturnerror($error);      

        // On s'assure que le board à restaurer existe
        $board=$em->getRepository($this->labelentity)->find($json->id);
        if(!$board) return $this->importreturnerror("<p>Impossible de restaurer le board n'existe pas</p>");      

        // On s'assure que l'utilisateur à la permission de restaurer ce board
        if($access=="user") {
            if($board->getUser()!=$this->getUser()) return $this->importreturnerror("<p>N'étant pas propriétaire du board vous ne pouvait pas le restaurer</p>");
        }
        $owner=$board->getUser();


        if($error!="") {
            $output["status"]="KO";
            $output["error"]=$error;
        }
        else {
            // On supprime le board pour le regénrer
            $em->remove($board);
            $em->flush();

            // Génération de la sauvegarde
            $board = new Scrum();
            $board->setId($json->id);
            $board->setTitle($json->title);
            $board->setFgComment($json->title);
            $board->setUser($owner);

            foreach($json->groups as $widgrp) {
                $group=$em->getRepository("CadolesCoreBundle:Group")->find($widgrp->id);
                if($group) $board->addGroup($group);
            }
            foreach($json->groupwriters as $widgrp) {
                $group=$em->getRepository("CadolesCoreBundle:Group")->find($widgrp->id);
                if($group) $board->addGroupwriter($group);
            }
            foreach($json->groupreaders as $widgrp) {
                $group=$em->getRepository("CadolesCoreBundle:Group")->find($widgrp->id);
                if($group) $board->addGroupreader($group);
            }
            
            foreach($json->users as $widusr) {
                $user=$em->getRepository("CadolesCoreBundle:User")->find($widusr->id);
                if($user) $board->addUser($user);
            }
            foreach($json->userwriters as $widusr) {
                $user=$em->getRepository("CadolesCoreBundle:User")->find($widusr->id);
                if($user) $board->addUserwriter($user);
            }
            foreach($json->userreaders as $widusr) {
                $user=$em->getRepository("CadolesCoreBundle:User")->find($widusr->id);
                if($user) $board->addUserreader($user);
            }

            $em->persist($board);
            $em->flush();

            foreach($json->columns as $coljson) {
                $column = new Scrumcolumn();
                $column->setId($coljson->id);
                $column->setTitle($coljson->title);
                $column->setRoworder($coljson->roworder);
                $column->setSize($coljson->size);
                $column->setScrum($board);

                $em->persist($column);
                $em->flush();

                foreach($coljson->widgets as $widjson) {
                    $user=$em->getRepository("CadolesCoreBundle:User")->find($widjson->user);
                    if(!$user) $user=$owner;

                    $widget = new Scrumwidget();
                    $widget->setId($widjson->id);
                    $widget->setTitle($widjson->title);
                    $widget->setDescription($widjson->description);
                    $widget->setFiletype($widjson->filetype);
                    $widget->setFile($widjson->file);
                    $widget->setRoworder($widjson->roworder);
                    $widget->setUser($user);
                    $widget->setScrumcolumn($column);

                    $em->persist($widget);
                    $em->flush();

                    foreach($widjson->documents as $docjson) {                   
                        $document = new Document();
                        $document->setId($docjson->id);
                        $document->setName($docjson->name);
                        $document->setFilename($docjson->filename);
                        $document->setDescription($docjson->description);
                        $document->setEntity($docjson->entity);
                        $document->setRoworder($docjson->roworder);
                        $document->setExtention($docjson->extention);
                        $document->setMinetype($docjson->minetype);
                        $document->setHavethumb($docjson->havethumb);
                        $document->setScrumwidget($widget);
        
                        $em->persist($document);
                        $em->flush();                    
                    }

                    foreach($widjson->messages as $msgjson) {
                        $user=$em->getRepository("CadolesCoreBundle:User")->find($msgjson->user);
                        if(!$user) $user=$owner;

                        $message = new Message();
                        $message->setId($msgjson->id);
                        $message->setMessage($msgjson->message);
                        $message->setSubmitdate(new \DateTime($msgjson->submitdate));
                        $message->setUser($user);
                        $message->setScrumwidget($widget);
        
                        $em->persist($message);
                        $em->flush();                    
                    }                
                }
            }
            
            // On clone les fichiers
            $fs = new Filesystem();
            $finder = new Finder();
            if($fs->exists($destdir."/private/document")) {
                $finder->in($destdir."/private/document")->directories()->depth('== 0');
                foreach ($finder as $dir) {
                    $dest=str_replace("/private/document/","web/uploads/document/scrumwidget/",$dir);
                    $fs->mirror($dir->getPathname(), $rootdir."/uploads/document/scrumwidget/".$dir->getBasename());
                }
            }
            if($fs->exists($destdir."/public/scrum/".$json->id)) $fs->mirror($destdir."/public/scrum/".$json->id, $rootdir."/web/uploads/scrum/".$json->id);        
        }

        $output["status"]="OK";
        $output["id"]=$json->id;
        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');        
        return $response;   
    }

    private function importreturnerror($error) {
        $output["status"]="KO";
        $output["error"]=$error;

        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');        
        return $response;        
    }

    private function perm($entity) {
        $perm=false;

        if($entity->getUser()==$this->getUser()) $perm="write";
        if($this->getUser()->getRole()=="ROLE_ADMIN"||$this->getUser()->getRole()=="ROLE_MODO") $perm="write";

        // Récupération des groupes de l'utilisateur
        $groups=$this->getUser()->getGroups();

        // Ses groupes ont-ils la permission 
        foreach($groups as $group) {
            if($entity->getGroups()->contains($group)) $perm="write";
        }

        // Son compte a-til la permission
        if($entity->getUsers()->contains($this->getUser())) $perm="write";

        // Si pas de permission on regarde s'il a les permissions en écriture limitée
        if(!$perm) {
            // Ses groupes ont-ils la permission 
            foreach($groups as $group) {
                if($entity->getGroupwriters()->contains($group)) $perm="writeuser";
            }

            // Son compte a-til la permission
            if($entity->getUserwriters()->contains($this->getUser())) $perm="writeuser";
        }
                
        // Si pas de permission on regarde s'il a les permissions en lecture
        if(!$perm) {
            // Ses groupes ont-ils la permission 
            foreach($groups as $group) {
                if($entity->getGroupreaders()->contains($group)) $perm="read";
            }

            // Son compte a-til la permission
            if($entity->getUserreaders()->contains($this->getUser())) $perm="read";
        }

        // Erreur si non permis
        if(!$perm) throw $this->createNotFoundException('Permission denied');

        return $perm;
    }
}
