<?php

namespace Cadoles\CoreBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Yaml\Yaml;

use Symfony\Component\Finder\Finder;

class ThemeController extends Controller
{
    public function listAction(Request $request)
    {
        $session=$this->get('session');
        $finder = new Finder();

        $dir = $this->get('kernel')->getRootDir()."/../web/bundles/cadolescore/themes";
        $url="/".$this->getParameter('alias')."/bundles/cadolescore/themes";

        $finder->in($dir)->directories()->depth('== 0');
        $themes=[];
        $themes[""]["dir"]="";
        $themes[""]["url"]=$url;
        $themes[""]["name"]="Thème par défaut";

        foreach ($finder as $file) {
            $key=$file->getRelativePathname();
            $themes[$key]["dir"]=$key;
            $themes[$key]["url"]=$url."/".$key;

            $yml=Yaml::parseFile($dir.'/'.$key.'/info.yml');
            $themes[$key]["name"]=$yml["name"];
        }
        
        $current=$session->get("theme");
        $currentheme=$themes[$current];
        unset($themes[$current]);

        return $this->render('CadolesCoreBundle:Theme:list.html.twig',[
            'useheader'     => true,
            'usemenu'       => false,
            'usesidebar'    => true,
            'currentheme'   => $currentheme,
            'themes'        => $themes
        ]);
    }   

    public function selectAction(Request $request,$name)
    {
        $em = $this->getDoctrine()->getManager();
        $config=$em->getRepository("CadolesCoreBundle:Config")->findoneBy(["id"=>"theme"]);
        $config->setValue($name);

        $em->persist($config);
        $em->flush();        

        return $this->redirectToRoute("cadoles_core_config_theme");
    }

    public function setconfigAction(Request $request)
    {
        $session=$this->get('session');
        $themename=$session->get("theme");

        $logo=$request->query->get('logo');
        if(!empty($logo)) $session->set('logo',"bundles/cadolescore/themes/$themename/".$logo);

        $fgheader=$request->query->get('fgheader');
        if(!empty($fgheader)) $session->set('fgheader',boolval($fgheader));
        
        $header=$request->query->get('header');
        if(!empty($header)) $session->set('header',"bundles/cadolescore/themes/$themename/".$header);

        $heightheader=$request->query->get('heightheader');
        if(!empty($heightheader)) $session->set('heightheader',$heightheader);
        
        $colormain=$request->query->get('colormain');
        if(!empty($colormain)) $session->set('colormain',$colormain);        

        $fontcolorhover=$request->query->get('fontcolorhover');
        if(!empty($fontcolorhover)) $session->set('fontcolorhover',$fontcolorhover);   

        $colorbody=$request->query->get('colorbody');
        if(!empty($colorbody)) $session->set('colorbody',$colorbody);    

        $fontfacetitle=$request->query->get('fontfacetitle');
        if(!empty($fontfacetitle)) $session->set('fontfacetitle',$fontfacetitle);        

        $fontfacebody=$request->query->get('fontfacebody');
        if(!empty($fontfacebody)) $session->set('fontfacebody',$fontfacebody);        

        $color = $this->container->get('cadoles.core.service.color');
        $color->setColor();

        return new Response();
    }
}
