<?php

namespace Cadoles\CoreBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Form\FormError;

use Symfony\Bundle\FrameworkBundle\Console\Application;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Output\BufferedOutput;
use Symfony\Component\Console\Output\OutputInterface;
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\Exception\UnsatisfiedDependencyException;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

use Cadoles\CoreBundle\Entity\User;
use Cadoles\CoreBundle\Form\UserType;


class UserController extends Controller
{
    private $labelroute  = 'cadoles_core_config_user';
    private $labelentity = 'CadolesCoreBundle:User';
    private $labeldata   = 'user';
    private $labeldatas  = 'users';

    public function listAction()
    {
        if($this->getUser()->getRole()!="ROLE_ADMIN") throw $this->createNotFoundException('Permission denied');

        $em = $this->getDoctrine()->getManager();
        $config=$em->getRepository('CadolesCoreBundle:Config')->find("datausers");
        $fields=$config->getValue();
        $fields=json_decode($fields,true);

      	return $this->render('CadolesCoreBundle:User:list.html.twig',[
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,                 
            'fields'            => $fields
        ]);
    }

    public function ajaxlistAction(Request $request)
    {
        if($this->getUser()->getRole()!="ROLE_ADMIN") throw $this->createNotFoundException('Permission denied');

        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }
        
        $em = $this->getDoctrine()->getManager();
        
        $start=$request->query->get('start');
        $length= $request->query->get('length');
        $search= $request->query->get('search');
        $draw= $request->query->get('draw');
        $order= $request->query->get('order');

        // Nombre total d'enregistrement
        $total = $em->createQueryBuilder()->select('COUNT(user)')->from($this->labelentity,'user')->getQuery()->getSingleScalarResult();

        // Nombre d'enregistrement filtré
        if($search["value"]=="")
            $totalf = $total;
        else {
            $totalf= $em->createQueryBuilder()
                        ->select('COUNT(user)')
                        ->from('CadolesCoreBundle:User','user')
                        ->where('user.username LIKE :value OR user.firstname LIKE :value OR user.lastname LIKE :value OR user.email LIKE :value OR user.role LIKE :value')
                        ->setParameter("value", "%".$search["value"]."%")
                        ->getQuery()
                        ->getSingleScalarResult();
        }

        // Construction du tableau de retour
        $output = array(
            'draw' => $draw,
            'recordsFiltered' => $totalf,
            'recordsTotal' => $total,
            'data' => array(),
        );

        // Parcours des Enregistrement
        $qb = $em->createQueryBuilder();
        $qb->select('user')->from($this->labelentity,'user');
        if($search["value"]!="") {
            $qb ->where('user.username LIKE :value OR user.firstname LIKE :value OR user.lastname LIKE :value OR user.email LIKE :value OR user.role LIKE :value')
                ->setParameter("value", "%".$search["value"]."%");
        }

        switch($order[0]["column"]) {
            case 1 : 
            $qb->orderBy('user.username',$order[0]["dir"]);
            break;

            case 2 : 
            $qb->orderBy('user.lastname',$order[0]["dir"]);
            break;

            case 3 : 
            $qb->orderBy('user.firstname',$order[0]["dir"]);
            break;

            case 4 : 
            $qb->orderBy('user.email',$order[0]["dir"]);
            break;

            case 5 : 
            $qb->orderBy('user.role',$order[0]["dir"]);
            break;
        }

        $datas=$qb->setFirstResult($start)->setMaxResults($length)->getQuery()->getResult();

        foreach($datas as $data) {
            $tmp=[];
            array_push($tmp,"<a href='".$this->generateUrl('cadoles_core_config_user_update', array('id'=>$data->getId()))."'><i class='fa fa-file fa-fw fa-2x'></i></a>");
            array_push($tmp,"<img src='".$data->getAvatar()."' class='avatar' style='margin:auto;display:block;'>");
            array_push($tmp,$data->getUsername());
            array_push($tmp,$data->getLastname());
            array_push($tmp,$data->getFirstname());
            array_push($tmp,"<a href='mailto:".$data->getEmail()."'>".$data->getEmail()."</a>");
            array_push($tmp,$data->getRole());
            
            array_push($output["data"],$tmp);
        }

        // Retour
        return new Response(json_encode($output), 200);
    }    

    public function ajaxselectAction(Request $request)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }

        $output=array();
        $em = $this->getDoctrine()->getManager();
        $page_limit=$request->query->get('page_limit');
        $q=$request->query->get('q');
        
        $qb = $em->createQueryBuilder();
        $qb->select('table')->from("CadolesCoreBundle:User",'table')
        ->where('table.firstname LIKE :value')
        ->orWhere('table.lastname LIKE :value')
        ->orderBy('table.firstname')
        ->orderBy('table.lastname')
        ->setParameter("value", "%".$q."%");

        $datas=$qb->setFirstResult(0)->setMaxResults($page_limit)->getQuery()->getResult();
        foreach($datas as $data) {
            array_push($output,array("id"=>$data->getId(),"text"=>$data->getDisplayname()));
        }

        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');      
        return $response;
    }

    public function updateAction($id, Request $request) {
        if($this->getUser()->getRole()!="ROLE_ADMIN") throw $this->createNotFoundException('Permission denied');
        
        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository($this->labelentity)->find($id);
        if (!$entity) throw $this->createNotFoundException('Unable to find entity.');

        $form = $this->createForm(UserType::class, $entity, ["mode" => "update"]);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em->persist($entity);
            $em->flush();

            return $this->redirect($this->generateUrl('cadoles_core_config_user',["id"=>$entity->getId()]));          
        }

        return $this->render($this->labelentity.':edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,   
            'entity'            => $entity,
            'form'              => $form->createView(),
        ]);
    }

    protected function getDatas()
    {
        $em = $this->getDoctrine()->getManager();
        $datas = $em->getRepository($this->labelentity)->findAll();
        return $datas;
    } 
            
    protected function getData($id)
    {
        $em = $this->getDoctrine()->getManager();
        $data = $em->getRepository($this->labelentity)->find($id);

        if (!$data) {
            throw $this->createNotFoundException('Unable to find '.$this->labeldata);
        }

        return $data;
    } 

    protected function getErrorForm($id,$form,$request,$data,$mode) {
        if ($form->get('submit')->isClicked()&&$mode=="delete") {
        }

        if ($form->get('submit')->isClicked() && ($mode=="submit" || $mode=="update")) {
            // Taille du login > 5
            if (is_null($data->getUsername()) || strlen($data->getUsername()) < '5') {
                $form->addError(new FormError('Taille minimum du login 5 caractères'));
            }

            // On s'assure que le username ne contient pas des caractères speciaux
            $string = preg_replace('~[^@a-zA-Z0-9._-]~', '', $data->getUsername());
            if($string!=$data->getUsername())
            {
                $form->addError(new FormError('Caractères interdit dans votre login'));
            }
        }

      

        if ($form->get('submit')->isClicked() && !$form->isValid()) {
            $this->get('session')->getFlashBag()->clear();
            $validator = $this->get('validator');
            $errors = $validator->validate($data);
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }

            $errors = $form->getErrors();
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }
        }
    }  

    protected function csv_to_array($csv, $delimiter = ';', $enclosure = '', $escape = '\\', $terminator = "\n") { 
        $r = array(); 
        $rows = explode($terminator,trim($csv)); 

        $names = array_shift($rows); 
        $names = str_getcsv($names,$delimiter,$enclosure,$escape); 
        $nc = count($names); 
        foreach ($rows as $row) { 
            if (trim($row)) { 
                $values = str_getcsv($row,$delimiter,$enclosure,$escape); 
                if (!$values) $values = array_fill(0,$nc,null); 
                @$r[] = array_combine($names,$values); 
            } 
        } 
        return $r; 
    }       
}
