<?php

namespace Cadoles\CoreBundle\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Document
 *
 * @ORM\Table(name="document")
 * @ORM\Entity
 */
class Document
{
    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(name="name", type="string")
     *
     */
    private $name;

    /**
     * @ORM\Column(name="filename", type="string")
     *
     */
    private $filename;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $description;

    /**
     * @ORM\Column(name="entity", type="string")
     */
    private $entity;

    /**
     * @ORM\Column(type="integer")
     */
    private $roworder;

    /**
     * @ORM\Column(name="extention", type="string")
     */
    private $extention;

    /**
     * @ORM\Column(name="minetype", type="string")
     */
    private $minetype;

    /**
     * @ORM\Column(name="havethumb", type="boolean")
     */
    private $havethumb;

    /**
     * @ORM\ManyToOne(targetEntity="Scrumwidget", inversedBy="scrumwidgetdocuments")
     * @ORM\JoinColumn(nullable=true)
     */
    private $scrumwidget;

    /**
     * @ORM\ManyToOne(targetEntity="Whiteboardwidget", inversedBy="whiteboardwidgetdocuments")
     * @ORM\JoinColumn(nullable=true)
     */
    private $whiteboardwidget;

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }
    
    /**
     * Set name
     *
     * @param string $name
     *
     * @return Document
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set filename
     *
     * @param string $filename
     *
     * @return Document
     */
    public function setFilename($filename)
    {
        $this->filename = $filename;

        return $this;
    }

    /**
     * Get filename
     *
     * @return string
     */
    public function getFilename()
    {
        return $this->filename;
    }

    /**
     * Set description
     *
     * @param string $description
     *
     * @return Document
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set entity
     *
     * @param string $entity
     *
     * @return Document
     */
    public function setEntity($entity)
    {
        $this->entity = $entity;

        return $this;
    }

    /**
     * Get entity
     *
     * @return string
     */
    public function getEntity()
    {
        return $this->entity;
    }

    /**
     * Set roworder
     *
     * @param integer $roworder
     *
     * @return Document
     */
    public function setRoworder($roworder)
    {
        $this->roworder = $roworder;

        return $this;
    }

    /**
     * Get roworder
     *
     * @return integer
     */
    public function getRoworder()
    {
        return $this->roworder;
    }

    /**
     * Set extention
     *
     * @param string $extention
     *
     * @return Document
     */
    public function setExtention($extention)
    {
        $this->extention = $extention;

        return $this;
    }

    /**
     * Get extention
     *
     * @return string
     */
    public function getExtention()
    {
        return $this->extention;
    }

    /**
     * Set minetype
     *
     * @param string $minetype
     *
     * @return Document
     */
    public function setMinetype($minetype)
    {
        $this->minetype = $minetype;

        return $this;
    }

    /**
     * Get minetype
     *
     * @return string
     */
    public function getMinetype()
    {
        return $this->minetype;
    }

    /**
     * Set havethumb
     *
     * @param boolean $havethumb
     *
     * @return Document
     */
    public function setHavethumb($havethumb)
    {
        $this->havethumb = $havethumb;

        return $this;
    }

    /**
     * Get havethumb
     *
     * @return boolean
     */
    public function getHavethumb()
    {
        return $this->havethumb;
    }

    /**
     * Set scrumwidget
     *
     * @param \Cadoles\CoreBundle\Entity\Scrumwidget $scrumwidget
     *
     * @return Document
     */
    public function setScrumwidget(\Cadoles\CoreBundle\Entity\Scrumwidget $scrumwidget = null)
    {
        $this->scrumwidget = $scrumwidget;

        return $this;
    }

    /**
     * Get scrumwidget
     *
     * @return \Cadoles\CoreBundle\Entity\Scrumwidget
     */
    public function getScrumwidget()
    {
        return $this->scrumwidget;
    }

    /**
     * Set whiteboardwidget
     *
     * @param \Cadoles\CoreBundle\Entity\Whiteboardwidget $whiteboardwidget
     *
     * @return Document
     */
    public function setWhiteboardwidget(\Cadoles\CoreBundle\Entity\Whiteboardwidget $whiteboardwidget = null)
    {
        $this->whiteboardwidget = $whiteboardwidget;

        return $this;
    }

    /**
     * Get whiteboardwidget
     *
     * @return \Cadoles\CoreBundle\Entity\Whiteboardwidget
     */
    public function getWhiteboardwidget()
    {
        return $this->whiteboardwidget;
    }
}
