<?php
namespace Cadoles\CoreBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;

use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity
 * @ORM\Table(name="groupe")
 * @ORM\HasLifecycleCallbacks()
 * @ORM\Entity(repositoryClass="Cadoles\CoreBundle\Repository\GroupRepository")
 * 
 * @UniqueEntity(fields="label", message="Un group existe déjà avec ce label")
 */
class Group
{
    /**
     * @ORM\Column(type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=250, unique=true)
     */
    private $label;

    /**
     * @ORM\Column(name="idexternal", type="integer",  nullable=true)
     */
    private $idexternal;

    /**
     * @ORM\Column(type="boolean", options={"default" : false})
     */
    private $fgtemplate;  

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $ldapfilter;

    /**
    * @ORM\ManyToMany(targetEntity="Scrum", mappedBy="groups")
    */    
    protected $scrums;      

    /**
    * @ORM\ManyToMany(targetEntity="Scrum", mappedBy="groupwriters")
    */    
    protected $scrumwriters;  
    
    /**
    * @ORM\ManyToMany(targetEntity="Scrum", mappedBy="groupreaders")
    */    
    protected $scrumreaders;  

    /**
    * @ORM\ManyToMany(targetEntity="Etherpad", mappedBy="groups")
    */    
    protected $etherpads;      

    /**
    * @ORM\ManyToMany(targetEntity="Ethercalc", mappedBy="groups")
    */    
    protected $ethercalcs;   

    /**
    * @ORM\ManyToMany(targetEntity="User", mappedBy="groups")
    */    
    protected $users;  

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->scrums = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set label
     *
     * @param string $label
     *
     * @return Group
     */
    public function setLabel($label)
    {
        $this->label = $label;

        return $this;
    }

    /**
     * Get label
     *
     * @return string
     */
    public function getLabel()
    {
        return $this->label;
    }

    /**
     * Set idexternal
     *
     * @param integer $idexternal
     *
     * @return Group
     */
    public function setIdexternal($idexternal)
    {
        $this->idexternal = $idexternal;

        return $this;
    }

    /**
     * Get idexternal
     *
     * @return integer
     */
    public function getIdexternal()
    {
        return $this->idexternal;
    }

    /**
     * Set fgtemplate
     *
     * @param boolean $fgtemplate
     *
     * @return Group
     */
    public function setFgtemplate($fgtemplate)
    {
        $this->fgtemplate = $fgtemplate;

        return $this;
    }

    /**
     * Get fgtemplate
     *
     * @return boolean
     */
    public function getFgtemplate()
    {
        return $this->fgtemplate;
    }

    /**
     * Set ldapfilter
     *
     * @param string $ldapfilter
     *
     * @return Group
     */
    public function setLdapfilter($ldapfilter)
    {
        $this->ldapfilter = $ldapfilter;

        return $this;
    }

    /**
     * Get ldapfilter
     *
     * @return string
     */
    public function getLdapfilter()
    {
        return $this->ldapfilter;
    }

    /**
     * Add scrum
     *
     * @param \Cadoles\CoreBundle\Entity\Scrum $scrum
     *
     * @return Group
     */
    public function addScrum(\Cadoles\CoreBundle\Entity\Scrum $scrum)
    {
        $this->scrums[] = $scrum;

        return $this;
    }

    /**
     * Remove scrum
     *
     * @param \Cadoles\CoreBundle\Entity\Scrum $scrum
     */
    public function removeScrum(\Cadoles\CoreBundle\Entity\Scrum $scrum)
    {
        $this->scrums->removeElement($scrum);
    }

    /**
     * Get scrums
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getScrums()
    {
        return $this->scrums;
    }

    /**
     * Add user
     *
     * @param \Cadoles\CoreBundle\Entity\User $user
     *
     * @return Group
     */
    public function addUser(\Cadoles\CoreBundle\Entity\User $user)
    {
        $user->addGroup($this);
        $this->users[] = $user;

        return $this;
    }

    /**
     * Remove user
     *
     * @param \Cadoles\CoreBundle\Entity\User $user
     */
    public function removeUser(\Cadoles\CoreBundle\Entity\User $user)
    {
        $user->removeGroup($this);
        $this->users->removeElement($user);
    }

    /**
     * Get users
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getUsers()
    {
        return $this->users;
    }

    /**
     * Add etherpad
     *
     * @param \Cadoles\CoreBundle\Entity\Etherpad $etherpad
     *
     * @return Group
     */
    public function addEtherpad(\Cadoles\CoreBundle\Entity\Etherpad $etherpad)
    {
        $this->etherpads[] = $etherpad;

        return $this;
    }

    /**
     * Remove etherpad
     *
     * @param \Cadoles\CoreBundle\Entity\Etherpad $etherpad
     */
    public function removeEtherpad(\Cadoles\CoreBundle\Entity\Etherpad $etherpad)
    {
        $this->etherpads->removeElement($etherpad);
    }

    /**
     * Get etherpads
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getEtherpads()
    {
        return $this->etherpads;
    }

    /**
     * Add scrumreader.
     *
     * @param \Cadoles\CoreBundle\Entity\Scrum $scrumreader
     *
     * @return Group
     */
    public function addScrumreader(\Cadoles\CoreBundle\Entity\Scrum $scrumreader)
    {
        $this->scrumreaders[] = $scrumreader;

        return $this;
    }

    /**
     * Remove scrumreader.
     *
     * @param \Cadoles\CoreBundle\Entity\Scrum $scrumreader
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removeScrumreader(\Cadoles\CoreBundle\Entity\Scrum $scrumreader)
    {
        return $this->scrumreaders->removeElement($scrumreader);
    }

    /**
     * Get scrumreaders.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getScrumreaders()
    {
        return $this->scrumreaders;
    }

    /**
     * Add ethercalc.
     *
     * @param \Cadoles\CoreBundle\Entity\Ethercalc $ethercalc
     *
     * @return Group
     */
    public function addEthercalc(\Cadoles\CoreBundle\Entity\Ethercalc $ethercalc)
    {
        $this->ethercalcs[] = $ethercalc;

        return $this;
    }

    /**
     * Remove ethercalc.
     *
     * @param \Cadoles\CoreBundle\Entity\Ethercalc $ethercalc
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removeEthercalc(\Cadoles\CoreBundle\Entity\Ethercalc $ethercalc)
    {
        return $this->ethercalcs->removeElement($ethercalc);
    }

    /**
     * Get ethercalcs.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getEthercalcs()
    {
        return $this->ethercalcs;
    }

    /**
     * Add scrumwriter
     *
     * @param \Cadoles\CoreBundle\Entity\Scrum $scrumwriter
     *
     * @return Group
     */
    public function addScrumwriter(\Cadoles\CoreBundle\Entity\Scrum $scrumwriter)
    {
        $this->scrumwriters[] = $scrumwriter;

        return $this;
    }

    /**
     * Remove scrumwriter
     *
     * @param \Cadoles\CoreBundle\Entity\Scrum $scrumwriter
     */
    public function removeScrumwriter(\Cadoles\CoreBundle\Entity\Scrum $scrumwriter)
    {
        $this->scrumwriters->removeElement($scrumwriter);
    }

    /**
     * Get scrumwriters
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getScrumwriters()
    {
        return $this->scrumwriters;
    }
}
