<?php

namespace Cadoles\CoreBundle\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Message
 *
 * @ORM\Table(name="message")
 * @ORM\Entity
 */
class Message
{
    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(type="text")
     */
    private $message;

    /**
     * @ORM\Column(type="datetime")
     */
    private $submitdate;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="messages")
     */
    private $user;

    /**
     * @ORM\ManyToOne(targetEntity="Scrumwidget", inversedBy="messages")
     */
    private $scrumwidget;

    /**
     * @ORM\ManyToOne(targetEntity="Whiteboardwidget", inversedBy="messages")
     */
    private $whiteboardwidget;
        
    public function __construct()
    {
        $this->submitdate = new \DateTime();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }
    
    /**
     * Set message
     *
     * @param string $message
     *
     * @return Message
     */
    public function setMessage($message)
    {
        $this->message = $message;

        return $this;
    }

    /**
     * Get message
     *
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * Set submitdate
     *
     * @param \DateTime $submitdate
     *
     * @return Message
     */
    public function setSubmitdate($submitdate)
    {
        $this->submitdate = $submitdate;

        return $this;
    }

    /**
     * Get submitdate
     *
     * @return \DateTime
     */
    public function getSubmitdate()
    {
        return $this->submitdate;
    }

    /**
     * Set user
     *
     * @param \Cadoles\CoreBundle\Entity\User $user
     *
     * @return Message
     */
    public function setUser(\Cadoles\CoreBundle\Entity\User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return \Cadoles\CoreBundle\Entity\User
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Set scrumwidget
     *
     * @param \Cadoles\CoreBundle\Entity\Scrumwidget $scrumwidget
     *
     * @return Message
     */
    public function setScrumwidget(\Cadoles\CoreBundle\Entity\Scrumwidget $scrumwidget = null)
    {
        $this->scrumwidget = $scrumwidget;

        return $this;
    }

    /**
     * Get scrumwidget
     *
     * @return \Cadoles\CoreBundle\Entity\Scrumwidget
     */
    public function getScrumwidget()
    {
        return $this->scrumwidget;
    }

    /**
     * Set whiteboardwidget
     *
     * @param \Cadoles\CoreBundle\Entity\Whiteboardwidget $whiteboardwidget
     *
     * @return Message
     */
    public function setWhiteboardwidget(\Cadoles\CoreBundle\Entity\Whiteboardwidget $whiteboardwidget = null)
    {
        $this->whiteboardwidget = $whiteboardwidget;

        return $this;
    }

    /**
     * Get whiteboardwidget
     *
     * @return \Cadoles\CoreBundle\Entity\Whiteboardwidget
     */
    public function getWhiteboardwidget()
    {
        return $this->whiteboardwidget;
    }
}
