<?php

namespace Cadoles\CoreBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Scrum
 *
 * @ORM\Entity(repositoryClass="Cadoles\CoreBundle\Repository\ScrumRepository")
 * @ORM\Table(name="scrum")
 * @ORM\HasLifecycleCallbacks
 */
class Scrum
{
    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(name="name", type="string", length=100)
     */
    private $title;

    /**
     * @ORM\Column(name="fgcomment", type="boolean")
     */
    private $fgcomment;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="scrums")
     */
    private $user;

    /**
     * @ORM\OneToMany(targetEntity="Scrumcolumn", mappedBy="scrum", cascade={"persist"}, orphanRemoval=true)
     * @ORM\OrderBy({"roworder" = "ASC"})
     */
    private $scrumcolumns;

    /**
     * @ORM\ManyToMany(targetEntity="Cadoles\CoreBundle\Entity\Group", inversedBy="scrums", cascade={"persist"})
     * @ORM\JoinTable(name="scrumgroupe",
     *   joinColumns={@ORM\JoinColumn(name="scrum", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="groupe", referencedColumnName="id")}
     * )
     */
    protected $groups;

    /**
     * @ORM\ManyToMany(targetEntity="Group", inversedBy="scrumwriters", cascade={"persist"})
     * @ORM\JoinTable(name="scrumgroupewriter",
     *   joinColumns={@ORM\JoinColumn(name="scrum", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="groupe", referencedColumnName="id")}
     * )
     */
    protected $groupwriters;

    /**
     * @ORM\ManyToMany(targetEntity="Cadoles\CoreBundle\Entity\Group", inversedBy="scrumreaders", cascade={"persist"})
     * @ORM\JoinTable(name="scrumgroupereader",
     *   joinColumns={@ORM\JoinColumn(name="scrum", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="groupe", referencedColumnName="id")}
     * )
     */
    protected $groupreaders;

    /**
     * @ORM\ManyToMany(targetEntity="Cadoles\CoreBundle\Entity\User", inversedBy="scrumshareds", cascade={"persist"})
     * @ORM\JoinTable(name="scrumuser",
     *   joinColumns={@ORM\JoinColumn(name="scrum", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="user", referencedColumnName="id")}
     * )
     */
    protected $users;

    /**
     * @ORM\ManyToMany(targetEntity="User", inversedBy="scrumsharedwriters", cascade={"persist"})
     * @ORM\JoinTable(name="scrumuserwriter",
     *   joinColumns={@ORM\JoinColumn(name="scrum", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="user", referencedColumnName="id")}
     * )
     */
    protected $userwriters;
    
    /**
     * @ORM\ManyToMany(targetEntity="Cadoles\CoreBundle\Entity\User", inversedBy="scrumsharedreaders", cascade={"persist"})
     * @ORM\JoinTable(name="scrumuserreader",
     *   joinColumns={@ORM\JoinColumn(name="scrum", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="user", referencedColumnName="id")}
     * )
     */
    protected $userreaders;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->scrumcolumns = new \Doctrine\Common\Collections\ArrayCollection();
        $this->groups = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Set title
     *
     * @param string $title
     *
     * @return Scrum
     */
    public function setTitle($title)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * Get title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Set user
     *
     * @param \Cadoles\CoreBundle\Entity\User $user
     *
     * @return Scrum
     */
    public function setUser(\Cadoles\CoreBundle\Entity\User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return \Cadoles\CoreBundle\Entity\User
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Add scrumcolumn
     *
     * @param \Cadoles\CoreBundle\Entity\Scrumcolumn $scrumcolumn
     *
     * @return Scrum
     */
    public function addScrumcolumn(\Cadoles\CoreBundle\Entity\Scrumcolumn $scrumcolumn)
    {
        $this->scrumcolumns[] = $scrumcolumn;

        return $this;
    }

    /**
     * Remove scrumcolumn
     *
     * @param \Cadoles\CoreBundle\Entity\Scrumcolumn $scrumcolumn
     */
    public function removeScrumcolumn(\Cadoles\CoreBundle\Entity\Scrumcolumn $scrumcolumn)
    {
        $this->scrumcolumns->removeElement($scrumcolumn);
    }

    /**
     * Get scrumcolumns
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getScrumcolumns()
    {
        return $this->scrumcolumns;
    }

    /**
     * Add group
     *
     * @param \Cadoles\CoreBundle\Entity\Group $group
     *
     * @return Scrum
     */
    public function addGroup(\Cadoles\CoreBundle\Entity\Group $group)
    {
        $this->groups[] = $group;

        return $this;
    }

    /**
     * Remove group
     *
     * @param \Cadoles\CoreBundle\Entity\Group $group
     */
    public function removeGroup(\Cadoles\CoreBundle\Entity\Group $group)
    {
        $this->groups->removeElement($group);
    }

    /**
     * Get groups
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getGroups()
    {
        return $this->groups;
    }

    /**
     * Add user
     *
     * @param \Cadoles\CoreBundle\Entity\User $user
     *
     * @return Scrum
     */
    public function addUser(\Cadoles\CoreBundle\Entity\User $user)
    {
        $this->users[] = $user;

        return $this;
    }

    /**
     * Remove user
     *
     * @param \Cadoles\CoreBundle\Entity\User $user
     */
    public function removeUser(\Cadoles\CoreBundle\Entity\User $user)
    {
        $this->users->removeElement($user);
    }

    /**
     * Get users
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getUsers()
    {
        return $this->users;
    }

    /**
     * Add groupreader.
     *
     * @param \Cadoles\CoreBundle\Entity\Group $groupreader
     *
     * @return Scrum
     */
    public function addGroupreader(\Cadoles\CoreBundle\Entity\Group $groupreader)
    {
        $this->groupreaders[] = $groupreader;

        return $this;
    }

    /**
     * Remove groupreader.
     *
     * @param \Cadoles\CoreBundle\Entity\Group $groupreader
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removeGroupreader(\Cadoles\CoreBundle\Entity\Group $groupreader)
    {
        return $this->groupreaders->removeElement($groupreader);
    }

    /**
     * Get groupreaders.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getGroupreaders()
    {
        return $this->groupreaders;
    }

    /**
     * Add userreader.
     *
     * @param \Cadoles\CoreBundle\Entity\User $userreader
     *
     * @return Scrum
     */
    public function addUserreader(\Cadoles\CoreBundle\Entity\User $userreader)
    {
        $this->userreaders[] = $userreader;

        return $this;
    }

    /**
     * Remove userreader.
     *
     * @param \Cadoles\CoreBundle\Entity\User $userreader
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removeUserreader(\Cadoles\CoreBundle\Entity\User $userreader)
    {
        return $this->userreaders->removeElement($userreader);
    }

    /**
     * Get userreaders.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getUserreaders()
    {
        return $this->userreaders;
    }

    /**
     * Set fgcomment
     *
     * @param boolean $fgcomment
     *
     * @return Scrum
     */
    public function setFgcomment($fgcomment)
    {
        $this->fgcomment = $fgcomment;

        return $this;
    }

    /**
     * Get fgcomment
     *
     * @return boolean
     */
    public function getFgcomment()
    {
        return $this->fgcomment;
    }

    /**
     * Add groupwriter
     *
     * @param \Cadoles\CoreBundle\Entity\Group $groupwriter
     *
     * @return Scrum
     */
    public function addGroupwriter(\Cadoles\CoreBundle\Entity\Group $groupwriter)
    {
        $this->groupwriters[] = $groupwriter;

        return $this;
    }

    /**
     * Remove groupwriter
     *
     * @param \Cadoles\CoreBundle\Entity\Group $groupwriter
     */
    public function removeGroupwriter(\Cadoles\CoreBundle\Entity\Group $groupwriter)
    {
        $this->groupwriters->removeElement($groupwriter);
    }

    /**
     * Get groupwriters
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getGroupwriters()
    {
        return $this->groupwriters;
    }

    /**
     * Add userwriter
     *
     * @param \Cadoles\CoreBundle\Entity\User $userwriter
     *
     * @return Scrum
     */
    public function addUserwriter(\Cadoles\CoreBundle\Entity\User $userwriter)
    {
        $this->userwriters[] = $userwriter;

        return $this;
    }

    /**
     * Remove userwriter
     *
     * @param \Cadoles\CoreBundle\Entity\User $userwriter
     */
    public function removeUserwriter(\Cadoles\CoreBundle\Entity\User $userwriter)
    {
        $this->userwriters->removeElement($userwriter);
    }

    /**
     * Get userwriters
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getUserwriters()
    {
        return $this->userwriters;
    }
}
