<?php

namespace Cadoles\CoreBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Scrum
 *
 * @ORM\Entity
 * @ORM\Table(name="scrumcolumn")
 * @ORM\HasLifecycleCallbacks
 */
class Scrumcolumn
{
    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(name="name", type="string", length=100)
     */
    private $title;

    /**
     * @ORM\Column(name="roworder", type="integer")
     */
    private $roworder;

    /**
     * @ORM\Column(name="size", type="integer")
     */
    private $size;

    /**
     * @ORM\ManyToOne(targetEntity="Scrum", inversedBy="scrumcolumns")
     */
    private $scrum;
        
    /**
     * @ORM\OneToMany(targetEntity="Scrumwidget", mappedBy="scrumcolumn", cascade={"persist"}, orphanRemoval=true)
     * @ORM\OrderBy({"roworder" = "ASC"})
     */
    private $scrumwidgets;




    /**
     * Constructor
     */
    public function __construct()
    {
        $this->scrumwidgets = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }
    
    /**
     * Set title
     *
     * @param string $title
     *
     * @return Scrumcolumn
     */
    public function setTitle($title)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * Get title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Set roworder
     *
     * @param integer $roworder
     *
     * @return Scrumcolumn
     */
    public function setRoworder($roworder)
    {
        $this->roworder = $roworder;

        return $this;
    }

    /**
     * Get roworder
     *
     * @return integer
     */
    public function getRoworder()
    {
        return $this->roworder;
    }

    /**
     * Set size
     *
     * @param integer $size
     *
     * @return Scrumcolumn
     */
    public function setSize($size)
    {
        $this->size = $size;

        return $this;
    }

    /**
     * Get size
     *
     * @return integer
     */
    public function getSize()
    {
        return $this->size;
    }

    /**
     * Set scrum
     *
     * @param \Cadoles\CoreBundle\Entity\Scrum $scrum
     *
     * @return Scrumcolumn
     */
    public function setScrum(\Cadoles\CoreBundle\Entity\Scrum $scrum = null)
    {
        $this->scrum = $scrum;

        return $this;
    }

    /**
     * Get scrum
     *
     * @return \Cadoles\CoreBundle\Entity\Scrum
     */
    public function getScrum()
    {
        return $this->scrum;
    }

    /**
     * Add scrumwidget
     *
     * @param \Cadoles\CoreBundle\Entity\Scrumwidget $scrumwidget
     *
     * @return Scrumcolumn
     */
    public function addScrumwidget(\Cadoles\CoreBundle\Entity\Scrumwidget $scrumwidget)
    {
        $this->scrumwidgets[] = $scrumwidget;

        return $this;
    }

    /**
     * Remove scrumwidget
     *
     * @param \Cadoles\CoreBundle\Entity\Scrumwidget $scrumwidget
     */
    public function removeScrumwidget(\Cadoles\CoreBundle\Entity\Scrumwidget $scrumwidget)
    {
        $this->scrumwidgets->removeElement($scrumwidget);
    }

    /**
     * Get scrumwidgets
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getScrumwidgets()
    {
        return $this->scrumwidgets;
    }
}
