<?php

namespace Cadoles\CoreBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Scrum
 *
 * @ORM\Entity
 * @ORM\Table(name="scrumwidget")
 * @ORM\HasLifecycleCallbacks
 */
class Scrumwidget
{
    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(name="name", type="string", length=100)
     */
    private $title;

    /**
     * @ORM\Column(name="description", type="text", nullable=true)
     */
    private $description;

    /**
     * @ORM\Column(name="filetype", type="string", nullable=true)
     */
    private $filetype;

    /**
     * @ORM\Column(name="file", type="string", nullable=true)
     */
    private $file;
    
    /**
     * @ORM\Column(name="roworder", type="integer")
     */
    private $roworder;

    /**
     * @ORM\ManyToOne(targetEntity="Scrumcolumn", inversedBy="scrumwidgets")
     */
    private $scrumcolumn;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="scrumwidgets")
     * @ORM\JoinColumn(nullable=true)
     */
    private $user;

    /**
     * @ORM\OneToMany(targetEntity="Document", mappedBy="scrumwidget", cascade={"persist"}, orphanRemoval=true)
     */
    private $scrumwidgetdocuments;

    /**
     * @ORM\OneToMany(targetEntity="Message", mappedBy="scrumwidget", cascade={"persist"}, orphanRemoval=true)
     */
    private $messages;


    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }
    
    /**
     * Set title
     *
     * @param string $title
     *
     * @return Scrumwidget
     */
    public function setTitle($title)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * Get title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Set description
     *
     * @param string $description
     *
     * @return Scrumwidget
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set roworder
     *
     * @param integer $roworder
     *
     * @return Scrumwidget
     */
    public function setRoworder($roworder)
    {
        $this->roworder = $roworder;

        return $this;
    }

    /**
     * Get roworder
     *
     * @return integer
     */
    public function getRoworder()
    {
        return $this->roworder;
    }

    /**
     * Set scrumcolumn
     *
     * @param \Cadoles\CoreBundle\Entity\Scrumcolumn $scrumcolumn
     *
     * @return Scrumwidget
     */
    public function setScrumcolumn(\Cadoles\CoreBundle\Entity\Scrumcolumn $scrumcolumn = null)
    {
        $this->scrumcolumn = $scrumcolumn;

        return $this;
    }

    /**
     * Get scrumcolumn
     *
     * @return \Cadoles\CoreBundle\Entity\Scrumcolumn
     */
    public function getScrumcolumn()
    {
        return $this->scrumcolumn;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->scrumwidgetdocuments = new \Doctrine\Common\Collections\ArrayCollection();
        $this->messages = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Set user
     *
     * @param \Cadoles\CoreBundle\Entity\User $user
     *
     * @return Scrumwidget
     */
    public function setUser(\Cadoles\CoreBundle\Entity\User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return \Cadoles\CoreBundle\Entity\User
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Add scrumwidgetdocument
     *
     * @param \Cadoles\CoreBundle\Entity\Document $scrumwidgetdocument
     *
     * @return Scrumwidget
     */
    public function addScrumwidgetdocument(\Cadoles\CoreBundle\Entity\Document $scrumwidgetdocument)
    {
        $this->scrumwidgetdocuments[] = $scrumwidgetdocument;

        return $this;
    }

    /**
     * Remove scrumwidgetdocument
     *
     * @param \Cadoles\CoreBundle\Entity\Document $scrumwidgetdocument
     */
    public function removeScrumwidgetdocument(\Cadoles\CoreBundle\Entity\Document $scrumwidgetdocument)
    {
        $this->scrumwidgetdocuments->removeElement($scrumwidgetdocument);
    }

    /**
     * Get scrumwidgetdocuments
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getScrumwidgetdocuments()
    {
        return $this->scrumwidgetdocuments;
    }

    /**
     * Add message
     *
     * @param \Cadoles\CoreBundle\Entity\Message $message
     *
     * @return Scrumwidget
     */
    public function addMessage(\Cadoles\CoreBundle\Entity\Message $message)
    {
        $this->messages[] = $message;

        return $this;
    }

    /**
     * Remove message
     *
     * @param \Cadoles\CoreBundle\Entity\Message $message
     */
    public function removeMessage(\Cadoles\CoreBundle\Entity\Message $message)
    {
        $this->messages->removeElement($message);
    }

    /**
     * Get messages
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getMessages()
    {
        return $this->messages;
    }

    /**
     * Set filetype
     *
     * @param string $filetype
     *
     * @return Scrumwidget
     */
    public function setFiletype($filetype)
    {
        $this->filetype = $filetype;

        return $this;
    }

    /**
     * Get filetype
     *
     * @return string
     */
    public function getFiletype()
    {
        return $this->filetype;
    }

    /**
     * Set file
     *
     * @param string $file
     *
     * @return Scrumwidget
     */
    public function setFile($file)
    {
        $this->file = $file;

        return $this;
    }

    /**
     * Get file
     *
     * @return string
     */
    public function getFile()
    {
        return $this->file;
    }
}
