<?php
namespace Cadoles\CoreBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;

use Symfony\Component\Security\Core\User\UserInterface;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Validator\Constraints as Assert;
use Cadoles\CoreBundle\Validator\Password;


/**
 * @ORM\Entity
 * @ORM\Table(name="user")
 * @ORM\HasLifecycleCallbacks()
 *
 * @UniqueEntity(fields="username", message="Un utilisateur existe déjà avec ce login.")
 * @UniqueEntity(fields="email", message="Un utilisateur existe déjà avec ce mail.")
 */
class User implements UserInterface, \Serializable
{
    /**
     * @ORM\Column(type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=50, unique=true)
     */
    private $username;

    /**
     * @ORM\Column(type="string", length=250, nullable=true)
     */
    private $firstname;

    /**
     * @ORM\Column(type="string", length=250, nullable=true)
     */
    private $lastname;

    /**
     * @ORM\Column(type="string", length=250)
     */
    private $password;

    /**
     * @ORM\Column(type="string", length=250)
     */
    private $salt;

    /**
     * @Password()
     */
    private $tempopassword;

    /**
     * @ORM\Column(type="string", length=60, unique=true)
     */
    private $email;

    /**
      * @ORM\Column(type="string", length=200, nullable=true, options={"default" : 0})
     */
    private $avatar;

    /**
     * @ORM\Column(type="string", length=60)
     */
    private $role;

    /**
     * @ORM\OneToMany(targetEntity="Scrum", mappedBy="user", cascade={"persist"}, orphanRemoval=true)
     */
    private $scrums; 

    /**
     * @ORM\OneToMany(targetEntity="Scrumwidget", mappedBy="user")
     */
    private $scrumwidgets; 

    /**
     * @ORM\OneToMany(targetEntity="Etherpad", mappedBy="user", cascade={"persist"}, orphanRemoval=true)
     */
    private $etherpads; 

    /**
     * @ORM\OneToMany(targetEntity="Message", mappedBy="user")
     */
    private $messages; 

    /**
     * @ORM\ManyToMany(targetEntity="Group", inversedBy="users", cascade={"persist"})
     * @ORM\JoinTable(name="usergroupe",
     *   joinColumns={@ORM\JoinColumn(name="user", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="groupe", referencedColumnName="id")}
     * )
     */
    protected $groups;

    /**
    * @ORM\ManyToMany(targetEntity="Scrum", mappedBy="users")
    */    
    protected $scrumshareds;      

    /**
    * @ORM\ManyToMany(targetEntity="Scrum", mappedBy="userwriters")
    */    
    protected $scrumsharedwriters;   

    /**
    * @ORM\ManyToMany(targetEntity="Scrum", mappedBy="userreaders")
    */    
    protected $scrumsharedreaders;    

    /**
    * @ORM\ManyToMany(targetEntity="Etherpad", mappedBy="users")
    */    
    protected $etherpadshareds;      

    /**
    * @ORM\ManyToMany(targetEntity="Ethercalc", mappedBy="users")
    */    
    protected $ethercalcshareds;  
        
//== CODE A NE PAS REGENERER
    /**
     * @ORM\PostLoad
     */
    public function PostLoad() {
        if($this->getAvatar()=="") {
            $this->setAvatar("noavatar.png");
        }
    }

    public function getUserName()
    {
        return $this->username;
    }

    public function getSalt()
    {
        return $this->salt;
    }

    public function setPassword($password)
    {
        if($password!=$this->password&&$password!=""){
            $this->tempopassword=$password;
            
            $this->salt = uniqid(mt_rand(), true);
            $hash = "{SSHA}" . base64_encode(pack("H*", sha1($password . $this->salt)) . $this->salt);

            $this->password = $hash;
        }
        
        return $this;
    }

    public function setPasswordDirect($password)
    {
        $this->password = $password;
        
        return $this;
    }
        
    public function getPassword()
    {
        return $this->password;
    }

    public function getRoles()
    {
        return explode(",",$this->role);
    }

    public function hasRole(string $role)
    {
        return in_array($role,$this->getRoles());
    }

    public function eraseCredentials()
    {
    }

    /** @see \Serializable::serialize() */
    public function serialize()
    {
        return serialize(array(
            $this->id,
            $this->username,
            $this->password,
            $this->salt,
        ));
    }

    /** @see \Serializable::unserialize() */
    public function unserialize($serialized)
    {
        list (
            $this->id,
            $this->login,
            $this->password,
            $this->salt
        ) = unserialize($serialized);
    }

    private $displayname;
    public function getDisplayname() {
        return $this->firstname." ".$this->lastname;
    }   

//== FIN DU CODE A NE PAS REGENERER



    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set username
     *
     * @param string $username
     *
     * @return User
     */
    public function setUsername($username)
    {
        $this->username = $username;

        return $this;
    }

    /**
     * Set firstname
     *
     * @param string $firstname
     *
     * @return User
     */
    public function setFirstname($firstname)
    {
        $this->firstname = $firstname;

        return $this;
    }

    /**
     * Get firstname
     *
     * @return string
     */
    public function getFirstname()
    {
        return $this->firstname;
    }

    /**
     * Set lastname
     *
     * @param string $lastname
     *
     * @return User
     */
    public function setLastname($lastname)
    {
        $this->lastname = $lastname;

        return $this;
    }

    /**
     * Get lastname
     *
     * @return string
     */
    public function getLastname()
    {
        return $this->lastname;
    }

    /**
     * Set salt
     *
     * @param string $salt
     *
     * @return User
     */
    public function setSalt($salt)
    {
        $this->salt = $salt;

        return $this;
    }

    /**
     * Set email
     *
     * @param string $email
     *
     * @return User
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * Get email
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Set avatar
     *
     * @param string $avatar
     *
     * @return User
     */
    public function setAvatar($avatar)
    {
        $this->avatar = $avatar;

        return $this;
    }

    /**
     * Get avatar
     *
     * @return string
     */
    public function getAvatar()
    {
        return $this->avatar;
    }

    /**
     * Set role
     *
     * @param string $role
     *
     * @return User
     */
    public function setRole($role)
    {
        $this->role = $role;

        return $this;
    }

    /**
     * Get role
     *
     * @return string
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->scrums = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Add scrum
     *
     * @param \Cadoles\CoreBundle\Entity\Scrum $scrum
     *
     * @return User
     */
    public function addScrum(\Cadoles\CoreBundle\Entity\Scrum $scrum)
    {
        $this->scrums[] = $scrum;

        return $this;
    }

    /**
     * Remove scrum
     *
     * @param \Cadoles\CoreBundle\Entity\Scrum $scrum
     */
    public function removeScrum(\Cadoles\CoreBundle\Entity\Scrum $scrum)
    {
        $this->scrums->removeElement($scrum);
    }

    /**
     * Get scrums
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getScrums()
    {
        return $this->scrums;
    }

    /**
     * Add group
     *
     * @param \Cadoles\CoreBundle\Entity\Group $group
     *
     * @return User
     */
    public function addGroup(\Cadoles\CoreBundle\Entity\Group $group)
    {
        $this->groups[] = $group;

        return $this;
    }

    /**
     * Remove group
     *
     * @param \Cadoles\CoreBundle\Entity\Group $group
     */
    public function removeGroup(\Cadoles\CoreBundle\Entity\Group $group)
    {
        $this->groups->removeElement($group);
    }

    /**
     * Get groups
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getGroups()
    {
        return $this->groups;
    }

    /**
     * Add scrumshared
     *
     * @param \Cadoles\CoreBundle\Entity\Scrum $scrumshared
     *
     * @return User
     */
    public function addScrumshared(\Cadoles\CoreBundle\Entity\Scrum $scrumshared)
    {
        $this->scrumshareds[] = $scrumshared;

        return $this;
    }

    /**
     * Remove scrumshared
     *
     * @param \Cadoles\CoreBundle\Entity\Scrum $scrumshared
     */
    public function removeScrumshared(\Cadoles\CoreBundle\Entity\Scrum $scrumshared)
    {
        $this->scrumshareds->removeElement($scrumshared);
    }

    /**
     * Get scrumshareds
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getScrumshareds()
    {
        return $this->scrumshareds;
    }

    /**
     * Add etherpad
     *
     * @param \Cadoles\CoreBundle\Entity\Etherpad $etherpad
     *
     * @return User
     */
    public function addEtherpad(\Cadoles\CoreBundle\Entity\Etherpad $etherpad)
    {
        $this->etherpads[] = $etherpad;

        return $this;
    }

    /**
     * Remove etherpad
     *
     * @param \Cadoles\CoreBundle\Entity\Etherpad $etherpad
     */
    public function removeEtherpad(\Cadoles\CoreBundle\Entity\Etherpad $etherpad)
    {
        $this->etherpads->removeElement($etherpad);
    }

    /**
     * Get etherpads
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getEtherpads()
    {
        return $this->etherpads;
    }

    /**
     * Add etherpadshared
     *
     * @param \Cadoles\CoreBundle\Entity\Etherpad $etherpadshared
     *
     * @return User
     */
    public function addEtherpadshared(\Cadoles\CoreBundle\Entity\Etherpad $etherpadshared)
    {
        $this->etherpadshareds[] = $etherpadshared;

        return $this;
    }

    /**
     * Remove etherpadshared
     *
     * @param \Cadoles\CoreBundle\Entity\Etherpad $etherpadshared
     */
    public function removeEtherpadshared(\Cadoles\CoreBundle\Entity\Etherpad $etherpadshared)
    {
        $this->etherpadshareds->removeElement($etherpadshared);
    }

    /**
     * Get etherpadshareds
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getEtherpadshareds()
    {
        return $this->etherpadshareds;
    }

    /**
     * Add scrumsharedreader.
     *
     * @param \Cadoles\CoreBundle\Entity\Scrum $scrumsharedreader
     *
     * @return User
     */
    public function addScrumsharedreader(\Cadoles\CoreBundle\Entity\Scrum $scrumsharedreader)
    {
        $this->scrumsharedreaders[] = $scrumsharedreader;

        return $this;
    }

    /**
     * Remove scrumsharedreader.
     *
     * @param \Cadoles\CoreBundle\Entity\Scrum $scrumsharedreader
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removeScrumsharedreader(\Cadoles\CoreBundle\Entity\Scrum $scrumsharedreader)
    {
        return $this->scrumsharedreaders->removeElement($scrumsharedreader);
    }

    /**
     * Get scrumsharedreaders.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getScrumsharedreaders()
    {
        return $this->scrumsharedreaders;
    }

    /**
     * Add ethercalcshared.
     *
     * @param \Cadoles\CoreBundle\Entity\Ethercalc $ethercalcshared
     *
     * @return User
     */
    public function addEthercalcshared(\Cadoles\CoreBundle\Entity\Ethercalc $ethercalcshared)
    {
        $this->ethercalcshareds[] = $ethercalcshared;

        return $this;
    }

    /**
     * Remove ethercalcshared.
     *
     * @param \Cadoles\CoreBundle\Entity\Ethercalc $ethercalcshared
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removeEthercalcshared(\Cadoles\CoreBundle\Entity\Ethercalc $ethercalcshared)
    {
        return $this->ethercalcshareds->removeElement($ethercalcshared);
    }

    /**
     * Get ethercalcshareds.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getEthercalcshareds()
    {
        return $this->ethercalcshareds;
    }

    /**
     * Add scrumwidget
     *
     * @param \Cadoles\CoreBundle\Entity\Scrumwidget $scrumwidget
     *
     * @return User
     */
    public function addScrumwidget(\Cadoles\CoreBundle\Entity\Scrumwidget $scrumwidget)
    {
        $this->scrumwidgets[] = $scrumwidget;

        return $this;
    }

    /**
     * Remove scrumwidget
     *
     * @param \Cadoles\CoreBundle\Entity\Scrumwidget $scrumwidget
     */
    public function removeScrumwidget(\Cadoles\CoreBundle\Entity\Scrumwidget $scrumwidget)
    {
        $this->scrumwidgets->removeElement($scrumwidget);
    }

    /**
     * Get scrumwidgets
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getScrumwidgets()
    {
        return $this->scrumwidgets;
    }

    /**
     * Add message
     *
     * @param \Cadoles\CoreBundle\Entity\Message $message
     *
     * @return User
     */
    public function addMessage(\Cadoles\CoreBundle\Entity\Message $message)
    {
        $this->messages[] = $message;

        return $this;
    }

    /**
     * Remove message
     *
     * @param \Cadoles\CoreBundle\Entity\Message $message
     */
    public function removeMessage(\Cadoles\CoreBundle\Entity\Message $message)
    {
        $this->messages->removeElement($message);
    }

    /**
     * Get messages
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getMessages()
    {
        return $this->messages;
    }

    /**
     * Add scrumsharedwriter
     *
     * @param \Cadoles\CoreBundle\Entity\Scrum $scrumsharedwriter
     *
     * @return User
     */
    public function addScrumsharedwriter(\Cadoles\CoreBundle\Entity\Scrum $scrumsharedwriter)
    {
        $this->scrumsharedwriters[] = $scrumsharedwriter;

        return $this;
    }

    /**
     * Remove scrumsharedwriter
     *
     * @param \Cadoles\CoreBundle\Entity\Scrum $scrumsharedwriter
     */
    public function removeScrumsharedwriter(\Cadoles\CoreBundle\Entity\Scrum $scrumsharedwriter)
    {
        $this->scrumsharedwriters->removeElement($scrumsharedwriter);
    }

    /**
     * Get scrumsharedwriters
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getScrumsharedwriters()
    {
        return $this->scrumsharedwriters;
    }
}
