<?php

namespace Cadoles\CoreBundle\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * Whiteboard
 *
 * @ORM\Table(name="whiteboard")
 * @ORM\Entity(repositoryClass="Cadoles\CoreBundle\Repository\WhiteboardRepository")
 * 
 */
class Whiteboard
{
    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(name="name", type="string", length=100)
     */
    private $title;

    /**
     * @ORM\Column(name="fgcomment", type="boolean")
     */
    private $fgcomment;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="whiteboards")
     */
    private $user;

    /**
     * @ORM\OneToMany(targetEntity="Whiteboardwidget", mappedBy="whiteboard", cascade={"persist"}, orphanRemoval=true)
     * @ORM\OrderBy({"roworder" = "ASC"})
     */
    private $whiteboardwidgets;

    /**
     * @ORM\ManyToMany(targetEntity="Group", inversedBy="whiteboards", cascade={"persist"})
     * @ORM\JoinTable(name="whiteboardgroupe",
     *   joinColumns={@ORM\JoinColumn(name="whiteboard", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="groupe", referencedColumnName="id")}
     * )
     */
    protected $groups;

    /**
     * @ORM\ManyToMany(targetEntity="Group", inversedBy="whiteboardwriters", cascade={"persist"})
     * @ORM\JoinTable(name="whiteboardgroupewriter",
     *   joinColumns={@ORM\JoinColumn(name="whiteboard", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="groupe", referencedColumnName="id")}
     * )
     */
    protected $groupwriters;

    /**
     * @ORM\ManyToMany(targetEntity="Group", inversedBy="whiteboardreaders", cascade={"persist"})
     * @ORM\JoinTable(name="whiteboardgroupereader",
     *   joinColumns={@ORM\JoinColumn(name="whiteboard", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="groupe", referencedColumnName="id")}
     * )
     */
    protected $groupreaders;

    /**
     * @ORM\ManyToMany(targetEntity="User", inversedBy="whiteboardshareds", cascade={"persist"})
     * @ORM\JoinTable(name="whiteboarduser",
     *   joinColumns={@ORM\JoinColumn(name="whiteboard", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="user", referencedColumnName="id")}
     * )
     */
    protected $users;

    /**
     * @ORM\ManyToMany(targetEntity="User", inversedBy="whiteboardsharedwriters", cascade={"persist"})
     * @ORM\JoinTable(name="whiteboarduserwriter",
     *   joinColumns={@ORM\JoinColumn(name="whiteboard", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="user", referencedColumnName="id")}
     * )
     */
    protected $userwriters;

    /**
     * @ORM\ManyToMany(targetEntity="User", inversedBy="whiteboardsharedreaders", cascade={"persist"})
     * @ORM\JoinTable(name="whiteboarduserreader",
     *   joinColumns={@ORM\JoinColumn(name="whiteboard", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="user", referencedColumnName="id")}
     * )
     */
    protected $userreaders;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->whiteboardwidgets = new \Doctrine\Common\Collections\ArrayCollection();
        $this->groups = new \Doctrine\Common\Collections\ArrayCollection();
        $this->groupwriters = new \Doctrine\Common\Collections\ArrayCollection();
        $this->groupreaders = new \Doctrine\Common\Collections\ArrayCollection();
        $this->users = new \Doctrine\Common\Collections\ArrayCollection();
        $this->userwriters = new \Doctrine\Common\Collections\ArrayCollection();
        $this->userreaders = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Set title
     *
     * @param string $title
     *
     * @return Whiteboard
     */
    public function setTitle($title)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * Get title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Set fgcomment
     *
     * @param boolean $fgcomment
     *
     * @return Whiteboard
     */
    public function setFgcomment($fgcomment)
    {
        $this->fgcomment = $fgcomment;

        return $this;
    }

    /**
     * Get fgcomment
     *
     * @return boolean
     */
    public function getFgcomment()
    {
        return $this->fgcomment;
    }

    /**
     * Set user
     *
     * @param \Cadoles\CoreBundle\Entity\User $user
     *
     * @return Whiteboard
     */
    public function setUser(\Cadoles\CoreBundle\Entity\User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return \Cadoles\CoreBundle\Entity\User
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Add whiteboardwidget
     *
     * @param \Cadoles\CoreBundle\Entity\Whiteboardwidget $whiteboardwidget
     *
     * @return Whiteboard
     */
    public function addWhiteboardwidget(\Cadoles\CoreBundle\Entity\Whiteboardwidget $whiteboardwidget)
    {
        $this->whiteboardwidgets[] = $whiteboardwidget;

        return $this;
    }

    /**
     * Remove whiteboardwidget
     *
     * @param \Cadoles\CoreBundle\Entity\Whiteboardwidget $whiteboardwidget
     */
    public function removeWhiteboardwidget(\Cadoles\CoreBundle\Entity\Whiteboardwidget $whiteboardwidget)
    {
        $this->whiteboardwidgets->removeElement($whiteboardwidget);
    }

    /**
     * Get whiteboardwidgets
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getWhiteboardwidgets()
    {
        return $this->whiteboardwidgets;
    }

    /**
     * Add group
     *
     * @param \Cadoles\CoreBundle\Entity\Group $group
     *
     * @return Whiteboard
     */
    public function addGroup(\Cadoles\CoreBundle\Entity\Group $group)
    {
        $this->groups[] = $group;

        return $this;
    }

    /**
     * Remove group
     *
     * @param \Cadoles\CoreBundle\Entity\Group $group
     */
    public function removeGroup(\Cadoles\CoreBundle\Entity\Group $group)
    {
        $this->groups->removeElement($group);
    }

    /**
     * Get groups
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getGroups()
    {
        return $this->groups;
    }

    /**
     * Add groupwriter
     *
     * @param \Cadoles\CoreBundle\Entity\Group $groupwriter
     *
     * @return Whiteboard
     */
    public function addGroupwriter(\Cadoles\CoreBundle\Entity\Group $groupwriter)
    {
        $this->groupwriters[] = $groupwriter;

        return $this;
    }

    /**
     * Remove groupwriter
     *
     * @param \Cadoles\CoreBundle\Entity\Group $groupwriter
     */
    public function removeGroupwriter(\Cadoles\CoreBundle\Entity\Group $groupwriter)
    {
        $this->groupwriters->removeElement($groupwriter);
    }

    /**
     * Get groupwriters
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getGroupwriters()
    {
        return $this->groupwriters;
    }

    /**
     * Add groupreader
     *
     * @param \Cadoles\CoreBundle\Entity\Group $groupreader
     *
     * @return Whiteboard
     */
    public function addGroupreader(\Cadoles\CoreBundle\Entity\Group $groupreader)
    {
        $this->groupreaders[] = $groupreader;

        return $this;
    }

    /**
     * Remove groupreader
     *
     * @param \Cadoles\CoreBundle\Entity\Group $groupreader
     */
    public function removeGroupreader(\Cadoles\CoreBundle\Entity\Group $groupreader)
    {
        $this->groupreaders->removeElement($groupreader);
    }

    /**
     * Get groupreaders
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getGroupreaders()
    {
        return $this->groupreaders;
    }

    /**
     * Add user
     *
     * @param \Cadoles\CoreBundle\Entity\User $user
     *
     * @return Whiteboard
     */
    public function addUser(\Cadoles\CoreBundle\Entity\User $user)
    {
        $this->users[] = $user;

        return $this;
    }

    /**
     * Remove user
     *
     * @param \Cadoles\CoreBundle\Entity\User $user
     */
    public function removeUser(\Cadoles\CoreBundle\Entity\User $user)
    {
        $this->users->removeElement($user);
    }

    /**
     * Get users
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getUsers()
    {
        return $this->users;
    }

    /**
     * Add userwriter
     *
     * @param \Cadoles\CoreBundle\Entity\User $userwriter
     *
     * @return Whiteboard
     */
    public function addUserwriter(\Cadoles\CoreBundle\Entity\User $userwriter)
    {
        $this->userwriters[] = $userwriter;

        return $this;
    }

    /**
     * Remove userwriter
     *
     * @param \Cadoles\CoreBundle\Entity\User $userwriter
     */
    public function removeUserwriter(\Cadoles\CoreBundle\Entity\User $userwriter)
    {
        $this->userwriters->removeElement($userwriter);
    }

    /**
     * Get userwriters
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getUserwriters()
    {
        return $this->userwriters;
    }

    /**
     * Add userreader
     *
     * @param \Cadoles\CoreBundle\Entity\User $userreader
     *
     * @return Whiteboard
     */
    public function addUserreader(\Cadoles\CoreBundle\Entity\User $userreader)
    {
        $this->userreaders[] = $userreader;

        return $this;
    }

    /**
     * Remove userreader
     *
     * @param \Cadoles\CoreBundle\Entity\User $userreader
     */
    public function removeUserreader(\Cadoles\CoreBundle\Entity\User $userreader)
    {
        $this->userreaders->removeElement($userreader);
    }

    /**
     * Get userreaders
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getUserreaders()
    {
        return $this->userreaders;
    }
}
