<?php

namespace Cadoles\CoreBundle\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * Whiteboardwidget
 *
 * @ORM\Table(name="whiteboardwidget")
 * @ORM\Entity()
 * 
 */
class Whiteboardwidget
{
    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(name="name", type="string", length=100)
     */
    private $title;

    /**
     * @ORM\Column(name="description", type="text", nullable=true)
     */
    private $description;

    /**
     * @ORM\Column(name="filetype", type="string", nullable=true)
     */
    private $filetype;

    /**
     * @ORM\Column(name="file", type="string", nullable=true)
     */
    private $file;

    /**
     * @ORM\Column(name="posx", type="integer")
     */
    private $posx;

    /**
     * @ORM\Column(name="posy", type="integer")
     */
    private $posy;

    /**
     * @ORM\Column(name="width", type="integer")
     */
    private $width;

    /**
     * @ORM\Column(name="roworder", type="integer")
     */
    private $roworder;

    /**
     * @ORM\ManyToOne(targetEntity="Whiteboard", inversedBy="whiteboardwidgets")
     */
    private $whiteboard;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="whiteboardwidgets")
     * @ORM\JoinColumn(nullable=true)
     */
    private $user;

    /**
     * @ORM\OneToMany(targetEntity="Document", mappedBy="whiteboardwidget", cascade={"persist"}, orphanRemoval=true)
     */
    private $whiteboardwidgetdocuments;

    /**
     * @ORM\OneToMany(targetEntity="Message", mappedBy="whiteboardwidget", cascade={"persist"}, orphanRemoval=true)
     */
    private $messages;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->whiteboardwidgetdocuments = new \Doctrine\Common\Collections\ArrayCollection();
        $this->messages = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Set title
     *
     * @param string $title
     *
     * @return Whiteboardwidget
     */
    public function setTitle($title)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * Get title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Set description
     *
     * @param string $description
     *
     * @return Whiteboardwidget
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set filetype
     *
     * @param string $filetype
     *
     * @return Whiteboardwidget
     */
    public function setFiletype($filetype)
    {
        $this->filetype = $filetype;

        return $this;
    }

    /**
     * Get filetype
     *
     * @return string
     */
    public function getFiletype()
    {
        return $this->filetype;
    }

    /**
     * Set file
     *
     * @param string $file
     *
     * @return Whiteboardwidget
     */
    public function setFile($file)
    {
        $this->file = $file;

        return $this;
    }

    /**
     * Get file
     *
     * @return string
     */
    public function getFile()
    {
        return $this->file;
    }

    /**
     * Set posx
     *
     * @param integer $posx
     *
     * @return Whiteboardwidget
     */
    public function setPosx($posx)
    {
        $this->posx = $posx;

        return $this;
    }

    /**
     * Get posx
     *
     * @return integer
     */
    public function getPosx()
    {
        return $this->posx;
    }

    /**
     * Set posy
     *
     * @param integer $posy
     *
     * @return Whiteboardwidget
     */
    public function setPosy($posy)
    {
        $this->posy = $posy;

        return $this;
    }

    /**
     * Get posy
     *
     * @return integer
     */
    public function getPosy()
    {
        return $this->posy;
    }

    /**
     * Set width
     *
     * @param integer $width
     *
     * @return Whiteboardwidget
     */
    public function setWidth($width)
    {
        $this->width = $width;

        return $this;
    }

    /**
     * Get width
     *
     * @return integer
     */
    public function getWidth()
    {
        return $this->width;
    }

    /**
     * Set roworder
     *
     * @param integer $roworder
     *
     * @return Whiteboardwidget
     */
    public function setRoworder($roworder)
    {
        $this->roworder = $roworder;

        return $this;
    }

    /**
     * Get roworder
     *
     * @return integer
     */
    public function getRoworder()
    {
        return $this->roworder;
    }

    /**
     * Set whiteboard
     *
     * @param \Cadoles\CoreBundle\Entity\Whiteboard $whiteboard
     *
     * @return Whiteboardwidget
     */
    public function setWhiteboard(\Cadoles\CoreBundle\Entity\Whiteboard $whiteboard = null)
    {
        $this->whiteboard = $whiteboard;

        return $this;
    }

    /**
     * Get whiteboard
     *
     * @return \Cadoles\CoreBundle\Entity\Whiteboard
     */
    public function getWhiteboard()
    {
        return $this->whiteboard;
    }

    /**
     * Set user
     *
     * @param \Cadoles\CoreBundle\Entity\User $user
     *
     * @return Whiteboardwidget
     */
    public function setUser(\Cadoles\CoreBundle\Entity\User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return \Cadoles\CoreBundle\Entity\User
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Add whiteboardwidgetdocument
     *
     * @param \Cadoles\CoreBundle\Entity\Document $whiteboardwidgetdocument
     *
     * @return Whiteboardwidget
     */
    public function addWhiteboardwidgetdocument(\Cadoles\CoreBundle\Entity\Document $whiteboardwidgetdocument)
    {
        $this->whiteboardwidgetdocuments[] = $whiteboardwidgetdocument;

        return $this;
    }

    /**
     * Remove whiteboardwidgetdocument
     *
     * @param \Cadoles\CoreBundle\Entity\Document $whiteboardwidgetdocument
     */
    public function removeWhiteboardwidgetdocument(\Cadoles\CoreBundle\Entity\Document $whiteboardwidgetdocument)
    {
        $this->whiteboardwidgetdocuments->removeElement($whiteboardwidgetdocument);
    }

    /**
     * Get whiteboardwidgetdocuments
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getWhiteboardwidgetdocuments()
    {
        return $this->whiteboardwidgetdocuments;
    }

    /**
     * Add message
     *
     * @param \Cadoles\CoreBundle\Entity\Message $message
     *
     * @return Whiteboardwidget
     */
    public function addMessage(\Cadoles\CoreBundle\Entity\Message $message)
    {
        $this->messages[] = $message;

        return $this;
    }

    /**
     * Remove message
     *
     * @param \Cadoles\CoreBundle\Entity\Message $message
     */
    public function removeMessage(\Cadoles\CoreBundle\Entity\Message $message)
    {
        $this->messages->removeElement($message);
    }

    /**
     * Get messages
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getMessages()
    {
        return $this->messages;
    }
}
