<?php
    namespace Cadoles\CoreBundle\EventListener;

    use Symfony\Component\DependencyInjection\ContainerInterface;
    use Symfony\Component\EventDispatcher\EventDispatcher;
    use Symfony\Component\EventDispatcher\Event;
    use Symfony\Component\HttpFoundation\Session\Session;
    use Doctrine\ORM\EntityManager;

    use Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface;
	use Symfony\Component\Security\Core\Authentication\Token\UsernamePasswordToken;

    class sessionListener {
        protected $container;
        protected $em;

        public function __construct($container, EntityManager $em, TokenStorageInterface $token_storage)
        {
            $this->container = $container;
            $this->em = $em;
            $this->token_storage = $token_storage;
        }

        public function haveRole($roles,$tohave,$route) {
            $haverole=false;
            if($roles=="") {
                if(empty($tohave)) $haverole=true;
            }
            else {
                foreach($roles as $role) {
                    if(in_array($role,$tohave))
                        $haverole=true;
                }
            }
            
            return $haverole;
        }

        public function onDomainParse(Event $event) {
            $session = new Session();

            

            $configs = $this->em->getRepository("CadolesCoreBundle:Config")->findAll();
            foreach($configs as $config) {
                $session->set($config->getId(), strval($config->getValue()));
            }
            
            // Calcul des couleurs
            $color = $this->container->get('cadoles.core.service.color');
            $color->setColor();

            // Utilisateur en cours
            $curentuserid=0;
            $token = $this->token_storage->getToken();
            if(!$token) return;
            $curentuser=$token->getUser();

            // Roles actif
            if($curentuser=="anon.") $roles=[];
            else $roles=$curentuser->getRoles();

            // mode_auth
            $mode_auth  =$this->container->getParameter('mode_auth');
            $session->set('mode_auth',$mode_auth);
        }
    }
