<?php
namespace Cadoles\CoreBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Ivory\CKEditorBundle\Form\Type\CKEditorType;

class DocumentType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('submit',
            SubmitType::class, [
                "label" => "Valider",
                "attr" => ["class" => "btn btn-success no-print"],
            ]
        );

        $builder->add('name',
            TextType::class, [
                "label" =>"Nom",
            ]
        );

        if($options["type"]=="scrum") $path="cadoles_core_user_scrum_upload";
        else $path="cadoles_core_user_whiteboard_upload";

        $builder->add('description',
            CKEditorType::class, [
                "required" => false,
                "config" => [
                    'uiColor' => '#ffffff',
                    'height' => 300,
                    'filebrowserUploadRoute' => $path,
                    'filebrowserUploadRouteParameters' => ['id' => $options["id"]],
                    'language' => 'fr',
                ],
            ]
        );        
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class'    => 'Cadoles\CoreBundle\Entity\Document',
            'mode'          => 'string',
            'type'          => 'string',
            'id'            => 'string',
        ));
    }
}
